--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'SQL_ASCII';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

--
-- Name: add_user(bigint, numeric, integer, integer); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION add_user(bigint, numeric, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN
insert into users (user_id, credit, owner_id, group_id) values ($1, $2, $3, $4);
return 1;
END;
$_$;


ALTER FUNCTION public.add_user(bigint, numeric, integer, integer) OWNER TO ibs;

--
-- Name: change_user_credit(bigint, numeric); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION change_user_credit(bigint, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN
    update users set credit = credit + $2 where user_id = $1;
return 1;
END;
$_$;


ALTER FUNCTION public.change_user_credit(bigint, numeric) OWNER TO ibs;

--
-- Name: delete_group_attr(bigint, text); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION delete_group_attr(bigint, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN
delete from group_attrs where attr_name = $2 and group_id = $1;
return 1;
END;
$_$;


ALTER FUNCTION public.delete_group_attr(bigint, text) OWNER TO ibs;

--
-- Name: delete_normal_user(bigint); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION delete_normal_user(bigint) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN
delete from normal_users where user_id = $1;
return 1;
END;
$_$;


ALTER FUNCTION public.delete_normal_user(bigint) OWNER TO ibs;

--
-- Name: delete_user_attr(bigint, text); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION delete_user_attr(bigint, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN
delete from user_attrs where attr_name = $2 and user_id = $1;
return 1;
END;
$_$;


ALTER FUNCTION public.delete_user_attr(bigint, text) OWNER TO ibs;

--
-- Name: get_mail_dir(text); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION get_mail_dir(text) RETURNS text
    LANGUAGE plpgsql
    AS $_$
DECLARE
  mail_dir text;
BEGIN
select into mail_dir email_attr.attr_value||'/' from user_attrs as email_attr
					    where 
					email_attr.attr_name = 'email_address'
					    and 
					email_attr.attr_value = $1 
					    and not exists 
					(select user_attrs.user_id 
					    from 
					user_attrs 
					    where 
					user_attrs.user_id=email_attr.user_id 
					    and 
					user_attrs.attr_name='lock');
return mail_dir;
END;
$_$;


ALTER FUNCTION public.get_mail_dir(text) OWNER TO ibs;

--
-- Name: get_mail_quota(text); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION get_mail_quota(text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
  quota INTEGER;
BEGIN
select into quota attr_value::integer 
	    from 
	user_attrs 
	    where 
	attr_name='mail_quota' 
	    and exists(
	select email_attr.user_id 
	    from 
	user_attrs as email_attr
	    where 
	user_attrs.user_id=email_attr.user_id 
	    and 
	email_attr.attr_name = 'email_address'
	    and
	email_attr.attr_value = $1); 
	    
IF NOT FOUND THEN
  select into quota attr_value::integer 
	from 
    group_attrs 
	where 
    attr_name='mail_quota' 
	and exists(
    select user_attrs.user_id 
	from 
    user_attrs,users 
	where 
    attr_name='email_address'
	and
    attr_value=$1 
	and 
    user_attrs.user_id=users.user_id 
	and 
    group_attrs.group_id=users.group_id); 
END IF;	
return quota;
END;
$_$;


ALTER FUNCTION public.get_mail_quota(text) OWNER TO ibs;

--
-- Name: insert_connection_log(bigint, numeric, timestamp without time zone, timestamp without time zone, boolean, smallint, integer, text[], text[]); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION insert_connection_log(bigint, numeric, timestamp without time zone, timestamp without time zone, boolean, smallint, integer, text[], text[]) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
    l_user_id alias for $1;
    l_credit_used alias for $2;
    l_login_time alias for $3;
    l_logout_time alias for $4;
    l_successful alias for $5;
    l_service alias for $6;
    l_ras_id alias for $7;
    l_names_array alias for $8;
    l_values_array alias for $9;
    l_connection_log_id integer;
BEGIN
    l_connection_log_id := nextval('connection_log_id');
    insert into connection_log (connection_log_id, user_id, credit_used, login_time, logout_time, successful, service, ras_id)
				values
			       (l_connection_log_id, l_user_id, l_credit_used, l_login_time, l_logout_time, l_successful, l_service, l_ras_id);

    FOR i in array_lower(l_names_array,1) .. array_upper(l_names_array,1) LOOP
	insert into connection_log_details (connection_log_id, name, value) 
					    values
					   (l_connection_log_id, l_names_array[i], l_values_array[i]);
    END LOOP;
    return 1;
END;
$_$;


ALTER FUNCTION public.insert_connection_log(bigint, numeric, timestamp without time zone, timestamp without time zone, boolean, smallint, integer, text[], text[]) OWNER TO ibs;

--
-- Name: insert_group_attr(bigint, text, text); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION insert_group_attr(bigint, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN
insert into group_attrs (group_id, attr_name, attr_value) values($1,$2,$3);
return 1;
END;
$_$;


ALTER FUNCTION public.insert_group_attr(bigint, text, text) OWNER TO ibs;

--
-- Name: insert_ias_event(bigint, smallint, text, numeric, text, text); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION insert_ias_event(bigint, smallint, text, numeric, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN
insert into ias_event (event_id, event_type, actor, amount, destinations, comment) values ($1, $2, $3, $4, $5, $6);
return 1;
END;
$_$;


ALTER FUNCTION public.insert_ias_event(bigint, smallint, text, numeric, text, text) OWNER TO ibs;

--
-- Name: insert_normal_user(bigint, text, text); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION insert_normal_user(bigint, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN
insert into normal_users (user_id, normal_username, normal_password) values($1,$2,$3);
return 1;
END;
$_$;


ALTER FUNCTION public.insert_normal_user(bigint, text, text) OWNER TO ibs;

--
-- Name: insert_user_attr(bigint, text, text); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION insert_user_attr(bigint, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN
insert into user_attrs (user_id, attr_name, attr_value) values($1,$2,$3);
return 1;
END;
$_$;


ALTER FUNCTION public.insert_user_attr(bigint, text, text) OWNER TO ibs;

--
-- Name: insert_user_audit_log(integer, boolean, bigint, text, text, text); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION insert_user_audit_log(integer, boolean, bigint, text, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN
insert into user_audit_log (admin_id, is_user, object_id, attr_name, old_value, new_value) values ($1, $2, $3, $4, $5, $6);
return 1;
END;
$_$;


ALTER FUNCTION public.insert_user_audit_log(integer, boolean, bigint, text, text, text) OWNER TO ibs;

--
-- Name: insert_web_analyzer_log(timestamp without time zone, bigint, inet, text, integer, integer, smallint, smallint, smallint, smallint, integer); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION insert_web_analyzer_log(timestamp without time zone, bigint, inet, text, integer, integer, smallint, smallint, smallint, smallint, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
    _id bigint;
BEGIN
select into _id nextval('web_analyzer_log_log_id');
insert into web_analyzer_log (log_id, _date, user_id, ip_addr, url, elapsed, bytes, miss, hit, successful, failure, _count ) values(_id,$1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11);
return 1;
END;
$_$;


ALTER FUNCTION public.insert_web_analyzer_log(timestamp without time zone, bigint, inet, text, integer, integer, smallint, smallint, smallint, smallint, integer) OWNER TO ibs;

--
-- Name: update_group_attr(bigint, text, text); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION update_group_attr(bigint, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN
update group_attrs set attr_value = $3 where attr_name = $2 and group_id = $1;
return 1;
END;
$_$;


ALTER FUNCTION public.update_group_attr(bigint, text, text) OWNER TO ibs;

--
-- Name: update_normal_user(bigint, text, text); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION update_normal_user(bigint, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN
update normal_users set normal_username = $2, normal_password = $3 where user_id = $1;
return 1;
END;
$_$;


ALTER FUNCTION public.update_normal_user(bigint, text, text) OWNER TO ibs;

--
-- Name: update_user_attr(bigint, text, text); Type: FUNCTION; Schema: public; Owner: ibs
--

CREATE FUNCTION update_user_attr(bigint, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN
update user_attrs set attr_value = $3 where attr_name = $2 and user_id = $1;
return 1;
END;
$_$;


ALTER FUNCTION public.update_user_attr(bigint, text, text) OWNER TO ibs;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: add_user_save_details; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE add_user_save_details (
    add_user_save_id integer NOT NULL,
    user_id bigint NOT NULL,
    username text,
    password text
);


ALTER TABLE public.add_user_save_details OWNER TO ibs;

--
-- Name: add_user_save_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE add_user_save_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.add_user_save_id_seq OWNER TO ibs;

--
-- Name: add_user_saves; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE add_user_saves (
    add_user_save_id integer NOT NULL,
    add_date timestamp without time zone DEFAULT now(),
    admin_id integer,
    type integer,
    comment text
);


ALTER TABLE public.add_user_saves OWNER TO ibs;

--
-- Name: admin_deposit_change; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE admin_deposit_change (
    admin_deposit_change_id integer NOT NULL,
    admin_id integer,
    to_admin_id integer,
    deposit_change numeric(12,2),
    change_time timestamp without time zone DEFAULT now(),
    remote_addr inet,
    comment text
);


ALTER TABLE public.admin_deposit_change OWNER TO ibs;

--
-- Name: admin_deposit_change_id; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE admin_deposit_change_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.admin_deposit_change_id OWNER TO ibs;

--
-- Name: admin_locks; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE admin_locks (
    lock_id bigint NOT NULL,
    locker_admin_id integer,
    admin_id integer,
    reason text
);


ALTER TABLE public.admin_locks OWNER TO ibs;

--
-- Name: admin_locks_lock_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE admin_locks_lock_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.admin_locks_lock_id_seq OWNER TO ibs;

--
-- Name: admin_messages; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE admin_messages (
    message_id bigint NOT NULL,
    user_id bigint,
    message_text text,
    post_date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.admin_messages OWNER TO ibs;

--
-- Name: admin_messages_message_id; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE admin_messages_message_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.admin_messages_message_id OWNER TO ibs;

--
-- Name: admin_perm_template_id; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE admin_perm_template_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.admin_perm_template_id OWNER TO ibs;

--
-- Name: admin_perm_templates; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE admin_perm_templates (
    template_id integer NOT NULL,
    template_name text
);


ALTER TABLE public.admin_perm_templates OWNER TO ibs;

--
-- Name: admin_perm_templates_detail; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE admin_perm_templates_detail (
    template_id integer NOT NULL,
    perm_name text NOT NULL,
    perm_value text
);


ALTER TABLE public.admin_perm_templates_detail OWNER TO ibs;

--
-- Name: admin_perms; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE admin_perms (
    admin_id integer NOT NULL,
    perm_name text NOT NULL,
    perm_value text
);


ALTER TABLE public.admin_perms OWNER TO ibs;

--
-- Name: admins; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE admins (
    admin_id integer NOT NULL,
    username text,
    password character(34),
    deposit numeric(12,2) DEFAULT 0,
    due numeric(12,2) DEFAULT 0,
    name text,
    comment text,
    creator_id integer
);


ALTER TABLE public.admins OWNER TO ibs;

--
-- Name: admins_extended_attrs; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE admins_extended_attrs (
    admin_id integer NOT NULL,
    attr_name text NOT NULL,
    attr_value text
);


ALTER TABLE public.admins_extended_attrs OWNER TO ibs;

--
-- Name: admins_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE admins_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.admins_id_seq OWNER TO ibs;

--
-- Name: bw_interface; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE bw_interface (
    interface_id integer NOT NULL,
    interface_name text,
    comment text
);


ALTER TABLE public.bw_interface OWNER TO ibs;

--
-- Name: bw_interface_interface_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE bw_interface_interface_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.bw_interface_interface_id_seq OWNER TO ibs;

--
-- Name: bw_leaf; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE bw_leaf (
    leaf_id integer NOT NULL,
    leaf_name text,
    interface_id integer,
    parent_id integer,
    default_rate_kbits integer,
    default_ceil_kbits integer,
    total_rate_kbits integer,
    total_ceil_kbits integer
);


ALTER TABLE public.bw_leaf OWNER TO ibs;

--
-- Name: bw_leaf_leaf_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE bw_leaf_leaf_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.bw_leaf_leaf_id_seq OWNER TO ibs;

--
-- Name: bw_leaf_services; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE bw_leaf_services (
    leaf_service_id integer NOT NULL,
    leaf_id integer,
    protocol text,
    filter text,
    rate_kbits integer,
    ceil_kbits integer
);


ALTER TABLE public.bw_leaf_services OWNER TO ibs;

--
-- Name: bw_leaf_services_leaf_service_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE bw_leaf_services_leaf_service_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.bw_leaf_services_leaf_service_id_seq OWNER TO ibs;

--
-- Name: bw_node; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE bw_node (
    node_id integer NOT NULL,
    interface_id integer,
    parent_id integer,
    rate_kbits integer,
    ceil_kbits integer
);


ALTER TABLE public.bw_node OWNER TO ibs;

--
-- Name: bw_node_node_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE bw_node_node_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.bw_node_node_id_seq OWNER TO ibs;

--
-- Name: bw_static_ip; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE bw_static_ip (
    bw_static_ip_id integer NOT NULL,
    ip inet,
    transmit_leaf_id integer,
    receive_leaf_id integer
);


ALTER TABLE public.bw_static_ip OWNER TO ibs;

--
-- Name: bw_static_ip_bw_static_ip_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE bw_static_ip_bw_static_ip_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.bw_static_ip_bw_static_ip_id_seq OWNER TO ibs;

--
-- Name: caller_id_users; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE caller_id_users (
    user_id bigint,
    caller_id text NOT NULL
);


ALTER TABLE public.caller_id_users OWNER TO ibs;

--
-- Name: charge_rule_day_of_weeks; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE charge_rule_day_of_weeks (
    charge_rule_id integer NOT NULL,
    day_of_week integer NOT NULL
);


ALTER TABLE public.charge_rule_day_of_weeks OWNER TO ibs;

--
-- Name: charge_rule_ports; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE charge_rule_ports (
    charge_rule_id integer NOT NULL,
    ras_port text NOT NULL
);


ALTER TABLE public.charge_rule_ports OWNER TO ibs;

--
-- Name: charge_rules; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE charge_rules (
    charge_id integer,
    charge_rule_id integer NOT NULL,
    start_time time without time zone,
    end_time time without time zone,
    time_limit integer,
    ras_id integer
);


ALTER TABLE public.charge_rules OWNER TO ibs;

--
-- Name: charge_rules_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE charge_rules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.charge_rules_id_seq OWNER TO ibs;

--
-- Name: charges; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE charges (
    charge_id integer NOT NULL,
    name text,
    charge_type text,
    comment text,
    admin_id integer,
    visible_to_all boolean DEFAULT false
);


ALTER TABLE public.charges OWNER TO ibs;

--
-- Name: charges_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE charges_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.charges_id_seq OWNER TO ibs;

--
-- Name: connection_log; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE connection_log (
    connection_log_id bigint NOT NULL,
    user_id bigint,
    credit_used numeric(12,2),
    login_time timestamp without time zone,
    logout_time timestamp without time zone,
    successful boolean,
    service smallint,
    ras_id integer
);


ALTER TABLE public.connection_log OWNER TO ibs;

--
-- Name: connection_log_details; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE connection_log_details (
    connection_log_id bigint NOT NULL,
    name text NOT NULL,
    value text
);


ALTER TABLE public.connection_log_details OWNER TO ibs;

--
-- Name: connection_log_id; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE connection_log_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.connection_log_id OWNER TO ibs;

--
-- Name: credit_change; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE credit_change (
    credit_change_id bigint NOT NULL,
    admin_id integer,
    action smallint,
    per_user_credit numeric(12,2),
    admin_credit numeric(12,2),
    change_time timestamp without time zone DEFAULT now(),
    remote_addr inet,
    comment text
);


ALTER TABLE public.credit_change OWNER TO ibs;

--
-- Name: credit_change_id; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE credit_change_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.credit_change_id OWNER TO ibs;

--
-- Name: credit_change_userid; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE credit_change_userid (
    credit_change_id bigint NOT NULL,
    user_id bigint NOT NULL
);


ALTER TABLE public.credit_change_userid OWNER TO ibs;

--
-- Name: defs; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE defs (
    name text NOT NULL,
    value text,
    type text
);


ALTER TABLE public.defs OWNER TO ibs;

--
-- Name: group_attrs; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE group_attrs (
    group_id integer NOT NULL,
    attr_name text NOT NULL,
    attr_value text
);


ALTER TABLE public.group_attrs OWNER TO ibs;

--
-- Name: groups; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE groups (
    group_id integer NOT NULL,
    group_name text,
    owner_id integer,
    comment text
);


ALTER TABLE public.groups OWNER TO ibs;

--
-- Name: groups_group_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE groups_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.groups_group_id_seq OWNER TO ibs;

--
-- Name: ias_event; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE ias_event (
    event_id bigint NOT NULL,
    event_type smallint,
    event_date timestamp without time zone DEFAULT now(),
    actor text,
    amount numeric(12,2),
    destinations text,
    comment text
);


ALTER TABLE public.ias_event OWNER TO ibs;

--
-- Name: ias_event_event_id; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE ias_event_event_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ias_event_event_id OWNER TO ibs;

--
-- Name: ias_event_extended; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE ias_event_extended (
    event_id bigint NOT NULL,
    name text NOT NULL,
    value text
);


ALTER TABLE public.ias_event_extended OWNER TO ibs;

--
-- Name: ibs_states; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE ibs_states (
    name text NOT NULL,
    value text
);


ALTER TABLE public.ibs_states OWNER TO ibs;

--
-- Name: internet_bw_snapshot; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE internet_bw_snapshot (
    snp_date timestamp without time zone DEFAULT now() NOT NULL,
    user_id integer NOT NULL,
    in_rate integer,
    out_rate integer
);


ALTER TABLE public.internet_bw_snapshot OWNER TO ibs;

--
-- Name: internet_charge_rules; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE internet_charge_rules (
    cpm numeric(12,2),
    cpk numeric(12,2),
    assumed_kps integer,
    bandwidth_limit_kbytes integer DEFAULT (-1),
    bw_transmit_leaf_id integer,
    bw_receive_leaf_id integer
)
INHERITS (charge_rules);


ALTER TABLE public.internet_charge_rules OWNER TO ibs;

--
-- Name: internet_onlines_snapshot; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE internet_onlines_snapshot (
    snp_date timestamp without time zone DEFAULT now() NOT NULL,
    ras_id integer NOT NULL,
    value integer
);


ALTER TABLE public.internet_onlines_snapshot OWNER TO ibs;

--
-- Name: ippool; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE ippool (
    ippool_id integer NOT NULL,
    ippool_name text,
    ippool_comment text
);


ALTER TABLE public.ippool OWNER TO ibs;

--
-- Name: ippool_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE ippool_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ippool_id_seq OWNER TO ibs;

--
-- Name: ippool_ips; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE ippool_ips (
    ippool_id integer NOT NULL,
    ip inet NOT NULL
);


ALTER TABLE public.ippool_ips OWNER TO ibs;

--
-- Name: normal_users; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE normal_users (
    user_id bigint,
    normal_username text,
    normal_password text
);


ALTER TABLE public.normal_users OWNER TO ibs;

--
-- Name: persistent_lan_users; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE persistent_lan_users (
    user_id bigint,
    persistent_lan_mac macaddr NOT NULL,
    persistent_lan_ip cidr NOT NULL,
    persistent_lan_ras_id integer
);


ALTER TABLE public.persistent_lan_users OWNER TO ibs;

--
-- Name: ras; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE ras (
    ras_id integer NOT NULL,
    ras_description text,
    ras_ip inet,
    ras_type text,
    radius_secret text,
    active boolean DEFAULT true,
    comment text
);


ALTER TABLE public.ras OWNER TO ibs;

--
-- Name: ras_attrs; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE ras_attrs (
    ras_id integer NOT NULL,
    attr_name text NOT NULL,
    attr_value text
);


ALTER TABLE public.ras_attrs OWNER TO ibs;

--
-- Name: ras_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE ras_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ras_id_seq OWNER TO ibs;

--
-- Name: ras_ippools; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE ras_ippools (
    serial integer NOT NULL,
    ras_id integer,
    ippool_id integer
);


ALTER TABLE public.ras_ippools OWNER TO ibs;

--
-- Name: ras_ippools_serial_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE ras_ippools_serial_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ras_ippools_serial_seq OWNER TO ibs;

--
-- Name: ras_ippools_serial_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ibs
--

ALTER SEQUENCE ras_ippools_serial_seq OWNED BY ras_ippools.serial;


--
-- Name: ras_ports; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE ras_ports (
    ras_id integer NOT NULL,
    port_name text NOT NULL,
    phone text,
    type text,
    comment text
);


ALTER TABLE public.ras_ports OWNER TO ibs;

--
-- Name: tariff_prefix_list; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE tariff_prefix_list (
    tariff_id integer,
    prefix_id integer NOT NULL,
    prefix_code text,
    prefix_name text,
    cpm numeric(12,2),
    free_seconds smallint,
    min_duration smallint,
    round_to smallint,
    min_chargable_duration smallint
);


ALTER TABLE public.tariff_prefix_list OWNER TO ibs;

--
-- Name: tariff_prefix_list_tariff_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE tariff_prefix_list_tariff_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tariff_prefix_list_tariff_id_seq OWNER TO ibs;

--
-- Name: user_attrs; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE user_attrs (
    user_id bigint NOT NULL,
    attr_name text NOT NULL,
    attr_value text
);


ALTER TABLE public.user_attrs OWNER TO ibs;

--
-- Name: user_audit_log; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE user_audit_log (
    user_audit_log integer NOT NULL,
    admin_id integer,
    is_user boolean,
    object_id bigint,
    attr_name text,
    old_value text,
    new_value text,
    change_time timestamp without time zone DEFAULT now()
);


ALTER TABLE public.user_audit_log OWNER TO ibs;

--
-- Name: user_audit_log_user_audit_log_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE user_audit_log_user_audit_log_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_audit_log_user_audit_log_seq OWNER TO ibs;

--
-- Name: user_audit_log_user_audit_log_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ibs
--

ALTER SEQUENCE user_audit_log_user_audit_log_seq OWNED BY user_audit_log.user_audit_log;


--
-- Name: user_messages; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE user_messages (
    message_id bigint NOT NULL,
    user_id bigint,
    message_text text,
    post_date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.user_messages OWNER TO ibs;

--
-- Name: user_messages_message_id; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE user_messages_message_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_messages_message_id OWNER TO ibs;

--
-- Name: users; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE users (
    user_id bigint NOT NULL,
    owner_id integer,
    credit numeric(12,2),
    group_id integer,
    creation_date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.users OWNER TO ibs;

--
-- Name: users_user_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE users_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.users_user_id_seq OWNER TO ibs;

--
-- Name: voip_charge_rule_tariff; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE voip_charge_rule_tariff (
    tariff_id integer NOT NULL,
    tariff_name text,
    comment text
);


ALTER TABLE public.voip_charge_rule_tariff OWNER TO ibs;

--
-- Name: voip_charge_rule_tariff_tariff_id_seq; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE voip_charge_rule_tariff_tariff_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.voip_charge_rule_tariff_tariff_id_seq OWNER TO ibs;

--
-- Name: voip_charge_rules; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE voip_charge_rules (
    tariff_id integer
)
INHERITS (charge_rules);


ALTER TABLE public.voip_charge_rules OWNER TO ibs;

--
-- Name: voip_onlines_snapshot; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE voip_onlines_snapshot (
    snp_date timestamp without time zone DEFAULT now() NOT NULL,
    ras_id integer NOT NULL,
    value integer
);


ALTER TABLE public.voip_onlines_snapshot OWNER TO ibs;

--
-- Name: voip_users; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE voip_users (
    user_id bigint,
    voip_username text,
    voip_password text
);


ALTER TABLE public.voip_users OWNER TO ibs;

--
-- Name: web_analyzer_log; Type: TABLE; Schema: public; Owner: ibs; Tablespace: 
--

CREATE TABLE web_analyzer_log (
    log_id bigint NOT NULL,
    _date timestamp without time zone DEFAULT now(),
    user_id bigint,
    ip_addr inet,
    url text,
    elapsed integer,
    bytes integer,
    miss smallint,
    hit smallint,
    successful smallint,
    failure smallint,
    _count integer
);


ALTER TABLE public.web_analyzer_log OWNER TO ibs;

--
-- Name: web_analyzer_log_log_id; Type: SEQUENCE; Schema: public; Owner: ibs
--

CREATE SEQUENCE web_analyzer_log_log_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.web_analyzer_log_log_id OWNER TO ibs;

--
-- Name: serial; Type: DEFAULT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY ras_ippools ALTER COLUMN serial SET DEFAULT nextval('ras_ippools_serial_seq'::regclass);


--
-- Name: user_audit_log; Type: DEFAULT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY user_audit_log ALTER COLUMN user_audit_log SET DEFAULT nextval('user_audit_log_user_audit_log_seq'::regclass);


--
-- Data for Name: add_user_save_details; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY add_user_save_details (add_user_save_id, user_id, username, password) FROM stdin;
144	134	bama2000	1891
144	135	bama2001	7436
144	136	bama2002	5284
144	137	bama2003	6752
144	138	bama2004	7618
144	139	bama2005	7684
144	140	bama2006	8261
144	141	bama2007	7621
144	142	bama2008	2266
144	143	bama2009	7832
251	250	zand	8881
299	289	bama2020	7763
299	290	bama2021	5183
299	291	bama2022	1354
299	292	bama2023	6164
299	293	bama2024	5896
299	294	bama2025	5678
299	295	bama2026	5595
299	296	bama2027	9836
299	297	bama2028	8834
245	235	bama2010	7197
245	236	bama2011	3538
245	237	bama2012	5138
245	238	bama2013	3181
245	239	bama2014	1836
245	240	bama2015	6768
245	241	bama2016	7436
245	242	bama2017	9923
245	243	bama2018	4747
245	244	bama2019	1747
299	298	bama2029	9463
334	324	bama2030	2575
334	325	bama2031	8266
334	326	bama2032	2563
334	327	bama2033	6824
334	328	bama2034	6584
334	329	bama2035	9396
334	330	bama2036	4992
334	331	bama2037	9844
334	332	bama2038	1611
334	333	bama2039	1952
378	368	bama2040	9321
378	369	bama2041	6891
378	370	bama2042	8588
378	371	bama2043	5424
378	372	bama2044	1942
378	373	bama2045	7951
378	374	bama2046	1828
378	375	bama2047	7466
378	376	bama2048	2959
378	377	bama2049	5192
389	379	bama2050	5576
389	380	bama2051	3283
389	381	bama2052	6138
389	382	bama2053	4837
389	383	bama2054	5754
389	384	bama2055	1868
389	385	bama2056	2596
389	386	bama2057	2696
389	387	bama2058	5745
389	388	bama2059	4932
456	455	sanjabi10	1010
555	545	bama2071	8821
555	546	bama2072	4958
555	547	bama2073	2246
555	548	bama2074	4492
555	549	bama2075	8496
555	550	bama2076	5999
555	551	bama2077	4597
555	552	bama2078	2644
555	553	bama2079	6541
555	554	bama2080	8898
503	493	bama2060	9347
503	494	bama2061	8597
503	495	bama2062	8352
503	496	bama2063	3985
503	497	bama2064	4918
503	498	bama2065	7182
503	499	bama2066	9888
503	500	bama2067	5262
503	501	bama2068	4731
503	502	bama2069	6925
578	568	bama2081	4496
578	569	bama2082	1961
578	570	bama2083	9711
578	571	bama2084	8859
578	572	bama2085	4125
578	573	bama2086	7738
578	574	bama2087	4154
578	575	bama2088	6425
578	576	bama2089	9539
578	577	bama2090	4712
600	590	bama2092	2822
600	591	bama2093	3614
600	592	bama2094	5775
600	593	bama2095	7592
600	594	bama2096	5967
600	595	bama2097	3559
600	596	bama2098	8363
600	597	bama2099	7756
600	598	bama2100	4636
600	599	bama2101	2271
625	615	bama2102	4732
625	616	bama2103	2994
625	617	bama2104	1628
625	618	bama2105	5733
625	619	bama2106	5685
625	620	bama2107	8226
625	621	bama2108	9819
625	622	bama2109	7351
625	623	bama2110	5615
625	624	bama2111	2768
641	631	bama2112	6452
641	632	bama2113	3432
641	633	bama2114	4837
641	634	bama2115	7986
641	635	bama2116	6648
641	636	bama2117	3632
641	637	bama2118	3699
641	638	bama2119	8483
641	639	bama2120	6171
641	640	bama2121	3721
642	631	bama2112	9126
642	632	bama2113	1538
642	633	bama2114	4926
642	634	bama2115	1118
642	635	bama2116	1629
642	636	bama2117	9653
642	637	bama2118	2491
642	638	bama2119	5664
642	639	bama2120	5991
642	640	bama2121	1945
665	655	bama2122	3657
665	656	bama2123	1924
665	657	bama2124	7528
665	658	bama2125	9214
665	659	bama2126	6931
665	660	bama2127	1593
665	661	bama2128	4892
665	662	bama2129	8614
665	663	bama2130	1635
665	664	bama2131	2897
680	670	bama2132	4942
680	671	bama2133	5319
680	672	bama2134	2368
680	673	bama2135	1621
680	674	bama2136	4344
680	675	bama2137	8474
680	676	bama2138	1438
680	677	bama2139	5143
680	678	bama2140	2391
680	679	bama2141	2564
703	693	bama2142	2898
703	694	bama2143	5117
703	695	bama2144	7621
703	696	bama2145	9394
703	697	bama2146	8536
703	698	bama2147	8769
703	699	bama2148	7339
703	700	bama2149	2159
703	701	bama2150	6679
703	702	bama2151	4226
738	728	bama2152	8286
738	729	bama2153	1566
738	730	bama2154	5644
738	731	bama2155	2279
738	732	bama2156	8876
738	733	bama2157	8329
738	734	bama2158	4772
738	735	bama2159	1884
738	736	bama2160	8791
738	737	bama2161	9151
758	748	bama2162	8634
758	749	bama2163	5722
758	750	bama2164	6759
758	751	bama2165	2356
758	752	bama2166	7656
758	753	bama2167	9647
758	754	bama2168	5686
758	755	bama2169	8949
758	756	bama2170	8759
758	757	bama2171	1653
780	770	bama2172	9192
780	771	bama2173	2415
780	772	bama2174	7214
780	773	bama2175	2418
780	774	bama2176	3519
780	775	bama2177	2823
780	776	bama2178	6992
780	777	bama2179	2827
780	778	bama2180	8387
780	779	bama2181	8834
821	811	bama2182	1644
821	812	bama2183	4647
821	813	bama2184	8136
821	814	bama2185	5672
821	815	bama2186	1399
821	816	bama2187	2839
821	817	bama2188	2817
821	818	bama2189	8354
821	819	bama2190	9114
821	820	bama2191	1712
849	839	bama2192	8424
849	840	bama2193	6359
849	841	bama2194	9459
849	842	bama2195	8445
849	843	bama2196	4884
849	844	bama2197	2436
849	845	bama2198	1792
849	846	bama2199	5848
849	847	bama2200	4318
849	848	bama2201	4676
873	863	bama2202	7773
873	864	bama2203	2753
873	865	bama2204	3653
873	866	bama2205	7925
873	867	bama2206	5965
873	868	bama2207	2152
873	869	bama2208	6874
873	870	bama2209	6375
873	871	bama2210	4335
873	872	bama2211	5994
904	903	rayan	4000
918	908	bama2212	6991
918	909	bama2213	4268
918	910	bama2214	8416
918	911	bama2215	4934
918	912	bama2216	7455
918	913	bama2217	9233
918	914	bama2218	1546
918	915	bama2219	1637
918	916	bama2220	5871
918	917	bama2221	5665
952	942	bama2222	3725
952	943	bama2223	9755
952	944	bama2224	4991
952	945	bama2225	3314
952	946	bama2226	3377
952	947	bama2227	5789
952	948	bama2228	4761
952	949	bama2229	9343
952	950	bama2230	2674
952	951	bama2231	1539
982	972	bama2232	5745
982	973	bama2233	7868
982	974	bama2234	8583
982	975	bama2235	6732
982	976	bama2236	6735
982	977	bama2237	2926
982	978	bama2238	5555
982	979	bama2239	1362
982	980	bama2240	7654
982	981	bama2241	4849
1030	1020	bama2242	9166
1030	1021	bama2243	5128
1030	1022	bama2244	2198
1030	1023	bama2245	8851
1030	1024	bama2246	5786
1030	1025	bama2247	5966
1030	1026	bama2248	7471
1030	1027	bama2249	6428
1030	1028	bama2250	3154
1030	1029	bama2251	1251
1054	1044	bama2252	3891
1054	1045	bama2253	2561
1054	1046	bama2254	8554
1054	1047	bama2255	9685
1054	1048	bama2256	5464
1054	1049	bama2257	8652
1054	1050	bama2258	5758
1054	1051	bama2259	4922
1054	1052	bama2260	9173
1054	1053	bama2261	8164
1087	1077	bama2262	4625
1087	1078	bama2263	5569
1087	1079	bama2264	7243
1087	1080	bama2265	6795
1087	1081	bama2266	1385
1087	1082	bama2267	9943
1087	1083	bama2268	3813
1087	1084	bama2269	2861
1087	1085	bama2270	1359
1087	1086	bama2271	8628
\.


--
-- Name: add_user_save_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('add_user_save_id_seq', 1, false);


--
-- Data for Name: add_user_saves; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY add_user_saves (add_user_save_id, add_date, admin_id, type, comment) FROM stdin;
144	2024-02-12 05:12:08.092914	0	1	
251	2024-02-21 16:26:57.10119	0	1	
245	2024-02-20 12:16:22.578632	0	1	
299	2024-02-28 16:33:16.423524	0	1	
334	2024-03-05 05:01:32.451994	0	1	
378	2024-03-10 18:06:02.961335	0	1	
389	2024-03-10 18:10:32.646583	0	1	
456	2024-03-30 15:11:32.937843	0	1	
555	2024-04-26 11:22:31.07957	0	1	
503	2024-04-09 07:01:23.530214	0	1	
578	2024-04-30 14:19:32.736252	0	1	
600	2024-05-11 12:55:16.880378	0	1	
625	2024-05-20 05:44:50.68122	0	1	
641	2024-05-26 17:24:07.16982	0	1	
642	2024-05-26 17:24:44.598313	0	1	
665	2024-05-31 16:41:23.77945	0	1	
680	2024-06-04 15:00:54.572605	0	1	
703	2024-06-09 15:46:40.562513	0	1	
738	2024-06-24 17:39:13.818142	0	1	
758	2024-06-30 17:14:35.055124	0	1	
780	2024-07-08 12:32:12.236646	0	1	
821	2024-07-31 13:23:10.057512	0	1	
849	2024-08-08 12:08:50.269423	0	1	
873	2024-08-16 09:18:08.528673	0	1	
904	2024-08-30 07:29:52.59948	0	1	
918	2024-08-31 14:58:12.245121	0	1	
952	2024-09-12 08:48:40.235546	0	1	
982	2024-09-20 05:02:57.328589	0	1	
1030	2024-10-16 13:44:57.30621	0	1	
1054	2024-10-24 17:09:24.619654	0	1	
1087	2024-11-14 15:22:48.510417	0	1	
\.


--
-- Data for Name: admin_deposit_change; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY admin_deposit_change (admin_deposit_change_id, admin_id, to_admin_id, deposit_change, change_time, remote_addr, comment) FROM stdin;
\.


--
-- Name: admin_deposit_change_id; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('admin_deposit_change_id', 1, false);


--
-- Data for Name: admin_locks; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY admin_locks (lock_id, locker_admin_id, admin_id, reason) FROM stdin;
\.


--
-- Name: admin_locks_lock_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('admin_locks_lock_id_seq', 1, false);


--
-- Data for Name: admin_messages; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY admin_messages (message_id, user_id, message_text, post_date) FROM stdin;
\.


--
-- Name: admin_messages_message_id; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('admin_messages_message_id', 1, false);


--
-- Name: admin_perm_template_id; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('admin_perm_template_id', 1, false);


--
-- Data for Name: admin_perm_templates; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY admin_perm_templates (template_id, template_name) FROM stdin;
\.


--
-- Data for Name: admin_perm_templates_detail; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY admin_perm_templates_detail (template_id, perm_name, perm_value) FROM stdin;
\.


--
-- Data for Name: admin_perms; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY admin_perms (admin_id, perm_name, perm_value) FROM stdin;
0	GOD	
\.


--
-- Data for Name: admins; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY admins (admin_id, username, password, deposit, due, name, comment, creator_id) FROM stdin;
0	system	$1$JQGNsGLB$52VXZ7zKyq87aBlj7sYPI1	-1043.00	0.00	IBS Internal System Account		0
\.


--
-- Data for Name: admins_extended_attrs; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY admins_extended_attrs (admin_id, attr_name, attr_value) FROM stdin;
\.


--
-- Name: admins_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('admins_id_seq', 1, false);


--
-- Data for Name: bw_interface; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY bw_interface (interface_id, interface_name, comment) FROM stdin;
\.


--
-- Name: bw_interface_interface_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('bw_interface_interface_id_seq', 1, false);


--
-- Data for Name: bw_leaf; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY bw_leaf (leaf_id, leaf_name, interface_id, parent_id, default_rate_kbits, default_ceil_kbits, total_rate_kbits, total_ceil_kbits) FROM stdin;
\.


--
-- Name: bw_leaf_leaf_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('bw_leaf_leaf_id_seq', 1, false);


--
-- Data for Name: bw_leaf_services; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY bw_leaf_services (leaf_service_id, leaf_id, protocol, filter, rate_kbits, ceil_kbits) FROM stdin;
\.


--
-- Name: bw_leaf_services_leaf_service_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('bw_leaf_services_leaf_service_id_seq', 1, false);


--
-- Data for Name: bw_node; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY bw_node (node_id, interface_id, parent_id, rate_kbits, ceil_kbits) FROM stdin;
\.


--
-- Name: bw_node_node_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('bw_node_node_id_seq', 1, false);


--
-- Data for Name: bw_static_ip; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY bw_static_ip (bw_static_ip_id, ip, transmit_leaf_id, receive_leaf_id) FROM stdin;
\.


--
-- Name: bw_static_ip_bw_static_ip_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('bw_static_ip_bw_static_ip_id_seq', 1, false);


--
-- Data for Name: caller_id_users; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY caller_id_users (user_id, caller_id) FROM stdin;
\.


--
-- Data for Name: charge_rule_day_of_weeks; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY charge_rule_day_of_weeks (charge_rule_id, day_of_week) FROM stdin;
1	0
1	1
1	2
1	3
1	4
1	5
1	6
\.


--
-- Data for Name: charge_rule_ports; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY charge_rule_ports (charge_rule_id, ras_port) FROM stdin;
1	_ALL_
\.


--
-- Data for Name: charge_rules; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY charge_rules (charge_id, charge_rule_id, start_time, end_time, time_limit, ras_id) FROM stdin;
\.


--
-- Name: charge_rules_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('charge_rules_id_seq', 1, true);


--
-- Data for Name: charges; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY charges (charge_id, name, charge_type, comment, admin_id, visible_to_all) FROM stdin;
1	Normal	Internet		0	t
\.


--
-- Name: charges_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('charges_id_seq', 1, true);


--
-- Data for Name: connection_log; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY connection_log (connection_log_id, user_id, credit_used, login_time, logout_time, successful, service, ras_id) FROM stdin;
9925076	254	0.00	2024-11-22 07:59:44	2024-11-22 08:00:03	t	1	9
\.


--
-- Data for Name: connection_log_details; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY connection_log_details (connection_log_id, name, value) FROM stdin;
9925076	username	behrooz
9925076	terminate_cause	Lost-Carrier
9925076	bytes_in	27849
9925076	nas_port_type	Async
9925076	bytes_out	6289
9925076	port	15936963
9925076	unique_id	port
9925076	remote_ip	172.31.0.74
\.


--
-- Name: connection_log_id; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('connection_log_id', 9925076, true);


--
-- Data for Name: credit_change; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY credit_change (credit_change_id, admin_id, action, per_user_credit, admin_credit, change_time, remote_addr, comment) FROM stdin;
1	0	1	1.00	1.00	2024-02-08 12:07:25.485885	178.131.98.246	
2	0	1	1.00	1.00	2024-02-08 12:43:16.953177	178.131.96.102	
3	0	1	1.00	1.00	2024-02-08 12:46:42.473675	178.131.96.102	
4	0	1	1.00	1.00	2024-02-08 12:49:54.994137	178.131.96.102	
5	0	1	1.00	1.00	2024-02-08 13:00:20.369133	178.131.96.102	
6	0	1	1.00	1.00	2024-02-08 13:05:46.990989	178.131.96.102	
7	0	1	1.00	1.00	2024-02-08 13:15:42.117472	178.131.96.102	
8	0	1	1.00	1.00	2024-02-08 13:21:26.471115	178.131.96.102	
9	0	1	1.00	1.00	2024-02-08 13:22:57.92397	178.131.96.102	
10	0	1	1.00	1.00	2024-02-08 13:26:52.914974	178.131.96.102	
11	0	1	1.00	1.00	2024-02-08 13:29:16.156715	178.131.96.102	
12	0	1	1.00	1.00	2024-02-08 13:29:23.12075	178.131.96.102	
13	0	1	1.00	1.00	2024-02-08 13:31:17.501597	178.131.96.102	
14	0	1	1.00	1.00	2024-02-08 13:33:14.257349	178.131.96.102	
15	0	1	1.00	1.00	2024-02-08 13:33:18.886823	178.131.96.102	
16	0	1	1.00	1.00	2024-02-08 13:36:01.443373	178.131.96.102	
17	0	1	1.00	1.00	2024-02-08 13:36:59.219472	178.131.96.102	
18	0	1	1.00	1.00	2024-02-08 13:38:37.827654	178.131.96.102	
19	0	1	1.00	1.00	2024-02-08 13:40:58.750149	178.131.96.102	
20	0	1	1.00	1.00	2024-02-08 13:43:16.459763	178.131.96.102	
21	0	1	1.00	1.00	2024-02-08 13:52:29.441	178.131.96.102	
22	0	1	1.00	1.00	2024-02-08 13:53:40.773914	178.131.96.102	
23	0	1	1.00	1.00	2024-02-08 13:56:04.934572	178.131.96.102	
24	0	1	1.00	1.00	2024-02-08 13:58:39.325223	178.131.96.102	
25	0	1	1.00	1.00	2024-02-08 14:00:46.53934	178.131.96.102	
26	0	1	1.00	1.00	2024-02-08 14:06:00.213517	178.131.96.102	
27	0	1	1.00	1.00	2024-02-08 14:08:07.755712	178.131.96.102	
28	0	1	1.00	1.00	2024-02-08 14:10:15.269199	178.131.96.102	
29	0	1	1.00	1.00	2024-02-08 14:14:38.381572	178.131.96.102	
30	0	1	1.00	1.00	2024-02-08 14:17:27.607655	178.131.96.102	
31	0	3	0.00	-2.00	2024-02-08 14:18:54.290551	178.131.96.102	
32	0	1	1.00	1.00	2024-02-08 14:20:37.221001	178.131.96.102	
33	0	1	1.00	1.00	2024-02-08 14:28:27.709087	178.131.96.102	
34	0	1	1.00	1.00	2024-02-08 14:31:21.322747	178.131.96.102	
35	0	1	1.00	1.00	2024-02-08 14:34:33.59739	178.131.96.102	
36	0	1	1.00	1.00	2024-02-08 14:36:00.217949	178.131.96.102	
37	0	1	1.00	1.00	2024-02-08 14:39:11.269543	178.131.96.102	
38	0	1	1.00	1.00	2024-02-08 14:59:08.394367	178.131.96.102	
39	0	1	1.00	1.00	2024-02-08 15:01:22.520939	178.131.96.102	
40	0	1	1.00	1.00	2024-02-08 15:02:09.857903	178.131.96.102	
41	0	1	1.00	1.00	2024-02-08 15:06:44.825837	178.131.96.102	
42	0	1	1.00	1.00	2024-02-08 15:12:39.014923	178.131.96.102	
43	0	1	1.00	1.00	2024-02-08 15:14:19.311717	178.131.96.102	
44	0	1	1.00	1.00	2024-02-08 15:17:12.126991	178.131.96.102	
45	0	1	1.00	1.00	2024-02-08 15:20:53.029425	178.131.96.102	
46	0	1	1.00	1.00	2024-02-08 15:23:09.604866	178.131.96.102	
47	0	1	1.00	1.00	2024-02-08 15:25:30.451904	178.131.96.102	
48	0	1	1.00	1.00	2024-02-08 15:26:30.80363	178.131.96.102	
49	0	1	1.00	1.00	2024-02-08 15:38:54.174987	178.131.97.214	
50	0	1	1.00	1.00	2024-02-08 15:45:19.679872	178.131.97.214	
51	0	1	1.00	1.00	2024-02-08 15:48:18.314194	178.131.97.214	
52	0	1	1.00	1.00	2024-02-08 16:00:27.856036	178.131.97.214	
53	0	1	1.00	1.00	2024-02-08 16:04:56.818468	178.131.97.214	
54	0	1	1.00	1.00	2024-02-08 16:07:41.245813	178.131.97.214	
55	0	1	1.00	1.00	2024-02-08 16:09:29.467812	178.131.97.214	
56	0	1	1.00	1.00	2024-02-08 16:22:07.310526	178.131.97.214	
57	0	1	1.00	1.00	2024-02-08 16:25:33.953573	178.131.97.214	
58	0	1	1.00	1.00	2024-02-08 16:28:34.713695	178.131.97.214	
59	0	1	1.00	1.00	2024-02-08 16:33:07.714654	178.131.97.214	
60	0	1	1.00	1.00	2024-02-08 16:38:23.469719	178.131.97.214	
61	0	1	1.00	1.00	2024-02-08 16:43:00.945227	178.131.97.214	
62	0	1	1.00	1.00	2024-02-08 16:46:55.979783	178.131.97.214	
63	0	1	1.00	1.00	2024-02-08 16:59:07.681019	178.131.97.214	
64	0	1	1.00	1.00	2024-02-08 17:01:25.643002	178.131.97.214	
65	0	1	1.00	1.00	2024-02-08 17:03:09.643413	178.131.97.214	
66	0	1	1.00	1.00	2024-02-08 17:07:57.908943	178.131.97.214	
67	0	1	1.00	1.00	2024-02-08 17:09:01.012193	178.131.97.214	
68	0	1	1.00	1.00	2024-02-08 17:11:50.449276	178.131.97.214	
69	0	1	1.00	1.00	2024-02-08 17:15:18.932373	178.131.97.214	
70	0	1	1.00	1.00	2024-02-08 17:24:32.674502	178.131.97.214	
71	0	1	1.00	1.00	2024-02-08 17:31:38.10798	178.131.97.214	
72	0	1	1.00	1.00	2024-02-08 17:35:43.51823	178.131.97.214	
73	0	1	1.00	1.00	2024-02-08 17:38:05.231955	178.131.97.214	
74	0	1	1.00	1.00	2024-02-08 17:40:49.216478	178.131.97.214	
75	0	1	1.00	1.00	2024-02-08 17:44:11.819471	178.131.97.214	
76	0	1	1.00	1.00	2024-02-08 17:46:38.592854	178.131.97.214	
77	0	1	1.00	1.00	2024-02-08 17:51:23.196207	178.131.97.214	
78	0	1	1.00	1.00	2024-02-08 17:53:09.803565	178.131.97.214	
79	0	1	1.00	1.00	2024-02-08 18:08:50.794816	178.131.97.214	
80	0	1	1.00	1.00	2024-02-08 18:11:34.977502	178.131.97.214	
81	0	1	1.00	1.00	2024-02-08 18:13:05.500287	178.131.97.214	
82	0	1	1.00	1.00	2024-02-08 18:14:39.522826	178.131.97.214	
83	0	1	1.00	1.00	2024-02-08 18:16:57.869677	178.131.97.214	
84	0	1	1.00	1.00	2024-02-08 18:18:01.934431	178.131.97.214	
85	0	1	1.00	1.00	2024-02-08 18:20:08.588818	178.131.97.214	
86	0	1	1.00	1.00	2024-02-08 18:24:52.353689	178.131.97.214	
87	0	1	1.00	1.00	2024-02-08 18:27:45.67378	178.131.97.214	
88	0	1	1.00	1.00	2024-02-08 18:31:10.943736	178.131.97.214	
89	0	1	1.00	1.00	2024-02-08 18:33:43.123608	178.131.98.143	
90	0	1	1.00	1.00	2024-02-08 18:35:56.313145	178.131.98.143	
91	0	1	1.00	1.00	2024-02-08 18:37:48.500696	178.131.98.143	
92	0	1	1.00	1.00	2024-02-08 18:39:44.616953	178.131.98.143	
93	0	1	1.00	1.00	2024-02-08 18:43:41.923139	178.131.98.143	
94	0	1	1.00	1.00	2024-02-08 18:45:31.380583	178.131.98.143	
95	0	1	1.00	1.00	2024-02-08 18:47:05.273445	178.131.98.143	
96	0	1	1.00	1.00	2024-02-08 18:49:55.188845	178.131.98.143	
97	0	1	1.00	1.00	2024-02-08 18:57:08.136535	178.131.98.143	
98	0	1	1.00	1.00	2024-02-08 18:58:18.484352	178.131.98.143	
99	0	1	1.00	1.00	2024-02-08 19:02:34.409563	178.131.98.143	
100	0	1	1.00	1.00	2024-02-08 19:05:49.38461	178.131.98.143	
101	0	1	1.00	1.00	2024-02-09 02:41:30.250298	213.202.217.17	
102	0	1	1.00	1.00	2024-02-09 02:51:59.513377	213.202.217.17	
103	0	1	1.00	1.00	2024-02-09 04:42:26.400751	213.202.217.17	
104	0	1	1.00	1.00	2024-02-09 05:23:48.015332	213.202.217.17	
105	0	1	1.00	1.00	2024-02-09 05:31:52.64075	213.202.217.17	
106	0	1	1.00	1.00	2024-02-09 06:03:08.126403	2.147.34.16	
107	0	1	1.00	1.00	2024-02-09 06:05:05.968162	2.147.34.16	
108	0	1	1.00	1.00	2024-02-09 06:07:22.20394	2.147.34.16	
109	0	3	0.00	-1.00	2024-02-09 11:18:01.67178	213.202.217.17	
110	0	1	1.00	1.00	2024-02-09 11:18:25.778687	213.202.217.17	
111	0	1	1.00	1.00	2024-02-09 15:09:21.017792	54.38.213.185	
112	0	1	1.00	1.00	2024-02-09 15:21:18.209347	54.38.213.185	
113	0	1	1.00	1.00	2024-02-10 05:05:09.454029	2.147.240.221	
114	0	1	1.00	1.00	2024-02-10 05:24:40.025935	147.135.204.116	
115	0	1	1.00	1.00	2024-02-10 07:46:54.507898	185.118.14.24	
116	0	1	1.00	1.00	2024-02-10 09:24:13.0335	147.135.204.116	
117	0	1	1.00	1.00	2024-02-10 10:32:50.2415	147.135.204.116	
118	0	1	1.00	1.00	2024-02-10 11:52:17.13621	147.135.204.116	
119	0	1	1.00	1.00	2024-02-10 11:53:41.995389	185.118.14.24	
120	0	1	1.00	1.00	2024-02-10 11:55:08.912966	185.118.14.24	
121	0	3	0.00	-1.00	2024-02-11 05:09:16.447283	46.4.197.230	
122	0	3	0.00	-1.00	2024-02-11 05:19:56.705022	46.4.197.230	
123	0	1	1.00	1.00	2024-02-11 05:20:26.037277	46.4.197.230	
124	0	1	1.00	1.00	2024-02-11 08:00:32.519296	2.147.45.54	
125	0	3	0.00	-1.00	2024-02-11 09:11:47.826348	46.4.197.230	
126	0	1	1.00	1.00	2024-02-11 15:35:15.531548	178.131.99.25	
127	0	1	1.00	1.00	2024-02-11 18:06:16.993356	147.135.204.116	
128	0	1	1.00	1.00	2024-02-12 01:39:50.503975	213.202.217.17	
129	0	1	1.00	1.00	2024-02-12 01:42:06.881916	213.202.217.17	
130	0	1	1.00	1.00	2024-02-12 01:54:52.682225	213.202.217.17	
131	0	3	0.00	-1.00	2024-02-12 01:55:48.805846	213.202.217.17	
132	0	1	1.00	1.00	2024-02-12 01:56:19.835	213.202.217.17	
133	0	1	1.00	1.00	2024-02-12 02:00:32.93574	213.202.217.17	
134	0	1	1.00	1.00	2024-02-12 03:19:40.392797	147.135.204.116	
135	0	1	1.00	1.00	2024-02-12 03:49:54.853334	185.118.14.24	
136	0	1	1.00	1.00	2024-02-12 03:52:21.613128	185.118.14.24	
137	0	1	1.00	1.00	2024-02-12 03:57:08.077015	185.118.14.24	
138	0	1	1.00	1.00	2024-02-12 04:03:20.126794	185.118.14.24	
139	0	1	1.00	1.00	2024-02-12 05:09:25.760298	185.118.14.24	
140	0	3	0.00	-1.00	2024-02-12 05:10:04.110119	185.118.14.24	
141	0	1	1.00	10.00	2024-02-12 05:10:38.583048	185.118.14.24	
142	0	3	0.00	-1.00	2024-02-12 05:39:15.549089	147.135.204.116	
143	0	1	1.00	1.00	2024-02-12 05:39:30.63768	147.135.204.116	
144	0	1	1.00	1.00	2024-02-12 12:45:43.6846	2.147.60.217	
145	0	1	1.00	1.00	2024-02-12 12:55:31.500876	54.38.213.185	
146	0	1	1.00	1.00	2024-02-12 16:07:16.558792	151.80.243.74	
147	0	1	1.00	1.00	2024-02-12 16:33:40.806337	147.135.204.116	
148	0	1	1.00	1.00	2024-02-13 04:53:25.324289	185.118.14.24	
149	0	1	1.00	1.00	2024-02-13 13:33:20.004034	213.202.217.17	
150	0	1	1.00	1.00	2024-02-13 15:20:50.513089	54.38.213.185	
151	0	1	1.00	1.00	2024-02-13 15:47:43.212031	46.105.88.74	
152	0	1	1.00	1.00	2024-02-13 17:22:13.902337	135.125.147.107	
153	0	1	1.00	1.00	2024-02-13 17:27:16.736103	135.125.147.107	
154	0	1	1.00	1.00	2024-02-13 17:51:22.350785	135.125.147.107	
155	0	3	0.00	-1.00	2024-02-13 23:56:27.009946	2.147.155.86	
156	0	1	1.00	1.00	2024-02-13 23:57:36.502052	2.147.155.86	
157	0	1	1.00	1.00	2024-02-14 05:43:59.313749	135.125.147.107	
158	0	3	0.00	-1.00	2024-02-14 14:30:08.412932	2.147.203.183	
159	0	1	1.00	1.00	2024-02-14 14:30:21.648159	2.147.203.183	
160	0	1	1.00	1.00	2024-02-14 14:56:36.209591	213.202.217.17	
161	0	3	0.00	-1.00	2024-02-14 15:35:34.435932	2.147.203.183	
162	0	1	1.00	1.00	2024-02-14 16:27:13.377782	213.202.217.17	
163	0	1	1.00	1.00	2024-02-15 02:18:17.996582	213.202.217.17	
164	0	1	1.00	1.00	2024-02-15 04:22:39.967979	2.147.64.22	
165	0	1	1.00	1.00	2024-02-15 04:26:18.75731	2.147.64.22	
166	0	1	1.00	1.00	2024-02-15 10:42:23.456461	213.202.217.17	
167	0	3	0.00	-1.00	2024-02-15 11:10:52.192573	213.202.217.17	
168	0	3	0.00	-1.00	2024-02-15 12:55:41.739887	2.147.49.140	
169	0	1	1.00	1.00	2024-02-15 12:56:08.138195	2.147.49.140	
170	0	1	1.00	1.00	2024-02-15 16:33:56.712177	135.125.147.107	
171	0	1	1.00	1.00	2024-02-15 17:13:26.954406	213.202.217.17	
172	0	1	1.00	1.00	2024-02-16 03:49:26.731808	213.202.217.17	
173	0	1	1.00	1.00	2024-02-16 04:54:13.019616	2.147.181.157	
174	0	3	0.00	-1.00	2024-02-16 16:19:09.931577	89.248.170.134	
175	0	1	1.00	1.00	2024-02-16 16:19:35.623153	89.248.170.134	
176	0	3	0.00	-1.00	2024-02-16 16:20:47.504702	89.248.170.134	
177	0	1	1.00	1.00	2024-02-16 16:32:07.902948	2.147.181.157	
178	0	3	0.00	-1.00	2024-02-17 00:49:26.508639	2.147.181.157	
179	0	1	1.00	1.00	2024-02-17 00:49:42.466794	2.147.181.157	
180	0	1	1.00	1.00	2024-02-17 00:49:50.521201	2.147.181.157	
181	0	1	1.00	1.00	2024-02-17 00:49:55.563561	2.147.181.157	
182	0	1	1.00	1.00	2024-02-17 00:50:00.0375	2.147.181.157	
183	0	1	1.00	1.00	2024-02-17 04:13:16.480501	185.118.14.24	
184	0	1	1.00	1.00	2024-02-17 05:03:05.070799	213.202.217.17	
185	0	1	1.00	1.00	2024-02-17 07:30:40.579232	185.118.14.24	
186	0	1	1.00	1.00	2024-02-17 08:25:55.911269	185.118.14.24	
187	0	1	1.00	1.00	2024-02-17 08:33:51.61661	185.118.14.24	
188	0	1	1.00	1.00	2024-02-17 08:36:18.037202	185.118.14.24	
189	0	1	1.00	1.00	2024-02-17 08:36:54.797731	185.118.14.24	
190	0	1	1.00	1.00	2024-02-17 08:40:50.406759	185.118.14.24	
191	0	3	0.00	-1.00	2024-02-17 13:16:31.720003	54.38.213.182	
192	0	1	1.00	1.00	2024-02-17 13:16:46.580686	54.38.213.182	
193	0	1	1.00	1.00	2024-02-17 13:51:06.94231	54.38.213.182	
194	0	1	1.00	1.00	2024-02-17 14:08:07.235222	54.38.213.182	
195	0	1	1.00	1.00	2024-02-17 14:11:51.425393	54.38.213.182	
196	0	1	1.00	1.00	2024-02-18 07:15:14.617107	185.118.14.24	
197	0	3	0.00	-1.00	2024-02-18 07:54:07.213481	185.118.14.24	
198	0	1	1.00	1.00	2024-02-18 07:54:21.737729	185.118.14.24	
199	0	1	1.00	1.00	2024-02-18 08:53:17.756375	185.118.14.24	
200	0	1	1.00	1.00	2024-02-18 11:18:13.996031	51.89.215.28	
201	0	1	1.00	1.00	2024-02-18 14:12:39.139271	213.202.217.17	
202	0	1	1.00	1.00	2024-02-18 14:12:45.718192	213.202.217.17	
203	0	1	1.00	1.00	2024-02-18 14:24:08.873741	213.202.217.17	
204	0	1	1.00	1.00	2024-02-18 16:06:06.322465	213.202.217.17	
205	0	3	0.00	-1.00	2024-02-18 16:58:38.937787	46.4.197.230	
206	0	1	1.00	1.00	2024-02-18 16:58:53.635175	46.4.197.230	
207	0	1	1.00	1.00	2024-02-18 17:00:52.740738	46.4.197.230	
208	0	3	0.00	-1.00	2024-02-19 02:04:51.401291	213.202.217.17	
209	0	1	1.00	1.00	2024-02-19 02:05:06.006053	213.202.217.17	
210	0	3	0.00	-1.00	2024-02-19 04:42:53.444061	2.147.22.106	
211	0	1	1.00	1.00	2024-02-19 04:43:12.825648	2.147.22.106	
212	0	1	1.00	1.00	2024-02-19 04:46:23.112115	2.147.22.106	
213	0	1	1.00	1.00	2024-02-19 07:24:30.702266	185.118.14.24	
214	0	1	1.00	1.00	2024-02-19 08:17:00.453193	185.118.14.24	
215	0	1	1.00	1.00	2024-02-19 09:31:12.866335	2.147.64.248	
216	0	1	1.00	1.00	2024-02-19 14:05:18.033078	213.202.217.17	
217	0	1	1.00	1.00	2024-02-19 14:21:55.527013	213.202.217.17	
218	0	1	1.00	1.00	2024-02-19 15:10:43.417985	93.117.187.181	
219	0	1	1.00	1.00	2024-02-19 15:40:45.72095	93.117.186.242	
220	0	1	1.00	1.00	2024-02-19 15:43:10.344407	93.117.186.242	
221	0	1	1.00	1.00	2024-02-19 15:43:51.479777	93.117.186.242	
222	0	1	1.00	1.00	2024-02-19 15:56:39.107922	93.117.186.242	
223	0	1	1.00	1.00	2024-02-19 17:26:09.168813	213.202.217.17	
224	0	1	1.00	1.00	2024-02-20 02:17:31.685205	185.118.14.24	
225	0	1	1.00	10.00	2024-02-20 12:12:00.939968	46.4.197.230	
226	0	1	1.00	10.00	2024-02-20 12:15:44.124706	46.4.197.230	
227	0	1	1.00	10.00	2024-02-20 12:15:45.476432	46.4.197.230	
228	0	1	1.00	1.00	2024-02-20 13:46:58.334176	46.4.197.230	
229	0	1	1.00	1.00	2024-02-20 15:40:24.510284	46.4.197.230	
230	0	1	1.00	1.00	2024-02-20 16:18:44.569364	93.117.185.100	
231	0	3	0.00	-10.00	2024-02-21 08:17:01.069416	46.4.197.230	
232	0	3	0.00	-1.00	2024-02-21 08:17:20.200024	46.4.197.230	
233	0	3	0.00	-1.00	2024-02-21 08:17:42.543839	46.4.197.230	
234	0	3	0.00	-4.00	2024-02-21 08:20:07.860486	46.4.197.230	
235	0	3	0.00	-1.00	2024-02-21 15:18:20.65007	46.4.197.230	
236	0	1	1.00	1.00	2024-02-21 15:18:36.114396	46.4.197.230	
237	0	1	1.00	1.00	2024-02-21 16:26:12.03428	46.4.197.230	
238	0	1	1.00	1.00	2024-02-22 04:33:19.86013	2.147.25.169	
239	0	1	1.00	1.00	2024-02-22 07:47:59.453755	46.4.197.230	
240	0	1	1.00	1.00	2024-02-22 07:50:14.272811	46.4.197.230	
241	0	1	1.00	1.00	2024-02-22 10:35:29.059131	46.4.197.230	
245	0	3	0.00	-1.00	2024-02-23 04:39:58.809159	213.202.217.17	
247	0	3	0.00	-1.00	2024-02-23 04:41:27.052871	213.202.217.17	
248	0	1	1.00	1.00	2024-02-23 04:48:04.641016	213.202.217.17	
249	0	3	0.00	-1.00	2024-02-23 15:45:52.706138	2.147.13.72	
251	0	3	0.00	-1.00	2024-02-24 07:14:53.935843	213.202.217.17	
252	0	1	1.00	1.00	2024-02-24 07:15:05.524345	213.202.217.17	
253	0	1	1.00	1.00	2024-02-24 10:27:25.933415	213.202.217.17	
254	0	3	0.00	-1.00	2024-02-24 15:54:32.582822	2.147.6.20	
256	0	1	1.00	2.00	2024-02-25 04:53:07.005698	93.117.187.53	
257	0	3	0.00	-2.00	2024-02-25 04:56:22.909225	93.117.187.53	
259	0	3	0.00	-3.00	2024-02-25 04:57:48.499659	93.117.187.53	
260	0	3	0.00	-1.00	2024-02-25 04:58:14.136267	93.117.187.53	
262	0	1	1.00	1.00	2024-02-25 06:17:41.721105	2.147.160.27	
264	0	3	0.00	-1.00	2024-02-25 12:57:21.21789	213.202.217.17	
265	0	1	1.00	1.00	2024-02-25 12:58:31.423827	213.202.217.17	
270	0	1	1.00	1.00	2024-02-25 15:20:55.65005	213.202.217.17	
272	0	1	1.00	1.00	2024-02-25 15:23:52.915951	213.202.217.17	
274	0	1	1.00	1.00	2024-02-26 00:54:23.352068	93.117.187.30	
275	0	3	0.00	-1.00	2024-02-26 00:57:09.314327	213.202.217.17	
276	0	1	1.00	1.00	2024-02-26 00:57:22.935463	213.202.217.17	
277	0	3	0.00	-1.00	2024-02-26 00:58:37.93516	213.202.217.17	
278	0	1	1.00	1.00	2024-02-26 00:58:52.265105	213.202.217.17	
279	0	3	0.00	-1.00	2024-02-26 00:59:42.472765	213.202.217.17	
280	0	1	1.00	1.00	2024-02-26 00:59:59.202105	213.202.217.17	
281	0	3	0.00	-1.00	2024-02-26 04:01:25.79365	185.118.14.24	
283	0	1	1.00	1.00	2024-02-26 09:26:11.873396	2.147.252.3	
284	0	1	1.00	1.00	2024-02-26 09:36:49.329718	2.147.252.3	
286	0	3	0.00	-1.00	2024-02-26 13:29:06.22281	93.117.185.229	
287	0	1	1.00	1.00	2024-02-26 15:04:29.030657	213.202.217.17	
288	0	1	1.00	1.00	2024-02-27 13:25:56.857627	147.135.204.116	
290	0	3	0.00	-1.00	2024-02-28 06:52:43.815358	185.118.14.24	
291	0	1	1.00	1.00	2024-02-28 06:52:53.252106	185.118.14.24	
293	0	1	1.00	1.00	2024-02-28 16:23:23.939964	2.147.66.24	
294	0	1	1.00	10.00	2024-02-28 16:32:12.983881	2.147.66.24	
297	0	1	1.00	1.00	2024-02-29 04:01:13.512525	2.147.173.182	
299	0	1	1.00	1.00	2024-02-29 07:48:51.407859	2.147.173.182	
301	0	1	1.00	1.00	2024-02-29 07:54:20.601197	2.147.173.182	
302	0	1	1.00	1.00	2024-02-29 08:00:55.249679	2.147.173.182	
303	0	1	1.00	1.00	2024-02-29 13:21:05.629605	51.89.215.28	
304	0	1	1.00	1.00	2024-02-29 14:29:18.785154	46.4.197.247	
306	0	1	1.00	1.00	2024-03-01 01:40:05.406616	213.202.217.17	
309	0	3	0.00	-1.00	2024-03-01 08:25:25.46734	93.117.184.174	
313	0	3	0.00	-1.00	2024-03-01 09:13:53.705723	93.117.184.174	
314	0	1	1.00	1.00	2024-03-01 09:14:08.362988	93.117.184.174	
315	0	1	1.00	1.00	2024-03-01 13:42:21.029527	188.40.183.147	
316	0	1	1.00	1.00	2024-03-02 05:32:31.102492	37.98.107.87	
317	0	1	1.00	1.00	2024-03-02 05:33:59.756135	185.118.14.24	
319	0	1	1.00	1.00	2024-03-02 06:46:40.433233	2.147.164.97	
320	0	3	0.00	-1.00	2024-03-02 13:48:29.195537	54.38.99.223	
321	0	1	1.00	1.00	2024-03-02 13:48:46.784526	54.38.99.223	
324	0	3	0.00	-1.00	2024-03-02 15:39:14.286737	54.38.99.223	
325	0	1	1.00	1.00	2024-03-02 15:39:27.38323	54.38.99.223	
328	0	3	0.00	-1.00	2024-03-03 14:31:17.40403	188.40.183.147	
329	0	1	1.00	1.00	2024-03-03 14:31:44.362726	188.40.183.147	
330	0	3	0.00	-1.00	2024-03-04 04:32:03.907892	188.40.183.147	
333	0	1	1.00	10.00	2024-03-05 05:00:57.535553	188.40.183.147	
335	0	1	1.00	1.00	2024-03-05 08:40:06.142146	37.98.87.107	
337	0	1	1.00	1.00	2024-03-05 14:35:03.759314	188.40.183.147	
338	0	3	0.00	-1.00	2024-03-05 14:50:01.53093	188.40.183.147	
339	0	1	1.00	1.00	2024-03-05 14:50:16.305911	188.40.183.147	
340	0	3	0.00	-1.00	2024-03-05 15:32:25.40872	188.40.183.147	
341	0	1	1.00	1.00	2024-03-05 15:32:42.105301	188.40.183.147	
342	0	3	0.00	-1.00	2024-03-06 08:56:53.655578	188.40.183.147	
346	0	3	0.00	-1.00	2024-03-06 15:54:32.030429	2.147.239.132	
350	0	3	0.00	-1.00	2024-03-06 23:53:26.852622	37.98.84.118	
353	0	3	0.00	-1.00	2024-03-06 23:54:44.456553	37.98.84.118	
355	0	3	0.00	-1.00	2024-03-07 00:11:51.444216	89.248.170.134	
356	0	1	1.00	1.00	2024-03-07 00:12:04.122209	89.248.170.134	
359	0	1	1.00	1.00	2024-03-07 06:05:50.499192	2.147.239.132	
362	0	3	0.00	-1.00	2024-03-08 06:59:35.511323	51.68.236.94	
364	0	1	1.00	1.00	2024-03-08 14:59:41.102641	51.68.236.94	
365	0	1	1.00	1.00	2024-03-08 15:18:35.931753	51.68.236.94	
370	0	3	0.00	-1.00	2024-03-09 12:32:15.622869	93.174.89.27	
375	0	1	1.00	1.00	2024-03-10 06:46:26.929817	2.147.71.174	
379	0	1	1.00	1.00	2024-03-10 13:29:49.900097	2.147.71.174	
380	0	3	0.00	-1.00	2024-03-10 16:52:27.617464	37.98.86.143	
383	0	1	1.00	1.00	2024-03-10 17:20:31.668703	2.147.71.174	
384	0	3	0.00	-1.00	2024-03-10 18:02:20.167482	2.147.71.174	
385	0	1	1.00	1.00	2024-03-10 18:02:47.209079	2.147.71.174	
386	0	1	1.00	10.00	2024-03-10 18:05:12.704752	188.40.183.147	
388	0	3	0.00	-1.00	2024-03-11 15:18:19.125016	2.147.10.236	
390	0	1	1.00	1.00	2024-03-11 15:28:25.76632	188.40.183.147	
391	0	1	1.00	1.00	2024-03-12 01:02:53.99307	188.40.183.147	
393	0	1	1.00	1.00	2024-03-12 03:20:46.336617	188.40.183.147	
394	0	1	1.00	1.00	2024-03-12 05:37:55.618003	94.102.53.89	
395	0	1	1.00	1.00	2024-03-12 13:42:31.042079	213.202.217.17	
396	0	1	1.00	1.00	2024-03-12 13:52:17.807229	213.202.217.17	
398	0	1	1.00	1.00	2024-03-12 14:08:08.110124	213.202.217.17	
401	0	1	1.00	1.00	2024-03-13 13:42:02.017208	54.38.99.223	
403	0	1	1.00	1.00	2024-03-13 16:19:36.779179	178.131.146.67	
404	0	1	1.00	1.00	2024-03-13 16:35:44.526289	178.131.146.33	
407	0	1	1.00	1.00	2024-03-14 14:14:19.581121	46.4.197.230	
408	0	3	0.00	-1.00	2024-03-14 14:27:58.919255	46.4.197.230	
409	0	1	1.00	1.00	2024-03-14 14:28:27.701138	46.4.197.230	
411	0	3	0.00	-1.00	2024-03-14 19:05:43.473673	2.147.222.8	
413	0	1	1.00	1.00	2024-03-15 05:41:12.099052	2.147.222.8	
414	0	1	1.00	1.00	2024-03-15 06:23:10.365107	46.105.88.74	
417	0	3	0.00	-1.00	2024-03-15 16:00:55.923048	178.131.144.98	
418	0	1	1.00	1.00	2024-03-15 16:01:31.498116	178.131.144.98	
419	0	1	1.00	1.00	2024-03-15 16:24:34.072754	2.147.127.108	
420	0	3	0.00	-1.00	2024-03-16 13:08:58.134423	54.38.99.223	
422	0	1	1.00	1.00	2024-03-16 13:11:18.021137	54.38.99.223	
424	0	1	1.00	1.00	2024-03-16 15:14:37.601633	178.131.146.43	
425	0	1	1.00	1.00	2024-03-16 15:17:06.350084	178.131.146.43	
426	0	3	0.00	-1.00	2024-03-16 16:31:08.113607	178.131.145.95	
428	0	1	1.00	1.00	2024-03-17 10:34:56.719979	2.147.245.196	
429	0	1	1.00	1.00	2024-03-17 13:36:05.707956	2.147.245.196	
432	0	1	1.00	1.00	2024-03-17 16:05:00.911528	178.131.145.130	
433	0	1	1.00	1.00	2024-03-17 16:23:14.33474	178.131.145.130	
434	0	1	1.00	1.00	2024-03-17 16:25:32.291984	178.131.145.130	
435	0	1	1.00	1.00	2024-03-17 17:09:59.224768	2.147.3.129	
437	0	3	0.00	-1.00	2024-03-18 05:19:01.204839	54.38.99.223	
438	0	1	1.00	1.00	2024-03-18 05:19:56.299288	54.38.99.223	
439	0	3	0.00	-1.00	2024-03-18 05:32:08.219923	54.38.99.223	
444	0	1	1.00	1.00	2024-03-18 17:03:39.162335	54.38.99.223	
445	0	1	1.00	1.00	2024-03-19 05:03:49.244695	2.147.19.94	
447	0	1	1.00	1.00	2024-03-19 12:38:08.80833	2.147.197.3	
449	0	1	1.00	1.00	2024-03-19 13:26:58.713703	54.38.99.223	
450	0	3	0.00	-1.00	2024-03-19 13:28:31.719951	54.38.99.223	
242	0	3	0.00	-1.00	2024-02-23 02:51:31.231026	213.202.217.17	
243	0	1	1.00	1.00	2024-02-23 02:51:44.437322	213.202.217.17	
244	0	1	1.00	1.00	2024-02-23 03:10:43.960777	213.202.217.17	
246	0	1	1.00	1.00	2024-02-23 04:40:14.241468	213.202.217.17	
250	0	1	1.00	1.00	2024-02-23 15:46:10.216662	2.147.13.72	
255	0	1	1.00	1.00	2024-02-24 15:54:57.938705	2.147.6.20	
258	0	3	0.00	-7.00	2024-02-25 04:57:06.818905	93.117.187.53	
261	0	3	0.00	-1.00	2024-02-25 06:17:30.707999	2.147.160.27	
263	0	1	1.00	1.00	2024-02-25 12:05:35.894948	213.202.217.17	
266	0	1	1.00	1.00	2024-02-25 13:51:14.030708	213.202.217.17	
267	0	3	0.00	-1.00	2024-02-25 14:22:04.842017	213.202.217.17	
268	0	1	1.00	1.00	2024-02-25 14:22:21.38498	213.202.217.17	
269	0	1	1.00	1.00	2024-02-25 14:33:15.029855	213.202.217.17	
271	0	3	0.00	-1.00	2024-02-25 15:23:32.936742	213.202.217.17	
273	0	3	0.00	-1.00	2024-02-26 00:54:07.045467	93.117.187.30	
282	0	1	1.00	1.00	2024-02-26 05:03:51.564189	185.118.14.24	
285	0	1	1.00	1.00	2024-02-26 13:18:49.148396	93.117.185.229	
289	0	1	1.00	1.00	2024-02-27 13:57:22.075902	2.147.127.26	
292	0	1	1.00	1.00	2024-02-28 07:41:06.275061	89.248.170.134	
295	0	3	0.00	-1.00	2024-02-29 03:58:49.584416	2.147.173.182	
296	0	1	1.00	1.00	2024-02-29 03:58:59.698787	2.147.173.182	
298	0	3	0.00	-1.00	2024-02-29 07:10:01.278022	2.147.173.182	
300	0	3	0.00	-1.00	2024-02-29 07:54:11.192526	2.147.173.182	
305	0	3	0.00	-1.00	2024-03-01 01:39:51.417531	213.202.217.17	
307	0	3	0.00	-1.00	2024-03-01 02:36:31.017801	213.202.217.17	
308	0	1	1.00	1.00	2024-03-01 02:37:02.420437	213.202.217.17	
310	0	1	1.00	1.00	2024-03-01 08:25:41.545372	93.117.184.174	
311	0	3	0.00	-1.00	2024-03-01 09:12:37.212019	93.117.184.174	
312	0	1	1.00	1.00	2024-03-01 09:12:50.070792	93.117.184.174	
318	0	3	0.00	-1.00	2024-03-02 06:46:27.703204	2.147.164.97	E
322	0	1	1.00	1.00	2024-03-02 15:16:20.637222	54.38.99.223	
323	0	1	1.00	1.00	2024-03-02 15:34:24.761574	54.38.99.223	
326	0	3	0.00	-1.00	2024-03-03 02:38:13.398889	2.147.153.246	
327	0	1	1.00	1.00	2024-03-03 02:38:29.471585	2.147.153.246	
331	0	1	1.00	1.00	2024-03-04 04:32:17.81503	188.40.183.147	
332	0	1	1.00	1.00	2024-03-04 14:34:51.143077	188.40.183.147	
334	0	3	0.00	-1.00	2024-03-05 08:39:45.306302	37.98.87.107	
336	0	1	1.00	1.00	2024-03-05 12:41:56.43579	147.135.204.116	
343	0	1	1.00	1.00	2024-03-06 08:57:14.547105	188.40.183.147	
344	0	1	1.00	1.00	2024-03-06 10:57:25.438606	188.40.183.147	
345	0	1	1.00	1.00	2024-03-06 14:02:15.121769	188.40.183.147	
347	0	1	1.00	1.00	2024-03-06 15:54:44.9081	2.147.239.132	
348	0	3	0.00	-1.00	2024-03-06 15:55:01.105611	2.147.239.132	
349	0	1	1.00	1.00	2024-03-06 15:55:16.495993	2.147.239.132	
351	0	1	1.00	1.00	2024-03-06 23:53:40.38729	37.98.84.118	
352	0	1	1.00	1.00	2024-03-06 23:54:12.356643	37.98.84.118	
354	0	1	1.00	1.00	2024-03-06 23:55:19.732691	37.98.84.118	
357	0	1	1.00	1.00	2024-03-07 03:35:44.379637	188.40.183.147	
358	0	1	1.00	1.00	2024-03-07 03:37:08.911645	188.40.183.147	
360	0	3	0.00	-1.00	2024-03-08 02:37:30.767652	2.147.67.17	
361	0	1	1.00	1.00	2024-03-08 02:38:30.534633	2.147.67.17	
363	0	1	1.00	1.00	2024-03-08 06:59:47.820932	51.68.236.94	
366	0	3	0.00	-1.00	2024-03-08 23:50:50.372808	37.98.87.232	
367	0	1	1.00	1.00	2024-03-09 03:40:33.490566	2.147.234.223	
368	0	3	0.00	-1.00	2024-03-09 03:42:40.190966	2.147.234.223	
369	0	1	1.00	1.00	2024-03-09 03:42:54.804493	2.147.234.223	
371	0	1	1.00	1.00	2024-03-09 12:32:34.503039	93.174.89.27	
372	0	1	1.00	1.00	2024-03-09 15:09:39.049045	188.40.183.147	
373	0	3	0.00	-1.00	2024-03-10 03:00:20.49148	2.147.71.174	
374	0	1	1.00	1.00	2024-03-10 03:00:38.277781	2.147.71.174	
376	0	3	0.00	-1.00	2024-03-10 13:26:34.327461	2.147.71.174	
377	0	1	1.00	1.00	2024-03-10 13:28:14.529517	2.147.71.174	
378	0	3	0.00	-1.00	2024-03-10 13:29:35.426108	2.147.71.174	
381	0	1	1.00	1.00	2024-03-10 17:01:01.067054	37.98.86.143	
382	0	1	1.00	1.00	2024-03-10 17:20:31.220807	2.147.71.174	
387	0	1	1.00	10.00	2024-03-10 18:09:50.871667	188.40.183.147	
389	0	1	1.00	1.00	2024-03-11 15:18:32.690718	2.147.10.236	
392	0	1	1.00	1.00	2024-03-12 01:02:59.352974	188.40.183.147	
397	0	3	0.00	-1.00	2024-03-12 14:07:39.017719	213.202.217.17	
399	0	3	0.00	-1.00	2024-03-12 16:46:50.884313	2.147.13.130	
400	0	1	1.00	1.00	2024-03-12 16:47:06.598462	2.147.13.130	
402	0	1	1.00	1.00	2024-03-13 14:41:22.634767	89.248.170.134	
405	0	1	1.00	1.00	2024-03-13 16:49:21.08036	46.4.197.230	
406	0	1	1.00	1.00	2024-03-13 16:51:06.840234	46.4.197.230	
410	0	1	1.00	1.00	2024-03-14 14:41:13.351149	46.4.197.230	
412	0	1	1.00	1.00	2024-03-14 19:06:10.954127	2.147.222.8	
415	0	3	0.00	-1.00	2024-03-15 08:24:48.998867	46.105.88.74	
416	0	1	1.00	1.00	2024-03-15 08:25:06.329371	46.105.88.74	
421	0	1	1.00	1.00	2024-03-16 13:09:11.027331	54.38.99.223	
423	0	3	0.00	-1.00	2024-03-16 15:06:41.176646	178.131.146.43	
427	0	1	1.00	1.00	2024-03-16 16:31:20.353758	178.131.145.95	
430	0	1	1.00	1.00	2024-03-17 13:36:34.928339	2.147.245.196	
431	0	3	0.00	-1.00	2024-03-17 15:16:32.238188	178.131.145.130	
436	0	1	1.00	1.00	2024-03-17 17:10:07.443731	2.147.3.129	
440	0	1	1.00	1.00	2024-03-18 06:26:51.643607	54.38.99.223	
441	0	3	0.00	-1.00	2024-03-18 16:54:58.812024	54.38.99.223	
442	0	1	1.00	1.00	2024-03-18 16:55:14.533163	54.38.99.223	
443	0	3	0.00	-1.00	2024-03-18 17:03:23.201236	54.38.99.223	
446	0	3	0.00	-1.00	2024-03-19 12:37:38.621259	2.147.197.3	
448	0	3	0.00	-1.00	2024-03-19 13:26:06.627905	54.38.99.223	
451	0	1	1.00	1.00	2024-03-19 13:28:52.634064	54.38.99.223	
452	0	1	1.00	1.00	2024-03-19 13:28:53.715318	54.38.99.223	
453	0	3	0.00	-1.00	2024-03-19 13:29:28.003989	54.38.99.223	
454	0	1	1.00	1.00	2024-03-19 13:30:22.786649	54.38.99.223	
455	0	1	1.00	1.00	2024-03-19 15:15:38.199182	54.38.99.223	
456	0	1	1.00	1.00	2024-03-22 13:33:40.044426	54.38.99.223	
457	0	3	0.00	-1.00	2024-03-22 13:34:41.014895	54.38.99.223	
458	0	1	1.00	1.00	2024-03-22 13:34:59.835774	54.38.99.223	
459	0	3	0.00	-1.00	2024-03-23 09:31:12.536966	46.4.197.230	
460	0	1	1.00	1.00	2024-03-23 09:31:31.763565	46.4.197.230	
461	0	3	0.00	-1.00	2024-03-23 09:42:27.846	46.4.197.230	
462	0	1	1.00	1.00	2024-03-23 09:42:38.762101	46.4.197.230	
463	0	1	1.00	1.00	2024-03-24 10:47:22.997643	2.147.12.105	
464	0	1	1.00	1.00	2024-03-24 10:47:23.200898	2.147.12.105	
465	0	1	1.00	1.00	2024-03-25 05:06:25.06298	54.38.99.223	
466	0	3	0.00	-1.00	2024-03-25 06:05:36.221675	54.38.99.223	
467	0	1	1.00	1.00	2024-03-25 06:05:51.800033	54.38.99.223	
468	0	1	1.00	1.00	2024-03-26 04:37:51.178187	62.102.134.107	
469	0	1	1.00	1.00	2024-03-27 04:00:59.436791	62.102.135.85	
470	0	1	1.00	1.00	2024-03-27 04:17:48.959583	147.135.204.116	
471	0	1	1.00	1.00	2024-03-27 04:18:19.927976	147.135.204.116	
472	0	1	1.00	1.00	2024-03-28 03:51:29.010287	62.102.133.136	
473	0	3	0.00	-1.00	2024-03-28 13:55:37.504807	147.135.204.116	
474	0	1	1.00	1.00	2024-03-28 19:04:57.656197	46.4.197.230	
475	0	1	1.00	1.00	2024-03-29 06:50:30.091866	2.147.205.210	
476	0	1	1.00	1.00	2024-03-29 09:08:43.745081	46.4.197.230	
477	0	3	0.00	-1.00	2024-03-29 14:21:42.930784	46.4.197.230	
478	0	1	1.00	1.00	2024-03-30 15:10:39.404419	46.4.197.230	
479	0	3	0.00	-1.00	2024-03-30 16:12:03.496337	46.4.197.230	
480	0	1	1.00	1.00	2024-03-31 04:05:47.59491	62.102.133.206	
481	0	3	0.00	-1.00	2024-03-31 12:15:35.398202	5.117.156.128	
482	0	1	1.00	1.00	2024-03-31 12:15:53.332324	5.117.156.128	
483	0	3	0.00	-1.00	2024-03-31 16:28:41.39872	89.198.3.177	
484	0	1	1.00	1.00	2024-03-31 16:49:20.122651	2.147.221.173	
485	0	1	1.00	1.00	2024-03-31 16:49:38.17245	89.198.116.89	
486	0	3	0.00	-1.00	2024-04-01 16:04:03.20274	2.147.172.114	
487	0	1	1.00	1.00	2024-04-01 16:05:13.152237	2.147.172.114	
488	0	1	1.00	1.00	2024-04-02 04:38:48.612309	185.118.14.24	
489	0	1	1.00	1.00	2024-04-02 07:19:00.828746	89.248.170.134	
490	0	1	1.00	1.00	2024-04-02 16:43:26.073768	93.174.89.27	
491	0	1	1.00	1.00	2024-04-02 16:45:16.92598	93.174.89.27	
492	0	1	1.00	1.00	2024-04-03 04:54:10.738851	185.118.14.24	
493	0	3	0.00	-1.00	2024-04-03 04:54:21.085769	185.118.14.24	
494	0	1	1.00	1.00	2024-04-03 17:56:30.892787	62.102.135.18	
495	0	1	1.00	1.00	2024-04-04 02:48:14.295831	185.118.14.24	
496	0	1	1.00	1.00	2024-04-04 07:42:06.294876	54.38.99.223	
497	0	1	1.00	1.00	2024-04-04 08:01:22.584124	54.38.99.223	
498	0	1	1.00	1.00	2024-04-04 09:42:04.248402	2.147.146.75	
499	0	1	1.00	1.00	2024-04-05 04:26:17.819118	62.102.135.180	
500	0	3	0.00	-1.00	2024-04-05 10:04:45.324579	2.147.237.58	
501	0	1	1.00	1.00	2024-04-05 10:04:57.36128	2.147.237.58	
502	0	3	0.00	-1.00	2024-04-05 13:45:50.326971	157.90.139.153	
503	0	1	1.00	1.00	2024-04-05 16:13:40.537794	2.147.140.97	
504	0	1	1.00	1.00	2024-04-05 16:14:12.236169	2.147.140.97	
505	0	1	1.00	1.00	2024-04-06 17:06:11.890976	147.135.204.116	
506	0	1	1.00	1.00	2024-04-07 15:14:39.346483	2.147.14.9	
507	0	1	1.00	1.00	2024-04-08 16:23:06.641348	2.147.197.166	
508	0	1	1.00	1.00	2024-04-08 17:34:12.523864	46.4.197.230	
509	0	1	1.00	1.00	2024-04-09 02:07:55.383622	147.135.204.116	
510	0	1	1.00	1.00	2024-04-09 06:34:31.818438	147.135.204.116	
511	0	1	10.00	100.00	2024-04-09 06:57:00.029299	147.135.204.116	
512	0	3	0.00	-70.00	2024-04-09 07:00:05.45046	178.131.152.176	
513	0	3	0.00	-31.00	2024-04-09 07:00:27.384559	178.131.152.176	
514	0	1	10.00	100.00	2024-04-09 07:00:53.625043	178.131.152.176	
515	0	1	1.00	1.00	2024-04-09 12:42:10.101029	2.147.208.238	
516	0	1	1.00	1.00	2024-04-10 11:01:23.42178	51.195.248.144	
517	0	1	1.00	1.00	2024-04-11 11:31:48.807046	89.248.170.134	
518	0	1	1.00	1.00	2024-04-11 16:10:37.218422	51.195.248.144	
519	0	1	1.00	1.00	2024-04-11 16:13:14.925558	178.131.144.219	
520	0	1	1.00	1.00	2024-04-12 14:39:45.721084	2.147.15.26	
521	0	1	1.00	1.00	2024-04-13 16:28:03.139897	54.38.99.223	
522	0	1	1.00	1.00	2024-04-14 02:18:19.477014	46.4.197.230	
523	0	3	0.00	-1.00	2024-04-14 02:18:38.230065	46.4.197.230	
524	0	1	1.00	1.00	2024-04-14 02:18:54.603106	46.4.197.230	
525	0	1	1.00	1.00	2024-04-14 06:14:36.488609	178.131.155.136	
526	0	1	1.00	1.00	2024-04-14 13:40:48.116792	93.117.180.113	
527	0	1	1.00	1.00	2024-04-14 14:40:38.402361	46.4.197.230	
528	0	1	1.00	1.00	2024-04-14 14:54:33.223839	46.4.197.230	
529	0	1	1.00	1.00	2024-04-15 13:20:03.724124	46.4.197.230	
530	0	1	1.00	1.00	2024-04-15 13:20:08.780559	46.4.197.230	
531	0	1	1.00	1.00	2024-04-15 13:22:55.130303	46.4.197.230	
532	0	1	1.00	1.00	2024-04-15 13:22:55.515901	46.4.197.230	
533	0	1	1.00	1.00	2024-04-15 16:19:40.347876	93.117.182.5	
534	0	1	1.00	1.00	2024-04-15 16:39:42.958322	93.117.181.191	
535	0	1	1.00	1.00	2024-04-16 13:22:10.492902	54.38.99.223	
536	0	1	1.00	1.00	2024-04-17 13:36:25.376367	178.131.128.49	
537	0	1	1.00	1.00	2024-04-17 17:10:51.901291	188.40.183.147	
538	0	1	1.00	1.00	2024-04-18 08:32:17.573216	2.147.207.149	
539	0	1	1.00	1.00	2024-04-18 13:45:50.499774	5.217.116.152	
540	0	1	1.00	1.00	2024-04-18 19:50:13.045101	178.131.129.197	
541	0	1	1.00	1.00	2024-04-19 07:42:53.800596	188.40.183.147	
542	0	1	1.00	1.00	2024-04-19 08:03:40.373298	188.40.183.147	
543	0	1	1.00	1.00	2024-04-20 16:59:52.177614	188.40.183.147	
544	0	1	1.00	1.00	2024-04-21 14:01:47.316077	89.248.170.134	
545	0	1	1.00	1.00	2024-04-21 15:45:56.736063	89.248.170.134	
546	0	3	0.00	-1.00	2024-04-21 15:46:18.694933	89.248.170.134	
547	0	1	1.00	1.00	2024-04-21 15:46:40.675241	89.248.170.134	
548	0	1	1.00	1.00	2024-04-21 16:11:14.451339	89.248.170.134	
549	0	1	1.00	1.00	2024-04-21 16:12:52.536052	89.248.170.134	
550	0	3	0.00	-1.00	2024-04-22 04:50:44.716683	2.147.118.8	
551	0	1	1.00	1.00	2024-04-22 04:51:39.792328	2.147.118.8	
552	0	3	0.00	-1.00	2024-04-23 05:03:45.338561	89.248.170.134	
553	0	1	1.00	1.00	2024-04-23 05:07:13.279648	89.248.170.134	
554	0	1	1.00	1.00	2024-04-24 05:38:31.953369	2.147.212.56	
555	0	1	1.00	1.00	2024-04-24 05:38:39.208176	2.147.212.56	
556	0	1	1.00	1.00	2024-04-24 16:46:38.232362	89.248.170.134	
557	0	1	1.00	1.00	2024-04-24 16:46:40.169206	89.248.170.134	
558	0	1	1.00	1.00	2024-04-25 06:38:13.020286	89.248.170.134	
559	0	3	0.00	-1.00	2024-04-25 14:16:12.204848	2.147.224.250	
560	0	1	1.00	1.00	2024-04-26 07:56:34.975717	2.147.128.233	
561	0	1	10.00	100.00	2024-04-26 11:21:47.084987	137.74.64.231	
562	0	1	1.00	1.00	2024-04-26 12:14:20.830347	137.74.64.231	
563	0	1	1.00	1.00	2024-04-27 05:49:44.635441	46.4.197.230	
564	0	3	0.00	-1.00	2024-04-27 16:14:07.169622	178.131.161.247	
565	0	1	1.00	1.00	2024-04-28 01:04:46.611648	178.131.163.78	
566	0	1	1.00	1.00	2024-04-28 14:21:55.697691	147.135.204.116	
567	0	1	1.00	1.00	2024-04-28 14:22:06.016681	147.135.204.116	
568	0	1	1.00	1.00	2024-04-28 14:25:36.105633	147.135.204.116	
569	0	1	1.00	1.00	2024-04-28 15:48:19.740941	147.135.204.116	
570	0	1	1.00	1.00	2024-04-29 04:23:33.693948	5.201.191.28	
571	0	1	1.00	1.00	2024-04-29 06:29:42.874429	2.147.248.171	
572	0	1	1.00	1.00	2024-04-30 03:28:49.466591	5.201.191.28	
573	0	1	1.00	1.00	2024-04-30 07:59:40.886052	2.147.68.14	
574	0	1	1.00	1.00	2024-04-30 14:17:16.456045	188.40.183.147	
575	0	1	10.00	100.00	2024-04-30 14:17:29.468115	188.40.183.147	
576	0	1	1.00	1.00	2024-05-01 00:49:06.225561	178.131.162.195	
577	0	1	1.00	1.00	2024-05-01 14:27:35.799164	89.248.170.134	
578	0	1	1.00	1.00	2024-05-02 09:12:09.66008	54.38.99.223	
579	0	1	1.00	1.00	2024-05-03 13:09:50.49619	188.40.183.147	
580	0	3	0.00	-1.00	2024-05-05 15:19:53.171083	178.131.161.219	
581	0	1	1.00	1.00	2024-05-05 15:20:04.913062	178.131.161.219	
582	0	1	1.00	1.00	2024-05-05 15:40:47.344853	178.131.161.219	
583	0	1	1.00	1.00	2024-05-06 15:30:33.247072	2.147.142.27	
584	0	1	1.00	1.00	2024-05-08 07:39:01.979045	54.38.99.223	
585	0	1	1.00	1.00	2024-05-08 15:20:58.46898	178.131.160.66	
586	0	3	0.00	-10.00	2024-05-08 16:08:13.185067	54.38.99.223	
587	0	1	1.00	1.00	2024-05-08 16:08:41.963839	54.38.99.223	
588	0	1	1.00	1.00	2024-05-09 05:17:39.810573	5.201.191.28	
589	0	1	1.00	10.00	2024-05-11 12:54:25.862361	2.147.126.200	
590	0	1	1.00	1.00	2024-05-11 13:02:55.306002	2.147.126.200	
591	0	1	1.00	1.00	2024-05-13 15:39:41.913433	93.117.186.254	
592	0	1	1.00	1.00	2024-05-13 17:02:42.942628	46.4.197.230	
593	0	1	1.00	1.00	2024-05-13 17:07:36.671514	46.4.197.230	
594	0	1	1.00	1.00	2024-05-14 14:08:50.866259	188.40.183.147	
595	0	1	1.00	1.00	2024-05-14 16:28:25.669461	93.117.184.51	
596	0	1	1.00	1.00	2024-05-15 16:25:53.870628	188.40.183.147	
597	0	1	1.00	1.00	2024-05-17 15:27:07.614163	46.4.197.247	
598	0	1	1.00	1.00	2024-05-17 15:27:08.741778	46.4.197.247	
599	0	3	0.00	-1.00	2024-05-18 13:33:01.957047	62.102.134.203	
600	0	1	1.00	1.00	2024-05-18 13:33:19.059646	62.102.134.203	
601	0	1	1.00	1.00	2024-05-19 12:50:59.381759	62.102.134.26	
602	0	1	1.00	1.00	2024-05-19 14:21:57.559899	62.102.132.34	
603	0	1	1.00	1.00	2024-05-19 15:18:50.776592	188.40.183.147	
604	0	1	1.00	1.00	2024-05-20 03:54:47.72057	5.201.191.28	
605	0	1	1.00	10.00	2024-05-20 05:44:09.850926	188.40.183.147	
606	0	3	0.00	-1.00	2024-05-20 12:35:42.863242	2.147.146.109	
607	0	1	1.00	1.00	2024-05-21 12:11:29.387713	5.201.191.28	
608	0	3	0.00	-1.00	2024-05-21 12:12:28.069514	5.201.191.28	
609	0	1	1.00	1.00	2024-05-21 15:54:12.592719	2.147.233.252	
610	0	3	0.00	-1.00	2024-05-24 03:29:19.050409	2.147.36.94	
611	0	3	0.00	-1.00	2024-05-24 15:57:57.183413	54.38.99.223	
612	0	1	1.00	1.00	2024-05-24 15:58:23.66142	54.38.99.223	
613	0	1	1.00	1.00	2024-05-26 06:40:48.247527	2.147.174.163	
614	0	3	0.00	-1.00	2024-05-26 14:22:46.787866	54.38.99.223	
615	0	1	1.00	1.00	2024-05-26 14:23:08.777793	54.38.99.223	
616	0	1	1.00	10.00	2024-05-26 17:23:06.447219	54.38.99.223	
617	0	1	1.00	1.00	2024-05-26 17:28:55.894104	54.38.99.223	
618	0	1	1.00	1.00	2024-05-26 17:28:57.088945	54.38.99.223	
619	0	1	1.00	1.00	2024-05-27 10:19:50.70976	5.201.191.28	
620	0	1	1.00	1.00	2024-05-27 16:32:25.545891	54.38.99.223	
621	0	1	1.00	1.00	2024-05-27 16:42:39.117526	54.38.99.223	
622	0	1	1.00	1.00	2024-05-27 16:43:51.806987	54.38.99.223	
623	0	3	0.00	-1.00	2024-05-29 01:26:20.067886	54.38.99.223	
624	0	1	1.00	1.00	2024-05-29 01:50:53.866818	2.147.76.249	
625	0	1	1.00	1.00	2024-05-29 05:51:33.245409	2.147.76.249	
626	0	1	1.00	1.00	2024-05-29 12:04:08.949206	2.147.76.249	
627	0	3	0.00	-1.00	2024-05-30 03:58:13.259933	2.147.183.95	
628	0	1	1.00	1.00	2024-05-30 09:17:03.488122	54.38.99.223	
629	0	1	1.00	1.00	2024-05-30 09:39:55.578384	54.38.99.223	
630	0	1	1.00	1.00	2024-05-30 15:41:14.166212	157.90.139.153	
631	0	3	0.00	-1.00	2024-05-30 16:44:37.648118	157.90.139.153	
632	0	1	1.00	10.00	2024-05-31 16:40:17.67696	157.90.139.153	
633	0	1	1.00	1.00	2024-06-01 13:50:10.527338	2.147.67.133	
634	0	1	1.00	1.00	2024-06-01 15:13:38.210272	147.135.204.116	
635	0	1	1.00	1.00	2024-06-02 08:05:19.180684	2.147.135.175	
636	0	1	1.00	1.00	2024-06-03 04:34:06.522131	2.147.135.175	
637	0	1	1.00	10.00	2024-06-04 15:00:04.657533	147.135.204.116	
638	0	3	0.00	-1.00	2024-06-05 12:33:00.471926	188.213.194.82	
639	0	1	1.00	1.00	2024-06-05 15:06:59.976163	188.213.194.247	
640	0	1	1.00	1.00	2024-06-05 15:07:16.845583	188.213.194.247	
641	0	1	1.00	1.00	2024-06-06 01:40:56.897763	188.213.194.205	
642	0	1	1.00	1.00	2024-06-07 14:41:19.011428	2.147.255.37	
643	0	3	0.00	-1.00	2024-06-07 15:05:52.7457	2.147.255.37	
644	0	1	1.00	1.00	2024-06-07 16:35:03.64333	2.147.255.37	
645	0	1	1.00	1.00	2024-06-08 06:00:29.04203	54.38.99.223	
646	0	1	1.00	1.00	2024-06-08 09:10:34.287985	54.38.99.223	
647	0	1	1.00	1.00	2024-06-08 15:22:10.636459	178.131.152.11	
648	0	1	1.00	1.00	2024-06-08 15:24:17.625103	178.131.152.11	
649	0	1	1.00	1.00	2024-06-08 15:25:26.605711	178.131.152.11	
650	0	1	1.00	1.00	2024-06-08 17:46:20.838581	178.131.155.69	
651	0	3	0.00	-1.00	2024-06-08 18:02:11.234795	54.38.99.223	
652	0	1	1.00	1.00	2024-06-08 18:03:18.478423	54.38.99.223	
653	0	1	1.00	10.00	2024-06-09 15:45:49.717926	51.89.157.215	
654	0	1	1.00	1.00	2024-06-10 11:22:17.912296	51.89.157.215	
655	0	1	1.00	1.00	2024-06-10 17:26:41.618375	89.248.170.134	
656	0	1	1.00	1.00	2024-06-10 17:30:19.108615	89.248.170.134	
657	0	1	1.00	1.00	2024-06-11 04:18:40.066453	5.201.191.28	
658	0	1	1.00	1.00	2024-06-11 16:35:19.522008	51.195.236.148	
659	0	3	0.00	-1.00	2024-06-12 11:42:51.324257	5.201.191.28	
660	0	3	0.00	-1.00	2024-06-14 08:53:16.255047	5.117.219.103	
661	0	1	1.00	1.00	2024-06-15 03:15:10.823804	2.147.43.147	
662	0	3	0.00	-1.00	2024-06-15 15:23:02.785768	89.248.170.134	
663	0	3	0.00	-1.00	2024-06-15 15:27:36.045812	89.248.170.134	
664	0	3	0.00	-1.00	2024-06-16 14:44:50.884847	2.147.137.139	
665	0	3	0.00	-1.00	2024-06-16 15:04:48.701269	2.147.49.171	
666	0	1	1.00	1.00	2024-06-16 15:50:23.888105	93.119.212.95	
667	0	3	0.00	-1.00	2024-06-16 16:11:13.789091	93.119.212.95	
668	0	3	0.00	-1.00	2024-06-16 16:13:54.440906	93.119.212.95	
669	0	1	1.00	1.00	2024-06-16 16:19:12.572526	93.119.212.95	
670	0	1	1.00	1.00	2024-06-16 16:19:17.808134	93.119.212.95	
671	0	3	0.00	-1.00	2024-06-16 16:45:00.363968	93.119.215.234	
672	0	3	0.00	-1.00	2024-06-17 05:25:00.736433	51.89.157.215	
673	0	1	1.00	1.00	2024-06-17 05:37:29.636087	51.89.157.215	
674	0	3	0.00	-1.00	2024-06-17 08:28:30.582188	51.89.157.215	
675	0	3	0.00	-1.00	2024-06-17 14:22:25.058455	51.89.157.215	
676	0	1	1.00	1.00	2024-06-17 14:58:00.347364	51.89.157.215	
677	0	1	1.00	1.00	2024-06-17 14:58:00.855426	51.89.157.215	
678	0	1	1.00	1.00	2024-06-18 05:48:06.052173	157.90.139.153	
679	0	3	0.00	-1.00	2024-06-18 12:28:45.439941	157.90.139.153	
680	0	3	0.00	-1.00	2024-06-18 13:13:17.151058	89.248.170.134	
681	0	1	1.00	1.00	2024-06-19 06:14:54.260197	2.147.58.95	
682	0	1	1.00	1.00	2024-06-19 06:15:51.239638	2.147.58.95	
683	0	1	1.00	1.00	2024-06-19 06:16:32.006966	2.147.58.95	
684	0	3	0.00	-1.00	2024-06-19 12:53:31.80689	2.147.58.95	
685	0	1	1.00	1.00	2024-06-19 15:37:50.356078	2.147.10.251	
686	0	1	1.00	1.00	2024-06-19 17:32:04.95143	54.36.194.237	
687	0	1	1.00	1.00	2024-06-20 13:16:10.227807	2.147.174.56	
688	0	1	1.00	1.00	2024-06-22 03:53:45.454801	54.38.99.223	
689	0	1	1.00	1.00	2024-06-22 14:35:27.456729	54.36.194.237	
690	0	1	1.00	1.00	2024-06-22 14:39:58.755636	54.36.194.237	
691	0	1	1.00	1.00	2024-06-23 03:44:22.010753	5.201.191.28	
692	0	1	1.00	1.00	2024-06-24 06:46:47.947661	54.36.194.237	
693	0	3	0.00	-1.00	2024-06-24 12:28:45.316547	5.215.60.82	
694	0	1	1.00	10.00	2024-06-24 17:38:27.697783	51.195.236.148	
695	0	1	1.00	1.00	2024-06-25 04:08:48.256127	89.198.149.15	
696	0	1	1.00	1.00	2024-06-25 04:11:33.301988	89.198.149.15	
697	0	1	1.00	1.00	2024-06-25 18:05:00.151478	147.135.204.116	
698	0	3	0.00	-1.00	2024-06-26 01:17:20.403878	2.147.120.93	
699	0	1	1.00	1.00	2024-06-26 14:50:48.86107	46.4.197.230	
700	0	1	1.00	1.00	2024-06-27 01:07:54.026431	51.89.157.215	
701	0	3	0.00	-1.00	2024-06-27 17:43:48.745279	54.36.194.237	
702	0	1	1.00	1.00	2024-06-28 08:11:13.438751	157.90.139.153	
703	0	1	1.00	1.00	2024-06-28 14:51:36.481505	5.112.69.29	
704	0	1	1.00	1.00	2024-06-30 05:43:55.249614	2.147.218.235	
705	0	1	1.00	1.00	2024-06-30 08:58:54.201943	51.195.236.148	
706	0	1	1.00	10.00	2024-06-30 17:13:15.513006	89.248.170.134	
707	0	3	0.00	-1.00	2024-07-01 12:23:31.745115	5.115.115.123	
708	0	1	1.00	1.00	2024-07-01 12:23:43.45945	5.115.115.123	
709	0	1	1.00	1.00	2024-07-01 14:03:06.41713	51.68.236.93	
710	0	1	1.00	1.00	2024-07-01 15:07:22.013137	51.68.236.93	
711	0	1	1.00	1.00	2024-07-01 16:40:42.751636	51.68.236.93	
712	0	1	1.00	1.00	2024-07-02 04:35:00.744987	5.201.191.28	
713	0	3	0.00	-1.00	2024-07-02 11:24:59.62095	2.147.6.233	
714	0	3	0.00	-1.00	2024-07-02 15:01:43.739702	2.147.234.209	
715	0	1	1.00	1.00	2024-07-02 16:48:47.195914	37.98.115.41	
716	0	3	0.00	-1.00	2024-07-03 09:23:27.156219	54.38.99.223	
717	0	1	1.00	1.00	2024-07-03 09:24:00.715269	54.38.99.223	
718	0	3	0.00	-1.00	2024-07-03 10:55:42.819754	54.38.99.223	
719	0	1	1.00	1.00	2024-07-03 16:57:07.175452	54.36.194.237	
720	0	3	0.00	-1.00	2024-07-03 17:17:16.360751	54.36.194.237	
721	0	1	1.00	1.00	2024-07-04 04:49:10.164902	54.36.194.237	
722	0	3	0.00	-1.00	2024-07-04 09:22:22.376235	54.38.99.223	
723	0	1	1.00	1.00	2024-07-05 05:40:47.118224	37.98.112.25	
724	0	1	1.00	1.00	2024-07-06 08:24:07.974534	2.147.46.160	
725	0	1	1.00	10.00	2024-07-08 12:30:38.109253	157.90.139.153	
726	0	3	0.00	-1.00	2024-07-08 13:13:55.81927	157.90.139.153	
727	0	1	1.00	1.00	2024-07-08 13:19:46.069484	157.90.139.153	
728	0	1	1.00	1.00	2024-07-08 16:39:33.347911	137.74.64.231	
729	0	1	1.00	1.00	2024-07-09 13:34:32.636315	157.90.139.153	
730	0	1	1.00	1.00	2024-07-09 15:20:33.412749	37.98.65.167	
731	0	3	0.00	-1.00	2024-07-11 02:17:08.534563	178.131.27.232	
732	0	1	1.00	1.00	2024-07-11 02:17:21.700705	178.131.27.232	
733	0	3	0.00	-1.00	2024-07-13 08:25:16.839444	157.90.139.153	
734	0	1	1.00	1.00	2024-07-16 09:13:15.245652	2.147.154.253	
735	0	1	1.00	1.00	2024-07-17 07:26:26.120292	89.248.170.134	
736	0	3	0.00	-1.00	2024-07-19 13:13:41.518847	51.195.236.148	
737	0	3	0.00	-1.00	2024-07-21 14:33:39.342725	2.147.35.13	
738	0	1	1.00	1.00	2024-07-21 14:34:13.903106	2.147.35.13	
739	0	1	1.00	1.00	2024-07-21 14:34:19.701919	2.147.35.13	
740	0	3	0.00	-1.00	2024-07-21 16:50:27.083974	2.147.35.13	
741	0	1	1.00	1.00	2024-07-22 11:16:50.31623	2.147.208.139	
742	0	1	1.00	1.00	2024-07-22 16:13:22.589251	2.147.231.62	
743	0	1	1.00	1.00	2024-07-24 05:26:10.081783	2.147.244.72	
744	0	1	1.00	1.00	2024-07-24 14:47:06.661117	188.40.183.147	
745	0	1	1.00	1.00	2024-07-24 14:48:53.130486	188.40.183.147	
746	0	1	1.00	1.00	2024-07-25 14:20:55.17569	51.89.157.215	
747	0	1	1.00	1.00	2024-07-25 16:15:38.158994	51.89.157.215	
748	0	3	0.00	-1.00	2024-07-26 04:12:49.356354	51.89.157.215	
749	0	3	0.00	-1.00	2024-07-26 14:38:45.08119	2.147.10.174	
750	0	1	1.00	1.00	2024-07-26 14:40:24.553514	2.147.10.174	
751	0	1	1.00	1.00	2024-07-26 14:49:14.584013	2.147.10.174	
752	0	3	0.00	-1.00	2024-07-28 13:10:26.542083	2.147.241.0	
753	0	1	1.00	1.00	2024-07-28 13:10:49.614491	2.147.241.0	
754	0	1	1.00	1.00	2024-07-28 13:11:10.665401	2.147.241.0	
755	0	1	1.00	1.00	2024-07-28 14:19:48.816687	2.147.177.99	
756	0	1	1.00	1.00	2024-07-29 05:22:55.741678	147.135.204.116	
757	0	3	0.00	-10.00	2024-07-29 14:18:37.341528	147.135.204.116	
758	0	1	1.00	1.00	2024-07-29 14:19:01.132031	147.135.204.116	
759	0	3	0.00	-1.00	2024-07-29 15:57:58.813918	2.147.245.52	
760	0	1	1.00	1.00	2024-07-29 15:58:20.644095	2.147.245.52	
761	0	3	0.00	-1.00	2024-07-30 11:00:26.109513	147.135.204.116	
762	0	1	1.00	1.00	2024-07-30 15:00:07.006001	178.131.177.152	
763	0	1	1.00	1.00	2024-07-30 15:23:10.350584	178.131.177.152	
764	0	3	0.00	-1.00	2024-07-30 15:26:59.825149	178.131.177.152	
765	0	1	1.00	1.00	2024-07-30 15:27:11.909458	178.131.177.152	
766	0	1	1.00	1.00	2024-07-31 05:42:33.932807	93.119.217.144	
767	0	1	1.00	1.00	2024-07-31 05:45:31.236342	93.119.217.144	
768	0	1	1.00	1.00	2024-07-31 08:43:37.846353	93.119.219.50	
769	0	1	1.00	10.00	2024-07-31 13:17:33.681739	2.147.165.143	
770	0	1	1.00	1.00	2024-08-01 16:38:27.342452	2.147.167.216	
771	0	1	1.00	1.00	2024-08-02 13:21:49.59122	2.147.108.60	
772	0	1	1.00	1.00	2024-08-03 18:06:22.002114	2.147.248.48	
773	0	3	0.00	-1.00	2024-08-04 04:18:54.400125	2.147.248.48	
774	0	1	1.00	1.00	2024-08-04 04:19:10.117752	2.147.248.48	
775	0	3	0.00	-1.00	2024-08-05 04:48:23.435622	37.98.84.96	
776	0	1	1.00	1.00	2024-08-05 04:48:35.384063	37.98.84.96	
777	0	1	1.00	1.00	2024-08-05 06:36:28.225039	37.98.84.96	
778	0	1	1.00	1.00	2024-08-05 06:38:31.512347	37.98.84.96	
779	0	3	0.00	-1.00	2024-08-05 06:46:43.123412	37.98.84.96	
780	0	1	1.00	1.00	2024-08-05 16:41:45.094458	2.147.199.50	
781	0	1	1.00	1.00	2024-08-06 06:08:49.737823	37.98.84.144	
782	0	1	1.00	1.00	2024-08-06 12:19:23.925121	2.147.19.64	
783	0	1	1.00	1.00	2024-08-06 17:04:04.309268	51.195.236.148	
784	0	1	1.00	1.00	2024-08-06 17:09:40.413528	178.131.178.232	
785	0	1	1.00	1.00	2024-08-07 05:18:19.416813	178.131.171.172	
786	0	1	1.00	1.00	2024-08-07 17:32:45.757423	51.195.236.148	
787	0	1	1.00	1.00	2024-08-07 17:35:50.996458	51.195.236.148	
788	0	3	0.00	-1.00	2024-08-08 03:16:34.308624	188.212.243.17	
789	0	1	1.00	1.00	2024-08-08 03:16:46.64863	188.212.243.17	
790	0	1	1.00	1.00	2024-08-08 09:17:16.234402	51.89.157.215	
791	0	1	1.00	10.00	2024-08-08 12:08:11.81247	2.147.67.157	
792	0	1	1.00	1.00	2024-08-09 03:10:53.201926	188.212.240.249	
793	0	1	1.00	1.00	2024-08-09 07:29:11.823259	147.135.204.109	
794	0	1	1.00	1.00	2024-08-09 07:29:21.074284	147.135.204.109	
795	0	1	1.00	1.00	2024-08-10 03:51:42.317902	5.201.191.28	
796	0	1	1.00	1.00	2024-08-10 06:13:00.612791	37.98.75.188	
797	0	3	0.00	-1.00	2024-08-10 13:41:26.566878	2.147.249.0	
798	0	1	1.00	1.00	2024-08-10 13:41:39.908369	2.147.249.0	
799	0	1	1.00	1.00	2024-08-11 09:03:34.397349	2.147.182.104	
800	0	3	0.00	-1.00	2024-08-11 15:42:41.001436	2.147.168.56	
801	0	1	1.00	1.00	2024-08-11 15:42:50.920223	2.147.168.56	
802	0	1	1.00	1.00	2024-08-11 15:47:19.904224	2.147.168.56	
803	0	3	0.00	-1.00	2024-08-12 04:49:06.41849	178.63.219.75	
804	0	3	0.00	-1.00	2024-08-12 14:51:32.307526	37.98.113.115	
805	0	1	1.00	1.00	2024-08-12 14:51:45.554887	37.98.113.115	
806	0	1	1.00	1.00	2024-08-12 16:00:25.01762	37.98.113.115	
807	0	1	1.00	1.00	2024-08-13 08:18:45.047972	2.147.122.98	
808	0	3	0.00	-1.00	2024-08-15 10:47:56.742985	168.119.94.4	
809	0	1	1.00	1.00	2024-08-15 10:48:29.959714	168.119.94.4	
810	0	1	1.00	10.00	2024-08-16 09:16:58.299453	51.89.157.215	
811	0	1	1.00	1.00	2024-08-16 14:11:25.972717	51.89.157.215	
812	0	1	1.00	1.00	2024-08-16 17:35:00.571072	5.117.12.188	
813	0	1	1.00	1.00	2024-08-17 16:27:25.457615	51.89.157.215	
814	0	1	1.00	1.00	2024-08-17 16:27:26.601643	51.89.157.215	
815	0	1	1.00	1.00	2024-08-17 16:51:56.479095	2.147.126.61	
816	0	3	0.00	-1.00	2024-08-18 13:06:32.972964	5.201.191.28	
817	0	3	0.00	-1.00	2024-08-18 13:07:00.662299	5.201.191.28	
818	0	1	1.00	1.00	2024-08-18 15:20:09.584211	37.98.112.55	
819	0	1	1.00	1.00	2024-08-19 07:39:34.4141	2.147.50.183	
820	0	1	1.00	1.00	2024-08-19 10:37:34.744699	51.89.157.215	
821	0	1	1.00	1.00	2024-08-19 15:54:15.219338	51.89.157.215	
822	0	1	1.00	1.00	2024-08-21 01:05:18.914565	51.89.157.215	
823	0	1	1.00	1.00	2024-08-21 02:20:28.453526	2.147.151.246	
824	0	1	1.00	1.00	2024-08-22 09:29:34.084701	178.131.161.29	
825	0	3	0.00	-1.00	2024-08-22 09:33:21.337667	178.131.161.29	
826	0	1	1.00	1.00	2024-08-23 03:11:18.981726	178.131.161.19	
827	0	1	1.00	1.00	2024-08-23 06:44:57.677951	178.131.161.19	
828	0	3	0.00	-1.00	2024-08-24 02:27:53.639167	51.195.236.148	
829	0	1	1.00	1.00	2024-08-24 02:28:10.431058	51.195.236.148	
830	0	1	1.00	1.00	2024-08-24 02:28:16.72004	51.195.236.148	
831	0	1	1.00	1.00	2024-08-24 04:50:54.438541	5.201.191.28	
832	0	1	1.00	1.00	2024-08-24 07:47:27.648881	5.201.191.28	
833	0	3	0.00	-1.00	2024-08-24 12:11:53.394272	51.195.236.148	
834	0	1	1.00	1.00	2024-08-24 12:12:08.707543	51.195.236.148	
835	0	1	1.00	1.00	2024-08-24 12:12:09.714813	51.195.236.148	
836	0	1	1.00	1.00	2024-08-25 14:01:11.480516	2.147.173.63	
837	0	1	1.00	1.00	2024-08-26 17:58:23.568175	51.195.236.148	
838	0	1	1.00	1.00	2024-08-27 13:25:36.523202	51.195.236.148	
839	0	1	1.00	1.00	2024-08-27 13:32:47.125457	2.147.233.196	
840	0	1	1.00	1.00	2024-08-27 16:38:51.553084	51.195.236.148	
841	0	1	1.00	1.00	2024-08-28 08:15:52.554314	2.147.185.17	
842	0	1	1.00	1.00	2024-08-28 12:34:26.79762	2.147.185.17	
843	0	1	1.00	1.00	2024-08-28 13:07:45.487862	2.147.185.17	
844	0	1	1.00	1.00	2024-08-28 15:50:50.423257	2.147.185.17	
845	0	1	1.00	1.00	2024-08-30 07:29:32.817493	2.147.7.136	
846	0	1	1.00	1.00	2024-08-30 07:37:06.615538	2.147.7.136	
847	0	1	1.00	1.00	2024-08-30 08:33:20.995041	2.147.7.136	
848	0	1	1.00	1.00	2024-08-31 12:40:27.871069	2.147.102.88	
849	0	1	1.00	10.00	2024-08-31 14:57:28.246535	51.195.236.148	
850	0	1	1.00	1.00	2024-08-31 16:36:44.433375	2.147.102.88	
851	0	3	0.00	-1.00	2024-09-01 04:02:18.213345	5.201.191.28	
852	0	1	1.00	1.00	2024-09-01 13:15:59.629794	178.131.146.235	
853	0	3	0.00	-1.00	2024-09-02 16:16:19.45409	2.147.229.115	
854	0	1	1.00	1.00	2024-09-02 16:16:47.575797	2.147.229.115	
855	0	1	1.00	1.00	2024-09-03 09:18:49.012168	5.201.191.28	
856	0	3	0.00	-1.00	2024-09-03 11:55:30.003648	2.147.229.115	
857	0	1	1.00	1.00	2024-09-03 11:55:41.59972	2.147.229.115	
858	0	3	0.00	-1.00	2024-09-03 12:32:38.315546	2.147.229.115	
859	0	1	1.00	1.00	2024-09-03 12:32:58.039358	2.147.229.115	
860	0	1	1.00	1.00	2024-09-03 14:52:02.669927	2.147.124.51	
861	0	1	1.00	1.00	2024-09-03 14:57:06.446636	2.147.124.51	
862	0	3	0.00	-1.00	2024-09-03 16:32:43.503221	2.147.124.51	
863	0	1	1.00	1.00	2024-09-03 16:32:59.955351	2.147.124.51	
864	0	1	1.00	1.00	2024-09-04 04:57:22.853483	80.82.68.136	
865	0	1	1.00	1.00	2024-09-04 11:31:49.646904	2.147.40.2	
866	0	1	1.00	1.00	2024-09-05 02:47:24.317401	5.201.191.28	
867	0	3	0.00	-1.00	2024-09-05 12:49:10.314085	51.195.236.148	
868	0	1	1.00	1.00	2024-09-06 04:06:15.600595	80.82.68.136	
869	0	3	0.00	-1.00	2024-09-06 08:48:17.298185	2.147.149.123	
870	0	1	1.00	1.00	2024-09-06 08:48:27.944171	2.147.149.123	
871	0	1	1.00	1.00	2024-09-06 16:31:04.619616	147.135.204.109	
872	0	1	1.00	1.00	2024-09-07 14:11:04.549806	51.195.236.148	
873	0	1	1.00	1.00	2024-09-08 13:08:28.250115	2.147.19.124	
874	0	3	0.00	-1.00	2024-09-08 14:48:44.001144	51.195.236.148	
875	0	1	1.00	1.00	2024-09-08 14:49:03.161149	51.195.236.148	
876	0	1	1.00	1.00	2024-09-09 05:56:25.848653	157.90.139.153	
877	0	3	0.00	-1.00	2024-09-10 05:39:57.605983	5.201.191.28	
878	0	1	1.00	1.00	2024-09-10 05:40:21.435413	5.201.191.28	
879	0	1	1.00	1.00	2024-09-10 05:40:23.246816	5.201.191.28	
880	0	1	1.00	1.00	2024-09-10 10:37:48.805039	5.201.191.28	
881	0	3	0.00	-1.00	2024-09-10 15:26:09.844622	93.117.186.140	
882	0	1	1.00	1.00	2024-09-10 15:26:22.055309	93.117.186.140	
883	0	1	1.00	10.00	2024-09-12 08:48:04.435579	93.117.187.78	
884	0	1	1.00	1.00	2024-09-13 14:22:25.69779	51.89.157.215	
885	0	1	1.00	1.00	2024-09-13 17:22:33.15209	80.82.68.136	
886	0	1	1.00	1.00	2024-09-14 03:49:03.030107	80.82.68.136	
887	0	3	0.00	-1.00	2024-09-14 06:13:59.753922	5.201.191.28	
888	0	1	1.00	1.00	2024-09-14 06:14:16.503725	5.201.191.28	
889	0	1	1.00	1.00	2024-09-15 04:11:59.013173	5.201.191.28	
890	0	3	0.00	-1.00	2024-09-15 15:18:17.854995	2.147.167.125	
891	0	1	1.00	1.00	2024-09-15 15:18:32.021502	2.147.167.125	
892	0	1	1.00	1.00	2024-09-17 13:28:45.855392	2.147.158.35	
893	0	1	1.00	1.00	2024-09-17 18:13:47.098152	80.82.68.136	
894	0	3	0.00	-1.00	2024-09-19 04:30:59.403324	78.47.215.138	
895	0	1	1.00	1.00	2024-09-19 09:16:57.011228	147.135.204.109	
896	0	1	1.00	10.00	2024-09-20 05:00:16.316208	147.135.204.109	
897	0	1	1.00	10.00	2024-09-20 05:01:57.897202	147.135.204.109	
898	0	1	1.00	1.00	2024-09-21 03:37:23.747657	93.117.184.111	
899	0	3	0.00	-1.00	2024-09-21 13:57:38.397371	168.119.94.4	
900	0	1	1.00	1.00	2024-09-22 03:38:50.537686	5.201.191.28	
901	0	3	0.00	-1.00	2024-09-22 03:39:04.145332	5.201.191.28	
902	0	1	1.00	1.00	2024-09-22 03:39:16.907063	5.201.191.28	
903	0	3	0.00	-1.00	2024-09-22 14:19:24.669797	168.119.94.4	
904	0	3	0.00	-1.00	2024-09-22 14:42:52.217015	168.119.94.4	
905	0	1	1.00	1.00	2024-09-22 14:43:11.41826	168.119.94.4	
906	0	1	1.00	1.00	2024-09-23 06:10:58.245677	5.201.191.28	
907	0	1	1.00	1.00	2024-09-23 13:48:30.423315	2.147.188.196	
908	0	3	0.00	-1.00	2024-09-23 17:40:19.170634	80.82.68.136	
909	0	1	1.00	1.00	2024-09-23 17:40:34.233574	80.82.68.136	
910	0	1	1.00	1.00	2024-09-24 05:02:14.594355	2.147.188.196	
911	0	3	0.00	-1.00	2024-09-24 05:11:04.359698	2.147.188.196	
912	0	1	1.00	1.00	2024-09-24 05:11:20.655279	2.147.188.196	
913	0	1	1.00	1.00	2024-09-25 05:35:19.042212	2.147.228.25	
914	0	1	1.00	1.00	2024-09-25 10:51:31.608534	147.135.204.109	
915	0	1	1.00	1.00	2024-09-28 14:06:47.482199	2.147.121.31	
916	0	1	1.00	1.00	2024-09-29 06:06:30.613464	2.147.121.31	
917	0	1	1.00	1.00	2024-09-29 14:43:23.421355	93.174.90.36	
918	0	1	1.00	1.00	2024-09-29 14:43:24.462232	93.174.90.36	
919	0	1	1.00	1.00	2024-09-30 10:34:58.840037	5.201.191.28	
920	0	1	1.00	1.00	2024-09-30 10:37:22.510136	5.201.191.28	
921	0	1	1.00	1.00	2024-09-30 14:17:52.23549	2.147.10.78	
922	0	3	0.00	-1.00	2024-09-30 14:18:01.911186	2.147.10.78	
923	0	3	0.00	-1.00	2024-09-30 14:18:49.91149	2.147.10.78	
924	0	1	1.00	1.00	2024-09-30 14:19:03.400941	2.147.10.78	
925	0	1	1.00	1.00	2024-10-03 03:17:47.726508	2.147.29.238	
926	0	3	0.00	-1.00	2024-10-03 14:54:51.318544	93.174.90.36	
927	0	1	1.00	1.00	2024-10-03 14:55:07.157478	93.174.90.36	
928	0	3	0.00	-1.00	2024-10-04 16:09:01.89745	2.147.165.44	
929	0	1	1.00	1.00	2024-10-06 12:30:18.705539	2.147.47.123	
930	0	1	1.00	1.00	2024-10-07 01:38:32.69854	137.74.64.231	
931	0	1	1.00	1.00	2024-10-07 11:03:43.12532	5.201.191.28	
932	0	3	0.00	-1.00	2024-10-07 11:54:09.723827	2.147.79.131	
933	0	1	1.00	1.00	2024-10-07 11:54:34.65211	2.147.79.131	
934	0	3	0.00	-1.00	2024-10-07 16:04:26.613674	2.147.114.235	
935	0	3	0.00	-1.00	2024-10-07 16:34:33.712207	2.147.114.235	
936	0	3	0.00	-1.00	2024-10-07 16:35:21.914842	2.147.114.235	
937	0	3	0.00	-1.00	2024-10-08 09:25:16.608418	2.147.114.235	
938	0	1	1.00	1.00	2024-10-08 11:01:29.183577	93.174.90.36	
939	0	1	1.00	1.00	2024-10-08 11:05:36.903041	93.174.90.36	
940	0	3	0.00	-1.00	2024-10-09 01:36:45.067135	93.174.90.36	
941	0	1	1.00	1.00	2024-10-09 14:01:07.653485	2.147.159.247	
942	0	1	1.00	1.00	2024-10-09 14:01:37.595985	2.147.159.247	
943	0	1	1.00	1.00	2024-10-10 09:12:25.976337	80.82.68.136	
944	0	3	0.00	-1.00	2024-10-11 02:00:36.208413	5.117.113.116	
945	0	3	0.00	-1.00	2024-10-12 05:08:13.496628	93.174.90.36	
946	0	1	1.00	1.00	2024-10-12 12:53:32.315445	2.147.146.53	
947	0	1	1.00	1.00	2024-10-12 14:30:33.991547	93.174.90.36	
948	0	1	1.00	1.00	2024-10-12 14:30:46.570593	93.174.90.36	
949	0	1	1.00	1.00	2024-10-13 06:02:31.804262	5.201.191.28	
950	0	3	0.00	-1.00	2024-10-13 06:35:16.295025	93.174.90.36	
951	0	1	1.00	1.00	2024-10-15 15:59:32.608285	2.147.200.28	
952	0	1	1.00	1.00	2024-10-16 09:52:54.121657	5.201.191.28	
953	0	3	0.00	-1.00	2024-10-16 13:07:14.409715	2.147.200.28	
954	0	1	1.00	1.00	2024-10-16 13:07:25.729066	2.147.200.28	
955	0	1	1.00	10.00	2024-10-16 13:44:04.120878	54.38.99.223	
956	0	3	0.00	-1.00	2024-10-16 18:12:05.679306	2.147.200.28	
957	0	1	1.00	1.00	2024-10-18 14:23:48.762959	93.174.90.36	
958	0	3	0.00	-1.00	2024-10-19 07:21:31.29909	5.201.191.28	
959	0	1	1.00	1.00	2024-10-19 07:21:39.542419	5.201.191.28	
960	0	1	1.00	1.00	2024-10-20 12:18:49.787361	2.147.239.219	
961	0	1	1.00	1.00	2024-10-20 13:30:00.598784	2.147.239.219	
962	0	1	1.00	1.00	2024-10-21 11:12:38.626431	93.174.90.36	
963	0	3	0.00	-1.00	2024-10-22 09:55:10.777723	5.201.191.28	
964	0	1	1.00	1.00	2024-10-22 09:55:29.607898	5.201.191.28	
965	0	3	0.00	-1.00	2024-10-23 13:38:33.711419	80.82.68.136	
966	0	1	1.00	1.00	2024-10-23 13:38:45.719431	80.82.68.136	
967	0	1	1.00	1.00	2024-10-23 14:16:10.714557	80.82.68.136	
968	0	1	1.00	1.00	2024-10-24 01:39:23.684434	93.174.90.36	
969	0	1	1.00	1.00	2024-10-24 03:49:23.61757	2.147.100.171	
970	0	1	1.00	1.00	2024-10-24 05:00:07.39153	2.147.100.171	
971	0	3	0.00	-1.00	2024-10-24 15:08:42.029968	2.147.31.234	
972	0	3	0.00	-1.00	2024-10-24 15:10:47.782408	2.147.31.234	
973	0	1	1.00	1.00	2024-10-24 15:34:54.203681	2.147.31.234	
974	0	1	1.00	1.00	2024-10-24 17:08:33.498735	157.90.139.153	
975	0	1	1.00	10.00	2024-10-24 17:08:43.180559	157.90.139.153	
976	0	1	1.00	1.00	2024-10-26 13:47:37.226726	2.147.113.215	
977	0	3	0.00	-1.00	2024-10-27 03:23:20.980169	78.47.215.138	
978	0	1	1.00	1.00	2024-10-27 03:23:31.085616	78.47.215.138	
979	0	3	0.00	-1.00	2024-10-27 05:24:27.748693	2.147.229.112	
980	0	1	1.00	1.00	2024-10-27 05:24:49.684477	2.147.229.112	
981	0	3	0.00	-1.00	2024-10-28 08:21:03.663599	147.135.204.109	
982	0	1	1.00	1.00	2024-10-28 08:21:15.780277	147.135.204.109	
983	0	1	1.00	1.00	2024-10-29 07:15:50.210686	168.119.94.4	
984	0	3	0.00	-1.00	2024-10-31 11:28:57.114955	168.119.94.4	
985	0	1	1.00	1.00	2024-10-31 11:29:11.178112	168.119.94.4	
986	0	3	0.00	-1.00	2024-11-02 03:27:20.11967	5.201.191.28	
987	0	3	0.00	-1.00	2024-11-02 06:34:51.093238	5.201.191.28	
988	0	1	1.00	1.00	2024-11-02 06:35:09.808209	5.201.191.28	
989	0	1	1.00	1.00	2024-11-02 08:16:04.622271	5.201.191.28	
990	0	1	1.00	1.00	2024-11-02 08:16:10.777688	5.201.191.28	
991	0	1	1.00	1.00	2024-11-02 14:23:05.640063	37.98.112.206	
992	0	3	0.00	-1.00	2024-11-02 14:29:35.331709	37.98.112.206	
993	0	1	1.00	1.00	2024-11-02 15:35:15.64172	54.38.99.223	
994	0	1	1.00	1.00	2024-11-02 15:35:16.003282	54.38.99.223	
995	0	1	1.00	1.00	2024-11-03 07:08:23.501856	5.201.191.28	
996	0	1	1.00	1.00	2024-11-03 12:19:21.307483	37.98.114.135	
997	0	1	1.00	1.00	2024-11-03 14:18:45.475041	93.174.90.36	
998	0	3	0.00	-1.00	2024-11-04 11:26:52.781171	2.147.139.108	
999	0	1	1.00	1.00	2024-11-04 11:30:02.897044	2.147.139.108	
1000	0	1	1.00	1.00	2024-11-04 11:30:14.978266	2.147.139.108	
1001	0	3	0.00	-1.00	2024-11-05 14:21:03.833356	168.119.94.4	
1002	0	1	1.00	1.00	2024-11-07 12:27:46.166246	80.82.68.136	
1003	0	1	1.00	1.00	2024-11-07 12:36:44.607956	109.108.174.8	
1004	0	1	1.00	1.00	2024-11-08 12:44:55.155463	2.147.10.125	
1005	0	3	0.00	-1.00	2024-11-09 04:35:29.906392	178.131.148.53	
1006	0	3	0.00	-1.00	2024-11-12 12:47:45.299677	2.147.145.121	
1007	0	1	1.00	1.00	2024-11-12 12:47:59.316816	2.147.145.121	
1008	0	3	0.00	-1.00	2024-11-12 15:35:10.485419	51.195.236.148	
1009	0	3	0.00	-1.00	2024-11-13 02:05:54.261946	5.201.191.28	
1010	0	1	1.00	1.00	2024-11-14 15:22:00.208769	2.147.14.239	
1011	0	1	1.00	10.00	2024-11-14 15:22:07.897933	2.147.14.239	
1012	0	1	1.00	1.00	2024-11-16 13:37:04.320835	168.119.94.4	
1013	0	1	1.00	1.00	2024-11-18 04:07:16.461329	168.119.94.4	
1014	0	1	1.00	1.00	2024-11-18 12:49:01.908597	80.82.68.136	
1015	0	1	1.00	1.00	2024-11-18 13:11:10.066049	80.82.68.136	
1016	0	1	1.00	1.00	2024-11-19 10:51:56.408333	2.147.60.171	
1017	0	1	1.00	1.00	2024-11-20 01:43:57.136065	5.201.191.28	
1018	0	1	1.00	1.00	2024-11-20 02:23:06.986977	54.38.99.223	
1019	0	3	0.00	-1.00	2024-11-21 01:30:26.588703	54.38.99.223	
1020	0	1	1.00	1.00	2024-11-21 01:30:43.589822	54.38.99.223	
1021	0	1	1.00	1.00	2024-11-21 07:09:14.972745	2.147.215.206	
1022	0	3	0.00	-1.00	2024-11-21 11:47:54.483204	93.174.90.36	
\.


--
-- Name: credit_change_id; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('credit_change_id', 1022, true);


--
-- Data for Name: credit_change_userid; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY credit_change_userid (credit_change_id, user_id) FROM stdin;
1	1
2	2
3	3
4	4
5	5
6	6
7	7
8	8
9	9
10	10
11	11
12	12
13	13
14	14
15	15
16	16
17	17
18	18
19	19
20	20
21	21
22	22
23	23
24	24
25	25
26	26
27	27
28	28
29	29
30	30
31	11
31	14
32	31
33	32
34	33
35	34
36	35
37	36
38	37
39	38
40	39
41	40
42	41
43	42
44	43
45	44
46	45
47	46
48	47
49	48
50	49
51	50
52	51
53	52
54	53
55	54
56	55
57	56
58	57
59	58
60	59
61	60
62	61
63	62
64	63
65	64
66	65
67	66
68	67
69	68
70	69
71	70
72	71
73	72
74	73
75	74
76	75
77	76
78	77
79	78
80	79
81	80
82	81
83	82
84	83
85	84
86	85
87	86
88	87
89	88
90	89
91	90
92	91
93	92
94	93
95	94
96	95
97	96
98	97
99	98
100	99
101	100
102	101
103	102
104	103
105	104
106	105
107	106
108	107
109	95
110	108
111	109
112	110
113	111
114	112
115	113
116	114
117	115
118	116
119	117
120	118
121	78
122	110
123	119
124	120
125	18
126	121
127	122
128	123
129	124
130	125
131	125
132	126
133	127
134	128
135	129
136	130
137	131
138	132
139	133
140	133
141	134
141	135
141	136
141	137
141	138
141	139
141	140
141	141
141	142
141	143
142	98
143	145
144	146
145	147
146	148
147	149
148	150
149	151
150	152
151	153
152	154
153	155
154	156
155	32
156	157
157	158
158	35
159	159
160	160
161	60
162	161
163	162
164	163
165	164
166	165
167	165
168	159
169	166
170	167
171	168
172	169
173	170
174	48
175	171
176	94
178	85
179	173
182	176
183	177
187	181
191	155
195	188
196	189
197	12
204	196
205	42
210	37
211	200
213	202
214	203
215	204
219	208
225	214
225	215
225	216
225	217
225	218
225	219
225	220
225	221
225	222
225	223
229	247
230	248
231	225
231	226
231	227
231	228
231	229
231	230
231	231
231	232
231	233
231	234
233	117
236	249
238	252
239	253
242	86
245	81
249	13
251	211
252	261
253	262
254	41
256	264
256	265
257	264
257	265
264	99
265	269
272	274
274	275
276	276
279	16
280	278
281	23
283	280
286	56
287	283
288	284
290	79
291	286
294	289
294	290
294	291
294	292
294	293
294	294
294	295
294	296
294	297
294	298
295	28
297	301
307	73
309	71
316	313
317	314
319	315
320	10
321	316
324	26
328	51
329	321
330	199
333	324
333	325
333	326
333	327
333	328
333	329
333	330
333	331
333	332
333	333
340	8
342	27
346	109
350	21
353	22
356	348
359	351
362	4
370	148
375	361
380	25
383	366
386	368
386	369
386	370
386	371
386	372
386	373
386	374
386	375
386	376
386	377
387	379
387	380
387	381
387	382
387	383
387	384
387	385
387	386
387	387
387	388
388	196
394	395
395	396
396	397
398	398
401	400
404	403
407	406
408	69
409	407
413	410
414	411
417	156
420	194
422	416
425	418
426	166
428	420
429	421
432	423
434	425
435	426
437	206
438	428
439	172
445	432
447	433
449	434
450	88
453	163
456	439
459	256
461	267
462	442
463	443
464	444
465	445
466	100
468	447
470	449
473	451
475	453
478	455
479	253
480	457
486	246
488	462
489	463
490	464
491	465
492	466
177	172
180	174
184	178
186	180
189	183
190	184
198	190
200	192
202	194
206	197
208	80
209	199
212	201
217	206
224	213
226	225
226	226
226	227
226	228
226	229
226	230
226	231
226	232
226	233
226	234
228	246
232	66
234	169
234	173
234	174
234	175
237	250
240	254
241	255
246	258
250	260
255	263
258	217
258	218
258	219
258	220
258	221
258	222
258	223
261	102
263	268
266	270
267	29
268	271
269	272
271	129
273	19
282	279
285	282
289	285
292	287
296	300
298	55
300	82
305	149
308	308
310	309
311	53
312	310
318	64
322	317
323	318
326	57
327	320
331	322
332	323
334	205
336	336
343	340
344	341
345	342
347	343
348	343
349	344
351	345
352	346
354	347
357	349
358	350
360	38
361	352
363	353
366	273
367	356
368	131
369	357
371	358
372	359
373	9
374	360
376	192
377	362
378	2
381	364
382	365
389	390
392	393
397	34
399	186
400	399
402	401
405	404
406	405
410	408
412	409
415	43
416	412
421	415
423	416
427	419
430	422
431	182
436	427
440	429
441	249
442	430
443	138
446	49
448	58
451	435
454	437
455	438
457	439
458	440
460	441
467	446
469	448
471	450
474	452
476	454
481	308
483	424
484	459
485	460
487	461
493	466
495	468
496	469
497	470
499	472
501	473
502	178
505	476
506	477
507	478
509	480
510	481
512	485
512	486
512	487
512	488
512	489
512	490
512	491
514	493
514	494
514	495
514	496
514	497
514	498
514	499
514	500
514	501
514	502
516	505
517	506
518	507
519	508
520	509
521	510
524	512
525	513
528	516
529	517
532	520
534	522
535	523
536	524
538	526
539	527
181	175
185	179
188	182
192	185
193	186
194	187
199	191
201	193
203	195
207	198
216	205
218	207
220	209
221	210
222	211
223	212
227	235
227	236
227	237
227	238
227	239
227	240
227	241
227	242
227	243
227	244
235	15
243	256
244	257
247	191
248	259
259	214
259	215
259	216
260	193
262	267
270	273
275	20
277	17
278	277
284	281
293	288
299	302
301	303
302	304
303	305
304	306
306	307
313	54
314	311
315	312
325	319
335	335
337	337
338	106
339	338
341	339
355	72
364	354
365	355
379	363
384	140
385	367
390	391
391	392
393	394
403	402
411	152
418	413
419	414
424	417
433	424
444	431
452	436
472	451
477	454
482	458
494	467
498	471
500	347
503	474
504	475
508	479
511	482
511	483
511	484
511	485
511	486
511	487
511	488
511	489
511	490
511	491
513	474
513	482
513	483
513	484
515	504
522	511
523	511
526	514
527	515
530	518
531	519
533	521
537	525
540	528
541	529
542	530
543	531
544	532
545	533
546	533
547	534
548	535
549	536
550	434
551	537
552	395
553	538
554	539
555	540
556	541
557	542
558	543
559	529
560	544
561	545
561	546
561	547
561	548
561	549
561	550
561	551
561	552
561	553
561	554
562	556
563	557
564	432
565	558
566	559
567	560
568	561
569	562
570	563
571	564
572	565
573	566
574	567
575	568
575	569
575	570
575	571
575	572
575	573
575	574
575	575
575	576
575	577
576	579
577	580
578	581
579	582
580	387
581	583
582	584
583	585
584	586
585	587
586	497
587	588
588	589
589	590
589	591
589	592
589	593
589	594
589	595
589	596
589	597
589	598
589	599
590	601
591	602
592	603
593	604
594	605
595	606
596	607
597	608
598	609
599	534
600	610
601	611
602	612
603	613
604	614
605	615
605	616
605	617
605	618
605	619
605	620
605	621
605	622
605	623
605	624
606	614
607	626
608	626
609	627
610	609
611	583
612	628
613	629
614	536
615	630
616	631
616	632
616	633
616	634
616	635
616	636
616	637
616	638
616	639
616	640
617	643
618	644
619	645
620	646
621	647
622	648
623	398
624	649
625	650
626	651
627	651
628	652
629	653
630	654
631	654
632	655
632	656
632	657
632	658
632	659
632	660
632	661
632	662
632	663
632	664
633	666
634	667
635	668
636	669
637	670
637	671
637	672
637	673
637	674
637	675
637	676
637	677
637	678
637	679
638	442
639	681
640	682
641	683
642	684
643	684
644	685
645	686
646	687
647	688
648	689
649	690
650	691
651	691
652	692
653	693
653	694
653	695
653	696
653	697
653	698
653	699
653	700
653	701
653	702
654	704
655	705
656	706
657	707
658	708
659	87
660	523
661	709
662	260
663	145
664	67
665	33
666	710
667	586
668	272
669	711
670	712
671	710
672	706
673	713
674	514
675	281
676	714
677	715
678	716
679	356
680	363
681	717
682	718
683	719
684	352
685	720
686	721
687	722
688	723
689	724
690	725
691	726
692	727
693	464
694	728
694	729
694	730
694	731
694	732
694	733
694	734
694	735
694	736
694	737
695	739
696	740
697	741
698	315
699	742
700	743
701	399
702	744
703	745
704	746
705	747
706	748
706	749
706	750
706	751
706	752
706	753
706	754
706	755
706	756
706	757
707	720
708	759
709	760
710	761
711	762
712	763
713	603
714	447
715	764
716	89
717	765
718	171
719	766
720	305
721	767
722	666
723	768
724	769
725	770
725	771
725	772
725	773
725	774
725	775
725	776
725	777
725	778
725	779
726	601
727	781
728	782
729	783
730	784
731	427
732	785
733	784
734	786
735	787
736	119
737	759
738	788
739	789
740	52
741	790
742	791
743	792
744	793
745	794
746	795
747	796
748	744
749	480
750	797
751	798
752	767
753	799
754	800
755	801
756	802
757	548
758	803
759	121
760	804
761	803
762	805
763	806
764	805
765	807
766	808
767	809
768	810
769	811
769	812
769	813
769	814
769	815
769	816
769	817
769	818
769	819
769	820
770	822
771	823
772	824
773	393
774	825
775	402
776	826
777	827
778	828
779	824
780	829
781	830
782	831
783	832
784	833
785	834
786	835
787	836
788	791
789	837
790	838
791	839
791	840
791	841
791	842
791	843
791	844
791	845
791	846
791	847
791	848
792	850
793	851
794	852
795	853
796	854
797	789
798	855
799	856
800	428
801	857
802	858
803	858
804	797
805	859
806	860
807	861
808	612
809	862
810	863
810	864
810	865
810	866
810	867
810	868
810	869
810	870
810	871
810	872
811	874
812	875
813	876
814	877
815	878
816	598
817	375
818	879
819	880
820	881
821	882
822	883
823	884
824	885
825	885
826	886
827	887
828	287
829	888
830	889
831	890
832	891
833	800
834	892
835	893
836	894
837	895
838	896
839	897
840	898
841	899
842	900
843	901
844	902
845	903
846	905
847	906
848	907
849	908
849	909
849	910
849	911
849	912
849	913
849	914
849	915
849	916
849	917
850	919
851	201
852	920
853	857
854	921
855	922
856	859
857	923
858	856
859	924
860	925
861	926
862	478
863	927
864	928
865	929
866	930
867	896
868	931
869	855
870	932
871	933
872	934
873	935
874	783
875	936
876	937
877	179
878	938
879	939
880	940
881	884
882	941
883	942
883	943
883	944
883	945
883	946
883	947
883	948
883	949
883	950
883	951
884	953
885	954
886	955
887	889
888	956
889	957
890	532
891	958
892	959
893	960
894	905
895	961
896	962
896	963
896	964
896	965
896	966
896	967
896	968
896	969
896	970
896	971
897	972
897	973
897	974
897	975
897	976
897	977
897	978
897	979
897	980
897	981
898	983
899	422
900	984
901	984
902	985
903	195
904	923
905	986
906	987
907	988
908	811
909	989
910	990
911	359
912	991
913	992
914	993
915	994
916	995
917	996
918	997
919	998
920	999
921	1000
922	1000
923	927
924	1001
925	1002
926	794
927	1003
928	834
929	1004
930	1005
931	1006
932	367
933	1007
934	828
935	1006
936	200
937	933
938	1008
939	1009
940	921
941	1010
942	1011
943	1012
944	798
945	515
946	1013
947	1014
948	1015
949	1016
950	448
951	1017
952	1018
953	142
954	1019
955	1020
955	1021
955	1022
955	1023
955	1024
955	1025
955	1026
955	1027
955	1028
955	1029
956	1018
957	1031
958	985
959	1032
960	1033
961	1034
962	1035
963	893
964	1036
965	745
966	1037
967	1038
968	1039
969	1040
970	1041
971	931
972	934
973	1042
974	1043
975	1044
975	1045
975	1046
975	1047
975	1048
975	1049
975	1050
975	1051
975	1052
975	1053
976	1055
977	1003
978	1056
979	810
980	1057
981	919
982	1058
983	1059
984	939
985	1060
986	421
987	924
988	1061
989	1062
990	1063
991	1064
992	168
993	1065
994	1066
995	1067
996	1068
997	1069
998	1013
999	1070
1000	1071
1001	935
1002	1072
1003	1073
1004	1074
1005	605
1006	862
1007	1075
1008	1073
1009	1004
1010	1076
1011	1077
1011	1078
1011	1079
1011	1080
1011	1081
1011	1082
1011	1083
1011	1084
1011	1085
1011	1086
1012	1088
1013	1089
1014	1090
1015	1091
1016	1092
1017	1093
1018	1094
1019	1056
1020	1095
1021	1096
1022	1059
\.


--
-- Data for Name: defs; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY defs (name, value, type) FROM stdin;
BW_IPTABLES_COMMAND	S'iptables'\np0\n.	\N
BW_TC_COMMAND	S'tc'\np0\n.	\N
CHECK_ONLINE_INTERVAL	I60\n.	\N
CHECK_ONLINE_MAX_FAILS	I2\n.	\N
FASTDIAL_PREFIX	S''\np0\n.	\N
IAS_ENABLED	I0\n.	\N
IBS_SERVER_IP	S'127.0.0.1'\np0\n.	\N
IBS_SERVER_PORT	I1235\n.	\N
KILL_USERS_ON_SHUTDOWN	I1\n.	\N
KILL_USERS_SHUTDOWN_WAIT_TIME	I20\n.	\N
MAX_USER_POOL_SIZE	I10000\n.	\N
RADIUS_SERVER_ACCT_PORT	I1813\n.	\N
RADIUS_SERVER_AUTH_PORT	I1812\n.	\N
RADIUS_SERVER_BIND_IP	(lp0\nS'0.0.0.0'\np1\na.	\N
RADIUS_SERVER_CLEANUP_TIME	I20\n.	\N
RADIUS_SERVER_ENABLED	I1\n.	\N
REALTIME_BW_SNAPSHOT_HOURS	I5\n.	\N
REALTIME_BW_SNAPSHOT_INTERVAL	I15\n.	\N
REALTIME_ONLINES_SNAPSHOT_HOURS	I5\n.	\N
REALTIME_ONLINES_SNAPSHOT_INTERVAL	I15\n.	\N
SNAPSHOT_BW_INTERVAL	I60\n.	\N
SNAPSHOT_ONLINES_INTERVAL	I300\n.	\N
TRUSTED_CLIENTS	(lp0\nS'127.0.0.1'\np1\na.	\N
USER_AUDIT_LOG	I1\n.	\N
WEB_ANALYZER_PASSWORD	S'web_analyzer_password'\np0\n.	\N
\.


--
-- Data for Name: group_attrs; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY group_attrs (group_id, attr_name, attr_value) FROM stdin;
1	rel_exp_date	2592000
1	multi_login	2
1	traffic_periodic_accounting_daily	30
1	traffic_periodic_accounting_daily_limit	10485760000
1	normal_charge	1
2	rel_exp_date	2592000
2	multi_login	2
2	traffic_periodic_accounting_daily	30
2	traffic_periodic_accounting_daily_limit	20971520000
3	rel_exp_date	2592000
3	traffic_periodic_accounting_daily	30
3	traffic_periodic_accounting_daily_limit	36700160000
3	normal_charge	1
3	multi_login	2
4	normal_charge	1
4	rel_exp_date	2592000
4	multi_login	2
4	traffic_periodic_accounting_daily	30
4	traffic_periodic_accounting_daily_limit	52428800000
5	normal_charge	1
5	rel_exp_date	2592000
5	multi_login	2
5	traffic_periodic_accounting_daily	30
5	traffic_periodic_accounting_daily_limit	73400320000
6	normal_charge	1
6	rel_exp_date	2592000
6	multi_login	2
6	traffic_periodic_accounting_daily	30
6	traffic_periodic_accounting_daily_limit	104857600000
14	rel_exp_date	7776000
7	rel_exp_date	5184000
7	multi_login	2
7	traffic_periodic_accounting_daily	60
7	traffic_periodic_accounting_daily_limit	73400320000
7	normal_charge	1
8	normal_charge	1
8	rel_exp_date	7776000
8	multi_login	2
8	traffic_periodic_accounting_daily	90
8	traffic_periodic_accounting_daily_limit	157286400000
9	normal_charge	1
9	rel_exp_date	7776000
9	multi_login	2
9	traffic_periodic_accounting_daily	90
9	traffic_periodic_accounting_daily_limit	262144000000
10	normal_charge	1
10	rel_exp_date	15552000
10	multi_login	2
10	traffic_periodic_accounting_daily	180
10	traffic_periodic_accounting_daily_limit	314572800000
11	normal_charge	1
11	rel_exp_date	15552000
11	multi_login	2
11	traffic_periodic_accounting_daily	180
11	traffic_periodic_accounting_daily_limit	471859200000
12	normal_charge	1
12	rel_exp_date	31104000
12	multi_login	2
12	traffic_periodic_accounting_daily	365
12	traffic_periodic_accounting_daily_limit	629145600000
13	normal_charge	1
13	rel_exp_date	31536000
13	multi_login	2
13	traffic_periodic_accounting_daily	365
13	traffic_periodic_accounting_daily_limit	838860800000
2	normal_charge	1
14	traffic_periodic_accounting_daily	90
14	traffic_periodic_accounting_daily_limit	104857600000
14	multi_login	1
14	normal_charge	1
\.


--
-- Data for Name: groups; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY groups (group_id, group_name, owner_id, comment) FROM stdin;
1	1-Month-10G	0	
2	1-Month-20G	0	
14	3-month-100-G-bama	0	
3	1-Month-35G	0	
4	1-Month-50G	0	
5	1-Month-70G	0	
6	1-Month-100G	0	
7	2-Month-70G	0	
8	3-Month-150G	0	
9	3-Month-250G	0	
10	6-Month-300G	0	
11	6-Month-450G	0	
12	12-Month-600G	0	
13	12-Month-800G	0	
\.


--
-- Name: groups_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('groups_group_id_seq', 14, true);


--
-- Data for Name: ias_event; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY ias_event (event_id, event_type, event_date, actor, amount, destinations, comment) FROM stdin;
\.


--
-- Name: ias_event_event_id; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('ias_event_event_id', 1, false);


--
-- Data for Name: ias_event_extended; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY ias_event_extended (event_id, name, value) FROM stdin;
\.


--
-- Data for Name: ibs_states; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY ibs_states (name, value) FROM stdin;
AUTO_CLEAN_CONNECTION_LOG	0
AUTO_CLEAN_CREDIT_CHANGE	0
AUTO_CLEAN_USER_AUDIT_LOG	0
AUTO_CLEAN_SNAPSHOTS	0
AUTO_CLEAN_WEB_ANALYZER_LOG	1209600
LOWLOAD_JOBS	1732266066
MIDNIGHT_JOBS	1732251665
\.


--
-- Data for Name: internet_bw_snapshot; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY internet_bw_snapshot (snp_date, user_id, in_rate, out_rate) FROM stdin;
\.


--
-- Data for Name: internet_charge_rules; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY internet_charge_rules (charge_id, charge_rule_id, start_time, end_time, time_limit, ras_id, cpm, cpk, assumed_kps, bandwidth_limit_kbytes, bw_transmit_leaf_id, bw_receive_leaf_id) FROM stdin;
1	1	00:00:00	23:59:59	\N	\N	0.00	0.00	8000000	800000000	\N	\N
\.


--
-- Data for Name: internet_onlines_snapshot; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY internet_onlines_snapshot (snp_date, ras_id, value) FROM stdin;
\.


--
-- Data for Name: ippool; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY ippool (ippool_id, ippool_name, ippool_comment) FROM stdin;
\.


--
-- Name: ippool_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('ippool_id_seq', 1, false);


--
-- Data for Name: ippool_ips; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY ippool_ips (ippool_id, ip) FROM stdin;
\.


--
-- Data for Name: normal_users; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY normal_users (user_id, normal_username, normal_password) FROM stdin;
682	m42	4002
390	peji	2022
3	behnam2	9340
358	torkamandi	3830
279	noor	6785
6	afi	7007
7	maral	7700
103	roghayeh	2641
5	hesari	9009
340	mostafa103	3003
361	peyghambari	6754
321	madah	7422
1008	fooladvand	1230
261	parisa	9595
252	anderson	4545
280	mashaal1	1121
717	mostafa112	9000
132	chtalaee	1230
284	kazemipc	1230
286	saljooghi	1230
351	majid	1010
353	behnam4	4414
289	bama2020	7763
24	seyfi	6371
709	tdmsm6	1234
322	sajad	1847
104	sahar57	5757
105	msharif1	4431
355	babak	1230
301	mostafa104	4080
290	bama2021	5183
30	mostafa	1020
31	mostafa100	1001
158	goldoost	2230
713	jafari07	7777
400	tkeyhan	6363
441	sheyda	2672
36	farhad13	5012
258	sheyda2	6668
357	gorjian3	1230
39	sania	2022
40	mehdi	8080
291	bama2022	1354
930	manzar	7300
415	zomorod	9620
44	saber	8308
45	yaser	5566
46	marjan	9990
1075	roodaki	1440
177	askari	3365
444	mvo1	1121
50	amin45	3645
323	rahimi11	1212
790	theotheo	9009
313	mostafa105	1005
742	bahareh3	4747
111	dastanpoor	1230
292	bama2023	6164
324	bama2030	2575
445	nazemian	6996
59	sadr	4704
164	sina	4055
61	ashoori3	3303
62	dashti	3191
63	melika70	7007
325	bama2031	8266
65	arast3	3000
722	erfan	8589
68	kiana	2343
410	ashkan	2128
70	mirkazemi	5356
319	keyhan5	5500
992	azizm	1358
326	bama2032	2563
74	setareh14	1414
75	samira2	6098
76	jamali	1230
77	navid	5759
134	bama2000	1891
1077	bama2262	4625
645	mirzayi	7614
262	rahimi10	1021
344	elnaz	1983
83	esfandiari	7525
942	bama2222	3725
476	arianpc	1230
293	bama2024	5896
716	shahin	4452
769	m50	1200
765	m37	1230
90	m35	5005
91	m32	9527
92	melisa	1891
93	danesh	9247
1010	tdmsm10	6328
1011	tdmsm11	6476
96	negar11	6660
97	negar12	7770
1017	fatemeh	4689
107	mahsa96	3696
150	banisadr	4242
120	aliasghar	8819
112	reza	3330
294	bama2025	5678
1031	alavi	9000
101	rezaei	0548
108	cheraghi	6155
394	jalalizadeh	2020
135	bama2001	7436
113	ati	1230
540	mehrabi	4617
114	c103	1230
115	javadi	8541
84	soheyl	7070
122	farhadi1000	1000
116	daftar10	1230
118	daftar	1230
123	hadadi	1230
124	rtp	1230
136	bama2002	5284
126	khhosseini	1230
127	khhosseini2	1230
1061	rafiee	3000
295	bama2026	5595
130	daftartehran	1230
419	barati	3535
137	bama2003	6752
647	fatemeh1	5252
139	bama2005	7684
524	talkhabloo	5531
141	bama2007	7621
1067	gorjian5	1230
143	bama2009	7832
743	ghaderi	2323
146	msm48	4800
147	ahatami2d	3330
437	m40	4005
151	fjafari	2016
452	leila24	5024
153	hosniyeh	0010
154	maleki2	7252
204	hamidr	7770
542	samira3	3303
157	rad	1338
170	rahimi	5258
160	sheyda77	1377
161	maleki	5992
162	fkarimi	1643
128	sabzineh	1230
809	esfandiari2	9009
167	shirani	9006
180	bargh	9560
188	saghayi2	1231
306	nekoonampc	1230
307	yusefi	5758
181	elna2	9091
183	farzan2	3030
185	aryo1	1133
189	boss	1230
263	parastoo	6369
786	noori5	5005
792	test120	1234
396	hatami2	1230
176	kami	3884
197	tofighi	1475
202	daftarforoosh	1230
207	zalipc	1230
210	karbasi3	3309
282	parsa	6464
212	nazanin2	9498
285	saryazdi	8949
894	johari	7614
288	mylove	8520
300	mostafa102	7000
303	nazanin	1090
461	neishaboori	2222
1078	bama2263	5569
311	sarikhan2	1230
312	zahra	2728
314	mostafa106	7770
235	bama2010	7197
236	bama2011	3538
237	bama2012	5138
238	bama2013	3181
239	bama2014	1836
240	bama2015	6768
241	bama2016	7436
242	bama2017	9923
243	bama2018	4747
244	bama2019	1747
248	negin1	0404
433	danial	9259
457	hadadi2	5056
255	fariba	8777
259	vafa	7778
712	sanjabi30	3030
269	aali	7156
715	seyed2	9399
360	solmaz	1370
274	sasan2	0909
275	msm78	3505
276	msm37	3748
277	msm35	3536
278	msm36	6055
316	msm80	7600
317	amin66	4266
318	nima	6862
320	najar	7707
327	bama2033	6824
328	bama2034	6584
329	bama2035	9396
330	bama2036	4992
331	bama2037	9844
332	bama2038	1611
333	bama2039	1952
335	elmira	2090
337	rose	1230
338	c105	1005
339	arsa	1980
341	aghakhani2	1230
342	salimian57	1657
345	ghafari10	1010
477	omid1	6581
348	farnaz	3000
350	mostafa108	8811
724	msm90	9009
354	beheshti	8343
362	setayesh	4005
718	tdmsm7	1234
364	golnaz	0496
379	bama2050	5576
380	bama2051	3283
381	bama2052	6138
382	bama2053	4837
383	bama2054	5754
384	bama2055	1868
385	bama2056	2596
386	bama2057	2696
611	javdani	5241
388	bama2059	4932
928	seif	6808
650	melika	2171
1055	tdmsm12	4747
401	talkhabloo1	0853
403	niusha	7770
404	farzin1	1144
405	farzin2	1155
406	minoo	5053
407	tahmineh	4849
408	navayi	3219
411	mostofi1	4454
423	sahar1	7099
417	farzaneh	1314
425	jalalizadeh3	6060
986	reyhaneh	2442
860	noroozian	1230
430	msm26	2026
431	bama2004	7618
538	nhasibi2	7171
440	mahshid2	1230
763	mashaalpc	1230
446	seyed	1600
450	farnaz2	1230
453	mtaheri	1448
455	sanjabi10	1010
458	leyla	6850
462	mostafa109	1009
764	test	1234
467	bameri	7816
469	asemi	6959
471	mahshid	2010
472	nabikhani	1403
475	bagheri2	2929
959	dashti2	3012
1009	miladpc	1230
481	msm86	6676
505	asal2	9000
506	parisa2	2001
508	armand	1013
509	mehdipoor	1121
510	raeesi	5185
513	akbari2	2220
516	msm60	6009
520	leila25	2525
521	naser15	1230
726	jamshidi2	2202
420	daftar11	1230
525	barkhordari	1230
526	zohreh	3311
527	soheyl2	2222
528	bama2070	1111
544	salimian	7846
685	fatah	7424
1079	bama2264	7243
613	m41	4140
535	maleki1	9090
537	mohammadi66	6066
543	imani2	3862
556	alipoor2	2202
557	ebi	1230
560	ghasemi	7093
563	kahari	1230
565	ansari	1230
566	mina	0909
568	bama2081	4496
569	bama2082	1961
570	bama2083	9711
571	bama2084	8859
572	bama2085	4125
573	bama2086	7738
574	bama2087	4154
429	milad	3725
184	fa8	8811
880	elmira2	9000
187	navab	0739
190	kami2	4422
397	sedighi	2010
198	shaghayegh	1376
336	radan	3545
719	tdmsm8	1234
208	karbasi1	1121
209	karbasi2	9972
213	maziyarpc	1230
463	jalalizadeh10	6091
247	asal	9000
250	zand	8881
254	behrooz	2770
460	jalalizadeh2	3030
257	shahin2	4455
465	noora	1718
268	hatami	1701
270	ataheri	2761
271	mostafa10	2010
283	mona	6989
296	bama2027	9836
297	bama2028	8834
298	bama2029	9463
304	maroof	9200
310	sarikhan1	1121
366	yazdan	5566
349	mostafa107	5560
368	bama2040	9321
369	bama2041	6891
370	bama2042	8588
371	bama2043	5424
372	bama2044	1942
373	bama2045	7951
374	bama2046	1828
882	test9	1234
376	bama2048	2959
377	bama2049	5192
409	saragol	7097
412	mostofi	1230
413	maleki3	3343
414	imani	4741
418	padideh	3331
468	shahi	1230
436	m38	8880
438	poneh	1077
470	salmani	7770
473	ghafari20	2030
479	aghasemi2	2202
493	bama2060	9347
494	bama2061	8597
495	bama2062	8352
496	bama2063	3985
589	habibi4	4441
498	bama2065	7182
499	bama2066	9888
500	bama2067	5262
501	bama2068	4731
502	bama2069	6925
504	bameri2	2220
512	msm24	2425
721	alipoor	4444
1016	pariapc	1230
522	rezakermani	1230
530	sanjabi20	1230
646	ghadimi	7893
545	bama2071	8821
546	bama2072	4958
547	bama2073	2246
806	panahipc	1230
549	bama2075	8496
550	bama2076	5999
551	bama2077	4597
552	bama2078	2644
553	bama2079	6541
554	bama2080	8898
558	alvani	7893
561	mohammad91	3535
562	batool	0606
564	zhestmezon	1121
575	bama2088	6425
576	bama2089	9539
577	bama2090	4712
579	nazanin10	3502
580	hidokht	6018
581	bama2091	6000
582	mostafa110	1001
629	makki1	4857
584	khavari	7505
585	fereshteh	1087
309	parastoo39	1009
587	akbar6	1090
588	bama2064	4918
590	bama2092	2822
591	bama2093	3614
592	bama2094	5775
593	bama2095	7592
594	bama2096	5967
595	bama2097	3559
596	bama2098	8363
597	bama2099	7756
887	mahali	7000
599	bama2101	2271
47	jalal	7799
602	shekufeh	4440
770	bama2172	9192
604	harandi	1090
606	hossein	2045
628	bama2058	5745
610	habibi1	3911
607	ayousefi2	1230
627	aliasadi	3953
615	bama2102	4732
616	bama2103	2994
617	bama2104	1628
618	bama2105	5733
619	bama2106	5685
620	bama2107	8226
621	bama2108	9819
622	bama2109	7351
623	bama2110	5615
624	bama2111	2768
203	ab2	1230
630	habibi2	9292
771	bama2173	2415
648	fatemeh2	2992
649	tdmsm	1234
652	mostafa111	3339
653	khoshghadam	4391
655	bama2122	3657
656	bama2123	1924
657	bama2124	7528
658	bama2125	9214
659	bama2126	6931
660	bama2127	1593
661	bama2128	4892
662	bama2129	8614
663	bama2130	1635
664	bama2131	2897
826	skeyhan	6262
829	mghorbani	9797
667	azam	5577
631	bama2112	9126
632	bama2113	1538
633	bama2114	4926
634	bama2115	1118
635	bama2116	1629
636	bama2117	9653
637	bama2118	2491
638	bama2119	5664
639	bama2120	5991
640	bama2121	1945
644	elham1	1122
1	aria	2580
668	tdmsm2	1234
669	ashraf	9779
391	soltan	2930
670	bama2132	4942
671	bama2133	5319
672	bama2134	2368
673	bama2135	1621
674	bama2136	4344
675	bama2137	8474
676	bama2138	1438
677	bama2139	5143
678	bama2140	2391
679	bama2141	2564
683	tst	123
687	khjamali	1230
688	tdmsm3	1234
689	tdmsm4	1234
690	tdmsm5	1234
693	bama2142	2898
692	akbari3	1230
694	bama2143	5117
695	bama2144	7621
696	bama2145	9394
697	bama2146	8536
698	bama2147	8769
699	bama2148	7339
700	bama2149	2159
701	bama2150	6679
702	bama2151	4226
704	system10	1230
725	msm91	9021
707	khanzadeh	1230
708	test10	1234
727	sara70	1230
728	bama2152	8286
729	bama2153	1566
730	bama2154	5644
731	bama2155	2279
732	bama2156	8876
733	bama2157	8329
734	bama2158	4772
735	bama2159	1884
736	bama2160	8791
737	bama2161	9151
739	beni	2003
740	test11	1111
741	kahouli	9200
746	mostafa113	1314
747	mahdieh	1230
748	bama2162	8634
749	bama2163	5722
750	bama2164	6759
751	bama2165	2356
752	bama2166	7656
753	bama2167	9647
754	bama2168	5686
755	bama2169	8949
756	bama2170	8759
757	bama2171	1653
987	hosseini3	3333
760	shegarf	0925
761	test30	1234
762	pegah	3777
766	morteza	1624
768	azm	2167
772	bama2174	7214
773	bama2175	2418
774	bama2176	3519
775	bama2177	2823
776	bama2178	6992
777	bama2179	2827
778	bama2180	8387
779	bama2181	8834
781	parsa2	4000
782	mahshad	8545
937	emami	3333
787	mostafa114	7001
795	ramezan	5450
861	raheleh	1200
1037	saghar2	2222
801	mtorabi	9000
802	seyedi	7000
808	esfandiari1	2200
804	mcb	1230
807	tiam	9991
1080	bama2265	6795
990	askari2	9000
812	bama2183	4647
813	bama2184	8136
814	bama2185	5672
815	bama2186	1399
816	bama2187	2839
817	bama2188	2817
818	bama2189	8354
819	bama2190	9114
820	bama2191	1712
822	msm33	3531
823	shirvani	2020
830	mahyar	9990
825	meysam	7398
827	bagheri45	4500
831	mehrdad	7990
833	mojtaba	4322
1005	tdmsm9	1234
835	taghavi	5595
836	naji	9090
837	bagheri	3003
839	bama2192	8424
840	bama2193	6359
841	bama2194	9459
842	bama2195	8445
843	bama2196	4884
844	bama2197	2436
845	bama2198	1792
846	bama2199	5848
847	bama2200	4318
848	bama2201	4676
850	noroozi	4003
852	arezum	8404
853	daftar15	1230
854	fahim	1366
932	msm72	9000
922	daftar21	1375698
863	bama2202	7773
864	bama2203	2753
865	bama2204	3653
866	bama2205	7925
867	bama2206	5965
868	bama2207	2152
869	bama2208	6874
870	bama2209	6375
871	bama2210	4335
872	bama2211	5994
874	babak2	5001
875	hivapc	1230
878	test7	1234
879	hafezpc	1230
881	azam2	7770
883	test600	1234
943	bama2223	9755
1038	tahoora	2624
991	c106	2200
886	saharh	8080
891	daftar20	1230
895	test220	1234
1012	melikapc	1230
897	amirhossein	2975
899	hizomi	3865
900	shamim	8000
901	abbasi	1990
902	enayat	5511
903	rayan	4000
890	m52	1005
1015	m101	6007
972	bama2232	5745
906	ahmadi2	0813
907	test80	1234
908	bama2212	6991
909	bama2213	4268
910	bama2214	8416
911	bama2215	4934
912	bama2216	7455
913	bama2217	9233
914	bama2218	1546
915	bama2219	1637
916	bama2220	5871
917	bama2221	5665
1060	farzan1	3303
838	m100	1005
531	moein	9999
929	matin	3131
1096	saeedeh	3795
1068	abas	9000
925	test900	9000
926	rrastegar	1200
1002	roodakipc	1230
1074	yavari	3683
936	azba	8647
1063	daftar30	1230
940	faranak	7707
941	sherafat	4270
944	bama2224	4991
945	bama2225	3314
946	bama2226	3377
947	bama2227	5789
948	bama2228	4761
949	bama2229	9343
950	bama2230	2674
951	bama2231	1539
953	arast	2030
954	milad2	3000
955	torabi100	3003
956	saghar	3769
958	ghazal	9096
960	manzar2	3300
961	fa30	3000
973	bama2233	7868
974	bama2234	8583
975	bama2235	6732
976	bama2236	6735
977	bama2237	2926
978	bama2238	5555
979	bama2239	1362
980	bama2240	7654
981	bama2241	4849
983	fatemeh40	0640
1033	c201	2001
988	shima	4302
989	bama2182	1644
993	mirzayi2	2000
994	c200	2000
995	faraji	4000
998	sanjabi15	4002
999	sanjabi16	6004
1032	fasa	5791
1001	saba	7729
1057	asghari	7007
1007	bama2006	8261
920	zolfaghari	7000
1019	bama2008	2266
1020	bama2242	9166
1021	bama2243	5128
1022	bama2244	2198
1023	bama2245	8851
997	salehi	8612
1024	bama2246	5786
1025	bama2247	5966
1026	bama2248	7471
1027	bama2249	6428
1028	bama2250	3154
1029	bama2251	1251
1034	akaram	8888
1035	latifeh	1230
1036	asadi	5500
1039	raha3	3993
1040	mahshidpc	1230
1042	mghorbani2	2000
1044	bama2252	3891
1045	bama2253	2561
1046	bama2254	8554
1047	bama2255	9685
1048	bama2256	5464
1049	bama2257	8652
1050	bama2258	5758
1051	bama2259	4922
1052	bama2260	9173
1053	bama2261	8164
1058	aghasemi	7343
1064	paroham	1234
1066	m102	7272
1069	navab2	2222
1071	monshi	7070
1081	bama2266	1385
1082	bama2267	9943
1083	bama2268	3813
1084	bama2269	2861
1085	bama2270	1359
1086	bama2271	8628
1088	elham	1230
1089	hasani	1230
1090	bakhshi	1145
1091	bahareh	1230
1092	tara	1372
1093	anbar	1230
1094	daftar31	1230
1095	bahareh5	5550
\.


--
-- Data for Name: persistent_lan_users; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY persistent_lan_users (user_id, persistent_lan_mac, persistent_lan_ip, persistent_lan_ras_id) FROM stdin;
\.


--
-- Data for Name: ras; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY ras (ras_id, ras_description, ras_ip, ras_type, radius_secret, active, comment) FROM stdin;
1	169	78.39.57.169	Mikrotik	one3	t	
2	172	78.39.57.172	Mikrotik	Progmaster	t	
3	173	78.39.57.173	Mikrotik	Progmaster	t	
4	174	78.39.57.174	Mikrotik	Progmaster	t	
5	78.39.57.175	78.39.57.175	Mikrotik	Progmaster	t	
6	163	78.39.57.163	Mikrotik	Progmaster	t	
7	21	95.38.155.21	Mikrotik	One3	t	
8	9	95.38.155.9	Mikrotik	one3	t	
9	78.39.57.165	78.39.57.165	Mikrotik	Progmaster	t	
\.


--
-- Data for Name: ras_attrs; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY ras_attrs (ras_id, attr_name, attr_value) FROM stdin;
9	mikrotik_ssh_password	Progmaster
9	mikrotik_ssh_username	IBSng
\.


--
-- Name: ras_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('ras_id_seq', 9, true);


--
-- Data for Name: ras_ippools; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY ras_ippools (serial, ras_id, ippool_id) FROM stdin;
\.


--
-- Name: ras_ippools_serial_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('ras_ippools_serial_seq', 1, false);


--
-- Data for Name: ras_ports; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY ras_ports (ras_id, port_name, phone, type, comment) FROM stdin;
\.


--
-- Data for Name: tariff_prefix_list; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY tariff_prefix_list (tariff_id, prefix_id, prefix_code, prefix_name, cpm, free_seconds, min_duration, round_to, min_chargable_duration) FROM stdin;
\.


--
-- Name: tariff_prefix_list_tariff_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('tariff_prefix_list_tariff_id_seq', 1, false);


--
-- Data for Name: user_attrs; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY user_attrs (user_id, attr_name, attr_value) FROM stdin;
475	first_login	1714384635
269	first_login	1724517827
270	first_login	1729961652
595	traffic_periodic_accounting_daily	90
3	abs_exp_date	1707932834
613	traffic_periodic_accounting_daily_reset	1731643200
932	first_login	1730192959
329	traffic_periodic_accounting_daily_reset	1717477200
116	traffic_periodic_accounting_daily	90
75	traffic_periodic_accounting_daily	72
112	multi_login	12
360	traffic_periodic_accounting_daily_reset	1712635200
986	first_login	1732032267
189	first_login	1724485473
342	traffic_periodic_accounting_daily_reset	1714885200
906	first_login	1730233152
630	first_login	1728715298
255	first_login	1711305440
336	first_login	1728319980
114	abs_exp_date	1711463074
521	traffic_periodic_accounting_daily_reset	1715745600
62	first_login	1728991237
695	traffic_periodic_accounting_daily_reset	1723608000
7	abs_exp_date	1708712169
183	lock	2/3/2024
668	traffic_periodic_accounting_daily_reset	1725768000
130	first_login	1728741017
124	traffic_periodic_accounting_daily_usage	431059012
327	traffic_periodic_accounting_daily_reset	1714798800
7	traffic_periodic_accounting_daily_reset	1709960400
316	first_login	1725734536
333	traffic_periodic_accounting_daily_reset	1715058000
958	first_login	1729059031
362	traffic_periodic_accounting_daily_reset	1717819200
279	first_login	1730307052
394	first_login	1732220595
462	first_login	1716718973
107	abs_exp_date	1708686491
139	first_login	1710859541
419	first_login	1729667367
114	traffic_periodic_accounting_daily	45
1005	traffic_periodic_accounting_daily_reset	1733457600
317	abs_exp_date	1740860275
729	first_login	1722791605
7	first_login	1707416812
181	first_login	1731597609
471	first_login	1727297099
190	traffic_periodic_accounting_daily_reset	1734152400
300	first_login	1716893726
312	abs_exp_date	1717872172
122	abs_exp_date	1708470405
377	first_login	1719860157
647	traffic_periodic_accounting_daily_reset	1732420800
62	traffic_periodic_accounting_daily	80
411	first_login	1717490027
303	traffic_periodic_accounting_daily_reset	1716958800
213	traffic_periodic_accounting_daily_reset	1739509200
126	traffic_periodic_accounting_daily_reset	1733288400
513	first_login	1730194594
345	first_login	1717684730
746	traffic_periodic_accounting_daily_reset	1727928000
96	abs_exp_date	1708214283
97	abs_exp_date	1708214347
433	first_login	1726514847
688	traffic_periodic_accounting_daily_reset	1733457600
825	first_login	1729855166
998	traffic_periodic_accounting_daily	180
682	traffic_periodic_accounting_daily_reset	1725336000
101	traffic_periodic_accounting_daily_reset	1710046800
329	first_login	1712355320
521	first_login	1713212456
769	traffic_periodic_accounting_daily_reset	1735790400
116	traffic_periodic_accounting_daily_reset	1733461200
1	traffic_periodic_accounting_daily_reset	1741496400
151	first_login	1707915143
414	abs_exp_date	1712953557
158	first_login	1731293981
544	abs_exp_date	1721217452
132	traffic_periodic_accounting_daily	90
827	traffic_periodic_accounting_daily_reset	1733198400
5	first_login	1721036137
36	abs_exp_date	1708890035
472	first_login	1730890377
787	first_login	1730033016
372	traffic_periodic_accounting_daily_reset	1715486400
31	abs_exp_date	1708802586
664	traffic_periodic_accounting_daily_reset	1722657600
6	first_login	1711565234
289	traffic_periodic_accounting_daily_reset	1714366800
303	first_login	1711817047
132	multi_login	2
39	first_login	1717758385
36	traffic_periodic_accounting_daily_reset	1709960400
36	first_login	1707422269
361	first_login	1717875512
572	first_login	1728923718
956	first_login	1731863527
972	traffic_periodic_accounting_daily_reset	1732075200
213	first_login	1724068154
270	traffic_periodic_accounting_daily_reset	1734757200
441	first_login	1729883109
596	first_login	1729949915
118	first_login	1715432297
40	abs_exp_date	1738181269
40	traffic_periodic_accounting_daily	356
40	traffic_periodic_accounting_daily_limit	734003200000
40	traffic_periodic_accounting_daily_reset	1738126800
40	first_login	1707423456
44	abs_exp_date	1737750135
45	abs_exp_date	1737750245
45	traffic_periodic_accounting_daily	351
45	traffic_periodic_accounting_daily_limit	796917760000
373	traffic_periodic_accounting_daily_usage	10275
508	traffic_periodic_accounting_daily_reset	1720756800
436	multi_login	1
649	first_login	1730897060
891	first_login	1727182863
62	traffic_periodic_accounting_daily_limit	146800640000
527	first_login	1719507545
292	traffic_periodic_accounting_daily_reset	1714453200
330	traffic_periodic_accounting_daily_reset	1714885200
621	traffic_periodic_accounting_daily_reset	1721793600
460	abs_exp_date	1713387088
301	first_login	1718692015
177	traffic_periodic_accounting_daily_reset	1710738000
292	first_login	1709306371
74	abs_exp_date	1708641908
115	abs_exp_date	1709652792
59	traffic_periodic_accounting_daily_reset	1735880400
75	traffic_periodic_accounting_daily_limit	104857600000
115	traffic_periodic_accounting_daily_reset	1710133200
540	traffic_periodic_accounting_daily_usage	697379
561	first_login	1727358965
295	first_login	1709311318
105	traffic_periodic_accounting_daily_usage	22594436977
747	first_login	1725709140
101	first_login	1707469211
564	traffic_periodic_accounting_daily_reset	1737777600
65	abs_exp_date	1710886125
756	traffic_periodic_accounting_daily_reset	1725422400
257	first_login	1724445464
728	first_login	1728167564
304	traffic_periodic_accounting_daily_reset	1711774800
261	first_login	1711393388
565	traffic_periodic_accounting_daily	365
311	traffic_periodic_accounting_daily	34
542	first_login	1729237735
188	abs_exp_date	1739389537
61	traffic_periodic_accounting_daily_reset	1709960400
61	first_login	1707429709
202	first_login	1728801971
461	first_login	1715080527
506	traffic_periodic_accounting_daily_reset	1744344000
993	traffic_periodic_accounting_daily_reset	1743912000
920	abs_exp_date	1750785457
380	first_login	1720313697
103	first_login	1731857075
93	traffic_periodic_accounting_daily_reset	1728104400
44	traffic_periodic_accounting_daily_reset	1738904400
44	first_login	1707435303
97	traffic_periodic_accounting_daily_reset	1710046800
114	traffic_periodic_accounting_daily_limit	52428800000
77	multi_login	2
941	first_login	1730872960
97	first_login	1707462098
360	first_login	1710057115
59	first_login	1726558998
46	traffic_periodic_accounting_daily_reset	1739077200
320	first_login	1730279022
930	abs_exp_date	1740995797
371	traffic_periodic_accounting_daily_reset	1715486400
74	traffic_periodic_accounting_daily_reset	1710046800
290	traffic_periodic_accounting_daily_reset	1714366800
727	first_login	1732114432
649	traffic_periodic_accounting_daily_reset	1732766400
91	traffic_periodic_accounting_daily_reset	1711774800
91	first_login	1707456626
74	first_login	1707460637
1017	traffic_periodic_accounting_daily	365
470	traffic_periodic_accounting_daily_reset	1717387200
871	traffic_periodic_accounting_daily_reset	1730088000
512	first_login	1731569472
176	first_login	1710877296
1068	abs_exp_date	1733160044
384	traffic_periodic_accounting_daily_reset	1717646400
146	abs_exp_date	1708969618
47	traffic_periodic_accounting_daily_reset	1738990800
476	abs_exp_date	1731445624
177	first_login	1708161647
47	first_login	1707462646
581	first_login	1720459019
362	first_login	1712259464
550	traffic_periodic_accounting_daily_reset	1719547200
607	traffic_periodic_accounting_daily	90
593	first_login	1721224895
602	first_login	1725778624
764	abs_exp_date	1720039752
495	traffic_periodic_accounting_daily_reset	1718164800
479	traffic_periodic_accounting_daily_reset	1717732800
323	multi_login	1
721	traffic_periodic_accounting_daily_reset	1739592000
526	traffic_periodic_accounting_daily_reset	1726372800
45	traffic_periodic_accounting_daily_reset	1737694800
45	first_login	1707435340
725	first_login	1732272879
717	first_login	1731151203
423	first_login	1723637438
742	first_login	1730836724
75	traffic_periodic_accounting_daily_reset	1713675600
75	first_login	1707455546
150	abs_exp_date	1718963632
65	traffic_periodic_accounting_daily_reset	1712552400
65	first_login	1707442508
404	traffic_periodic_accounting_daily_reset	1733630400
311	traffic_periodic_accounting_daily_limit	52428800000
584	first_login	1729359111
690	traffic_periodic_accounting_daily_usage	107918895
93	lock	
868	traffic_periodic_accounting_daily_reset	1729915200
46	abs_exp_date	1738095970
47	abs_exp_date	1738096019
1007	traffic_periodic_accounting_daily	98
24	first_login	1715196263
1071	traffic_periodic_accounting_daily	90
563	traffic_periodic_accounting_daily_reset	1737691200
504	first_login	1730443153
754	traffic_periodic_accounting_daily_reset	1722830400
936	first_login	1731010962
146	traffic_periodic_accounting_daily_reset	1710392400
653	multi_login	2
551	traffic_periodic_accounting_daily_reset	1716955200
306	first_login	1714673912
822	abs_exp_date	1724963938
63	abs_exp_date	1709157720
318	traffic_periodic_accounting_daily_reset	1740459600
190	first_login	1730213586
61	abs_exp_date	1709416406
63	traffic_periodic_accounting_daily_reset	1710046800
1066	traffic_periodic_accounting_daily_reset	1738296000
208	traffic_periodic_accounting_daily_reset	1734238800
252	first_login	1728591590
891	traffic_periodic_accounting_daily	30
161	traffic_periodic_accounting_daily_reset	1728709200
542	traffic_periodic_accounting_daily	180
481	first_login	1715285079
894	lock	
477	first_login	1718132197
153	first_login	1714729737
111	abs_exp_date	1709287536
653	traffic_periodic_accounting_daily_reset	1722225600
1	first_login	1719148712
357	first_login	1731389718
500	traffic_periodic_accounting_daily_reset	1718596800
268	first_login	1712666686
247	traffic_periodic_accounting_daily_reset	1732593600
345	traffic_periodic_accounting_daily_reset	1720155600
70	abs_exp_date	1713047555
431	traffic_periodic_accounting_daily_reset	1721102400
878	first_login	1724700777
118	traffic_periodic_accounting_daily	90
781	first_login	1720462214
644	traffic_periodic_accounting_daily_reset	1719288000
90	traffic_periodic_accounting_daily_reset	1730433600
401	traffic_periodic_accounting_daily_reset	1736222400
337	traffic_periodic_accounting_daily_usage	2936443009
160	traffic_periodic_accounting_daily_reset	1710565200
75	abs_exp_date	1713653270
493	traffic_periodic_accounting_daily_reset	1718596800
983	traffic_periodic_accounting_daily	90
212	abs_exp_date	1710714809
437	first_login	1710871548
92	traffic_periodic_accounting_daily_reset	1710046800
92	first_login	1707456236
724	first_login	1732272581
772	traffic_periodic_accounting_daily_reset	1723003200
769	first_login	1728455876
83	abs_exp_date	1709162325
147	abs_exp_date	1739296566
243	traffic_periodic_accounting_daily_reset	1714107600
458	traffic_periodic_accounting_daily_reset	1732593600
83	traffic_periodic_accounting_daily_reset	1709960400
83	first_login	1707434619
105	first_login	1712063470
103	traffic_periodic_accounting_daily_reset	1735966800
638	first_login	1717167886
368	traffic_periodic_accounting_daily_reset	1712808000
675	traffic_periodic_accounting_daily_reset	1722916800
757	first_login	1720372471
170	traffic_periodic_accounting_daily_reset	1739163600
420	first_login	1730618525
162	traffic_periodic_accounting_daily_reset	1715749200
709	traffic_periodic_accounting_daily_reset	1733976000
108	first_login	1722676532
91	traffic_periodic_accounting_daily	50
91	traffic_periodic_accounting_daily_limit	62914560000
683	abs_exp_date	1717911700
355	first_login	1716660089
164	multi_login	2
300	traffic_periodic_accounting_daily_reset	1719550800
135	traffic_periodic_accounting_daily_reset	1710565200
610	traffic_periodic_accounting_daily_reset	1728964800
429	first_login	1730446158
263	first_login	1725541974
63	first_login	1707470428
662	first_login	1727656924
277	traffic_periodic_accounting_daily_reset	1734843600
573	traffic_periodic_accounting_daily_reset	1720152000
573	first_login	1715015123
274	first_login	1729795407
506	first_login	1712857072
107	traffic_periodic_accounting_daily_reset	1710046800
553	first_login	1719377676
111	traffic_periodic_accounting_daily_reset	1710306000
304	first_login	1709214579
405	first_login	1726173188
167	traffic_periodic_accounting_daily_reset	1723525200
330	first_login	1709747694
722	abs_exp_date	1720372606
407	first_login	1710450871
307	traffic_periodic_accounting_daily_reset	1740373200
446	traffic_periodic_accounting_daily_reset	1719115200
446	first_login	1711361415
508	abs_exp_date	1719169048
50	abs_exp_date	1757104453
103	traffic_periodic_accounting_daily	66
103	traffic_periodic_accounting_daily_limit	104857600000
883	abs_exp_date	1724303152
116	first_login	1724236412
790	first_login	1724870419
988	traffic_periodic_accounting_daily	90
268	traffic_periodic_accounting_daily_reset	1720242000
351	traffic_periodic_accounting_daily_reset	1726718400
409	first_login	1720779688
770	traffic_periodic_accounting_daily_reset	1725854400
70	first_login	1707449561
396	traffic_periodic_accounting_daily	180
505	first_login	1732208703
242	traffic_periodic_accounting_daily_reset	1719291600
1016	first_login	1731478463
465	traffic_periodic_accounting_daily_reset	1722398400
505	traffic_periodic_accounting_daily_reset	1736049600
692	traffic_periodic_accounting_daily	180
271	first_login	1731961165
930	first_login	1726043021
348	traffic_periodic_accounting_daily_reset	1733115600
880	traffic_periodic_accounting_daily_reset	1734408000
610	first_login	1723885329
146	first_login	1707807005
1007	traffic_periodic_accounting_daily_reset	1736827200
250	first_login	1708574860
344	first_login	1717570356
806	traffic_periodic_accounting_daily_usage	2402548965
826	first_login	1730672282
134	first_login	1722173231
91	abs_exp_date	1711755638
92	abs_exp_date	1708818250
891	traffic_periodic_accounting_daily_reset	1729656000
470	first_login	1712232496
183	abs_exp_date	1714052265
408	traffic_periodic_accounting_daily	90
1029	traffic_periodic_accounting_daily_reset	1732507200
501	traffic_periodic_accounting_daily_reset	1716696000
556	traffic_periodic_accounting_daily_reset	1719288000
508	first_login	1718737125
582	first_login	1717509651
128	multi_login	3
455	traffic_periodic_accounting_daily_reset	1719547200
147	traffic_periodic_accounting_daily_reset	1739250000
180	traffic_periodic_accounting_daily_reset	1716008400
68	abs_exp_date	1709331378
563	first_login	1730356700
243	first_login	1708938972
240	traffic_periodic_accounting_daily_reset	1711429200
458	first_login	1730278826
143	traffic_periodic_accounting_daily_reset	1713589200
46	first_login	1707582057
465	first_login	1715287007
413	first_login	1718731157
118	traffic_periodic_accounting_daily_limit	41943040000
473	traffic_periodic_accounting_daily_reset	1720065600
644	first_login	1716759619
241	traffic_periodic_accounting_daily_reset	1712120400
135	first_login	1708014387
96	traffic_periodic_accounting_daily_reset	1710046800
143	first_login	1708438918
408	first_login	1731307027
437	traffic_periodic_accounting_daily_reset	1721188800
250	traffic_periodic_accounting_daily_reset	1713675600
70	traffic_periodic_accounting_daily_reset	1717736400
713	first_login	1730025590
96	first_login	1707462073
1007	first_login	1728361187
980	traffic_periodic_accounting_daily_reset	1734148800
104	abs_exp_date	1708684353
74	traffic_periodic_accounting_daily_usage	1957289651
568	traffic_periodic_accounting_daily_reset	1719892800
62	traffic_periodic_accounting_daily_reset	1735016400
107	first_login	1707477259
438	traffic_periodic_accounting_daily_reset	1742356800
682	first_login	1717615066
212	traffic_periodic_accounting_daily_reset	1710997200
368	first_login	1710235170
198	first_login	1724775854
239	first_login	1712663170
278	first_login	1732211888
68	traffic_periodic_accounting_daily_reset	1710046800
68	first_login	1707472148
5	multi_login	1
463	traffic_periodic_accounting_daily_reset	1717214400
101	abs_exp_date	1709020365
540	traffic_periodic_accounting_daily_reset	1716523200
170	first_login	1708102792
137	first_login	1708163430
111	first_login	1707720199
376	traffic_periodic_accounting_daily_reset	1717300800
467	first_login	1714912817
342	first_login	1709758935
342	abs_exp_date	1714676571
997	traffic_periodic_accounting_daily_reset	1732766400
409	traffic_periodic_accounting_daily_reset	1725940800
438	first_login	1710876651
829	traffic_periodic_accounting_daily	118
823	first_login	1731177537
668	first_login	1723898430
104	traffic_periodic_accounting_daily_reset	1710046800
104	first_login	1707477678
693	traffic_periodic_accounting_daily_reset	1720756800
510	first_login	1728633533
990	first_login	1730364498
30	first_login	1732108439
127	traffic_periodic_accounting_daily_reset	1736395200
162	first_login	1707984006
115	first_login	1707581566
6	traffic_periodic_accounting_daily_reset	1720328400
344	traffic_periodic_accounting_daily_reset	1740805200
776	traffic_periodic_accounting_daily_reset	1723089600
747	traffic_periodic_accounting_daily	90
390	traffic_periodic_accounting_daily_reset	1720497600
337	traffic_periodic_accounting_daily_reset	1712206800
1005	first_login	1730773004
638	traffic_periodic_accounting_daily_reset	1722312000
257	traffic_periodic_accounting_daily_reset	1739768400
328	first_login	1712247612
296	traffic_periodic_accounting_daily_reset	1711861200
291	first_login	1709222408
911	traffic_periodic_accounting_daily_reset	1730865600
430	first_login	1731840512
247	first_login	1727453172
802	traffic_periodic_accounting_daily_reset	1727409600
396	traffic_periodic_accounting_daily_reset	1743912000
184	abs_exp_date	1709991786
581	multi_login	4
114	traffic_periodic_accounting_daily_usage	227521730
93	first_login	1719436392
318	first_login	1716669152
379	traffic_periodic_accounting_daily_reset	1717387200
288	traffic_periodic_accounting_daily_reset	1740632400
285	traffic_periodic_accounting_daily_reset	1714194000
275	traffic_periodic_accounting_daily_reset	1734843600
90	first_login	1714934696
298	traffic_periodic_accounting_daily_reset	1714712400
123	traffic_periodic_accounting_daily_usage	341744145
595	traffic_periodic_accounting_daily_limit	104857600000
157	traffic_periodic_accounting_daily_reset	1738904400
960	traffic_periodic_accounting_daily_reset	1741060800
715	traffic_periodic_accounting_daily	90
212	first_login	1708431697
198	traffic_periodic_accounting_daily_reset	1739336400
531	traffic_periodic_accounting_daily_reset	1734321600
1007	abs_exp_date	1736783711
983	traffic_periodic_accounting_daily_limit	157286400000
236	first_login	1708449995
637	first_login	1731183980
1088	traffic_periodic_accounting_daily_reset	1734325200
749	traffic_periodic_accounting_daily_reset	1722484800
147	first_login	1707764157
210	traffic_periodic_accounting_daily_reset	1734498000
312	traffic_periodic_accounting_daily_reset	1718514000
696	first_login	1718818572
291	traffic_periodic_accounting_daily_reset	1714366800
960	first_login	1726650637
236	traffic_periodic_accounting_daily_reset	1718773200
101	traffic_periodic_accounting_daily_usage	6487602521
244	traffic_periodic_accounting_daily_reset	1714194000
629	first_login	1722085004
160	first_login	1707981208
721	first_login	1729364096
676	traffic_periodic_accounting_daily_reset	1722916800
111	traffic_periodic_accounting_daily_usage	677042178
307	first_login	1716834383
284	traffic_periodic_accounting_daily_reset	1711602000
114	traffic_periodic_accounting_daily_reset	1711429200
114	first_login	1707575453
540	first_login	1713953136
127	traffic_periodic_accounting_daily	90
297	first_login	1709395354
297	traffic_periodic_accounting_daily_reset	1714539600
581	traffic_periodic_accounting_daily_reset	1724990400
522	first_login	1732273944
645	first_login	1716820364
238	first_login	1708793811
663	traffic_periodic_accounting_daily_reset	1722657600
241	first_login	1709546164
998	traffic_periodic_accounting_daily_limit	314572800000
618	traffic_periodic_accounting_daily_reset	1718942400
124	traffic_periodic_accounting_daily_reset	1710306000
795	first_login	1726076283
463	first_login	1712066173
207	traffic_periodic_accounting_daily_reset	1726462800
126	traffic_periodic_accounting_daily	37
126	traffic_periodic_accounting_daily_limit	52428800000
743	multi_login	2
663	first_login	1717493497
391	traffic_periodic_accounting_daily_reset	1733457600
602	traffic_periodic_accounting_daily_reset	1736395200
414	traffic_periodic_accounting_daily_reset	1713067200
207	first_login	1711791891
239	traffic_periodic_accounting_daily_reset	1716526800
1066	first_login	1730576370
157	first_login	1723492897
77	first_login	1719656585
283	first_login	1724584061
280	first_login	1731093763
772	first_login	1720459262
431	first_login	1717216710
124	first_login	1707720473
376	first_login	1712140666
328	traffic_periodic_accounting_daily_reset	1717390800
118	traffic_periodic_accounting_daily_reset	1723093200
763	traffic_periodic_accounting_daily_reset	1722484800
180	first_login	1708240476
123	traffic_periodic_accounting_daily_reset	1710306000
123	first_login	1707720416
203	traffic_periodic_accounting_daily_reset	1739422800
326	traffic_periodic_accounting_daily_reset	1714798800
136	traffic_periodic_accounting_daily_reset	1713243600
337	first_login	1709667423
770	first_login	1720686679
61	traffic_periodic_accounting_daily_usage	28999110191
312	first_login	1710013504
890	traffic_periodic_accounting_daily_reset	1732248000
289	first_login	1709214953
619	traffic_periodic_accounting_daily_reset	1719115200
440	traffic_periodic_accounting_daily_usage	392232214
31	traffic_periodic_accounting_daily_reset	1710306000
31	first_login	1707774327
379	first_login	1712223716
415	first_login	1710609332
790	traffic_periodic_accounting_daily_reset	1729396800
719	first_login	1730194996
574	first_login	1715098153
262	traffic_periodic_accounting_daily_reset	1724302800
262	first_login	1708789530
288	first_login	1709155429
993	first_login	1728390638
209	traffic_periodic_accounting_daily_reset	1734325200
502	traffic_periodic_accounting_daily_reset	1716696000
161	first_login	1719951031
127	traffic_periodic_accounting_daily_limit	52428800000
658	traffic_periodic_accounting_daily_reset	1719806400
747	traffic_periodic_accounting_daily_reset	1735272000
244	first_login	1709052542
327	first_login	1709656735
937	traffic_periodic_accounting_daily_reset	1733716800
1017	traffic_periodic_accounting_daily_limit	629145600000
538	traffic_periodic_accounting_daily_reset	1744948800
414	first_login	1710542558
1029	first_login	1729939756
150	traffic_periodic_accounting_daily	129
150	traffic_periodic_accounting_daily_limit	209715200000
501	first_login	1714126551
842	traffic_periodic_accounting_daily_reset	1725854400
400	first_login	1731615329
325	traffic_periodic_accounting_daily_reset	1712379600
298	first_login	1709560642
323	first_login	1709829798
671	traffic_periodic_accounting_daily_reset	1722744000
613	first_login	1716146628
339	traffic_periodic_accounting_daily_reset	1714798800
878	traffic_periodic_accounting_daily_reset	1726804800
1001	first_login	1730351832
296	first_login	1709316206
833	abs_exp_date	1723151434
445	traffic_periodic_accounting_daily_reset	1726891200
83	traffic_periodic_accounting_daily_usage	1124876044
261	traffic_periodic_accounting_daily_reset	1716526800
430	traffic_periodic_accounting_daily_reset	1734148800
417	traffic_periodic_accounting_daily_reset	1713153600
351	first_login	1711192599
461	traffic_periodic_accounting_daily_reset	1719720000
751	traffic_periodic_accounting_daily_reset	1725249600
907	abs_exp_date	1725208858
326	first_login	1709655913
455	first_login	1711826481
520	abs_exp_date	1737139479
774	first_login	1720463291
457	traffic_periodic_accounting_daily_reset	1714536000
452	traffic_periodic_accounting_daily_reset	1714190400
309	traffic_periodic_accounting_daily_reset	1740373200
96	traffic_periodic_accounting_daily_usage	12811387262
462	traffic_periodic_accounting_daily_reset	1719806400
560	traffic_periodic_accounting_daily_reset	1716868800
385	traffic_periodic_accounting_daily_reset	1715054400
113	first_login	1728280171
324	first_login	1709650693
339	first_login	1709696799
36	traffic_periodic_accounting_daily_usage	1069191602
333	first_login	1709925157
929	traffic_periodic_accounting_daily_reset	1733198400
595	traffic_periodic_accounting_daily_reset	1734062400
162	abs_exp_date	1715325551
374	traffic_periodic_accounting_daily_reset	1718596800
440	traffic_periodic_accounting_daily_reset	1721880000
324	traffic_periodic_accounting_daily_reset	1714798800
560	first_login	1714360305
535	traffic_periodic_accounting_daily_reset	1718856000
282	traffic_periodic_accounting_daily_reset	1724475600
981	traffic_periodic_accounting_daily_reset	1734235200
285	first_login	1709060470
184	traffic_periodic_accounting_daily	21
184	traffic_periodic_accounting_daily_limit	36700160000
97	traffic_periodic_accounting_daily_usage	8662477538
317	traffic_periodic_accounting_daily_reset	1740891600
317	first_login	1709410726
141	traffic_periodic_accounting_daily_reset	1710910800
167	first_login	1708033480
141	first_login	1708341352
248	traffic_periodic_accounting_daily	78
136	first_login	1708103198
183	traffic_periodic_accounting_daily	68
183	traffic_periodic_accounting_daily_limit	125829120000
310	first_login	1731048876
530	traffic_periodic_accounting_daily_reset	1729051200
621	first_login	1716658135
689	first_login	1729599262
374	first_login	1710858473
185	traffic_periodic_accounting_daily_reset	1713330000
414	traffic_periodic_accounting_daily_usage	864536428
499	traffic_periodic_accounting_daily_reset	1715918400
92	traffic_periodic_accounting_daily_usage	9503176081
383	traffic_periodic_accounting_daily_reset	1715054400
183	traffic_periodic_accounting_daily_reset	1714021200
183	first_login	1708202733
189	traffic_periodic_accounting_daily_reset	1755320400
619	first_login	1716560111
417	first_login	1710617192
754	first_login	1720258344
271	traffic_periodic_accounting_daily_reset	1734757200
1010	traffic_periodic_accounting_daily_reset	1734062400
460	traffic_periodic_accounting_daily_reset	1714536000
618	first_login	1716402545
579	traffic_periodic_accounting_daily	90
403	traffic_periodic_accounting_daily_reset	1741838400
134	traffic_periodic_accounting_daily_reset	1725858000
240	first_login	1708874239
433	traffic_periodic_accounting_daily_limit	157286400000
408	traffic_periodic_accounting_daily_limit	104857600000
953	traffic_periodic_accounting_daily_reset	1736568000
640	traffic_periodic_accounting_daily_reset	1722225600
452	first_login	1711668424
460	first_login	1711952915
68	traffic_periodic_accounting_daily_usage	3272672839
766	abs_exp_date	1728623374
371	first_login	1710347925
7	traffic_periodic_accounting_daily_usage	1372795915
293	first_login	1709308287
405	traffic_periodic_accounting_daily_reset	1733803200
185	first_login	1708199029
105	traffic_periodic_accounting_daily_reset	1720414800
779	first_login	1720710784
568	first_login	1714746102
457	first_login	1711972228
391	first_login	1730633735
476	traffic_periodic_accounting_daily	220
243	traffic_periodic_accounting_daily_usage	28986708
319	first_login	1730058857
331	traffic_periodic_accounting_daily_reset	1714971600
594	traffic_periodic_accounting_daily_reset	1718510400
160	traffic_periodic_accounting_daily_usage	1654358653
31	traffic_periodic_accounting_daily_usage	781054723
373	traffic_periodic_accounting_daily_reset	1713326400
296	traffic_periodic_accounting_daily_usage	0
1011	traffic_periodic_accounting_daily_usage	858360897
658	first_login	1717259638
423	traffic_periodic_accounting_daily_reset	1731470400
887	traffic_periodic_accounting_daily	90
187	traffic_periodic_accounting_daily_reset	1755234000
197	traffic_periodic_accounting_daily_reset	1739336400
659	traffic_periodic_accounting_daily_reset	1722484800
879	traffic_periodic_accounting_daily_reset	1726545600
879	first_login	1724009452
852	abs_exp_date	1728905418
813	traffic_periodic_accounting_daily_reset	1727928000
562	traffic_periodic_accounting_daily_reset	1737864000
84	first_login	1726152729
550	first_login	1714398013
657	traffic_periodic_accounting_daily_reset	1722398400
286	first_login	1730729856
802	first_login	1722246398
202	traffic_periodic_accounting_daily_reset	1731646800
385	first_login	1712503247
177	traffic_periodic_accounting_daily_usage	2081622275
547	traffic_periodic_accounting_daily_reset	1716696000
509	first_login	1715583252
325	first_login	1709828744
104	traffic_periodic_accounting_daily_usage	10306103962
597	traffic_periodic_accounting_daily_reset	1721188800
499	first_login	1713369182
293	traffic_periodic_accounting_daily_reset	1714453200
818	traffic_periodic_accounting_daily_reset	1725508800
1019	traffic_periodic_accounting_daily_reset	1734235200
383	first_login	1712494003
571	first_login	1716306304
440	first_login	1711541097
176	traffic_periodic_accounting_daily_reset	1721106000
1019	traffic_periodic_accounting_daily	60
388	traffic_periodic_accounting_daily_reset	1717732800
425	traffic_periodic_accounting_daily_reset	1714449600
678	traffic_periodic_accounting_daily_reset	1720411200
693	first_login	1718212810
535	first_login	1713732956
979	first_login	1728727530
531	traffic_periodic_accounting_daily	90
1019	traffic_periodic_accounting_daily_limit	41943040000
595	first_login	1731595141
284	first_login	1709059343
362	abs_exp_date	1715197309
815	traffic_periodic_accounting_daily_reset	1727841600
146	traffic_periodic_accounting_daily_usage	19893395
298	traffic_periodic_accounting_daily_usage	478422
185	traffic_periodic_accounting_daily_usage	25054097
597	first_login	1716059897
530	first_login	1713528237
494	traffic_periodic_accounting_daily_reset	1715400000
407	traffic_periodic_accounting_daily_reset	1725940800
599	first_login	1718821023
749	first_login	1719943149
332	traffic_periodic_accounting_daily_reset	1715745600
875	traffic_periodic_accounting_daily_reset	1726459200
751	first_login	1720108274
128	traffic_periodic_accounting_daily_reset	1736913600
958	traffic_periodic_accounting_daily	90
557	traffic_periodic_accounting_daily_reset	1729742400
136	traffic_periodic_accounting_daily_usage	201781
349	traffic_periodic_accounting_daily_reset	1733288400
386	traffic_periodic_accounting_daily_reset	1715140800
382	traffic_periodic_accounting_daily_reset	1716004800
75	traffic_periodic_accounting_daily_usage	7286849481
355	traffic_periodic_accounting_daily_reset	1720242000
290	traffic_periodic_accounting_daily_usage	17290166
187	first_login	1716359887
528	first_login	1731935251
544	traffic_periodic_accounting_daily_reset	1721880000
615	traffic_periodic_accounting_daily_reset	1721361600
740	traffic_periodic_accounting_daily_reset	1721880000
469	traffic_periodic_accounting_daily_reset	1719979200
235	first_login	1708449780
413	traffic_periodic_accounting_daily_reset	1720843200
164	first_login	1716909515
496	traffic_periodic_accounting_daily_reset	1715659200
509	traffic_periodic_accounting_daily_reset	1725854400
861	traffic_periodic_accounting_daily_reset	1728705600
137	traffic_periodic_accounting_daily_reset	1713330000
158	traffic_periodic_accounting_daily_reset	1738990800
457	traffic_periodic_accounting_daily_usage	465194689
107	traffic_periodic_accounting_daily_usage	35265876502
396	traffic_periodic_accounting_daily_limit	209715200000
683	traffic_periodic_accounting_daily_usage	18365
623	traffic_periodic_accounting_daily_reset	1719288000
24	traffic_periodic_accounting_daily_reset	1730696400
237	traffic_periodic_accounting_daily_usage	1025780676
403	first_login	1710365529
594	first_login	1715963448
818	first_login	1722959029
259	traffic_periodic_accounting_daily_reset	1711256400
259	first_login	1708685994
240	traffic_periodic_accounting_daily_usage	1497340104
697	traffic_periodic_accounting_daily_reset	1721534400
709	first_login	1730097055
445	first_login	1720761753
669	traffic_periodic_accounting_daily_reset	1748923200
475	traffic_periodic_accounting_daily_reset	1717473600
697	first_login	1718982306
629	traffic_periodic_accounting_daily_reset	1758600000
543	traffic_periodic_accounting_daily_reset	1716609600
571	traffic_periodic_accounting_daily_reset	1721448000
235	traffic_periodic_accounting_daily_reset	1713589200
521	traffic_periodic_accounting_daily_usage	26083116
248	traffic_periodic_accounting_daily_limit	136314880000
786	traffic_periodic_accounting_daily_reset	1736654400
481	traffic_periodic_accounting_daily_reset	1725595200
678	first_login	1717872472
65	traffic_periodic_accounting_daily_usage	6933353454
814	traffic_periodic_accounting_daily_reset	1725595200
588	first_login	1715237843
814	first_login	1723048089
576	traffic_periodic_accounting_daily_reset	1717732800
792	abs_exp_date	1721899591
576	first_login	1715191894
652	first_login	1732111638
615	first_login	1716225348
659	first_login	1717327938
874	traffic_periodic_accounting_daily_reset	1734148800
735	traffic_periodic_accounting_daily_reset	1722225600
538	first_login	1713863352
70	traffic_periodic_accounting_daily_usage	162815247
338	traffic_periodic_accounting_daily_reset	1712206800
338	first_login	1709668464
739	first_login	1719307123
763	first_login	1719909399
154	first_login	1720037554
425	first_login	1711912261
115	traffic_periodic_accounting_daily_usage	3404614733
151	traffic_periodic_accounting_daily_reset	1718254800
312	traffic_periodic_accounting_daily_limit	157286400000
237	traffic_periodic_accounting_daily_reset	1711170000
237	first_login	1708628398
331	first_login	1709825033
238	traffic_periodic_accounting_daily_usage	2146655
292	traffic_periodic_accounting_daily_usage	24062188
183	traffic_periodic_accounting_daily_usage	2616839178
63	traffic_periodic_accounting_daily_usage	3200459179
184	lock	2/3/2024
284	traffic_periodic_accounting_daily_usage	1350885420
323	traffic_periodic_accounting_daily_reset	1740891600
669	first_login	1717404595
436	traffic_periodic_accounting_daily_reset	1724212800
290	first_login	1709216314
569	first_login	1714828734
235	traffic_periodic_accounting_daily_usage	20942309
354	traffic_periodic_accounting_daily_reset	1717650000
213	traffic_periodic_accounting_daily_usage	548696314
656	traffic_periodic_accounting_daily_reset	1720238400
1016	traffic_periodic_accounting_daily_reset	1733976000
863	traffic_periodic_accounting_daily_reset	1729051200
556	first_login	1714149149
830	traffic_periodic_accounting_daily_reset	1733284800
404	first_login	1726214888
782	traffic_periodic_accounting_daily_reset	1725076800
592	traffic_periodic_accounting_daily_reset	1720843200
306	traffic_periodic_accounting_daily_reset	1716958800
143	traffic_periodic_accounting_daily_usage	685533
526	first_login	1716065024
564	first_login	1730113322
285	traffic_periodic_accounting_daily_usage	246294467
551	first_login	1714398827
712	traffic_periodic_accounting_daily_reset	1734062400
364	traffic_periodic_accounting_daily_reset	1733371200
327	traffic_periodic_accounting_daily_usage	11685795
841	traffic_periodic_accounting_daily_reset	1725854400
694	traffic_periodic_accounting_daily_reset	1720843200
569	traffic_periodic_accounting_daily_reset	1719979200
696	traffic_periodic_accounting_daily_reset	1723953600
694	first_login	1718296838
261	traffic_periodic_accounting_daily_usage	1035143705
397	traffic_periodic_accounting_daily_reset	1716264000
891	traffic_periodic_accounting_daily_limit	10485760000
572	traffic_periodic_accounting_daily_reset	1733112000
647	first_login	1716894569
329	traffic_periodic_accounting_daily_usage	57511498
707	traffic_periodic_accounting_daily_reset	1736222400
640	first_login	1717071288
397	first_login	1713725715
544	first_login	1714132863
852	lock	
252	traffic_periodic_accounting_daily_reset	1729314000
289	traffic_periodic_accounting_daily_usage	63726954
495	first_login	1713020388
552	first_login	1714492916
585	traffic_periodic_accounting_daily_reset	1717560000
242	first_login	1714323429
157	traffic_periodic_accounting_daily	180
547	first_login	1714159090
372	first_login	1710350996
76	traffic_periodic_accounting_daily_reset	1738472400
577	traffic_periodic_accounting_daily_reset	1717905600
276	first_login	1731832497
382	first_login	1713456674
895	traffic_periodic_accounting_daily_usage	74808391
312	traffic_periodic_accounting_daily	99
384	traffic_periodic_accounting_daily_usage	178146137
255	traffic_periodic_accounting_daily_reset	1716354000
1042	traffic_periodic_accounting_daily_reset	1761451200
331	traffic_periodic_accounting_daily_usage	172603104
476	traffic_periodic_accounting_daily_limit	314572800000
338	traffic_periodic_accounting_daily_usage	1523003211
692	traffic_periodic_accounting_daily_reset	1743825600
599	traffic_periodic_accounting_daily_reset	1723867200
141	traffic_periodic_accounting_daily_usage	766116919
510	traffic_periodic_accounting_daily	180
494	first_login	1712855757
592	first_login	1715713944
277	first_login	1731832549
740	first_login	1719318782
639	traffic_periodic_accounting_daily_reset	1719720000
565	traffic_periodic_accounting_daily_limit	367001600000
46	multi_login	1
776	first_login	1720528600
841	first_login	1723305390
460	traffic_periodic_accounting_daily_usage	8768589622
477	traffic_periodic_accounting_daily_reset	1722830400
415	traffic_periodic_accounting_daily_usage	93901799
259	traffic_periodic_accounting_daily_usage	2661828120
330	traffic_periodic_accounting_daily_usage	52604410
153	traffic_periodic_accounting_daily_reset	1718254800
546	traffic_periodic_accounting_daily_reset	1717473600
250	traffic_periodic_accounting_daily_usage	163384661
496	first_login	1713136276
469	traffic_periodic_accounting_daily_usage	50053777
244	traffic_periodic_accounting_daily_usage	50505376
384	first_login	1712501453
372	traffic_periodic_accounting_daily_usage	1967109
479	first_login	1712612916
373	first_login	1710789602
238	traffic_periodic_accounting_daily_reset	1713934800
332	first_login	1710597241
577	first_login	1715349061
875	first_login	1723901973
633	traffic_periodic_accounting_daily_reset	1719460800
549	first_login	1714321501
1042	first_login	1729949082
180	traffic_periodic_accounting_daily_usage	2547394541
1044	traffic_periodic_accounting_daily_reset	1732507200
733	traffic_periodic_accounting_daily_reset	1722139200
527	traffic_periodic_accounting_daily_reset	1721188800
120	first_login	1732213929
545	traffic_periodic_accounting_daily_reset	1719979200
947	traffic_periodic_accounting_daily_reset	1731729600
291	traffic_periodic_accounting_daily_usage	144958254
607	traffic_periodic_accounting_daily_limit	31457280000
90	multi_login	1
304	traffic_periodic_accounting_daily_usage	3858411132
39	traffic_periodic_accounting_daily_reset	1722920400
394	traffic_periodic_accounting_daily_reset	1733976000
731	traffic_periodic_accounting_daily_reset	1722052800
197	first_login	1723925610
370	traffic_periodic_accounting_daily_usage	7560767
370	traffic_periodic_accounting_daily_reset	1712808000
699	traffic_periodic_accounting_daily_reset	1721534400
294	traffic_periodic_accounting_daily_reset	1711861200
294	first_login	1709308505
294	traffic_periodic_accounting_daily_usage	682766567
369	traffic_periodic_accounting_daily_reset	1712808000
369	first_login	1710238141
370	first_login	1710253763
135	traffic_periodic_accounting_daily_usage	1215494907
908	first_login	1725284024
657	first_login	1717257667
958	traffic_periodic_accounting_daily_limit	104857600000
328	traffic_periodic_accounting_daily_usage	208264104
628	first_login	1721813371
937	first_login	1729667482
545	first_login	1714843956
522	traffic_periodic_accounting_daily_reset	1733889600
388	first_login	1712594438
591	traffic_periodic_accounting_daily_reset	1718251200
864	traffic_periodic_accounting_daily_reset	1734408000
498	traffic_periodic_accounting_daily_reset	1718424000
549	traffic_periodic_accounting_daily_reset	1719460800
631	traffic_periodic_accounting_daily_reset	1719374400
493	first_login	1713433738
656	first_login	1717661706
565	traffic_periodic_accounting_daily_reset	1745985600
368	traffic_periodic_accounting_daily_usage	1626604331
750	traffic_periodic_accounting_daily_reset	1725076800
557	first_login	1714211677
562	traffic_periodic_accounting_daily	180
732	traffic_periodic_accounting_daily_reset	1722139200
164	traffic_periodic_accounting_daily_reset	1720933200
436	first_login	1714934608
531	traffic_periodic_accounting_daily_limit	157286400000
887	first_login	1731070106
718	first_login	1729920903
737	traffic_periodic_accounting_daily_reset	1724904000
954	lock	
390	first_login	1715396824
774	traffic_periodic_accounting_daily_reset	1725595200
360	traffic_periodic_accounting_daily_usage	10216711475
616	traffic_periodic_accounting_daily_reset	1718769600
516	traffic_periodic_accounting_daily_reset	1733889600
835	traffic_periodic_accounting_daily	180
406	traffic_periodic_accounting_daily	117
704	traffic_periodic_accounting_daily_reset	1733630400
369	traffic_periodic_accounting_daily_usage	5644907812
908	traffic_periodic_accounting_daily_reset	1730433600
295	traffic_periodic_accounting_daily_usage	151620945
699	first_login	1718992317
374	traffic_periodic_accounting_daily_usage	25599899107
750	first_login	1719943347
1022	first_login	1732279419
881	first_login	1724089593
961	traffic_periodic_accounting_daily_reset	1731902400
622	first_login	1716661705
543	first_login	1714042965
151	traffic_periodic_accounting_daily_usage	264726581
406	traffic_periodic_accounting_daily_limit	209715200000
325	traffic_periodic_accounting_daily_usage	329277689
546	first_login	1714926564
580	traffic_periodic_accounting_daily_reset	1746072000
326	traffic_periodic_accounting_daily_usage	21379536
417	traffic_periodic_accounting_daily_usage	631138611
324	traffic_periodic_accounting_daily_usage	33262763
585	first_login	1715053595
137	traffic_periodic_accounting_daily_usage	55203512
332	traffic_periodic_accounting_daily_usage	8512855
410	traffic_periodic_accounting_daily_reset	1742011200
410	first_login	1710502747
212	traffic_periodic_accounting_daily_usage	52695709255
91	traffic_periodic_accounting_daily_usage	50184159462
453	abs_exp_date	1711796674
293	traffic_periodic_accounting_daily_usage	98379402
500	traffic_periodic_accounting_daily_usage	237836868
715	traffic_periodic_accounting_daily_reset	1734667200
588	traffic_periodic_accounting_daily_reset	1720411200
1007	traffic_periodic_accounting_daily_limit	104857600000
992	traffic_periodic_accounting_daily_reset	1735012800
675	first_login	1717779185
707	first_login	1723542574
502	first_login	1714140229
633	first_login	1716887241
690	traffic_periodic_accounting_daily_reset	1720584000
704	first_login	1718141599
577	traffic_periodic_accounting_daily_usage	729106871
753	traffic_periodic_accounting_daily_reset	1725249600
452	abs_exp_date	1712703958
301	traffic_periodic_accounting_daily_reset	1722315600
766	traffic_periodic_accounting_daily_reset	1730347200
412	traffic_periodic_accounting_daily_reset	1741579200
650	traffic_periodic_accounting_daily_reset	1732507200
162	traffic_periodic_accounting_daily_usage	5204613094
241	traffic_periodic_accounting_daily_usage	2480638972
679	traffic_periodic_accounting_daily_reset	1721707200
928	traffic_periodic_accounting_daily	365
386	first_login	1712589625
732	first_login	1719583079
494	traffic_periodic_accounting_daily_usage	13378252568
753	first_login	1720109239
547	traffic_periodic_accounting_daily_usage	1478775296
1023	traffic_periodic_accounting_daily_reset	1732334400
354	first_login	1715084774
958	traffic_periodic_accounting_daily_reset	1739332800
1096	traffic_periodic_accounting_daily_reset	1734757200
690	first_login	1718005449
498	traffic_periodic_accounting_daily_usage	539772968
687	traffic_periodic_accounting_daily_reset	1749355200
685	traffic_periodic_accounting_daily_reset	1725508800
868	first_login	1724779776
683	traffic_periodic_accounting_daily_reset	1720238400
975	traffic_periodic_accounting_daily_reset	1730520000
660	first_login	1717338145
661	traffic_periodic_accounting_daily_reset	1722484800
379	traffic_periodic_accounting_daily_usage	12585586
764	traffic_periodic_accounting_daily_reset	1722484800
590	first_login	1730136623
999	traffic_periodic_accounting_daily	180
850	traffic_periodic_accounting_daily_reset	1738209600
679	first_login	1719162913
1088	first_login	1731783641
616	first_login	1716207654
624	traffic_periodic_accounting_daily_usage	910847555
339	traffic_periodic_accounting_daily_usage	194196527
1096	first_login	1732192625
411	traffic_periodic_accounting_daily_reset	1733976000
646	traffic_periodic_accounting_daily_reset	1732420800
510	traffic_periodic_accounting_daily_limit	262144000000
842	first_login	1723309028
748	first_login	1722955342
741	traffic_periodic_accounting_daily_reset	1750910400
560	traffic_periodic_accounting_daily_usage	7999712589
837	first_login	1730838912
552	traffic_periodic_accounting_daily_reset	1719633600
667	traffic_periodic_accounting_daily_reset	1748836800
381	traffic_periodic_accounting_daily_usage	23833435221
469	first_login	1712233175
1071	multi_login	3
685	first_login	1717792936
333	traffic_periodic_accounting_daily_usage	18810761
239	traffic_periodic_accounting_daily_usage	249460092
661	first_login	1717343824
498	first_login	1713290801
120	traffic_periodic_accounting_daily_reset	1733547600
765	traffic_periodic_accounting_daily	90
453	traffic_periodic_accounting_daily_reset	1714276800
453	first_login	1711727689
620	first_login	1716735983
722	traffic_periodic_accounting_daily_reset	1721448000
591	first_login	1715674997
827	first_login	1730659991
366	traffic_periodic_accounting_daily_reset	1725681600
874	first_login	1731677887
258	traffic_periodic_accounting_daily_reset	1724216400
210	first_login	1731132025
1002	traffic_periodic_accounting_daily_reset	1733112000
944	traffic_periodic_accounting_daily_reset	1728964800
989	traffic_periodic_accounting_daily_reset	1732248000
1088	abs_exp_date	1733771185
726	traffic_periodic_accounting_daily_reset	1750651200
295	traffic_periodic_accounting_daily_reset	1714453200
623	first_login	1716721878
203	first_login	1716726736
453	traffic_periodic_accounting_daily_usage	43684779
565	first_login	1714462163
425	traffic_periodic_accounting_daily_usage	3969476559
297	traffic_periodic_accounting_daily_usage	112286798
622	traffic_periodic_accounting_daily_usage	0
701	traffic_periodic_accounting_daily_reset	1724385600
792	traffic_periodic_accounting_daily_reset	1724385600
385	traffic_periodic_accounting_daily_usage	9512553805
740	traffic_periodic_accounting_daily_usage	96635916
502	traffic_periodic_accounting_daily_usage	114128016
112	first_login	1728368331
687	first_login	1717852255
664	first_login	1717516646
606	traffic_periodic_accounting_daily_reset	1731211200
164	traffic_periodic_accounting_daily_usage	6670121242
130	traffic_periodic_accounting_daily	60
853	traffic_periodic_accounting_daily_reset	1725854400
639	traffic_periodic_accounting_daily_usage	5489066925
735	first_login	1719670668
258	first_login	1721877545
461	traffic_periodic_accounting_daily_usage	4069585551
895	traffic_periodic_accounting_daily_reset	1727236800
731	first_login	1719513048
650	first_login	1716976599
695	first_login	1718444387
495	traffic_periodic_accounting_daily_usage	85269466
132	traffic_periodic_accounting_daily_limit	52428800000
983	first_login	1730111141
617	traffic_periodic_accounting_daily_reset	1721361600
733	traffic_periodic_accounting_daily_usage	1383582
692	first_login	1728300706
752	traffic_periodic_accounting_daily_reset	1722571200
388	traffic_periodic_accounting_daily_usage	436100203
752	first_login	1720001702
341	traffic_periodic_accounting_daily_reset	1733029200
412	first_login	1726377092
381	traffic_periodic_accounting_daily_reset	1715054400
381	first_login	1712512489
895	first_login	1724710062
314	first_login	1722350219
607	traffic_periodic_accounting_daily_reset	1723521600
823	traffic_periodic_accounting_daily_reset	1738123200
571	traffic_periodic_accounting_daily_usage	138533785
943	first_login	1726241638
737	first_login	1719742203
437	traffic_periodic_accounting_daily_usage	604646680
631	first_login	1716831711
587	first_login	1726309219
755	traffic_periodic_accounting_daily_reset	1722830400
655	traffic_periodic_accounting_daily_reset	1722744000
756	first_login	1720287280
801	traffic_periodic_accounting_daily	176
871	first_login	1724948003
1023	first_login	1729764106
582	traffic_periodic_accounting_daily_reset	1722484800
764	first_login	1719953652
549	traffic_periodic_accounting_daily_usage	14452516
617	traffic_periodic_accounting_daily_usage	355824270
671	first_login	1717605928
628	traffic_periodic_accounting_daily_reset	1724299200
467	traffic_periodic_accounting_daily_reset	1719979200
733	first_login	1719598040
861	first_login	1723552264
693	traffic_periodic_accounting_daily_usage	211794498
722	first_login	1718905142
739	traffic_periodic_accounting_daily_reset	1734840000
620	traffic_periodic_accounting_daily_reset	1721880000
545	traffic_periodic_accounting_daily_usage	576715271
741	first_login	1719390798
700	traffic_periodic_accounting_daily_reset	1724299200
1010	first_login	1728889387
944	first_login	1726398160
726	first_login	1719132861
683	first_login	1717687415
687	traffic_periodic_accounting_daily_usage	6896828669
377	traffic_periodic_accounting_daily_reset	1722484800
470	traffic_periodic_accounting_daily_usage	49374722
76	first_login	1731246051
342	traffic_periodic_accounting_daily_usage	33641933521
537	traffic_periodic_accounting_daily_reset	1744862400
864	first_login	1730142668
623	traffic_periodic_accounting_daily_usage	21102896542
371	traffic_periodic_accounting_daily_usage	159420890
475	traffic_periodic_accounting_daily_usage	5295127157
667	first_login	1717319654
496	traffic_periodic_accounting_daily_usage	37139489999
606	first_login	1715719060
355	traffic_periodic_accounting_daily_usage	852808902
544	traffic_periodic_accounting_daily_usage	1065400565
730	first_login	1719492808
452	traffic_periodic_accounting_daily_usage	610454875
624	traffic_periodic_accounting_daily_reset	1719288000
624	first_login	1716742367
415	traffic_periodic_accounting_daily_reset	1715745600
632	first_login	1717000837
362	traffic_periodic_accounting_daily_usage	748939975
552	traffic_periodic_accounting_daily_usage	52398789
383	traffic_periodic_accounting_daily_usage	22781019502
139	traffic_periodic_accounting_daily_usage	519092667
700	first_login	1719154065
928	traffic_periodic_accounting_daily_limit	681574400000
1044	first_login	1729956814
433	traffic_periodic_accounting_daily_reset	1734148800
757	traffic_periodic_accounting_daily_reset	1725163200
648	traffic_periodic_accounting_daily_reset	1732420800
694	traffic_periodic_accounting_daily_usage	2640691888
764	traffic_periodic_accounting_daily_usage	599808897
716	traffic_periodic_accounting_daily	90
865	traffic_periodic_accounting_daily_reset	1726718400
692	traffic_periodic_accounting_daily_limit	209715200000
462	traffic_periodic_accounting_daily_usage	6271685983
303	traffic_periodic_accounting_daily_usage	207482960
835	traffic_periodic_accounting_daily_limit	314572800000
992	first_login	1727261083
380	traffic_periodic_accounting_daily_reset	1725249600
46	traffic_periodic_accounting_daily_usage	202477465792
833	traffic_periodic_accounting_daily_reset	1725508800
833	first_login	1722979589
808	traffic_periodic_accounting_daily_reset	1724990400
335	first_login	1731507861
550	traffic_periodic_accounting_daily_usage	27998065
850	first_login	1723193164
782	first_login	1722526803
396	first_login	1723881307
808	first_login	1722421455
597	traffic_periodic_accounting_daily_usage	369621839
816	traffic_periodic_accounting_daily_reset	1725422400
766	first_login	1728393062
987	traffic_periodic_accounting_daily_reset	1729656000
569	traffic_periodic_accounting_daily_usage	24098608
911	first_login	1725719206
734	traffic_periodic_accounting_daily_reset	1724731200
768	traffic_periodic_accounting_daily_reset	1733198400
895	abs_exp_date	1724796989
636	traffic_periodic_accounting_daily_reset	1722052800
792	first_login	1721817541
655	first_login	1717597395
1036	abs_exp_date	1732024559
838	traffic_periodic_accounting_daily_reset	1738641600
740	abs_exp_date	1719389525
566	first_login	1730525948
446	traffic_periodic_accounting_daily_usage	3140579588
508	traffic_periodic_accounting_daily_usage	764203306
755	first_login	1720258884
865	first_login	1724159764
554	traffic_periodic_accounting_daily_reset	1719806400
621	traffic_periodic_accounting_daily_usage	67432617
592	traffic_periodic_accounting_daily_usage	48575953
568	traffic_periodic_accounting_daily_usage	62472393
585	traffic_periodic_accounting_daily_usage	989547852
765	traffic_periodic_accounting_daily_limit	31457280000
830	first_login	1725391182
167	traffic_periodic_accounting_daily_usage	373443162
699	traffic_periodic_accounting_daily_usage	796523782
887	traffic_periodic_accounting_daily_limit	157286400000
139	traffic_periodic_accounting_daily_reset	1716008400
1071	traffic_periodic_accounting_daily_limit	157286400000
852	traffic_periodic_accounting_daily	66
202	traffic_periodic_accounting_daily_usage	444031160
354	traffic_periodic_accounting_daily_usage	4747868273
920	traffic_periodic_accounting_daily_reset	1756699200
366	first_login	1718040954
236	traffic_periodic_accounting_daily_usage	14622638571
473	first_login	1714971873
587	traffic_periodic_accounting_daily_reset	1762660800
829	abs_exp_date	1733085975
263	traffic_periodic_accounting_daily_reset	1729486800
775	traffic_periodic_accounting_daily_reset	1723089600
386	traffic_periodic_accounting_daily_usage	27629745705
819	traffic_periodic_accounting_daily_reset	1725508800
915	traffic_periodic_accounting_daily_reset	1728532800
551	traffic_periodic_accounting_daily_usage	4281565359
906	traffic_periodic_accounting_daily_reset	1732766400
607	first_login	1715804786
991	traffic_periodic_accounting_daily_reset	1732334400
825	traffic_periodic_accounting_daily_reset	1733112000
479	traffic_periodic_accounting_daily_usage	303679457
656	traffic_periodic_accounting_daily_usage	818450291
500	first_login	1713510659
617	first_login	1716226633
670	traffic_periodic_accounting_daily_reset	1720929600
670	first_login	1718368800
556	traffic_periodic_accounting_daily_usage	99365113
546	traffic_periodic_accounting_daily_usage	771176099
554	first_login	1714674195
255	traffic_periodic_accounting_daily_usage	144538818
382	traffic_periodic_accounting_daily_usage	11129216798
580	first_login	1714588502
463	traffic_periodic_accounting_daily_usage	65480946
929	first_login	1731699248
1012	traffic_periodic_accounting_daily	60
636	first_login	1716915354
945	first_login	1726408669
664	traffic_periodic_accounting_daily_usage	12865930
657	traffic_periodic_accounting_daily_usage	7195136
914	traffic_periodic_accounting_daily_reset	1728532800
1047	traffic_periodic_accounting_daily_reset	1733288400
1025	traffic_periodic_accounting_daily_reset	1732334400
648	first_login	1716929156
860	traffic_periodic_accounting_daily_usage	346656432
845	traffic_periodic_accounting_daily_reset	1725940800
640	traffic_periodic_accounting_daily_usage	6004412
77	traffic_periodic_accounting_daily_reset	1738558800
499	traffic_periodic_accounting_daily_usage	212491413
774	traffic_periodic_accounting_daily_usage	743045
467	traffic_periodic_accounting_daily_usage	278845670
351	traffic_periodic_accounting_daily_usage	1464719
361	traffic_periodic_accounting_daily_usage	3337285770
636	traffic_periodic_accounting_daily_usage	116058339
1079	traffic_periodic_accounting_daily_reset	1734757200
915	first_login	1725973125
501	traffic_periodic_accounting_daily_usage	36751383523
835	traffic_periodic_accounting_daily_reset	1738641600
321	first_login	1730982570
819	first_login	1722959117
950	traffic_periodic_accounting_daily_reset	1731902400
407	traffic_periodic_accounting_daily_usage	40641786
300	traffic_periodic_accounting_daily_usage	2994345096
157	traffic_periodic_accounting_daily_limit	209715200000
835	first_login	1723098475
376	traffic_periodic_accounting_daily_usage	90403392
158	traffic_periodic_accounting_daily	90
727	traffic_periodic_accounting_daily_reset	1734753600
829	traffic_periodic_accounting_daily_limit	157286400000
852	traffic_periodic_accounting_daily_limit	104857600000
575	first_login	1725539347
756	traffic_periodic_accounting_daily_usage	90803865
988	traffic_periodic_accounting_daily_limit	157286400000
761	abs_exp_date	1719947291
743	first_login	1719467090
576	traffic_periodic_accounting_daily_usage	425036446
321	traffic_periodic_accounting_daily_reset	1732770000
978	traffic_periodic_accounting_daily_reset	1733630400
634	traffic_periodic_accounting_daily_usage	18053898
594	traffic_periodic_accounting_daily_usage	21022930968
543	traffic_periodic_accounting_daily_usage	1256975837
763	traffic_periodic_accounting_daily_usage	160609619
472	traffic_periodic_accounting_daily_reset	1733112000
872	traffic_periodic_accounting_daily_reset	1727668800
775	first_login	1720518388
806	traffic_periodic_accounting_daily_reset	1724904000
801	traffic_periodic_accounting_daily_limit	104857600000
743	traffic_periodic_accounting_daily_reset	1724644800
806	first_login	1722367410
991	first_login	1729796627
853	first_login	1723276332
749	traffic_periodic_accounting_daily_usage	190229781
473	traffic_periodic_accounting_daily_usage	17596218
867	traffic_periodic_accounting_daily_usage	0
712	traffic_periodic_accounting_daily	180
768	first_login	1729449141
754	traffic_periodic_accounting_daily_usage	1002909521
455	traffic_periodic_accounting_daily_usage	12308351917
1020	traffic_periodic_accounting_daily_reset	1731643200
553	traffic_periodic_accounting_daily_reset	1722312000
999	traffic_periodic_accounting_daily_limit	314572800000
1032	traffic_periodic_accounting_daily_reset	1734494400
618	traffic_periodic_accounting_daily_usage	1211182571
627	traffic_periodic_accounting_daily_reset	1721448000
658	traffic_periodic_accounting_daily_usage	958372448
436	traffic_periodic_accounting_daily	90
436	traffic_periodic_accounting_daily_limit	104857600000
340	first_login	1730525847
622	traffic_periodic_accounting_daily_reset	1721793600
844	traffic_periodic_accounting_daily_reset	1728532800
1031	first_login	1731952980
644	traffic_periodic_accounting_daily_usage	476813468
627	first_login	1716323910
734	first_login	1719599499
812	traffic_periodic_accounting_daily_reset	1725076800
701	first_login	1719238140
554	traffic_periodic_accounting_daily_usage	65161014
585	abs_exp_date	1717183881
620	traffic_periodic_accounting_daily_usage	525469
672	traffic_periodic_accounting_daily_usage	124425002
397	traffic_periodic_accounting_daily_usage	7451258474
282	first_login	1716221893
242	traffic_periodic_accounting_daily_usage	224441244
890	first_login	1727115981
50	traffic_periodic_accounting_daily	364
1051	traffic_periodic_accounting_daily_reset	1734152400
634	traffic_periodic_accounting_daily_reset	1722052800
208	first_login	1731135304
1034	traffic_periodic_accounting_daily_reset	1737172800
254	traffic_periodic_accounting_daily_reset	1734498000
90	traffic_periodic_accounting_daily_usage	224913433
948	traffic_periodic_accounting_daily_reset	1732680000
1091	traffic_periodic_accounting_daily_reset	1734498000
627	traffic_periodic_accounting_daily_usage	244119254
1079	first_login	1732205142
526	traffic_periodic_accounting_daily_usage	1121081551
777	traffic_periodic_accounting_daily_reset	1723176000
431	traffic_periodic_accounting_daily_usage	332267596
535	traffic_periodic_accounting_daily_usage	562477402
408	traffic_periodic_accounting_daily_reset	1736308800
130	traffic_periodic_accounting_daily_limit	20971520000
591	traffic_periodic_accounting_daily_usage	932255206
848	traffic_periodic_accounting_daily_reset	1728705600
542	traffic_periodic_accounting_daily_limit	262144000000
579	traffic_periodic_accounting_daily_limit	157286400000
845	first_login	1723392608
899	traffic_periodic_accounting_daily_reset	1730001600
653	traffic_periodic_accounting_daily_usage	115420780
153	traffic_periodic_accounting_daily_usage	4836110983
204	first_login	1722939658
445	traffic_periodic_accounting_daily_usage	0
953	first_login	1731444207
778	traffic_periodic_accounting_daily_reset	1725768000
807	traffic_periodic_accounting_daily_reset	1737864000
645	traffic_periodic_accounting_daily_reset	1732334400
616	traffic_periodic_accounting_daily_usage	804734076
872	first_login	1725096735
493	traffic_periodic_accounting_daily_usage	123622782
867	traffic_periodic_accounting_daily_reset	1727323200
1031	traffic_periodic_accounting_daily_reset	1734408000
188	traffic_periodic_accounting_daily_reset	1739332800
987	traffic_periodic_accounting_daily_usage	12537159
913	traffic_periodic_accounting_daily_reset	1733630400
994	traffic_periodic_accounting_daily	180
840	first_login	1723281889
1061	traffic_periodic_accounting_daily_reset	1733112000
801	traffic_periodic_accounting_daily_reset	1737604800
112	traffic_periodic_accounting_daily	90
779	traffic_periodic_accounting_daily_reset	1725854400
752	traffic_periodic_accounting_daily_usage	1930301490
128	first_login	1727761085
639	first_login	1717174534
914	first_login	1725959547
638	traffic_periodic_accounting_daily_usage	11506709
886	traffic_periodic_accounting_daily_reset	1726977600
801	abs_exp_date	1737397288
589	traffic_periodic_accounting_daily_reset	1733371200
611	first_login	1716139465
831	traffic_periodic_accounting_daily_reset	1725508800
747	traffic_periodic_accounting_daily_limit	104857600000
1074	traffic_periodic_accounting_daily	90
815	first_login	1722673671
816	traffic_periodic_accounting_daily_usage	67230827
611	traffic_periodic_accounting_daily_reset	1721275200
677	traffic_periodic_accounting_daily_reset	1723003200
278	traffic_periodic_accounting_daily_reset	1734843600
312	traffic_periodic_accounting_daily_usage	9421305894
840	traffic_periodic_accounting_daily_reset	1728446400
516	first_login	1731297727
846	first_login	1723476315
777	traffic_periodic_accounting_daily_usage	1640816082
913	first_login	1728463967
755	traffic_periodic_accounting_daily_usage	972877753
188	first_login	1729021568
743	traffic_periodic_accounting_daily_usage	16288534
524	first_login	1719902368
844	first_login	1723388901
573	traffic_periodic_accounting_daily_usage	5317411
839	first_login	1723221986
611	traffic_periodic_accounting_daily_usage	704770650
158	traffic_periodic_accounting_daily_limit	125829120000
207	traffic_periodic_accounting_daily_usage	10809605
268	traffic_periodic_accounting_daily_usage	11889380039
582	traffic_periodic_accounting_daily_usage	619118973
632	traffic_periodic_accounting_daily_usage	313715831
634	first_login	1716888764
574	traffic_periodic_accounting_daily_usage	14482674
306	traffic_periodic_accounting_daily_usage	30746413728
672	traffic_periodic_accounting_daily_reset	1720152000
672	first_login	1717612104
176	traffic_periodic_accounting_daily_usage	27283392412
309	first_login	1717881617
653	first_login	1717077388
814	traffic_periodic_accounting_daily_usage	9550552819
527	traffic_periodic_accounting_daily_usage	8428589095
735	traffic_periodic_accounting_daily_usage	382819198
867	first_login	1724779746
50	traffic_periodic_accounting_daily_limit	629145600000
920	first_login	1725211908
838	traffic_periodic_accounting_daily	90
663	traffic_periodic_accounting_daily_usage	76296023
833	traffic_periodic_accounting_daily_usage	314834796
777	first_login	1720601396
975	first_login	1727967680
945	traffic_periodic_accounting_daily_reset	1731556800
839	traffic_periodic_accounting_daily_reset	1728360000
760	traffic_periodic_accounting_daily_usage	3805685505
358	traffic_periodic_accounting_daily_reset	1757048400
959	first_login	1726602006
1061	first_login	1730549747
728	traffic_periodic_accounting_daily_usage	752974641
345	traffic_periodic_accounting_daily_usage	11588855024
476	traffic_periodic_accounting_daily_reset	1746590400
922	traffic_periodic_accounting_daily_reset	1727928000
1091	first_login	1731958644
725	traffic_periodic_accounting_daily_reset	1732680000
615	traffic_periodic_accounting_daily_usage	5335743
712	traffic_periodic_accounting_daily_limit	314572800000
1079	traffic_periodic_accounting_daily_usage	191066623
1051	first_login	1731606182
436	traffic_periodic_accounting_daily_usage	47126626667
943	traffic_periodic_accounting_daily_reset	1731384000
894	traffic_periodic_accounting_daily_reset	1732334400
320	traffic_periodic_accounting_daily_reset	1732770000
669	traffic_periodic_accounting_daily_usage	2184805391
696	traffic_periodic_accounting_daily_usage	371609060
907	traffic_periodic_accounting_daily_reset	1727668800
948	first_login	1730101794
269	traffic_periodic_accounting_daily_reset	1734757200
676	first_login	1717779949
697	traffic_periodic_accounting_daily_usage	884985151
899	first_login	1724847840
707	traffic_periodic_accounting_daily_usage	263650212
907	first_login	1725133516
112	traffic_periodic_accounting_daily_reset	1738645200
903	first_login	1725017599
817	traffic_periodic_accounting_daily_reset	1728100800
589	first_login	1730880173
450	traffic_periodic_accounting_daily_reset	1732248000
358	first_login	1717850919
1020	first_login	1729112335
886	first_login	1724398157
314	traffic_periodic_accounting_daily_usage	27265609
989	first_login	1727150110
716	traffic_periodic_accounting_daily_limit	104857600000
994	traffic_periodic_accounting_daily_limit	314572800000
336	traffic_periodic_accounting_daily_reset	1732942800
812	first_login	1722543254
716	first_login	1728534466
817	first_login	1722940707
619	traffic_periodic_accounting_daily_usage	22067535050
822	traffic_periodic_accounting_daily_reset	1725249600
465	traffic_periodic_accounting_daily_usage	7701110059
722	traffic_periodic_accounting_daily_usage	7329235231
341	first_login	1717223619
841	traffic_periodic_accounting_daily_usage	4460672362
1047	first_login	1730710945
912	traffic_periodic_accounting_daily_reset	1728273600
631	traffic_periodic_accounting_daily_usage	21059697572
863	first_login	1723922888
661	traffic_periodic_accounting_daily_usage	40799718
655	traffic_periodic_accounting_daily_usage	459576825
668	traffic_periodic_accounting_daily_usage	16693239
882	abs_exp_date	1724184103
848	first_login	1723556669
853	traffic_periodic_accounting_daily_usage	2500472691
701	traffic_periodic_accounting_daily_usage	77638496
660	traffic_periodic_accounting_daily_usage	10901786
401	first_login	1723407930
748	traffic_periodic_accounting_daily_reset	1727582400
632	traffic_periodic_accounting_daily_reset	1722139200
671	traffic_periodic_accounting_daily_usage	15582663
670	traffic_periodic_accounting_daily_usage	21535928878
361	traffic_periodic_accounting_daily_reset	1723003200
659	traffic_periodic_accounting_daily_usage	107029890
762	traffic_periodic_accounting_daily_reset	1727668800
6	traffic_periodic_accounting_daily_usage	75705642621
677	first_login	1717863495
574	traffic_periodic_accounting_daily_reset	1720238400
39	traffic_periodic_accounting_daily_usage	122220014
633	traffic_periodic_accounting_daily_usage	1358601238
390	traffic_periodic_accounting_daily_usage	312146606
930	traffic_periodic_accounting_daily	174
606	traffic_periodic_accounting_daily_usage	266538814
879	traffic_periodic_accounting_daily_usage	3176562787
400	traffic_periodic_accounting_daily_reset	1733630400
652	traffic_periodic_accounting_daily_reset	1732766400
731	traffic_periodic_accounting_daily_usage	21594730782
912	first_login	1725727951
635	first_login	1716915516
861	traffic_periodic_accounting_daily_usage	20196211
248	traffic_periodic_accounting_daily_reset	1735362000
771	traffic_periodic_accounting_daily_usage	21103273787
1049	traffic_periodic_accounting_daily_reset	1733806800
925	traffic_periodic_accounting_daily_reset	1727928000
822	traffic_periodic_accounting_daily_usage	5010250062
593	traffic_periodic_accounting_daily_usage	36704937
510	traffic_periodic_accounting_daily_reset	1744084800
673	traffic_periodic_accounting_daily_reset	1720411200
673	first_login	1717833409
1063	traffic_periodic_accounting_daily_reset	1733112000
1011	traffic_periodic_accounting_daily_reset	1731556800
481	traffic_periodic_accounting_daily_usage	4742980247
772	traffic_periodic_accounting_daily_usage	374118223
902	traffic_periodic_accounting_daily_reset	1732680000
204	traffic_periodic_accounting_daily_usage	1514667468
870	traffic_periodic_accounting_daily_reset	1730001600
1028	traffic_periodic_accounting_daily_reset	1732334400
700	traffic_periodic_accounting_daily_usage	138123090
132	traffic_periodic_accounting_daily_reset	1738818000
1028	first_login	1729802260
377	traffic_periodic_accounting_daily_usage	6438522345
979	traffic_periodic_accounting_daily_reset	1733889600
801	first_login	1722409806
678	traffic_periodic_accounting_daily_usage	2268618465
947	first_login	1726581374
676	traffic_periodic_accounting_daily_usage	59020303
1019	first_login	1731700001
972	first_login	1726912324
718	traffic_periodic_accounting_daily_reset	1734408000
809	traffic_periodic_accounting_daily_reset	1724990400
847	traffic_periodic_accounting_daily_reset	1728705600
809	first_login	1722421663
894	first_login	1724615462
712	first_login	1726475866
476	first_login	1727594963
1055	traffic_periodic_accounting_daily_reset	1732766400
557	traffic_periodic_accounting_daily_usage	18075094875
757	traffic_periodic_accounting_daily_usage	242766410
1034	first_login	1729447303
807	first_login	1722371235
778	first_login	1720621824
504	traffic_periodic_accounting_daily_reset	1733371200
1074	traffic_periodic_accounting_daily_limit	157286400000
838	traffic_periodic_accounting_daily_limit	62914560000
599	traffic_periodic_accounting_daily_usage	1752010104
916	traffic_periodic_accounting_daily_reset	1731643200
900	traffic_periodic_accounting_daily_reset	1727409600
940	traffic_periodic_accounting_daily_reset	1733716800
940	first_login	1725985268
1012	traffic_periodic_accounting_daily_limit	36700160000
1011	first_login	1728975506
776	traffic_periodic_accounting_daily_usage	563521711
116	traffic_periodic_accounting_daily_limit	10485760000
587	traffic_periodic_accounting_daily	365
537	first_login	1729621902
950	first_login	1726751407
688	first_login	1730024253
730	traffic_periodic_accounting_daily_usage	3339309
739	traffic_periodic_accounting_daily_usage	7496789996
751	traffic_periodic_accounting_daily_usage	3298575
792	traffic_periodic_accounting_daily_usage	418276002
674	traffic_periodic_accounting_daily_usage	21201970531
732	traffic_periodic_accounting_daily_usage	2248870176
588	traffic_periodic_accounting_daily_usage	62316184
593	traffic_periodic_accounting_daily_reset	1726113600
674	traffic_periodic_accounting_daily_reset	1720584000
674	first_login	1718010234
779	traffic_periodic_accounting_daily_usage	334699
878	abs_exp_date	1724780768
760	traffic_periodic_accounting_daily_reset	1722916800
635	traffic_periodic_accounting_daily_usage	35808400
698	traffic_periodic_accounting_daily_reset	1724126400
698	first_login	1718982914
677	traffic_periodic_accounting_daily_usage	19074
698	traffic_periodic_accounting_daily_usage	10898696
635	traffic_periodic_accounting_daily_reset	1722052800
673	traffic_periodic_accounting_daily_usage	1829656748
762	first_login	1719927015
675	traffic_periodic_accounting_daily_usage	180548951
335	traffic_periodic_accounting_daily_reset	1732942800
941	traffic_periodic_accounting_daily_reset	1733716800
522	traffic_periodic_accounting_daily_usage	76212835
818	traffic_periodic_accounting_daily_usage	1080449067
986	traffic_periodic_accounting_daily_reset	1734753600
854	traffic_periodic_accounting_daily_reset	1734325200
471	traffic_periodic_accounting_daily_reset	1735531200
770	traffic_periodic_accounting_daily_usage	2539356
1002	multi_login	6
1094	traffic_periodic_accounting_daily_reset	1734670800
1055	first_login	1730191992
1060	traffic_periodic_accounting_daily_reset	1732939200
154	traffic_periodic_accounting_daily_usage	9038696576
900	first_login	1724864385
778	traffic_periodic_accounting_daily_usage	48061585
587	traffic_periodic_accounting_daily_limit	629145600000
902	first_login	1724917599
909	traffic_periodic_accounting_daily_reset	1727928000
313	traffic_periodic_accounting_daily_reset	1732683600
126	first_login	1727683923
596	traffic_periodic_accounting_daily_reset	1734148800
715	traffic_periodic_accounting_daily_limit	157286400000
628	traffic_periodic_accounting_daily_usage	21606318520
314	traffic_periodic_accounting_daily_reset	1727499600
561	traffic_periodic_accounting_daily_reset	1732420800
773	traffic_periodic_accounting_daily_usage	122593584
909	first_login	1725384514
1058	traffic_periodic_accounting_daily_reset	1732680000
286	traffic_periodic_accounting_daily_reset	1732424400
262	traffic_periodic_accounting_daily_usage	6444858853
729	traffic_periodic_accounting_daily_reset	1727236800
928	traffic_periodic_accounting_daily_reset	1756958400
134	traffic_periodic_accounting_daily_usage	15472647695
310	traffic_periodic_accounting_daily_reset	1732597200
704	traffic_periodic_accounting_daily_usage	409582744
922	first_login	1725370448
809	traffic_periodic_accounting_daily_usage	542401916
1024	traffic_periodic_accounting_daily_reset	1732334400
24	traffic_periodic_accounting_daily_usage	75494424
1063	first_login	1730549797
846	traffic_periodic_accounting_daily_reset	1728619200
925	first_login	1725390097
994	traffic_periodic_accounting_daily_reset	1743048000
1089	traffic_periodic_accounting_daily_reset	1734498000
679	traffic_periodic_accounting_daily_usage	21192135570
875	traffic_periodic_accounting_daily_usage	6426754402
960	traffic_periodic_accounting_daily	167
916	first_login	1726503668
994	first_login	1727549227
579	traffic_periodic_accounting_daily_reset	1737864000
1015	traffic_periodic_accounting_daily	90
951	traffic_periodic_accounting_daily_reset	1729310400
181	traffic_periodic_accounting_daily_reset	1739250000
951	first_login	1726767620
845	traffic_periodic_accounting_daily_usage	1616305694
282	traffic_periodic_accounting_daily_usage	54579895970
380	traffic_periodic_accounting_daily_usage	97119846
753	traffic_periodic_accounting_daily_usage	117121427
707	traffic_periodic_accounting_daily	180
660	traffic_periodic_accounting_daily_reset	1722484800
301	traffic_periodic_accounting_daily_usage	1391713717
850	abs_exp_date	1738221138
366	traffic_periodic_accounting_daily_usage	92118698367
850	traffic_periodic_accounting_daily	174
869	first_login	1724782875
734	traffic_periodic_accounting_daily_usage	4390954
695	traffic_periodic_accounting_daily_usage	23462817
736	traffic_periodic_accounting_daily_reset	1722225600
736	first_login	1719683572
771	traffic_periodic_accounting_daily_reset	1723262400
771	first_login	1720716134
812	traffic_periodic_accounting_daily_usage	2583510132
773	traffic_periodic_accounting_daily_reset	1723003200
773	first_login	1720459779
553	traffic_periodic_accounting_daily_usage	2901281358
607	traffic_periodic_accounting_daily_usage	5450746316
806	traffic_periodic_accounting_daily	180
108	traffic_periodic_accounting_daily_reset	1730782800
736	traffic_periodic_accounting_daily_usage	515740906
581	traffic_periodic_accounting_daily_usage	1817646451
737	traffic_periodic_accounting_daily_usage	3186863
806	traffic_periodic_accounting_daily_limit	22020096000
413	traffic_periodic_accounting_daily_usage	10593471956
822	first_login	1722662608
760	first_login	1720354243
468	traffic_periodic_accounting_daily_reset	1727755200
468	first_login	1720267961
998	traffic_periodic_accounting_daily_reset	1743220800
112	traffic_periodic_accounting_daily_limit	125829120000
584	traffic_periodic_accounting_daily_reset	1735617600
1025	first_login	1729782704
846	traffic_periodic_accounting_daily_usage	46623702
724	traffic_periodic_accounting_daily_reset	1734753600
1058	first_login	1730118111
1057	traffic_periodic_accounting_daily_reset	1732593600
524	traffic_periodic_accounting_daily_limit	157286400000
887	traffic_periodic_accounting_daily_reset	1732161600
513	traffic_periodic_accounting_daily_reset	1733803200
721	traffic_periodic_accounting_daily	90
831	first_login	1722962846
280	traffic_periodic_accounting_daily_reset	1734843600
316	traffic_periodic_accounting_daily_usage	6629597786
842	traffic_periodic_accounting_daily_usage	232903623
988	traffic_periodic_accounting_daily_reset	1734926400
781	traffic_periodic_accounting_daily_usage	33223108
1045	traffic_periodic_accounting_daily_reset	1733112000
154	traffic_periodic_accounting_daily_reset	1728795600
637	traffic_periodic_accounting_daily_reset	1732507200
1074	traffic_periodic_accounting_daily_reset	1738818000
113	traffic_periodic_accounting_daily_reset	1730869200
983	traffic_periodic_accounting_daily_reset	1739851200
1037	traffic_periodic_accounting_daily_reset	1734840000
562	traffic_periodic_accounting_daily_limit	209715200000
1051	traffic_periodic_accounting_daily_usage	1233071282
1015	traffic_periodic_accounting_daily_limit	62914560000
520	traffic_periodic_accounting_daily_reset	1737086400
930	traffic_periodic_accounting_daily_reset	1740974400
1037	first_login	1729706218
930	traffic_periodic_accounting_daily_limit	262144000000
980	first_login	1729000122
509	traffic_periodic_accounting_daily_usage	10802481929
1046	traffic_periodic_accounting_daily_reset	1732766400
477	traffic_periodic_accounting_daily_usage	887194635
815	traffic_periodic_accounting_daily_usage	12973469
364	first_login	1730308661
322	traffic_periodic_accounting_daily_reset	1732856400
1045	first_login	1730571647
1049	first_login	1731256185
1021	first_login	1729530506
775	traffic_periodic_accounting_daily_usage	220742500
872	traffic_periodic_accounting_daily_usage	1688558235
750	traffic_periodic_accounting_daily_usage	128608413
729	traffic_periodic_accounting_daily_usage	793990450
1075	traffic_periodic_accounting_daily_reset	1733979600
1060	first_login	1730390273
992	traffic_periodic_accounting_daily	90
765	traffic_periodic_accounting_daily_usage	1869566645
951	traffic_periodic_accounting_daily_usage	1151007867
419	traffic_periodic_accounting_daily_reset	1733889600
787	traffic_periodic_accounting_daily_reset	1734148800
50	traffic_periodic_accounting_daily_reset	1775106000
730	traffic_periodic_accounting_daily_reset	1724644800
1024	first_login	1729768106
1035	traffic_periodic_accounting_daily_reset	1737259200
747	multi_login	3
396	traffic_periodic_accounting_daily_usage	166368092
854	first_login	1731773676
1032	first_login	1729342777
1078	traffic_periodic_accounting_daily_reset	1734670800
188	traffic_periodic_accounting_daily_limit	209715200000
950	traffic_periodic_accounting_daily_usage	45049276
1022	traffic_periodic_accounting_daily_reset	1734753600
1033	traffic_periodic_accounting_daily_reset	1734667200
311	traffic_periodic_accounting_daily_reset	1729832400
1033	first_login	1729517993
311	first_login	1727364575
542	traffic_periodic_accounting_daily_reset	1776657600
946	traffic_periodic_accounting_daily_reset	1731643200
762	traffic_periodic_accounting_daily_usage	21773643368
645	traffic_periodic_accounting_daily_usage	122883630
682	traffic_periodic_accounting_daily_usage	104899584460
782	traffic_periodic_accounting_daily_usage	9204121947
1071	traffic_periodic_accounting_daily_reset	1738472400
847	traffic_periodic_accounting_daily_usage	27907615
204	traffic_periodic_accounting_daily_reset	1726462800
928	first_login	1725441315
870	first_login	1724856098
865	traffic_periodic_accounting_daily_usage	5258443233
258	traffic_periodic_accounting_daily_usage	4700921363
613	traffic_periodic_accounting_daily_usage	536339861
93	traffic_periodic_accounting_daily_usage	81587809478
707	traffic_periodic_accounting_daily_limit	209715200000
248	first_login	1723038190
998	first_login	1727719634
959	traffic_periodic_accounting_daily_usage	197788521
311	traffic_periodic_accounting_daily_usage	1740851622
128	traffic_periodic_accounting_daily_usage	666433675
1046	first_login	1730195474
575	traffic_periodic_accounting_daily_reset	1730606400
406	traffic_periodic_accounting_daily_reset	1740801600
946	first_login	1726517215
1012	traffic_periodic_accounting_daily_reset	1736308800
747	traffic_periodic_accounting_daily_usage	36577819739
836	traffic_periodic_accounting_daily_reset	1728446400
130	traffic_periodic_accounting_daily_reset	1733634000
1071	first_login	1730738219
1010	traffic_periodic_accounting_daily_usage	17429250
1063	traffic_periodic_accounting_daily_usage	3145220038
1040	traffic_periodic_accounting_daily_usage	1231475433
340	traffic_periodic_accounting_daily_usage	1337244844
161	traffic_periodic_accounting_daily_usage	3793607485
1077	traffic_periodic_accounting_daily_reset	1734498000
1002	first_login	1730711234
520	first_login	1728845193
276	traffic_periodic_accounting_daily_reset	1734843600
903	traffic_periodic_accounting_daily_reset	1730174400
652	traffic_periodic_accounting_daily_usage	161115068
512	traffic_periodic_accounting_daily_reset	1733803200
974	traffic_periodic_accounting_daily_reset	1735617600
531	first_login	1732171808
988	first_login	1727204860
1067	traffic_periodic_accounting_daily_reset	1733202000
1074	first_login	1731090117
118	traffic_periodic_accounting_daily_usage	1531936598
1057	first_login	1730021200
929	traffic_periodic_accounting_daily_usage	172963119
916	traffic_periodic_accounting_daily_usage	147395545
992	traffic_periodic_accounting_daily_limit	104857600000
50	first_login	1725654870
1036	traffic_periodic_accounting_daily	28
808	traffic_periodic_accounting_daily_usage	815380345
323	traffic_periodic_accounting_daily_usage	249191779
170	traffic_periodic_accounting_daily_usage	87995759
866	traffic_periodic_accounting_daily_usage	742756442
1040	traffic_periodic_accounting_daily_reset	1732334400
1035	first_login	1729523700
1088	traffic_periodic_accounting_daily_usage	4751438090
1092	traffic_periodic_accounting_daily_reset	1734584400
349	traffic_periodic_accounting_daily_usage	379965161
1064	traffic_periodic_accounting_daily_reset	1733202000
765	traffic_periodic_accounting_daily_reset	1735531200
646	first_login	1727789339
1075	first_login	1731436167
1029	traffic_periodic_accounting_daily_usage	1307100284
1057	traffic_periodic_accounting_daily_usage	30656994952
319	traffic_periodic_accounting_daily_reset	1732770000
871	traffic_periodic_accounting_daily_usage	54792204
804	traffic_periodic_accounting_daily_usage	432172982
816	first_login	1722866827
787	traffic_periodic_accounting_daily_usage	20461137
471	traffic_periodic_accounting_daily	90
910	traffic_periodic_accounting_daily_usage	1028045647
868	traffic_periodic_accounting_daily_usage	64225284
565	traffic_periodic_accounting_daily_usage	22718927396
316	traffic_periodic_accounting_daily_reset	1730091600
505	traffic_periodic_accounting_daily_usage	3259391219
928	traffic_periodic_accounting_daily_usage	36045562839
1094	first_login	1732087461
1093	traffic_periodic_accounting_daily_reset	1734670800
692	traffic_periodic_accounting_daily_usage	3491823803
1093	first_login	1732085079
813	traffic_periodic_accounting_daily_usage	75782834
189	traffic_periodic_accounting_daily_usage	7607214512
709	traffic_periodic_accounting_daily_usage	332489079
254	first_login	1732035684
719	traffic_periodic_accounting_daily_reset	1734580800
813	first_login	1722765281
869	traffic_periodic_accounting_daily_usage	144117166
1078	first_login	1732118309
1005	traffic_periodic_accounting_daily_usage	170556368
409	traffic_periodic_accounting_daily_usage	244163229
978	first_login	1728496612
878	traffic_periodic_accounting_daily_usage	1156705427
802	traffic_periodic_accounting_daily_usage	237818865
836	first_login	1723316892
847	first_login	1723542188
860	traffic_periodic_accounting_daily_reset	1726027200
860	first_login	1723520554
866	traffic_periodic_accounting_daily_reset	1726718400
866	first_login	1724166648
1094	traffic_periodic_accounting_daily_usage	42753866
1089	first_login	1731922163
1064	first_login	1730653227
850	traffic_periodic_accounting_daily_limit	209715200000
829	traffic_periodic_accounting_daily_reset	1733025600
829	first_login	1722890930
524	traffic_periodic_accounting_daily	180
275	first_login	1732023481
844	traffic_periodic_accounting_daily_usage	91919618
831	traffic_periodic_accounting_daily_usage	3230180257
688	traffic_periodic_accounting_daily_usage	83569400
572	traffic_periodic_accounting_daily_usage	739608361
667	traffic_periodic_accounting_daily_usage	25297047058
283	traffic_periodic_accounting_daily_reset	1740027600
820	first_login	1722959780
1069	abs_exp_date	1744426140
820	traffic_periodic_accounting_daily_usage	39548373
1036	traffic_periodic_accounting_daily_limit	83886080000
1036	first_login	1729607873
1077	traffic_periodic_accounting_daily_usage	30622546
1021	traffic_periodic_accounting_daily_reset	1734667200
848	traffic_periodic_accounting_daily_usage	38843636
113	traffic_periodic_accounting_daily_usage	117163867
1038	traffic_periodic_accounting_daily_reset	1734840000
894	traffic_periodic_accounting_daily_usage	3176631180
247	traffic_periodic_accounting_daily_usage	4529174
886	traffic_periodic_accounting_daily_usage	37082951
127	traffic_periodic_accounting_daily_usage	2462309739
1077	first_login	1731924349
286	traffic_periodic_accounting_daily_usage	32999726386
420	traffic_periodic_accounting_daily_reset	1733976000
917	traffic_periodic_accounting_daily_usage	6741957599
274	traffic_periodic_accounting_daily_reset	1734757200
190	traffic_periodic_accounting_daily_usage	4652102900
210	traffic_periodic_accounting_daily_usage	1252447388
912	traffic_periodic_accounting_daily_usage	2098599377
978	traffic_periodic_accounting_daily_usage	11439832
880	traffic_periodic_accounting_daily_usage	123762705
947	traffic_periodic_accounting_daily_usage	32724816
353	traffic_periodic_accounting_daily_reset	1733202000
429	traffic_periodic_accounting_daily_reset	1734062400
84	traffic_periodic_accounting_daily_usage	436236881
30	traffic_periodic_accounting_daily_reset	1733288400
972	traffic_periodic_accounting_daily_usage	24317215
558	traffic_periodic_accounting_daily_usage	2631847178
863	traffic_periodic_accounting_daily_usage	257926786
960	abs_exp_date	1741040174
746	first_login	1723200899
959	traffic_periodic_accounting_daily_reset	1731729600
748	traffic_periodic_accounting_daily_usage	40581632
870	traffic_periodic_accounting_daily_usage	278117349
188	traffic_periodic_accounting_daily	120
433	traffic_periodic_accounting_daily	90
429	traffic_periodic_accounting_daily_usage	10062858731
901	traffic_periodic_accounting_daily_usage	7160493476
1008	traffic_periodic_accounting_daily_usage	5652766
313	first_login	1730982810
728	traffic_periodic_accounting_daily_reset	1732248000
209	first_login	1731135816
900	traffic_periodic_accounting_daily_usage	3861213740
891	traffic_periodic_accounting_daily_usage	78240636
961	first_login	1729853119
1040	first_login	1730393782
840	traffic_periodic_accounting_daily_usage	2801391
915	traffic_periodic_accounting_daily_usage	1451097991
1067	first_login	1730641356
715	first_login	1726995721
1045	traffic_periodic_accounting_daily_usage	69308215
907	traffic_periodic_accounting_daily_usage	945759025
954	traffic_periodic_accounting_daily_usage	15890465246
897	traffic_periodic_accounting_daily_usage	11036161789
471	traffic_periodic_accounting_daily_limit	104857600000
530	traffic_periodic_accounting_daily_usage	11071688136
648	traffic_periodic_accounting_daily_usage	2644769245
1050	traffic_periodic_accounting_daily_reset	1733893200
765	first_login	1728556575
650	traffic_periodic_accounting_daily_usage	5097753
5	traffic_periodic_accounting_daily_reset	1736481600
685	traffic_periodic_accounting_daily_usage	6807194390
925	traffic_periodic_accounting_daily_usage	66685196
897	traffic_periodic_accounting_daily_reset	1727323200
897	first_login	1724780323
468	traffic_periodic_accounting_daily_usage	2661740697
819	traffic_periodic_accounting_daily_usage	4017263414
901	traffic_periodic_accounting_daily_reset	1727409600
901	first_login	1724871414
1012	first_login	1728570513
903	traffic_periodic_accounting_daily_usage	694240596
839	traffic_periodic_accounting_daily_usage	126558040
575	traffic_periodic_accounting_daily_usage	147259600
727	traffic_periodic_accounting_daily_usage	383224753
975	traffic_periodic_accounting_daily_usage	1700781345
1021	traffic_periodic_accounting_daily_usage	72158873
837	traffic_periodic_accounting_daily_reset	1733457600
278	traffic_periodic_accounting_daily_usage	12696733
725	traffic_periodic_accounting_daily_usage	548369839
911	traffic_periodic_accounting_daily_usage	0
937	traffic_periodic_accounting_daily_usage	316793403
786	traffic_periodic_accounting_daily_usage	3358344503
662	traffic_periodic_accounting_daily_usage	2930721610
689	traffic_periodic_accounting_daily_usage	946843087
341	traffic_periodic_accounting_daily_usage	45174798384
589	traffic_periodic_accounting_daily_usage	2786706353
997	traffic_periodic_accounting_daily_usage	17150634769
537	traffic_periodic_accounting_daily_usage	3265506259
990	traffic_periodic_accounting_daily_usage	18290158503
336	traffic_periodic_accounting_daily_usage	4650163207
45	traffic_periodic_accounting_daily_usage	137395253938
945	traffic_periodic_accounting_daily_usage	9719747
558	traffic_periodic_accounting_daily_reset	1729828800
637	traffic_periodic_accounting_daily_usage	1036892208
689	traffic_periodic_accounting_daily_reset	1733457600
717	traffic_periodic_accounting_daily_usage	1423027725
986	traffic_periodic_accounting_daily_usage	59549454
647	traffic_periodic_accounting_daily_usage	88211372658
991	traffic_periodic_accounting_daily_usage	13610302182
528	traffic_periodic_accounting_daily_reset	1734321600
1050	first_login	1731342891
936	traffic_periodic_accounting_daily_usage	1867775745
781	traffic_periodic_accounting_daily_reset	1735963200
322	traffic_periodic_accounting_daily_usage	12080353621
317	traffic_periodic_accounting_daily_usage	87041419608
820	traffic_periodic_accounting_daily_reset	1728100800
960	traffic_periodic_accounting_daily_limit	36700160000
769	traffic_periodic_accounting_daily_usage	8130060717
961	traffic_periodic_accounting_daily_usage	2183260807
925	abs_exp_date	1725475998
130	traffic_periodic_accounting_daily_usage	11551135019
909	traffic_periodic_accounting_daily_usage	3035245594
864	traffic_periodic_accounting_daily_usage	208962076
974	traffic_periodic_accounting_daily_usage	298608575
979	traffic_periodic_accounting_daily_usage	57095662
768	traffic_periodic_accounting_daily_usage	164635146
790	traffic_periodic_accounting_daily_usage	1597652871
1008	traffic_periodic_accounting_daily_reset	1733544000
340	traffic_periodic_accounting_daily_reset	1733029200
1002	traffic_periodic_accounting_daily_usage	3228248870
1025	traffic_periodic_accounting_daily_usage	1595157770
981	traffic_periodic_accounting_daily_usage	102727530
817	traffic_periodic_accounting_daily_usage	84433441
869	traffic_periodic_accounting_daily_reset	1729915200
721	traffic_periodic_accounting_daily_limit	209715200000
741	traffic_periodic_accounting_daily_usage	102152180100
116	traffic_periodic_accounting_daily_usage	1029132789
908	traffic_periodic_accounting_daily_usage	20603826
910	traffic_periodic_accounting_daily_reset	1728014400
795	traffic_periodic_accounting_daily_usage	14826973288
1023	traffic_periodic_accounting_daily_usage	21568322633
30	traffic_periodic_accounting_daily_usage	18897098645
203	traffic_periodic_accounting_daily_usage	3345633568
288	traffic_periodic_accounting_daily_usage	144992289349
1044	traffic_periodic_accounting_daily_usage	3241892257
318	traffic_periodic_accounting_daily_usage	84196700337
910	first_login	1725463858
974	first_login	1727877165
1008	first_login	1728399724
1015	traffic_periodic_accounting_daily_reset	1736481600
1015	first_login	1728758002
263	traffic_periodic_accounting_daily_usage	11614594457
917	traffic_periodic_accounting_daily_reset	1729137600
566	traffic_periodic_accounting_daily_reset	1732593600
917	first_login	1726589335
826	traffic_periodic_accounting_daily_reset	1733198400
766	traffic_periodic_accounting_daily_usage	595313379
954	traffic_periodic_accounting_daily_reset	1728792000
954	first_login	1726262766
746	traffic_periodic_accounting_daily_usage	252291602
595	traffic_periodic_accounting_daily_usage	11664407457
566	traffic_periodic_accounting_daily_usage	3334313751
1066	traffic_periodic_accounting_daily_usage	12712917300
1035	traffic_periodic_accounting_daily_usage	1966129541
902	traffic_periodic_accounting_daily_usage	10443799474
887	traffic_periodic_accounting_daily_usage	135000504
562	first_login	1730230288
719	traffic_periodic_accounting_daily_usage	20580179
1048	traffic_periodic_accounting_daily_usage	1012843140
742	traffic_periodic_accounting_daily_usage	6694835949
1016	traffic_periodic_accounting_daily_usage	298341415
112	traffic_periodic_accounting_daily_usage	9192387403
364	traffic_periodic_accounting_daily_usage	86784829
989	traffic_periodic_accounting_daily_usage	1159414422
275	traffic_periodic_accounting_daily_usage	402147402
881	traffic_periodic_accounting_daily_usage	92439095
836	traffic_periodic_accounting_daily_usage	181883486
786	first_login	1728992799
1009	traffic_periodic_accounting_daily_usage	89561291
1068	traffic_periodic_accounting_daily_reset	1733202000
1068	first_login	1730657785
1092	traffic_periodic_accounting_daily_usage	1839454658
563	traffic_periodic_accounting_daily_usage	7307827201
208	traffic_periodic_accounting_daily_usage	8257988045
430	traffic_periodic_accounting_daily_usage	4171293550
1095	traffic_periodic_accounting_daily_usage	2354381598
50	traffic_periodic_accounting_daily_usage	19871845742
946	traffic_periodic_accounting_daily_usage	216857657
450	first_login	1728311848
1037	traffic_periodic_accounting_daily_usage	720141419
419	traffic_periodic_accounting_daily_usage	2902682756
830	traffic_periodic_accounting_daily_usage	114547064501
602	traffic_periodic_accounting_daily_usage	7881589896
520	traffic_periodic_accounting_daily	96
520	traffic_periodic_accounting_daily_limit	136314880000
513	traffic_periodic_accounting_daily_usage	8044889393
983	traffic_periodic_accounting_daily_usage	1931615307
558	first_login	1727788715
1096	traffic_periodic_accounting_daily_usage	545406641
974	traffic_periodic_accounting_daily	60
391	traffic_periodic_accounting_daily_usage	25651841247
120	traffic_periodic_accounting_daily_usage	2555244777
420	traffic_periodic_accounting_daily_usage	515570619
350	traffic_periodic_accounting_daily_usage	2460787372
943	traffic_periodic_accounting_daily_usage	119991881
825	traffic_periodic_accounting_daily_usage	10871608019
458	traffic_periodic_accounting_daily_usage	17608028774
1069	traffic_periodic_accounting_daily_reset	1746680400
279	traffic_periodic_accounting_daily_reset	1734843600
40	traffic_periodic_accounting_daily_usage	110775278911
1050	traffic_periodic_accounting_daily_usage	205025351
269	traffic_periodic_accounting_daily_usage	33682355278
62	traffic_periodic_accounting_daily_usage	15534486089
881	traffic_periodic_accounting_daily_reset	1729224000
974	traffic_periodic_accounting_daily_limit	41943040000
914	traffic_periodic_accounting_daily_usage	339523339
973	traffic_periodic_accounting_daily_usage	3620354640
313	traffic_periodic_accounting_daily_usage	36135482259
579	first_login	1728026167
610	traffic_periodic_accounting_daily_usage	165628389
584	traffic_periodic_accounting_daily_usage	1330602136
476	traffic_periodic_accounting_daily_usage	13249116551
980	traffic_periodic_accounting_daily_usage	55478563
252	traffic_periodic_accounting_daily_usage	1959061165
127	first_login	1727682051
126	traffic_periodic_accounting_daily_usage	1282741941
1069	traffic_periodic_accounting_daily_usage	346263179
1055	traffic_periodic_accounting_daily_usage	21924532
922	traffic_periodic_accounting_daily_usage	782435787
973	traffic_periodic_accounting_daily_reset	1730174400
973	first_login	1727630298
801	traffic_periodic_accounting_daily_usage	6361968042
1007	traffic_periodic_accounting_daily_usage	128941147
350	first_login	1729947883
322	first_login	1730571683
524	traffic_periodic_accounting_daily_reset	1742702400
932	traffic_periodic_accounting_daily_reset	1733457600
132	first_login	1729932116
406	first_login	1728392763
899	traffic_periodic_accounting_daily_usage	42076552
84	traffic_periodic_accounting_daily_reset	1730865600
1009	traffic_periodic_accounting_daily_reset	1730952000
1009	first_login	1728399961
826	traffic_periodic_accounting_daily_usage	13343102394
441	traffic_periodic_accounting_daily_reset	1734494400
999	traffic_periodic_accounting_daily_usage	83214706206
274	traffic_periodic_accounting_daily_usage	177892495
944	traffic_periodic_accounting_daily_usage	1299918577
1015	traffic_periodic_accounting_daily_usage	12572088343
976	traffic_periodic_accounting_daily_usage	1541668157
1089	traffic_periodic_accounting_daily_usage	528732735
1024	traffic_periodic_accounting_daily_usage	1782927388
1039	abs_exp_date	1732945295
1060	traffic_periodic_accounting_daily_usage	36709288785
277	traffic_periodic_accounting_daily_usage	10921075
1032	traffic_periodic_accounting_daily_usage	444325257
344	traffic_periodic_accounting_daily_usage	76449207074
471	traffic_periodic_accounting_daily_usage	27954392337
649	traffic_periodic_accounting_daily_usage	3148754343
516	traffic_periodic_accounting_daily_usage	7383634789
1012	traffic_periodic_accounting_daily_usage	145521142
724	traffic_periodic_accounting_daily_usage	142211272
993	traffic_periodic_accounting_daily_usage	37044761820
197	traffic_periodic_accounting_daily_usage	37764915416
209	traffic_periodic_accounting_daily_usage	1673095003
276	traffic_periodic_accounting_daily_usage	40975632
408	traffic_periodic_accounting_daily_usage	7589036074
715	traffic_periodic_accounting_daily_usage	1156993713
1022	traffic_periodic_accounting_daily_usage	65107375
854	traffic_periodic_accounting_daily_usage	432986823
823	traffic_periodic_accounting_daily_usage	3874511888
1019	traffic_periodic_accounting_daily_usage	4706937289
630	traffic_periodic_accounting_daily_reset	1732334400
504	traffic_periodic_accounting_daily_usage	3198403161
999	traffic_periodic_accounting_daily_reset	1743220800
999	first_login	1727720318
1091	traffic_periodic_accounting_daily_usage	2231627905
353	traffic_periodic_accounting_daily_usage	7062757755
590	traffic_periodic_accounting_daily_reset	1733716800
76	traffic_periodic_accounting_daily_usage	9917580633
988	traffic_periodic_accounting_daily_usage	2697903309
829	traffic_periodic_accounting_daily_usage	51150426837
960	traffic_periodic_accounting_daily_usage	284902788
1033	traffic_periodic_accounting_daily_usage	375005514
941	traffic_periodic_accounting_daily_usage	30339526277
742	traffic_periodic_accounting_daily_reset	1732420800
936	traffic_periodic_accounting_daily_reset	1733544000
590	traffic_periodic_accounting_daily_usage	1789265915
992	traffic_periodic_accounting_daily_usage	484469446
713	traffic_periodic_accounting_daily_usage	3791530302
713	traffic_periodic_accounting_daily_reset	1732507200
320	traffic_periodic_accounting_daily_usage	6056601151
1034	traffic_periodic_accounting_daily_usage	50833060216
450	traffic_periodic_accounting_daily_usage	19222565858
712	traffic_periodic_accounting_daily_usage	40886614924
198	traffic_periodic_accounting_daily_usage	2504616876
349	first_login	1729934282
1049	traffic_periodic_accounting_daily_usage	816973037
838	first_login	1728564404
438	traffic_periodic_accounting_daily_usage	92027578282
726	traffic_periodic_accounting_daily_usage	8707788986
913	traffic_periodic_accounting_daily_usage	229430655
920	traffic_periodic_accounting_daily_usage	43503509161
1092	first_login	1732033973
1069	first_login	1731178719
1067	traffic_periodic_accounting_daily_usage	905025250
997	first_login	1730232744
401	traffic_periodic_accounting_daily_usage	7566293659
1095	traffic_periodic_accounting_daily_reset	1734757200
248	traffic_periodic_accounting_daily_usage	48184279930
423	traffic_periodic_accounting_daily_usage	22720664432
976	traffic_periodic_accounting_daily_reset	1734498000
976	first_login	1731987144
584	traffic_periodic_accounting_daily	60
584	traffic_periodic_accounting_daily_limit	52428800000
717	traffic_periodic_accounting_daily_reset	1734321600
350	traffic_periodic_accounting_daily_reset	1733288400
561	traffic_periodic_accounting_daily_usage	1994575362
995	traffic_periodic_accounting_daily_reset	1732766400
981	first_login	1729087373
1048	traffic_periodic_accounting_daily_reset	1733288400
1048	first_login	1730730826
716	traffic_periodic_accounting_daily_reset	1736827200
990	traffic_periodic_accounting_daily_reset	1732334400
187	traffic_periodic_accounting_daily_usage	139938325443
1020	traffic_periodic_accounting_daily_usage	21406587220
995	traffic_periodic_accounting_daily_usage	4076570939
1001	traffic_periodic_accounting_daily_reset	1732852800
538	traffic_periodic_accounting_daily_usage	70122531
807	traffic_periodic_accounting_daily_usage	95720478632
132	traffic_periodic_accounting_daily_usage	541989358
995	first_login	1730284861
542	traffic_periodic_accounting_daily_usage	32124497673
1058	traffic_periodic_accounting_daily_usage	13469888823
630	traffic_periodic_accounting_daily_usage	1249287297
579	traffic_periodic_accounting_daily_usage	21595340414
411	traffic_periodic_accounting_daily_usage	12116685548
358	traffic_periodic_accounting_daily_usage	29106549551
147	traffic_periodic_accounting_daily_usage	27099583505
400	traffic_periodic_accounting_daily_usage	11521901166
506	traffic_periodic_accounting_daily_usage	194272366967
1027	traffic_periodic_accounting_daily_usage	1197844647
629	traffic_periodic_accounting_daily_usage	7232299790
804	traffic_periodic_accounting_daily_reset	1732680000
1026	traffic_periodic_accounting_daily_reset	1732334400
1026	first_login	1729782960
804	first_login	1730196468
994	traffic_periodic_accounting_daily_usage	52332746920
404	traffic_periodic_accounting_daily_usage	9880024408
271	traffic_periodic_accounting_daily_usage	193080901
1042	traffic_periodic_accounting_daily_usage	1273203360
5	traffic_periodic_accounting_daily_usage	165379866
880	first_login	1729935144
956	traffic_periodic_accounting_daily_reset	1734062400
1028	traffic_periodic_accounting_daily_usage	87638952
1038	first_login	1729711093
795	traffic_periodic_accounting_daily_reset	1737518400
1017	traffic_periodic_accounting_daily_reset	1760500800
1017	first_login	1729024009
1047	traffic_periodic_accounting_daily_usage	829188695
1027	traffic_periodic_accounting_daily_reset	1732334400
1027	first_login	1729783195
890	traffic_periodic_accounting_daily_usage	22034808
662	traffic_periodic_accounting_daily_reset	1730347200
906	traffic_periodic_accounting_daily_usage	23757668412
412	traffic_periodic_accounting_daily_usage	2805072595
77	traffic_periodic_accounting_daily_usage	91787383789
353	first_login	1730746963
874	traffic_periodic_accounting_daily_usage	2828414514
309	traffic_periodic_accounting_daily_usage	11498032832
1064	traffic_periodic_accounting_daily_usage	9623876881
528	traffic_periodic_accounting_daily_usage	5359432
1017	traffic_periodic_accounting_daily_usage	40342826734
47	traffic_periodic_accounting_daily_usage	318806970931
1095	first_login	1732173028
1026	traffic_periodic_accounting_daily_usage	520555297
280	traffic_periodic_accounting_daily_usage	68276924
998	traffic_periodic_accounting_daily_usage	31381326112
1	traffic_periodic_accounting_daily_usage	34542352165
718	traffic_periodic_accounting_daily_usage	428525464
524	traffic_periodic_accounting_daily_usage	29108010137
283	traffic_periodic_accounting_daily_usage	190229992
403	traffic_periodic_accounting_daily_usage	245882203255
1078	traffic_periodic_accounting_daily_usage	247291638
410	traffic_periodic_accounting_daily_usage	67778766028
1031	traffic_periodic_accounting_daily_usage	2524888166
270	traffic_periodic_accounting_daily_usage	514419279
716	traffic_periodic_accounting_daily_usage	8629273388
433	traffic_periodic_accounting_daily_usage	52033495704
956	traffic_periodic_accounting_daily_usage	11487860778
587	traffic_periodic_accounting_daily_usage	9963043207
103	traffic_periodic_accounting_daily_usage	14482285803
1061	traffic_periodic_accounting_daily_usage	31565509311
441	traffic_periodic_accounting_daily_usage	8117730830
531	traffic_periodic_accounting_daily_usage	125718433899
181	traffic_periodic_accounting_daily_usage	5441655019
59	traffic_periodic_accounting_daily_usage	36326198438
1036	traffic_periodic_accounting_daily_usage	874483605
335	traffic_periodic_accounting_daily_usage	5776113410
953	traffic_periodic_accounting_daily_usage	8893500854
835	traffic_periodic_accounting_daily_usage	120127832183
948	traffic_periodic_accounting_daily_usage	3214256080
949	traffic_periodic_accounting_daily_usage	706502148
44	traffic_periodic_accounting_daily_usage	172832840941
357	traffic_periodic_accounting_daily_reset	1733288400
357	traffic_periodic_accounting_daily_usage	885458578
307	traffic_periodic_accounting_daily_usage	102270233674
949	traffic_periodic_accounting_daily_reset	1732766400
949	first_login	1730196636
930	traffic_periodic_accounting_daily_usage	33050749113
1071	traffic_periodic_accounting_daily_usage	32695486584
646	traffic_periodic_accounting_daily_usage	4070857126
1036	traffic_periodic_accounting_daily_reset	1734408000
319	traffic_periodic_accounting_daily_usage	27134243963
1093	traffic_periodic_accounting_daily_usage	17284446
472	traffic_periodic_accounting_daily_usage	1526242424
1046	traffic_periodic_accounting_daily_usage	8228546342
940	traffic_periodic_accounting_daily_usage	94856340526
512	traffic_periodic_accounting_daily_usage	24760830376
348	traffic_periodic_accounting_daily_usage	14235204677
520	traffic_periodic_accounting_daily_usage	37958951460
1074	traffic_periodic_accounting_daily_usage	5294411764
406	traffic_periodic_accounting_daily_usage	15193384804
158	traffic_periodic_accounting_daily_usage	2181300411
837	traffic_periodic_accounting_daily_usage	14555488526
254	traffic_periodic_accounting_daily_usage	8307741811
580	traffic_periodic_accounting_daily_usage	97225301599
108	traffic_periodic_accounting_daily_usage	18417437100
721	traffic_periodic_accounting_daily_usage	2308528579
596	traffic_periodic_accounting_daily_usage	5602184177
827	traffic_periodic_accounting_daily_usage	6456538123
850	traffic_periodic_accounting_daily_usage	29694056487
838	traffic_periodic_accounting_daily_usage	7186886824
932	traffic_periodic_accounting_daily_usage	2500386535
958	traffic_periodic_accounting_daily_usage	3170044127
321	traffic_periodic_accounting_daily_usage	31728252356
1038	traffic_periodic_accounting_daily_usage	247389658
1001	traffic_periodic_accounting_daily_usage	24122783467
157	traffic_periodic_accounting_daily_usage	85060775129
310	traffic_periodic_accounting_daily_usage	7938810014
1075	traffic_periodic_accounting_daily_usage	30385326499
348	first_login	1730737173
188	traffic_periodic_accounting_daily_usage	63735067018
405	traffic_periodic_accounting_daily_usage	33147649474
510	traffic_periodic_accounting_daily_usage	24613380156
279	traffic_periodic_accounting_daily_usage	133385100
1068	traffic_periodic_accounting_daily_usage	24792141288
562	traffic_periodic_accounting_daily_usage	18035244819
394	traffic_periodic_accounting_daily_usage	6809070062
564	traffic_periodic_accounting_daily_usage	16527563600
257	traffic_periodic_accounting_daily_usage	234802934
\.


--
-- Data for Name: user_audit_log; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY user_audit_log (user_audit_log, admin_id, is_user, object_id, attr_name, old_value, new_value, change_time) FROM stdin;
1	0	f	1	rel_exp_date	_NOVALUE_	1 Months	2024-02-08 12:05:44.221064
2	0	f	1	multi_login	_NOVALUE_	2	2024-02-08 12:05:56.668326
3	0	f	1	traffic_periodic_accounting_daily	_NOVALUE_	30	2024-02-08 12:06:21.812401
4	0	f	1	traffic_periodic_accounting_daily_limit	_NOVALUE_	10000M	2024-02-08 12:06:21.812401
5	0	f	1	normal_charge	_NOVALUE_	Normal	2024-02-08 12:06:37.002056
6	0	t	1	normal_username	_NOVALUE_	aria	2024-02-08 12:07:35.260865
7	0	f	2	rel_exp_date	_NOVALUE_	1 Months	2024-02-08 12:09:07.701929
8	0	f	2	multi_login	_NOVALUE_	2	2024-02-08 12:09:22.495793
9	0	f	2	traffic_periodic_accounting_daily	_NOVALUE_	30	2024-02-08 12:09:53.686635
10	0	f	2	traffic_periodic_accounting_daily_limit	_NOVALUE_	20000M	2024-02-08 12:09:53.686635
11	0	f	2	normal_charge	_NOVALUE_	Normal	2024-02-08 12:10:10.399724
12	0	f	3	rel_exp_date	_NOVALUE_	1 Months	2024-02-08 12:11:05.779445
13	0	f	3	traffic_periodic_accounting_daily	_NOVALUE_	30	2024-02-08 12:11:20.783558
14	0	f	3	traffic_periodic_accounting_daily_limit	_NOVALUE_	35000M	2024-02-08 12:11:20.783558
15	0	f	3	normal_charge	_NOVALUE_	Normal	2024-02-08 12:11:35.296876
16	0	f	3	multi_login	_NOVALUE_	2	2024-02-08 12:12:11.930217
17	0	f	4	normal_charge	_NOVALUE_	Normal	2024-02-08 12:13:46.612804
18	0	f	4	rel_exp_date	_NOVALUE_	1 Months	2024-02-08 12:14:02.410224
19	0	f	4	multi_login	_NOVALUE_	2	2024-02-08 12:14:15.370713
20	0	f	4	traffic_periodic_accounting_daily	_NOVALUE_	30	2024-02-08 12:16:22.351707
21	0	f	4	traffic_periodic_accounting_daily_limit	_NOVALUE_	50000M	2024-02-08 12:16:22.351707
22	0	f	5	normal_charge	_NOVALUE_	Normal	2024-02-08 12:17:31.315305
23	0	f	5	rel_exp_date	_NOVALUE_	1 Months	2024-02-08 12:17:50.908198
24	0	f	5	multi_login	_NOVALUE_	2	2024-02-08 12:18:08.044049
25	0	f	5	traffic_periodic_accounting_daily	_NOVALUE_	30	2024-02-08 12:18:23.630936
26	0	f	5	traffic_periodic_accounting_daily_limit	_NOVALUE_	70000M	2024-02-08 12:18:23.630936
27	0	f	6	normal_charge	_NOVALUE_	Normal	2024-02-08 12:28:15.406395
28	0	f	6	rel_exp_date	_NOVALUE_	1 Months	2024-02-08 12:28:29.284549
29	0	f	6	multi_login	_NOVALUE_	2	2024-02-08 12:28:42.273846
30	0	f	6	traffic_periodic_accounting_daily	_NOVALUE_	30	2024-02-08 12:30:08.016886
31	0	f	6	traffic_periodic_accounting_daily_limit	_NOVALUE_	100000M	2024-02-08 12:30:08.016886
32	0	f	7	rel_exp_date	_NOVALUE_	1 Months	2024-02-08 12:31:12.295015
33	0	f	7	rel_exp_date	1 Months	2 Months	2024-02-08 12:31:21.53047
34	0	f	7	multi_login	_NOVALUE_	2	2024-02-08 12:31:33.660333
35	0	f	7	traffic_periodic_accounting_daily	_NOVALUE_	60	2024-02-08 12:31:52.020739
36	0	f	7	traffic_periodic_accounting_daily_limit	_NOVALUE_	70000M	2024-02-08 12:31:52.020739
37	0	f	7	normal_charge	_NOVALUE_	Normal	2024-02-08 12:32:03.800452
38	0	f	8	normal_charge	_NOVALUE_	Normal	2024-02-08 12:32:26.452592
39	0	f	8	rel_exp_date	_NOVALUE_	3 Months	2024-02-08 12:32:41.424304
40	0	f	8	multi_login	_NOVALUE_	2	2024-02-08 12:32:52.834326
41	0	f	8	traffic_periodic_accounting_daily	_NOVALUE_	90	2024-02-08 12:33:11.761735
42	0	f	8	traffic_periodic_accounting_daily_limit	_NOVALUE_	150000M	2024-02-08 12:33:11.761735
43	0	f	9	normal_charge	_NOVALUE_	Normal	2024-02-08 12:34:15.775568
44	0	f	9	rel_exp_date	_NOVALUE_	3 Months	2024-02-08 12:34:31.19912
45	0	f	9	multi_login	_NOVALUE_	2	2024-02-08 12:34:42.620719
46	0	f	9	traffic_periodic_accounting_daily	_NOVALUE_	90	2024-02-08 12:34:58.311481
47	0	f	9	traffic_periodic_accounting_daily_limit	_NOVALUE_	250000M	2024-02-08 12:34:58.311481
48	0	f	10	normal_charge	_NOVALUE_	Normal	2024-02-08 12:35:29.33204
49	0	f	10	rel_exp_date	_NOVALUE_	6 Months	2024-02-08 12:35:45.988807
50	0	f	10	multi_login	_NOVALUE_	2	2024-02-08 12:35:57.853354
51	0	f	10	traffic_periodic_accounting_daily	_NOVALUE_	180	2024-02-08 12:36:13.600589
52	0	f	10	traffic_periodic_accounting_daily_limit	_NOVALUE_	300000M	2024-02-08 12:36:13.600589
53	0	f	11	normal_charge	_NOVALUE_	Normal	2024-02-08 12:36:54.432154
54	0	f	11	rel_exp_date	_NOVALUE_	6 Months	2024-02-08 12:37:05.724619
55	0	f	11	multi_login	_NOVALUE_	2	2024-02-08 12:37:19.365477
56	0	f	11	traffic_periodic_accounting_daily	_NOVALUE_	180	2024-02-08 12:37:34.182758
57	0	f	11	traffic_periodic_accounting_daily_limit	_NOVALUE_	450000M	2024-02-08 12:37:34.182758
58	0	f	12	normal_charge	_NOVALUE_	Normal	2024-02-08 12:38:33.115078
59	0	f	12	rel_exp_date	_NOVALUE_	12 Months	2024-02-08 12:38:51.069041
60	0	f	12	multi_login	_NOVALUE_	2	2024-02-08 12:39:02.3147
61	0	f	12	traffic_periodic_accounting_daily	_NOVALUE_	365	2024-02-08 12:39:17.214023
62	0	f	12	traffic_periodic_accounting_daily_limit	_NOVALUE_	600000M	2024-02-08 12:39:17.214023
63	0	f	13	normal_charge	_NOVALUE_	Normal	2024-02-08 12:39:51.990447
64	0	f	13	rel_exp_date	_NOVALUE_	365 Days	2024-02-08 12:40:21.819589
65	0	f	13	multi_login	_NOVALUE_	2	2024-02-08 12:40:40.338981
66	0	f	13	traffic_periodic_accounting_daily	_NOVALUE_	365	2024-02-08 12:41:02.24745
67	0	f	13	traffic_periodic_accounting_daily_limit	_NOVALUE_	800000M	2024-02-08 12:41:02.24745
669	0	t	390	normal_username	_NOVALUE_	peji	2024-03-11 15:23:37.530976
670	0	t	391	normal_username	_NOVALUE_	soltan	2024-03-11 15:28:39.395494
70	0	t	3	normal_username	_NOVALUE_	behnam2	2024-02-08 12:47:02.794409
71	0	t	3	abs_exp_date	_NOVALUE_	2024-02-14 12:47	2024-02-08 12:47:14.895839
72	0	t	4	normal_username	_NOVALUE_	behnam4	2024-02-08 12:50:20.952542
73	0	t	5	normal_username	_NOVALUE_	hesari	2024-02-08 13:00:48.971956
74	0	t	5	abs_exp_date	_NOVALUE_	2024-02-15 13:01	2024-02-08 13:01:04.435044
75	0	t	6	normal_username	_NOVALUE_	afi	2024-02-08 13:05:58.259133
76	0	t	6	abs_exp_date	_NOVALUE_	2024-02-08 13:45	2024-02-08 13:06:08.032185
77	0	t	5	abs_exp_date	2024-02-15 13:01	2024-04-15 14:13	2024-02-08 13:13:11.181177
78	0	t	5	group	1-Month-20G	3-Month-150G	2024-02-08 13:13:29.567487
79	0	t	5	traffic_periodic_accounting_daily	90	67	2024-02-08 13:13:53.582873
80	0	t	5	traffic_periodic_accounting_daily_limit	150000M	100000M	2024-02-08 13:13:53.582873
81	0	t	7	normal_username	_NOVALUE_	maral	2024-02-08 13:15:53.380334
82	0	t	7	abs_exp_date	_NOVALUE_	2024-02-23 13:16	2024-02-08 13:16:09.035863
598	0	t	321	normal_username	_NOVALUE_	madah	2024-03-03 14:31:58.269637
460	0	t	200	normal_username	_NOVALUE_	sadri	2024-02-19 04:45:02.553421
90	0	t	13	normal_username	_NOVALUE_	msm72	2024-02-08 13:31:51.545202
95	0	t	16	abs_exp_date	_NOVALUE_	2024-02-22 13:36	2024-02-08 13:36:28.021132
545	0	t	279	normal_username	_NOVALUE_	noor	2024-02-26 05:04:01.339519
105	0	t	21	abs_exp_date	_NOVALUE_	2024-03-05 13:52	2024-02-08 13:52:59.557775
108	0	t	23	normal_username	_NOVALUE_	noor	2024-02-08 13:56:32.168688
546	0	t	280	normal_username	_NOVALUE_	mashaal1	2024-02-26 09:26:22.769733
294	0	t	103	normal_username	_NOVALUE_	roghayeh	2024-02-09 05:24:10.805804
295	0	t	103	abs_exp_date	_NOVALUE_	2024-04-15 06:24	2024-02-09 05:24:26.702268
299	0	t	104	abs_exp_date	_NOVALUE_	2024-02-23 05:32	2024-02-09 05:32:33.455976
616	0	t	340	normal_username	_NOVALUE_	mostafa103	2024-03-06 08:57:38.450701
308	0	t	109	normal_username	_NOVALUE_	elnaz	2024-02-09 15:09:38.173297
312	0	t	111	normal_username	_NOVALUE_	dastanpoor	2024-02-10 05:05:22.032044
321	0	t	6	abs_exp_date	2024-02-08 13:45	2024-03-19 09:04	2024-02-10 08:04:54.463771
327	0	t	115	abs_exp_date	_NOVALUE_	2024-03-05 10:33	2024-02-10 10:33:12.934462
328	0	t	116	normal_username	_NOVALUE_	daftar10	2024-02-10 11:52:29.960883
332	0	t	118	normal_username	_NOVALUE_	daftar	2024-02-10 11:55:17.946923
1856	0	t	128	multi_login	2	3	2024-07-20 05:33:09.44551
336	0	t	120	normal_username	_NOVALUE_	aliasghar	2024-02-11 08:00:58.120126
339	0	t	122	normal_username	_NOVALUE_	farhadi1000	2024-02-11 18:06:27.657885
345	0	t	126	abs_exp_date	_NOVALUE_	2024-03-20 02:56	2024-02-12 01:56:49.690664
348	0	t	127	normal_username	_NOVALUE_	khhosseini2	2024-02-12 02:00:53.378853
349	0	t	127	traffic_periodic_accounting_daily	60	37	2024-02-12 02:03:09.378987
350	0	t	127	traffic_periodic_accounting_daily_limit	70000M	25000M	2024-02-12 02:03:09.378987
357	0	t	130	normal_username	_NOVALUE_	daftartehran	2024-02-12 03:53:21.132833
358	0	t	130	group	3-Month-150G	2-Month-70G	2024-02-12 03:53:40.778041
359	0	t	131	normal_username	_NOVALUE_	gorjian3	2024-02-12 03:57:34.604875
361	0	t	132	normal_username	_NOVALUE_	chtalaee	2024-02-12 04:03:50.984524
374	0	t	146	normal_username	_NOVALUE_	msm48	2024-02-12 12:46:37.268122
375	0	t	146	abs_exp_date	_NOVALUE_	2024-02-26 12:46	2024-02-12 12:46:58.149203
378	0	t	148	normal_username	_NOVALUE_	torkamandi	2024-02-12 16:07:37.993086
379	0	t	148	abs_exp_date	_NOVALUE_	2024-03-09 16:08	2024-02-12 16:08:31.029851
382	0	t	150	normal_username	_NOVALUE_	banisadr	2024-02-13 04:53:42.016061
383	0	t	150	abs_exp_date	_NOVALUE_	2024-06-21 05:53	2024-02-13 04:53:52.15244
384	0	t	150	traffic_periodic_accounting_daily	180	129	2024-02-13 04:54:07.029638
385	0	t	150	traffic_periodic_accounting_daily_limit	300000M	200000M	2024-02-13 04:54:07.029638
386	0	t	151	normal_username	_NOVALUE_	fjafari	2024-02-13 13:34:58.254128
704	0	t	410	normal_username	_NOVALUE_	ashkan	2024-03-15 05:41:25.34235
392	0	t	155	normal_username	_NOVALUE_	aryo1	2024-02-13 17:27:29.082817
712	0	t	415	normal_username	_NOVALUE_	zomorod	2024-03-16 13:09:24.958905
716	0	t	419	normal_username	_NOVALUE_	barati	2024-03-16 16:32:13.938136
398	0	t	158	normal_username	_NOVALUE_	goldoost	2024-02-14 05:44:14.440589
748	0	t	208	first_login	2024-02-19 15:58	_NOVALUE_	2024-03-20 04:33:20.192654
407	0	t	164	multi_login	2	1	2024-02-15 05:19:06.062278
754	0	t	254	first_login	2024-02-22 07:59	_NOVALUE_	2024-03-22 11:47:08.249655
414	0	t	170	normal_username	_NOVALUE_	rahimi	2024-02-16 04:55:44.359455
415	0	t	171	normal_username	_NOVALUE_	bagheri	2024-02-16 16:20:03.048773
733	0	t	200	first_login	2024-02-19 04:45	_NOVALUE_	2024-03-19 05:03:08.000712
418	0	t	177	normal_username	_NOVALUE_	askari	2024-02-17 04:15:53.851813
419	0	t	178	normal_username	_NOVALUE_	shooshtari	2024-02-17 05:03:19.592473
420	0	t	178	abs_exp_date	_NOVALUE_	2024-03-15 06:03	2024-02-17 05:03:43.388668
422	0	t	179	abs_exp_date	_NOVALUE_	2024-04-25 08:32	2024-02-17 07:32:04.076236
427	0	t	182	normal_username	_NOVALUE_	sahar1	2024-02-17 08:36:31.886454
432	0	t	184	normal_username	_NOVALUE_	fa8	2024-02-17 08:41:22.326108
433	0	t	184	abs_exp_date	_NOVALUE_	2024-03-09 08:43	2024-02-17 08:43:06.189463
690	0	t	400	normal_username	_NOVALUE_	tkeyhan	2024-03-13 13:42:36.270549
440	0	t	187	normal_username	_NOVALUE_	navab	2024-02-17 14:08:27.559598
442	0	t	189	normal_username	_NOVALUE_	boss	2024-02-18 07:15:29.464861
449	0	t	195	normal_username	_NOVALUE_	sepideh	2024-02-18 14:24:24.280047
450	0	t	195	abs_exp_date	_NOVALUE_	2024-04-03 15:24	2024-02-18 14:24:38.322384
451	0	t	195	traffic_periodic_accounting_daily	60	45	2024-02-18 14:24:58.567875
452	0	t	195	traffic_periodic_accounting_daily_limit	70000M	60000M	2024-02-18 14:24:58.567875
674	0	t	395	normal_username	_NOVALUE_	nhasibi2	2024-03-12 05:42:25.127418
455	0	t	197	normal_username	_NOVALUE_	tofighi	2024-02-18 16:59:23.96424
461	0	t	201	normal_username	_NOVALUE_	fatemeh40	2024-02-19 04:46:51.863664
463	0	t	201	traffic_periodic_accounting_daily	90	70	2024-02-19 04:47:22.901725
464	0	t	201	traffic_periodic_accounting_daily_limit	150000M	90000M	2024-02-19 04:47:22.901725
466	0	t	203	normal_username	_NOVALUE_	abolfazl2	2024-02-19 08:17:11.426915
467	0	t	204	normal_username	_NOVALUE_	hamidr	2024-02-19 09:31:21.687021
738	0	t	436	normal_username	_NOVALUE_	m38	2024-03-19 13:29:07.416691
474	0	t	207	normal_username	_NOVALUE_	zalipc	2024-02-19 15:14:40.765087
477	0	t	210	normal_username	_NOVALUE_	karbasi3	2024-02-19 15:44:05.269955
478	0	t	211	normal_username	_NOVALUE_	parisa	2024-02-19 15:56:51.027643
480	0	t	212	normal_username	_NOVALUE_	nazanin2	2024-02-19 17:30:04.71564
481	0	t	212	abs_exp_date	_NOVALUE_	2024-03-17 18:33	2024-02-19 17:33:29.965699
547	0	t	281	normal_username	_NOVALUE_	vahideh	2024-02-26 09:37:02.950676
549	0	t	282	abs_exp_date	_NOVALUE_	2024-05-19 14:19	2024-02-26 13:19:38.493843
551	0	t	284	normal_username	_NOVALUE_	kazemipc	2024-02-27 13:26:18.745533
486	0	t	217	normal_username	_NOVALUE_	bama14	2024-02-20 12:12:55.928717
487	0	t	218	normal_username	_NOVALUE_	bama15	2024-02-20 12:12:55.928717
617	0	t	341	normal_username	_NOVALUE_	aghakhani2	2024-03-06 10:57:41.794156
641	0	t	361	normal_username	_NOVALUE_	peyghambari	2024-03-10 06:46:56.124827
91	0	t	13	abs_exp_date	_NOVALUE_	2024-02-25 13:32	2024-02-08 13:32:07.383816
92	0	t	15	normal_username	_NOVALUE_	msm26	2024-02-08 13:33:34.342071
94	0	t	16	normal_username	_NOVALUE_	msm36	2024-02-08 13:36:15.383602
548	0	t	282	normal_username	_NOVALUE_	parsa	2024-02-26 13:19:21.280774
99	0	t	18	abs_exp_date	_NOVALUE_	2024-02-28 13:39	2024-02-08 13:39:38.459314
102	0	t	20	normal_username	_NOVALUE_	msm37	2024-02-08 13:43:35.667836
106	0	t	22	normal_username	_NOVALUE_	ghafari20	2024-02-08 13:53:55.182427
552	0	t	285	normal_username	_NOVALUE_	saryazdi	2024-02-27 13:57:45.549518
296	0	t	103	traffic_periodic_accounting_daily	90	66	2024-02-09 05:25:36.1714
297	0	t	103	traffic_periodic_accounting_daily_limit	150000M	100000M	2024-02-09 05:25:36.1714
618	0	t	341	abs_exp_date	_NOVALUE_	2024-06-01 11:57	2024-03-06 10:57:58.321975
304	0	t	107	normal_username	_NOVALUE_	mahsa96	2024-02-09 06:07:46.404843
306	0	t	5	multi_login	2	1	2024-02-09 06:33:36.683844
307	0	t	108	normal_username	_NOVALUE_	cheraghi	2024-02-09 11:19:12.401579
309	0	t	109	abs_exp_date	_NOVALUE_	2024-04-03 16:09	2024-02-09 15:09:50.909875
310	0	t	110	normal_username	_NOVALUE_	mahroo	2024-02-09 15:21:37.358114
311	0	t	110	abs_exp_date	_NOVALUE_	2024-02-11 15:21	2024-02-09 15:21:50.168982
313	0	t	111	abs_exp_date	_NOVALUE_	2024-03-01 05:05	2024-02-10 05:05:36.772074
314	0	t	112	normal_username	_NOVALUE_	reza	2024-02-10 05:25:04.5191
315	0	t	112	multi_login	2	12	2024-02-10 05:25:24.031034
316	0	t	112	abs_exp_date	_NOVALUE_	2024-04-30 06:29	2024-02-10 05:29:31.898946
317	0	t	112	abs_exp_date	2024-04-30 06:29	2024-04-28 06:29	2024-02-10 05:29:51.632864
318	0	t	77	multi_login	2	2	2024-02-10 06:33:40.035777
320	0	t	113	normal_username	_NOVALUE_	ati	2024-02-10 07:47:25.95415
324	0	t	114	traffic_periodic_accounting_daily	60	45	2024-02-10 09:26:05.389124
325	0	t	114	traffic_periodic_accounting_daily_limit	70000M	50000M	2024-02-10 09:26:05.389124
326	0	t	115	normal_username	_NOVALUE_	javadi	2024-02-10 10:33:05.079484
330	0	t	116	traffic_periodic_accounting_daily	90	90	2024-02-10 11:54:53.0415
331	0	t	116	traffic_periodic_accounting_daily_limit	150000M	40000M	2024-02-10 11:54:53.0415
337	0	t	121	normal_username	_NOVALUE_	mcb	2024-02-11 15:35:23.73136
343	0	t	125	normal_username	_NOVALUE_	khhosseine	2024-02-12 01:55:20.358409
351	0	t	128	normal_username	_NOVALUE_	sabzineh	2024-02-12 03:19:52.239109
353	0	t	128	traffic_periodic_accounting_daily	60	39	2024-02-12 03:20:14.936297
354	0	t	128	traffic_periodic_accounting_daily_limit	70000M	50000M	2024-02-12 03:20:14.936297
362	0	t	134	normal_username	_NOVALUE_	bama2000	2024-02-12 05:12:08.092914
363	0	t	135	normal_username	_NOVALUE_	bama2001	2024-02-12 05:12:08.092914
364	0	t	136	normal_username	_NOVALUE_	bama2002	2024-02-12 05:12:08.092914
365	0	t	137	normal_username	_NOVALUE_	bama2003	2024-02-12 05:12:08.092914
366	0	t	138	normal_username	_NOVALUE_	bama2004	2024-02-12 05:12:08.092914
367	0	t	139	normal_username	_NOVALUE_	bama2005	2024-02-12 05:12:08.092914
368	0	t	140	normal_username	_NOVALUE_	bama2006	2024-02-12 05:12:08.092914
369	0	t	141	normal_username	_NOVALUE_	bama2007	2024-02-12 05:12:08.092914
370	0	t	142	normal_username	_NOVALUE_	bama2008	2024-02-12 05:12:08.092914
371	0	t	143	normal_username	_NOVALUE_	bama2009	2024-02-12 05:12:08.092914
372	0	t	132	multi_login	2	3	2024-02-12 05:23:41.573522
574	0	t	309	normal_username	_NOVALUE_	navid39	2024-03-01 08:25:57.442269
576	0	t	311	normal_username	_NOVALUE_	sarikhan2	2024-03-01 09:14:20.025536
388	0	t	153	normal_username	_NOVALUE_	hosniyeh	2024-02-13 15:48:12.054701
713	0	t	416	normal_username	_NOVALUE_	babaei	2024-03-16 13:11:37.205619
714	0	t	417	normal_username	_NOVALUE_	farzaneh	2024-03-16 15:15:34.709789
399	0	t	159	normal_username	_NOVALUE_	barati	2024-02-14 14:30:35.691628
405	0	t	164	normal_username	_NOVALUE_	sina	2024-02-15 04:26:34.020631
410	0	t	166	normal_username	_NOVALUE_	barati	2024-02-15 12:56:40.896016
412	0	t	168	normal_username	_NOVALUE_	mahla	2024-02-15 17:13:46.942836
417	0	t	176	normal_username	_NOVALUE_	kami	2024-02-17 01:01:32.189586
421	0	t	179	normal_username	_NOVALUE_	farzan1	2024-02-17 07:31:49.875377
423	0	t	179	traffic_periodic_accounting_daily	90	68	2024-02-17 07:34:47.693363
424	0	t	179	traffic_periodic_accounting_daily_limit	150000M	120000M	2024-02-17 07:34:47.693363
425	0	t	180	normal_username	_NOVALUE_	bargh	2024-02-17 08:26:09.547022
429	0	t	183	abs_exp_date	_NOVALUE_	2024-04-25 09:37	2024-02-17 08:37:45.876075
439	0	t	26	abs_exp_date	2024-02-16 14:06	2024-03-03 13:54	2024-02-17 13:54:02.917149
441	0	t	188	normal_username	_NOVALUE_	saghayi2	2024-02-17 14:12:03.677116
443	0	t	190	normal_username	_NOVALUE_	kami2	2024-02-18 07:54:30.216481
445	0	t	191	abs_exp_date	_NOVALUE_	2024-02-22 09:14	2024-02-18 09:14:09.851598
446	0	t	192	normal_username	_NOVALUE_	setayesh	2024-02-18 11:18:30.393143
447	0	t	192	abs_exp_date	_NOVALUE_	2024-03-10 12:18	2024-02-18 11:18:50.146051
675	0	t	395	group	1-Month-20G	2-Month-70G	2024-03-12 05:42:43.357135
456	0	t	198	normal_username	_NOVALUE_	shaghayegh	2024-02-18 17:01:12.623665
601	0	t	324	normal_username	_NOVALUE_	bama2030	2024-03-05 05:01:32.451994
462	0	t	201	abs_exp_date	_NOVALUE_	2024-04-29 05:47	2024-02-19 04:47:04.630602
619	0	t	342	normal_username	_NOVALUE_	salimian57	2024-03-06 14:02:35.221227
623	0	t	345	normal_username	_NOVALUE_	ghafari10	2024-03-06 23:53:57.409466
734	0	t	432	normal_username	_NOVALUE_	deniz	2024-03-19 05:04:52.037484
475	0	t	208	normal_username	_NOVALUE_	karbasi1	2024-02-19 15:41:29.729267
476	0	t	209	normal_username	_NOVALUE_	karbasi2	2024-02-19 15:43:23.498913
479	0	t	211	abs_exp_date	_NOVALUE_	2024-02-23 15:57	2024-02-19 15:57:05.515591
482	0	t	213	normal_username	_NOVALUE_	maziyarpc	2024-02-20 02:18:50.864681
488	0	t	219	normal_username	_NOVALUE_	bama16	2024-02-20 12:12:55.928717
489	0	t	220	normal_username	_NOVALUE_	bama17	2024-02-20 12:12:55.928717
490	0	t	221	normal_username	_NOVALUE_	bama18	2024-02-20 12:12:55.928717
620	0	t	342	abs_exp_date	_NOVALUE_	2024-05-02 15:02	2024-03-06 14:02:51.513203
599	0	t	322	normal_username	_NOVALUE_	sajad	2024-03-04 04:32:36.460015
465	0	t	202	normal_username	_NOVALUE_	daftarforoosh	2024-02-19 07:24:41.162736
93	0	t	15	abs_exp_date	_NOVALUE_	2024-02-21 13:33	2024-02-08 13:33:50.690007
98	0	t	18	normal_username	_NOVALUE_	msm67	2024-02-08 13:38:54.546263
550	0	t	283	normal_username	_NOVALUE_	mona	2024-02-26 15:04:43.730854
553	0	t	286	normal_username	_NOVALUE_	saljooghi	2024-02-28 06:53:22.117664
103	0	t	20	abs_exp_date	_NOVALUE_	2024-02-23 13:43	2024-02-08 13:43:50.959278
104	0	t	21	normal_username	_NOVALUE_	ghafari10	2024-02-08 13:52:47.433513
107	0	t	22	abs_exp_date	_NOVALUE_	2024-02-29 13:54	2024-02-08 13:54:09.441144
109	0	t	23	abs_exp_date	_NOVALUE_	2024-02-28 13:57	2024-02-08 13:57:01.568304
110	0	t	24	normal_username	_NOVALUE_	seyfi	2024-02-08 13:58:52.83192
111	0	t	25	normal_username	_NOVALUE_	golnaz	2024-02-08 14:00:59.594531
112	0	t	26	normal_username	_NOVALUE_	keyhan5	2024-02-08 14:06:20.190285
113	0	t	26	abs_exp_date	_NOVALUE_	2024-02-16 14:06	2024-02-08 14:06:32.025128
635	0	t	356	normal_username	_NOVALUE_	saharh	2024-03-09 03:40:52.411208
637	0	t	358	normal_username	_NOVALUE_	torkamandi	2024-03-09 12:32:45.620588
691	0	t	401	normal_username	_NOVALUE_	talkhabloo1	2024-03-13 14:41:44.632181
117	0	t	28	normal_username	_NOVALUE_	mostafa102	2024-02-08 14:10:34.49873
118	0	t	28	abs_exp_date	_NOVALUE_	2024-03-01 14:10	2024-02-08 14:10:55.905452
556	0	t	289	normal_username	_NOVALUE_	bama2020	2024-02-28 16:33:16.423524
557	0	t	290	normal_username	_NOVALUE_	bama2021	2024-02-28 16:33:16.423524
121	0	t	30	normal_username	_NOVALUE_	mostafa	2024-02-08 14:17:51.558141
122	0	t	30	abs_exp_date	_NOVALUE_	2024-03-01 14:18	2024-02-08 14:18:07.178985
123	0	t	31	normal_username	_NOVALUE_	mostafa100	2024-02-08 14:21:03.466684
124	0	t	31	abs_exp_date	_NOVALUE_	2024-02-24 14:23	2024-02-08 14:23:06.254775
400	0	t	160	normal_username	_NOVALUE_	sheyda77	2024-02-14 14:57:00.248193
406	0	t	164	group	1-Month-50G	1-Month-20G	2024-02-15 05:18:25.206143
127	0	t	33	normal_username	_NOVALUE_	jafari07	2024-02-08 14:31:53.796825
128	0	t	33	abs_exp_date	_NOVALUE_	2024-04-10 15:32	2024-02-08 14:32:16.288501
129	0	t	33	traffic_periodic_accounting_daily	90	62	2024-02-08 14:32:39.92498
130	0	t	33	traffic_periodic_accounting_daily_limit	150000M	100000M	2024-02-08 14:32:39.92498
715	0	t	418	normal_username	_NOVALUE_	padideh	2024-03-16 15:17:29.248111
132	0	t	35	normal_username	_NOVALUE_	barati	2024-02-08 14:36:22.132072
133	0	t	35	abs_exp_date	_NOVALUE_	2024-02-13 14:36	2024-02-08 14:36:36.289752
134	0	t	36	normal_username	_NOVALUE_	farhad13	2024-02-08 14:39:51.617356
135	0	t	36	abs_exp_date	_NOVALUE_	2024-02-25 14:40	2024-02-08 14:40:35.404839
136	0	t	37	normal_username	_NOVALUE_	sadri	2024-02-08 14:59:30.891999
137	0	t	37	abs_exp_date	_NOVALUE_	2024-02-18 15:00	2024-02-08 15:00:09.980545
719	0	t	420	normal_username	_NOVALUE_	daftar11	2024-03-17 10:35:18.576865
140	0	t	39	normal_username	_NOVALUE_	sania	2024-02-08 15:02:29.521922
141	0	t	39	abs_exp_date	_NOVALUE_	2024-03-07 15:03	2024-02-08 15:03:06.768293
142	0	t	40	normal_username	_NOVALUE_	mehdi	2024-02-08 15:07:25.685396
143	0	t	40	abs_exp_date	_NOVALUE_	2025-01-29 15:07	2024-02-08 15:07:49.089065
144	0	t	40	traffic_periodic_accounting_daily	365	356	2024-02-08 15:08:14.560964
145	0	t	40	traffic_periodic_accounting_daily_limit	800000M	700000M	2024-02-08 15:08:14.560964
146	0	t	41	normal_username	_NOVALUE_	parastoo	2024-02-08 15:13:10.425036
147	0	t	41	abs_exp_date	_NOVALUE_	2024-02-24 15:13	2024-02-08 15:13:22.656752
148	0	t	42	normal_username	_NOVALUE_	tofighi	2024-02-08 15:14:39.326856
149	0	t	42	abs_exp_date	_NOVALUE_	2024-02-17 15:15	2024-02-08 15:15:10.884742
152	0	t	44	normal_username	_NOVALUE_	saber	2024-02-08 15:21:34.41694
153	0	t	44	abs_exp_date	_NOVALUE_	2025-01-24 15:22	2024-02-08 15:22:15.523858
154	0	t	45	normal_username	_NOVALUE_	yaser	2024-02-08 15:23:50.571373
155	0	t	45	abs_exp_date	_NOVALUE_	2025-01-24 15:24	2024-02-08 15:24:05.08973
156	0	t	45	traffic_periodic_accounting_daily	365	351	2024-02-08 15:24:45.42303
157	0	t	45	traffic_periodic_accounting_daily_limit	800000M	760000M	2024-02-08 15:24:45.42303
158	0	t	46	normal_username	_NOVALUE_	marjan	2024-02-08 15:25:57.612344
159	0	t	46	abs_exp_date	_NOVALUE_	2025-01-28 15:26	2024-02-08 15:26:10.615472
160	0	t	47	normal_username	_NOVALUE_	jalal	2024-02-08 15:26:44.744469
161	0	t	47	abs_exp_date	_NOVALUE_	2025-01-28 15:26	2024-02-08 15:26:59.353635
162	0	t	48	normal_username	_NOVALUE_	bagheri	2024-02-08 15:39:08.893004
163	0	t	48	abs_exp_date	_NOVALUE_	2024-02-16 15:39	2024-02-08 15:39:22.142014
164	0	t	49	normal_username	_NOVALUE_	danial	2024-02-08 15:45:43.471422
165	0	t	49	abs_exp_date	_NOVALUE_	2024-03-18 16:45	2024-02-08 15:45:56.799209
166	0	t	49	abs_exp_date	2024-03-18 16:45	2024-03-18 16:46	2024-02-08 15:46:10.854706
167	0	t	50	normal_username	_NOVALUE_	amin45	2024-02-08 15:48:47.748923
168	0	t	50	abs_exp_date	_NOVALUE_	2024-09-05 16:48	2024-02-08 15:48:59.425968
169	0	t	50	traffic_periodic_accounting_daily	365	210	2024-02-08 15:49:33.95373
170	0	t	50	traffic_periodic_accounting_daily_limit	600000M	450000M	2024-02-08 15:49:33.95373
602	0	t	325	normal_username	_NOVALUE_	bama2031	2024-03-05 05:01:32.451994
603	0	t	326	normal_username	_NOVALUE_	bama2032	2024-03-05 05:01:32.451994
173	0	t	52	normal_username	_NOVALUE_	mohammad90	2024-02-08 16:05:24.803859
174	0	t	52	abs_exp_date	_NOVALUE_	2024-04-20 17:05	2024-02-08 16:05:41.947793
175	0	t	52	traffic_periodic_accounting_daily	90	72	2024-02-08 16:06:18.51288
176	0	t	52	traffic_periodic_accounting_daily_limit	150000M	120000M	2024-02-08 16:06:18.51288
177	0	t	53	normal_username	_NOVALUE_	sarikhan1	2024-02-08 16:08:08.960433
178	0	t	53	abs_exp_date	_NOVALUE_	2024-02-29 16:09	2024-02-08 16:09:11.203922
179	0	t	54	normal_username	_NOVALUE_	sarikhan2	2024-02-08 16:09:59.185775
624	0	t	347	normal_username	_NOVALUE_	ghafari20	2024-03-06 23:55:31.706128
626	0	t	345	group	1-Month-50G	1-Month-35G	2024-03-06 23:56:36.807994
627	0	t	348	normal_username	_NOVALUE_	farnaz	2024-03-07 00:12:16.841554
180	0	t	54	abs_exp_date	_NOVALUE_	2024-02-08 16:33	2024-02-08 16:10:12.463076
187	0	t	57	abs_exp_date	_NOVALUE_	2024-02-29 16:29	2024-02-08 16:29:08.662407
191	0	t	59	abs_exp_date	_NOVALUE_	2024-03-18 17:39	2024-02-08 16:39:07.758495
206	0	t	65	abs_exp_date	_NOVALUE_	2024-03-19 18:08	2024-02-08 17:08:45.982842
1577	0	t	713	normal_username	_NOVALUE_	jafari07	2024-06-17 05:38:41.361479
1578	0	t	713	abs_exp_date	_NOVALUE_	2024-07-08 05:39	2024-06-17 05:39:12.56679
211	0	t	68	normal_username	_NOVALUE_	kiana	2024-02-08 17:15:48.02966
218	0	t	70	normal_username	_NOVALUE_	mirkazemi	2024-02-08 17:32:17.673864
219	0	t	70	abs_exp_date	_NOVALUE_	2024-04-13 18:32	2024-02-08 17:32:35.553822
586	0	t	313	normal_username	_NOVALUE_	mostafa105	2024-03-02 05:32:50.943928
227	0	t	74	normal_username	_NOVALUE_	setareh14	2024-02-08 17:44:36.058949
231	0	t	75	traffic_periodic_accounting_daily	90	72	2024-02-08 17:49:59.109285
232	0	t	75	traffic_periodic_accounting_daily_limit	150000M	100000M	2024-02-08 17:49:59.109285
234	0	t	77	normal_username	_NOVALUE_	navid	2024-02-08 17:53:29.663691
237	0	t	78	abs_exp_date	_NOVALUE_	2024-02-18 18:09	2024-02-08 18:09:27.902902
298	0	t	104	normal_username	_NOVALUE_	sahar57	2024-02-09 05:32:19.705222
300	0	t	105	normal_username	_NOVALUE_	msharif1	2024-02-09 06:03:44.101385
301	0	t	105	abs_exp_date	_NOVALUE_	2024-03-27 07:04	2024-02-09 06:04:03.147837
305	0	t	107	abs_exp_date	_NOVALUE_	2024-02-23 06:08	2024-02-09 06:08:11.162713
319	0	t	77	multi_login	2	2	2024-02-10 06:33:42.394522
322	0	t	114	normal_username	_NOVALUE_	c103	2024-02-10 09:24:25.804996
323	0	t	114	abs_exp_date	_NOVALUE_	2024-03-26 10:24	2024-02-10 09:24:34.58942
329	0	t	116	group	1-Month-10G	3-Month-150G	2024-02-10 11:54:05.452156
333	0	t	118	traffic_periodic_accounting_daily	90	90	2024-02-10 11:55:33.58902
334	0	t	118	traffic_periodic_accounting_daily_limit	150000M	40000M	2024-02-10 11:55:33.58902
338	0	t	121	abs_exp_date	_NOVALUE_	2024-05-06 16:35	2024-02-11 15:35:35.049154
340	0	t	122	abs_exp_date	_NOVALUE_	2024-02-20 18:06	2024-02-11 18:06:45.166334
341	0	t	123	normal_username	_NOVALUE_	hadadi	2024-02-12 01:40:04.914371
342	0	t	124	normal_username	_NOVALUE_	rtp	2024-02-12 01:42:18.017187
344	0	t	126	normal_username	_NOVALUE_	khhosseini	2024-02-12 01:56:34.841726
346	0	t	126	traffic_periodic_accounting_daily	60	37	2024-02-12 01:57:15.005947
347	0	t	126	traffic_periodic_accounting_daily_limit	70000M	50000M	2024-02-12 01:57:15.005947
352	0	t	128	abs_exp_date	_NOVALUE_	2024-03-22 04:20	2024-02-12 03:20:02.283934
554	0	t	287	normal_username	_NOVALUE_	saghar	2024-02-28 07:41:22.837355
555	0	t	288	normal_username	_NOVALUE_	mylove	2024-02-28 16:23:35.710792
360	0	t	131	abs_exp_date	_NOVALUE_	2024-03-06 03:57	2024-02-12 03:57:48.842126
373	0	t	145	normal_username	_NOVALUE_	hamidreza	2024-02-12 05:39:55.453113
376	0	t	147	normal_username	_NOVALUE_	ahatami2d	2024-02-12 12:55:49.968577
377	0	t	147	abs_exp_date	_NOVALUE_	2025-02-11 12:56	2024-02-12 12:56:06.727837
389	0	t	153	abs_exp_date	_NOVALUE_	2024-03-05 15:48	2024-02-13 15:48:31.463957
390	0	t	154	normal_username	_NOVALUE_	maleki2	2024-02-13 17:22:32.691405
391	0	t	154	abs_exp_date	_NOVALUE_	2024-04-03 18:24	2024-02-13 17:24:29.637093
401	0	t	161	normal_username	_NOVALUE_	maleki	2024-02-14 16:28:14.502273
402	0	t	162	normal_username	_NOVALUE_	fkarimi	2024-02-15 02:18:35.530547
403	0	t	162	abs_exp_date	_NOVALUE_	2024-05-10 03:19	2024-02-15 02:19:11.41683
409	0	t	165	normal_username	_NOVALUE_	shooshtari	2024-02-15 10:42:40.683021
411	0	t	167	normal_username	_NOVALUE_	shirani	2024-02-15 16:34:15.625519
426	0	t	181	normal_username	_NOVALUE_	elna2	2024-02-17 08:34:26.787977
428	0	t	183	normal_username	_NOVALUE_	farzan2	2024-02-17 08:37:38.390474
430	0	t	183	traffic_periodic_accounting_daily	90	68	2024-02-17 08:37:57.12804
431	0	t	183	traffic_periodic_accounting_daily_limit	150000M	120000M	2024-02-17 08:37:57.12804
434	0	t	184	traffic_periodic_accounting_daily	30	21	2024-02-17 08:44:15.555771
435	0	t	185	normal_username	_NOVALUE_	aryo1	2024-02-17 13:17:00.404851
692	0	t	402	normal_username	_NOVALUE_	skeyhan	2024-03-13 16:19:50.583681
438	0	t	26	first_login	2024-02-08 14:08	_NOVALUE_	2024-02-17 13:53:43.414253
444	0	t	191	normal_username	_NOVALUE_	vafa	2024-02-18 09:14:02.052729
448	0	t	194	normal_username	_NOVALUE_	zomorod	2024-02-18 14:13:15.235129
457	0	t	198	abs_exp_date	_NOVALUE_	2024-05-15 18:01	2024-02-18 17:01:31.682412
604	0	t	327	normal_username	_NOVALUE_	bama2033	2024-03-05 05:01:32.451994
468	0	t	142	group	1-Month-35G	2-Month-70G	2024-02-19 12:45:05.13697
469	0	t	142	abs_exp_date	_NOVALUE_	2024-04-16 13:45	2024-02-19 12:45:27.632541
491	0	t	222	normal_username	_NOVALUE_	bama19	2024-02-20 12:12:55.928717
492	0	t	223	normal_username	_NOVALUE_	bama20	2024-02-20 12:12:55.928717
493	0	t	235	normal_username	_NOVALUE_	bama2010	2024-02-20 12:16:22.578632
494	0	t	236	normal_username	_NOVALUE_	bama2011	2024-02-20 12:16:22.578632
495	0	t	237	normal_username	_NOVALUE_	bama2012	2024-02-20 12:16:22.578632
496	0	t	238	normal_username	_NOVALUE_	bama2013	2024-02-20 12:16:22.578632
497	0	t	239	normal_username	_NOVALUE_	bama2014	2024-02-20 12:16:22.578632
498	0	t	240	normal_username	_NOVALUE_	bama2015	2024-02-20 12:16:22.578632
499	0	t	241	normal_username	_NOVALUE_	bama2016	2024-02-20 12:16:22.578632
500	0	t	242	normal_username	_NOVALUE_	bama2017	2024-02-20 12:16:22.578632
501	0	t	243	normal_username	_NOVALUE_	bama2018	2024-02-20 12:16:22.578632
502	0	t	244	normal_username	_NOVALUE_	bama2019	2024-02-20 12:16:22.578632
505	0	t	248	normal_username	_NOVALUE_	negin1	2024-02-20 16:19:27.127624
509	0	t	249	normal_username	_NOVALUE_	msm26	2024-02-21 15:20:33.517151
511	0	t	252	normal_username	_NOVALUE_	anderson	2024-02-22 04:33:43.428258
513	0	t	254	normal_username	_NOVALUE_	behrooz	2024-02-22 07:50:33.530227
764	0	t	132	first_login	2024-02-12 05:25	_NOVALUE_	2024-03-24 05:49:23.860675
516	0	t	257	normal_username	_NOVALUE_	shahin2	2024-02-23 03:10:57.28496
517	0	t	258	normal_username	_NOVALUE_	sheyda2	2024-02-23 04:40:27.054151
520	0	t	261	normal_username	_NOVALUE_	parisa	2024-02-24 07:19:14.110579
521	0	t	262	normal_username	_NOVALUE_	rahimi10	2024-02-24 10:27:40.819028
181	0	t	54	abs_exp_date	2024-02-08 16:33	2024-03-02 16:10	2024-02-08 16:10:33.353975
182	0	t	55	normal_username	_NOVALUE_	maroof	2024-02-08 16:22:34.402742
185	0	t	56	abs_exp_date	_NOVALUE_	2024-03-05 16:26	2024-02-08 16:26:44.422644
189	0	t	58	abs_exp_date	_NOVALUE_	2024-03-19 17:33	2024-02-08 16:33:56.284158
192	0	t	60	normal_username	_NOVALUE_	poorsalehi	2024-02-08 16:43:20.353927
194	0	t	61	normal_username	_NOVALUE_	ashoori3	2024-02-08 16:52:54.252175
195	0	t	61	abs_exp_date	_NOVALUE_	2024-03-02 16:53	2024-02-08 16:53:26.444973
196	0	t	62	normal_username	_NOVALUE_	dashti	2024-02-08 16:59:29.075452
201	0	t	63	abs_exp_date	_NOVALUE_	2024-02-28 17:02	2024-02-08 17:02:00.996057
600	0	t	323	normal_username	_NOVALUE_	rahimi11	2024-03-04 14:35:18.488158
1579	0	t	715	normal_username	_NOVALUE_	seyed2	2024-06-17 14:58:22.423558
1580	0	t	716	normal_username	_NOVALUE_	shahin	2024-06-18 05:52:19.3193
212	0	t	68	group	1-Month-35G	1-Month-70G	2024-02-08 17:16:00.240211
587	0	t	314	normal_username	_NOVALUE_	mostafa106	2024-03-02 05:34:10.705639
222	0	t	72	normal_username	_NOVALUE_	farnaz	2024-02-08 17:38:27.951707
223	0	t	72	abs_exp_date	_NOVALUE_	2024-03-08 17:38	2024-02-08 17:38:45.918674
226	0	t	73	abs_exp_date	_NOVALUE_	2024-02-29 17:41	2024-02-08 17:41:41.632327
228	0	t	74	abs_exp_date	_NOVALUE_	2024-02-22 17:45	2024-02-08 17:45:08.558947
229	0	t	75	normal_username	_NOVALUE_	samira2	2024-02-08 17:47:23.169374
236	0	t	78	normal_username	_NOVALUE_	asemi	2024-02-08 18:09:14.465981
397	0	t	157	normal_username	_NOVALUE_	rad	2024-02-13 23:57:49.295374
413	0	t	168	abs_exp_date	_NOVALUE_	2024-04-02 18:14	2024-02-15 17:14:07.839586
503	0	t	246	normal_username	_NOVALUE_	neishaboori	2024-02-20 13:47:18.602683
504	0	t	247	normal_username	_NOVALUE_	asal	2024-02-20 15:40:46.692652
507	0	t	248	traffic_periodic_accounting_daily	90	78	2024-02-20 16:19:58.85154
508	0	t	248	traffic_periodic_accounting_daily_limit	150000M	130000M	2024-02-20 16:19:58.85154
510	0	t	250	normal_username	_NOVALUE_	zand	2024-02-21 16:26:57.10119
512	0	t	253	normal_username	_NOVALUE_	anderson2	2024-02-22 07:48:27.995799
514	0	t	255	normal_username	_NOVALUE_	fariba	2024-02-22 10:35:44.432041
518	0	t	259	normal_username	_NOVALUE_	vafa	2024-02-23 04:48:21.607415
519	0	t	260	normal_username	_NOVALUE_	msm72	2024-02-23 15:47:17.797301
522	0	f	14	rel_exp_date	_NOVALUE_	3 Months	2024-02-24 11:00:16.797603
525	0	f	14	multi_login	_NOVALUE_	1	2024-02-24 11:00:49.817467
526	0	f	14	normal_charge	_NOVALUE_	Normal	2024-02-24 11:01:08.125623
527	0	t	236	group	1-Month-35G	3-month-100-G-bama	2024-02-24 11:01:40.52458
528	0	t	263	normal_username	_NOVALUE_	parastoo	2024-02-24 15:55:10.381793
529	0	t	264	normal_username	_NOVALUE_	aria1	2024-02-25 04:53:36.649677
530	0	t	265	normal_username	_NOVALUE_	aria2	2024-02-25 04:53:36.649677
533	0	t	269	normal_username	_NOVALUE_	aali	2024-02-25 12:58:52.71284
535	0	t	270	abs_exp_date	_NOVALUE_	2024-03-23 14:55	2024-02-25 13:55:03.631543
536	0	t	271	normal_username	_NOVALUE_	mostafa10	2024-02-25 14:22:45.44295
537	0	t	272	normal_username	_NOVALUE_	alipoor	2024-02-25 14:33:41.435613
638	0	t	1	group	1-Month-10G	12-Month-800G	2024-03-09 13:12:38.341302
640	0	t	360	normal_username	_NOVALUE_	solmaz	2024-03-10 03:00:56.742828
540	0	t	274	normal_username	_NOVALUE_	sasan2	2024-02-25 15:24:16.612731
541	0	t	275	normal_username	_NOVALUE_	msm78	2024-02-26 00:56:16.789943
542	0	t	276	normal_username	_NOVALUE_	msm37	2024-02-26 00:57:46.373756
543	0	t	277	normal_username	_NOVALUE_	msm35	2024-02-26 00:59:05.840525
544	0	t	278	normal_username	_NOVALUE_	msm36	2024-02-26 01:00:25.218419
558	0	t	291	normal_username	_NOVALUE_	bama2022	2024-02-28 16:33:16.423524
559	0	t	292	normal_username	_NOVALUE_	bama2023	2024-02-28 16:33:16.423524
560	0	t	293	normal_username	_NOVALUE_	bama2024	2024-02-28 16:33:16.423524
561	0	t	294	normal_username	_NOVALUE_	bama2025	2024-02-28 16:33:16.423524
562	0	t	295	normal_username	_NOVALUE_	bama2026	2024-02-28 16:33:16.423524
563	0	t	296	normal_username	_NOVALUE_	bama2027	2024-02-28 16:33:16.423524
564	0	t	297	normal_username	_NOVALUE_	bama2028	2024-02-28 16:33:16.423524
565	0	t	298	normal_username	_NOVALUE_	bama2029	2024-02-28 16:33:16.423524
567	0	t	301	normal_username	_NOVALUE_	mostafa104	2024-02-29 04:01:30.803679
569	0	t	304	normal_username	_NOVALUE_	maroof	2024-02-29 08:01:18.342434
572	0	t	307	normal_username	_NOVALUE_	yusefi	2024-03-01 01:40:16.964043
1549	0	t	335	first_login	2024-05-14 02:01	_NOVALUE_	2024-06-13 05:07:19.638361
575	0	t	310	normal_username	_NOVALUE_	sarikhan1	2024-03-01 09:13:28.517774
577	0	t	311	abs_exp_date	_NOVALUE_	2024-04-04 10:14	2024-03-01 09:14:32.606769
578	0	t	311	traffic_periodic_accounting_daily	60	34	2024-03-01 09:14:49.377343
579	0	t	311	traffic_periodic_accounting_daily_limit	70000M	50000M	2024-03-01 09:14:49.377343
580	0	t	312	normal_username	_NOVALUE_	zahra	2024-03-01 13:42:36.092617
581	0	t	312	abs_exp_date	_NOVALUE_	2024-06-08 14:42	2024-03-01 13:42:52.313444
582	0	t	312	traffic_periodic_accounting_daily	180	99	2024-03-01 13:43:09.596265
583	0	t	312	traffic_periodic_accounting_daily_limit	300000M	150M	2024-03-01 13:43:09.596265
584	0	t	312	traffic_periodic_accounting_daily	99	99	2024-03-01 13:43:29.120333
585	0	t	312	traffic_periodic_accounting_daily_limit	150M	150000M	2024-03-01 13:43:29.120333
588	0	t	315	normal_username	_NOVALUE_	nikdel4	2024-03-02 06:47:06.150582
589	0	t	184	lock	_NOVALUE_		2024-03-02 11:07:09.335982
590	0	t	184	lock		2/3/2024	2024-03-02 11:07:35.365011
591	0	t	183	lock	_NOVALUE_	2/3/2024	2024-03-02 11:07:59.097747
592	0	t	316	normal_username	_NOVALUE_	msm80	2024-03-02 13:49:00.968856
593	0	t	317	normal_username	_NOVALUE_	amin66	2024-03-02 15:16:39.553145
594	0	t	317	abs_exp_date	_NOVALUE_	2025-03-01 15:17	2024-03-02 15:17:55.95621
595	0	t	318	normal_username	_NOVALUE_	nima	2024-03-02 15:34:38.007842
596	0	t	319	normal_username	_NOVALUE_	keyhan5	2024-03-02 15:39:48.710956
597	0	t	320	normal_username	_NOVALUE_	najar	2024-03-03 02:38:45.329439
605	0	t	328	normal_username	_NOVALUE_	bama2034	2024-03-05 05:01:32.451994
606	0	t	329	normal_username	_NOVALUE_	bama2035	2024-03-05 05:01:32.451994
183	0	t	55	abs_exp_date	_NOVALUE_	2024-02-28 16:22	2024-02-08 16:22:47.718911
184	0	t	56	normal_username	_NOVALUE_	meghdad	2024-02-08 16:26:19.972504
186	0	t	57	normal_username	_NOVALUE_	najar	2024-02-08 16:28:57.218009
188	0	t	58	normal_username	_NOVALUE_	mohammadi66	2024-02-08 16:33:41.738293
190	0	t	59	normal_username	_NOVALUE_	sadr	2024-02-08 16:38:51.22202
193	0	t	60	abs_exp_date	_NOVALUE_	2024-03-09 16:45	2024-02-08 16:45:38.770973
197	0	t	62	abs_exp_date	_NOVALUE_	2024-04-28 17:59	2024-02-08 16:59:43.940041
198	0	t	62	traffic_periodic_accounting_daily	90	80	2024-02-08 17:00:16.395536
199	0	t	62	traffic_periodic_accounting_daily_limit	150000M	140000M	2024-02-08 17:00:16.395536
200	0	t	63	normal_username	_NOVALUE_	melika70	2024-02-08 17:01:41.846613
607	0	t	330	normal_username	_NOVALUE_	bama2036	2024-03-05 05:01:32.451994
608	0	t	331	normal_username	_NOVALUE_	bama2037	2024-03-05 05:01:32.451994
205	0	t	65	normal_username	_NOVALUE_	arast3	2024-02-08 17:08:33.03241
213	0	t	68	abs_exp_date	_NOVALUE_	2024-03-01 17:16	2024-02-08 17:16:18.89439
705	0	t	411	normal_username	_NOVALUE_	mostofi1	2024-03-15 06:24:29.951367
773	0	t	447	normal_username	_NOVALUE_	sheyda3	2024-03-26 04:38:12.020285
708	0	t	412	normal_username	_NOVALUE_	mostofi	2024-03-15 08:25:39.012108
709	0	t	413	normal_username	_NOVALUE_	maleki3	2024-03-15 16:02:11.700989
224	0	t	72	abs_exp_date	2024-03-08 17:38	2024-03-07 17:39	2024-02-08 17:39:15.601552
225	0	t	73	normal_username	_NOVALUE_	leyla	2024-02-08 17:41:12.323532
230	0	t	75	abs_exp_date	_NOVALUE_	2024-04-20 18:47	2024-02-08 17:47:50.678512
233	0	t	76	normal_username	_NOVALUE_	jamali	2024-02-08 17:51:43.35428
235	0	t	77	abs_exp_date	_NOVALUE_	2024-06-25 18:54	2024-02-08 17:54:28.795224
568	0	t	303	normal_username	_NOVALUE_	nazanin	2024-02-29 07:54:32.309409
570	0	t	305	normal_username	_NOVALUE_	shshakeri	2024-02-29 13:21:19.84335
240	0	t	80	normal_username	_NOVALUE_	sajad	2024-02-08 18:13:33.229195
241	0	t	80	abs_exp_date	_NOVALUE_	2024-02-18 18:13	2024-02-08 18:13:58.012026
242	0	t	81	normal_username	_NOVALUE_	sheyda2	2024-02-08 18:15:05.199736
243	0	t	81	abs_exp_date	_NOVALUE_	2024-02-22 18:15	2024-02-08 18:15:19.381146
244	0	t	82	normal_username	_NOVALUE_	nazanin	2024-02-08 18:17:16.391172
245	0	t	82	abs_exp_date	_NOVALUE_	2024-02-28 18:17	2024-02-08 18:17:27.934872
246	0	t	83	normal_username	_NOVALUE_	esfandiari	2024-02-08 18:18:30.52316
247	0	t	83	abs_exp_date	_NOVALUE_	2024-02-28 18:18	2024-02-08 18:18:45.042611
248	0	t	84	normal_username	_NOVALUE_	soheyl	2024-02-08 18:20:28.516969
249	0	t	84	abs_exp_date	_NOVALUE_	2024-02-13 18:20	2024-02-08 18:20:40.26407
250	0	t	85	normal_username	_NOVALUE_	kami	2024-02-08 18:25:04.855564
251	0	t	85	abs_exp_date	_NOVALUE_	2024-03-09 18:25	2024-02-08 18:25:29.889083
252	0	t	86	normal_username	_NOVALUE_	sheyda	2024-02-08 18:28:11.885937
253	0	t	86	abs_exp_date	_NOVALUE_	2024-02-22 18:28	2024-02-08 18:28:23.756534
1550	0	t	480	first_login	2024-05-13 15:45	_NOVALUE_	2024-06-13 08:20:42.779503
1554	0	t	405	first_login	2024-06-13 15:37	_NOVALUE_	2024-06-14 01:58:35.514833
1555	0	t	514	first_login	2024-05-14 15:23	_NOVALUE_	2024-06-14 10:33:35.596637
1558	0	t	709	normal_username	_NOVALUE_	tdmsm6	2024-06-15 03:15:28.665534
258	0	t	88	normal_username	_NOVALUE_	m38	2024-02-08 18:33:55.792451
259	0	t	88	abs_exp_date	_NOVALUE_	2024-03-07 18:34	2024-02-08 18:34:09.465988
260	0	t	89	normal_username	_NOVALUE_	m37	2024-02-08 18:36:07.052009
261	0	t	89	abs_exp_date	_NOVALUE_	2024-05-05 19:36	2024-02-08 18:36:28.233339
262	0	t	89	traffic_periodic_accounting_daily	90	87	2024-02-08 18:37:01.816198
263	0	t	89	traffic_periodic_accounting_daily_limit	150000M	60000M	2024-02-08 18:37:01.816198
264	0	t	90	normal_username	_NOVALUE_	m35	2024-02-08 18:38:01.453669
265	0	t	90	abs_exp_date	_NOVALUE_	2024-05-03 19:38	2024-02-08 18:38:43.330763
266	0	t	90	traffic_periodic_accounting_daily	90	85	2024-02-08 18:39:07.918022
267	0	t	90	traffic_periodic_accounting_daily_limit	150000M	70000M	2024-02-08 18:39:07.918022
268	0	t	91	normal_username	_NOVALUE_	m32	2024-02-08 18:40:18.013826
269	0	t	91	abs_exp_date	_NOVALUE_	2024-03-29 19:40	2024-02-08 18:40:38.610808
270	0	t	91	traffic_periodic_accounting_daily	60	50	2024-02-08 18:41:03.469381
271	0	t	91	traffic_periodic_accounting_daily_limit	70000M	60000M	2024-02-08 18:41:03.469381
272	0	t	92	normal_username	_NOVALUE_	melisa	2024-02-08 18:43:57.068766
273	0	t	92	abs_exp_date	_NOVALUE_	2024-02-24 18:44	2024-02-08 18:44:10.77039
274	0	t	93	normal_username	_NOVALUE_	danesh	2024-02-08 18:46:03.020302
275	0	t	93	abs_exp_date	_NOVALUE_	2024-03-24 19:46	2024-02-08 18:46:16.11022
506	0	t	248	abs_exp_date	_NOVALUE_	2024-05-08 17:19	2024-02-20 16:19:38.413283
523	0	f	14	traffic_periodic_accounting_daily	_NOVALUE_	90	2024-02-24 11:00:31.85516
278	0	t	95	normal_username	_NOVALUE_	cheraghi	2024-02-08 18:50:16.48441
279	0	t	95	abs_exp_date	_NOVALUE_	2024-02-11 18:50	2024-02-08 18:50:51.489543
280	0	t	96	normal_username	_NOVALUE_	negar11	2024-02-08 18:57:34.033733
281	0	t	96	abs_exp_date	_NOVALUE_	2024-02-17 18:58	2024-02-08 18:58:03.062861
282	0	t	97	normal_username	_NOVALUE_	negar12	2024-02-08 18:58:51.32091
283	0	t	97	abs_exp_date	_NOVALUE_	2024-02-17 18:59	2024-02-08 18:59:07.560643
284	0	t	98	normal_username	_NOVALUE_	hamidreza	2024-02-08 19:02:58.122451
285	0	t	98	abs_exp_date	_NOVALUE_	2024-02-11 19:03	2024-02-08 19:03:10.752857
566	0	t	300	normal_username	_NOVALUE_	mostafa102	2024-02-29 03:59:15.326198
571	0	t	306	normal_username	_NOVALUE_	nekoonampc	2024-02-29 14:29:32.220497
775	0	t	269	first_login	2024-02-25 13:09	_NOVALUE_	2024-03-26 06:32:46.128518
290	0	t	101	normal_username	_NOVALUE_	rezaei	2024-02-09 02:52:29.815691
291	0	t	101	abs_exp_date	_NOVALUE_	2024-02-27 02:52	2024-02-09 02:52:45.832411
524	0	f	14	traffic_periodic_accounting_daily_limit	_NOVALUE_	100000M	2024-02-24 11:00:31.85516
531	0	t	267	normal_username	_NOVALUE_	aghasemi	2024-02-25 06:17:54.580785
532	0	t	268	normal_username	_NOVALUE_	hatami	2024-02-25 12:06:14.82392
534	0	t	270	normal_username	_NOVALUE_	ataheri	2024-02-25 13:54:30.949819
710	0	t	414	normal_username	_NOVALUE_	imani	2024-03-15 16:24:48.394605
609	0	t	332	normal_username	_NOVALUE_	bama2038	2024-03-05 05:01:32.451994
610	0	t	333	normal_username	_NOVALUE_	bama2039	2024-03-05 05:01:32.451994
611	0	t	335	normal_username	_NOVALUE_	elmira	2024-03-05 08:40:33.912522
612	0	t	336	normal_username	_NOVALUE_	radan	2024-03-05 12:42:08.934617
613	0	t	337	normal_username	_NOVALUE_	rose	2024-03-05 14:35:32.194832
614	0	t	338	normal_username	_NOVALUE_	c105	2024-03-05 14:50:37.295108
615	0	t	339	normal_username	_NOVALUE_	arsa	2024-03-05 15:33:04.657317
621	0	t	344	normal_username	_NOVALUE_	elnaz	2024-03-06 15:55:57.640221
622	0	t	344	group	2-Month-70G	3-Month-150G	2024-03-06 15:56:50.144291
625	0	t	347	group	1-Month-50G	1-Month-35G	2024-03-06 23:56:15.403293
628	0	t	349	normal_username	_NOVALUE_	mostafa107	2024-03-07 03:36:05.417934
629	0	t	350	normal_username	_NOVALUE_	mostafa108	2024-03-07 03:37:21.525006
630	0	t	351	normal_username	_NOVALUE_	majid	2024-03-07 06:07:46.219358
631	0	t	352	normal_username	_NOVALUE_	erfan	2024-03-08 02:38:56.6044
632	0	t	353	normal_username	_NOVALUE_	behnam4	2024-03-08 07:00:11.142204
633	0	t	354	normal_username	_NOVALUE_	beheshti	2024-03-08 15:01:05.966954
634	0	t	355	normal_username	_NOVALUE_	babak	2024-03-08 15:19:25.644035
636	0	t	357	normal_username	_NOVALUE_	gorjian3	2024-03-09 03:43:11.354365
639	0	t	359	normal_username	_NOVALUE_	c106	2024-03-09 15:09:49.140077
642	0	t	362	normal_username	_NOVALUE_	setayesh	2024-03-10 13:28:33.414496
643	0	t	363	normal_username	_NOVALUE_	morteza	2024-03-10 13:30:04.40133
644	0	t	364	normal_username	_NOVALUE_	golnaz	2024-03-10 17:01:59.732719
645	0	t	366	normal_username	_NOVALUE_	yazdan	2024-03-10 17:20:47.725784
646	0	t	367	normal_username	_NOVALUE_	bama2006	2024-03-10 18:03:26.488911
647	0	t	367	group	1-Month-35G	2-Month-70G	2024-03-10 18:03:40.248889
648	0	t	367	abs_exp_date	_NOVALUE_	2024-04-17 18:03	2024-03-10 18:03:57.323612
649	0	t	368	normal_username	_NOVALUE_	bama2040	2024-03-10 18:06:02.961335
650	0	t	369	normal_username	_NOVALUE_	bama2041	2024-03-10 18:06:02.961335
651	0	t	370	normal_username	_NOVALUE_	bama2042	2024-03-10 18:06:02.961335
652	0	t	371	normal_username	_NOVALUE_	bama2043	2024-03-10 18:06:02.961335
653	0	t	372	normal_username	_NOVALUE_	bama2044	2024-03-10 18:06:02.961335
654	0	t	373	normal_username	_NOVALUE_	bama2045	2024-03-10 18:06:02.961335
655	0	t	374	normal_username	_NOVALUE_	bama2046	2024-03-10 18:06:02.961335
656	0	t	375	normal_username	_NOVALUE_	bama2047	2024-03-10 18:06:02.961335
657	0	t	376	normal_username	_NOVALUE_	bama2048	2024-03-10 18:06:02.961335
658	0	t	377	normal_username	_NOVALUE_	bama2049	2024-03-10 18:06:02.961335
659	0	t	379	normal_username	_NOVALUE_	bama2050	2024-03-10 18:10:32.646583
660	0	t	380	normal_username	_NOVALUE_	bama2051	2024-03-10 18:10:32.646583
661	0	t	381	normal_username	_NOVALUE_	bama2052	2024-03-10 18:10:32.646583
662	0	t	382	normal_username	_NOVALUE_	bama2053	2024-03-10 18:10:32.646583
663	0	t	383	normal_username	_NOVALUE_	bama2054	2024-03-10 18:10:32.646583
664	0	t	384	normal_username	_NOVALUE_	bama2055	2024-03-10 18:10:32.646583
665	0	t	385	normal_username	_NOVALUE_	bama2056	2024-03-10 18:10:32.646583
666	0	t	386	normal_username	_NOVALUE_	bama2057	2024-03-10 18:10:32.646583
667	0	t	387	normal_username	_NOVALUE_	bama2058	2024-03-10 18:10:32.646583
668	0	t	388	normal_username	_NOVALUE_	bama2059	2024-03-10 18:10:32.646583
671	0	t	393	normal_username	_NOVALUE_	meysam	2024-03-12 01:03:23.024224
672	0	t	394	normal_username	_NOVALUE_	jalalizadeh	2024-03-12 03:21:05.715954
673	0	t	394	abs_exp_date	_NOVALUE_	2024-03-23 03:22	2024-03-12 03:22:17.299988
676	0	t	395	abs_exp_date	_NOVALUE_	2024-04-26 05:42	2024-03-12 05:42:55.670243
677	0	t	395	traffic_periodic_accounting_daily	60	45	2024-03-12 05:43:26.215518
678	0	t	395	traffic_periodic_accounting_daily_limit	70000M	220000M	2024-03-12 05:43:26.215518
679	0	t	395	traffic_periodic_accounting_daily	45	45	2024-03-12 05:43:49.878601
680	0	t	395	traffic_periodic_accounting_daily_limit	220000M	21000M	2024-03-12 05:43:49.878601
1857	0	t	718	first_login	2024-06-20 02:57	_NOVALUE_	2024-07-20 08:24:21.777816
682	0	t	396	normal_username	_NOVALUE_	hatami2	2024-03-12 13:47:22.222289
683	0	t	396	group	1-Month-10G	1-Month-20G	2024-03-12 13:47:37.865908
684	0	t	397	normal_username	_NOVALUE_	sedighi	2024-03-12 13:52:32.200649
685	0	t	397	abs_exp_date	_NOVALUE_	2024-04-25 13:52	2024-03-12 13:52:54.427325
686	0	t	397	traffic_periodic_accounting_daily	60	44	2024-03-12 13:53:12.310525
687	0	t	397	traffic_periodic_accounting_daily_limit	70000M	65000M	2024-03-12 13:53:12.310525
688	0	t	398	normal_username	_NOVALUE_	elna	2024-03-12 14:08:21.792746
689	0	t	399	normal_username	_NOVALUE_	mandana	2024-03-12 16:47:17.957559
693	0	t	403	normal_username	_NOVALUE_	niusha	2024-03-13 16:36:01.756069
694	0	t	404	normal_username	_NOVALUE_	farzin1	2024-03-13 16:49:34.835035
695	0	t	405	normal_username	_NOVALUE_	farzin2	2024-03-13 16:51:24.164072
696	0	t	134	first_login	2024-02-12 18:34	_NOVALUE_	2024-03-14 13:47:17.659463
697	0	t	406	normal_username	_NOVALUE_	minoo	2024-03-14 14:14:34.750535
698	0	t	406	abs_exp_date	_NOVALUE_	2024-07-09 14:15	2024-03-14 14:15:03.282483
699	0	t	406	traffic_periodic_accounting_daily	180	117	2024-03-14 14:15:22.72179
700	0	t	406	traffic_periodic_accounting_daily_limit	300000M	200000M	2024-03-14 14:15:22.72179
701	0	t	407	normal_username	_NOVALUE_	tahmineh	2024-03-14 14:29:16.885757
702	0	t	408	normal_username	_NOVALUE_	navayi	2024-03-14 14:41:26.988048
703	0	t	409	normal_username	_NOVALUE_	saragol	2024-03-14 19:06:24.782552
706	0	t	411	abs_exp_date	_NOVALUE_	2024-06-04 06:27	2024-03-15 06:27:40.618281
711	0	t	414	abs_exp_date	_NOVALUE_	2024-04-12 16:25	2024-03-15 16:25:57.139333
717	0	t	171	first_login	2024-02-16 16:20	_NOVALUE_	2024-03-16 17:07:30.717025
718	0	t	171	traffic_periodic_accounting_daily	30	30	2024-03-16 17:08:03.214823
720	0	t	421	normal_username	_NOVALUE_	afsane	2024-03-17 13:36:21.161856
721	0	t	422	normal_username	_NOVALUE_	arash	2024-03-17 13:36:45.13444
722	0	t	423	normal_username	_NOVALUE_	sahar1	2024-03-17 16:20:03.014395
723	0	t	424	normal_username	_NOVALUE_	jalalizadeh2	2024-03-17 16:23:30.397764
724	0	t	425	normal_username	_NOVALUE_	jalalizadeh3	2024-03-17 16:25:45.328273
725	0	t	427	normal_username	_NOVALUE_	namazian	2024-03-17 17:10:23.895433
726	0	t	427	abs_exp_date	_NOVALUE_	2024-05-24 17:10	2024-03-17 17:10:37.000259
729	0	t	428	normal_username	_NOVALUE_	hanieh2	2024-03-18 05:20:19.046434
731	0	t	430	normal_username	_NOVALUE_	msm26	2024-03-18 16:55:33.817058
732	0	t	431	normal_username	_NOVALUE_	bama2004	2024-03-18 17:04:39.070891
735	0	t	139	first_login	2024-02-18 06:58	_NOVALUE_	2024-03-19 10:08:40.356517
739	0	t	437	normal_username	_NOVALUE_	m40	2024-03-19 13:30:40.415282
740	0	t	436	multi_login	2	1	2024-03-19 13:31:06.791579
741	0	t	374	group	1-Month-35G	2-Month-70G	2024-03-19 14:46:15.202069
742	0	t	438	normal_username	_NOVALUE_	poneh	2024-03-19 15:15:55.592983
743	0	t	176	first_login	2024-02-17 08:32	_NOVALUE_	2024-03-19 15:40:46.882747
744	0	t	176	group	1-Month-35G	3-Month-150G	2024-03-19 15:41:04.165186
745	0	t	59	group	2-Month-70G	3-Month-150G	2024-03-19 18:04:06.387104
746	0	t	59	first_login	2024-02-08 18:10	_NOVALUE_	2024-03-19 18:04:14.573574
749	0	t	209	first_login	2024-02-20 15:26	_NOVALUE_	2024-03-20 04:33:46.507809
750	0	t	210	first_login	2024-02-22 03:58	_NOVALUE_	2024-03-20 04:34:10.432665
751	0	t	120	first_login	2024-02-11 08:01	_NOVALUE_	2024-03-20 06:05:17.946317
752	0	t	6	first_login	2024-02-08 13:20	_NOVALUE_	2024-03-20 12:21:35.797343
753	0	t	6	abs_exp_date	2024-03-19 09:04	2024-03-27 12:21	2024-03-20 12:21:51.689486
757	0	t	275	first_login	2024-02-26 10:44	_NOVALUE_	2024-03-23 03:28:11.459598
759	0	t	394	abs_exp_date	2024-03-23 03:22	_NOVALUE_	2024-03-23 03:30:14.829515
760	0	t	441	normal_username	_NOVALUE_	sheyda	2024-03-23 09:31:45.925553
765	0	t	444	normal_username	_NOVALUE_	mvo1	2024-03-24 10:47:46.653043
767	0	t	445	normal_username	_NOVALUE_	nazemian	2024-03-25 05:07:38.451949
771	0	t	261	first_login	2024-02-24 07:21	_NOVALUE_	2024-03-25 15:00:45.005618
772	0	t	258	first_login	2024-02-23 04:40	_NOVALUE_	2024-03-26 03:44:30.627898
774	0	t	447	abs_exp_date	_NOVALUE_	2024-03-27 04:38	2024-03-26 04:38:27.019974
777	0	t	207	group	1-Month-35G	3-Month-150G	2024-03-26 12:23:54.712313
779	0	t	272	first_login	2024-02-25 14:40	_NOVALUE_	2024-03-26 17:30:03.742332
781	0	t	448	normal_username	_NOVALUE_	msm20	2024-03-27 04:01:17.874462
782	0	t	447	group	1-Month-10G	3-Month-150G	2024-03-27 04:03:45.713449
786	0	t	448	group	1-Month-50G	2-Month-70G	2024-03-27 04:12:23.231471
789	0	t	450	abs_exp_date	_NOVALUE_	2024-04-12 04:18	2024-03-27 04:18:47.727795
791	0	t	93	abs_exp_date	2024-03-24 19:46	_NOVALUE_	2024-03-27 07:30:52.221127
793	0	t	440	group	1-Month-10G	3-Month-150G	2024-03-27 08:12:52.523437
796	0	t	279	first_login	2024-02-26 05:27	_NOVALUE_	2024-03-27 13:33:28.016847
797	0	t	6	first_login	2024-03-20 12:33	_NOVALUE_	2024-03-27 14:45:02.593489
798	0	t	6	abs_exp_date	2024-03-27 12:21	_NOVALUE_	2024-03-27 14:45:13.018486
799	0	t	6	group	2-Month-70G	3-Month-150G	2024-03-27 14:46:40.369486
801	0	t	280	first_login	2024-02-26 09:32	_NOVALUE_	2024-03-28 06:11:03.396826
802	0	t	452	normal_username	_NOVALUE_	leila24	2024-03-28 19:05:31.590711
803	0	t	452	abs_exp_date	_NOVALUE_	2024-04-09 19:05	2024-03-28 19:05:58.108276
804	0	t	453	normal_username	_NOVALUE_	mtaheri	2024-03-29 07:04:16.213383
807	0	t	286	first_login	2024-02-28 07:04	_NOVALUE_	2024-03-29 09:16:33.990474
808	0	t	164	first_login	2024-02-15 04:58	_NOVALUE_	2024-03-30 12:24:36.090692
810	0	t	303	first_login	2024-02-29 07:55	_NOVALUE_	2024-03-30 12:44:04.363481
811	0	t	455	normal_username	_NOVALUE_	sanjabi10	2024-03-30 15:11:32.937843
812	0	t	252	first_login	2024-02-22 07:04	_NOVALUE_	2024-03-30 16:08:40.850838
813	0	t	457	normal_username	_NOVALUE_	hadadi2	2024-03-31 04:06:04.111891
815	0	t	458	normal_username	_NOVALUE_	leyla	2024-03-31 12:16:10.124316
816	0	t	425	group	1-Month-35G	1-Month-70G	2024-03-31 13:50:23.806714
819	0	t	460	abs_exp_date	_NOVALUE_	2024-04-17 16:51	2024-03-31 16:51:28.215311
820	0	t	310	first_login	2024-03-01 10:33	_NOVALUE_	2024-03-31 16:52:12.530028
821	0	t	311	first_login	2024-03-01 15:49	_NOVALUE_	2024-03-31 16:53:02.593002
1551	0	t	512	first_login	2024-05-14 06:27	_NOVALUE_	2024-06-13 11:49:30.249455
826	0	t	320	first_login	2024-03-03 03:33	_NOVALUE_	2024-04-01 08:16:27.984884
827	0	t	287	first_login	2024-02-28 08:46	_NOVALUE_	2024-04-01 12:19:33.218791
828	0	t	246	first_login	2024-02-20 14:01	_NOVALUE_	2024-04-01 16:03:47.203058
829	0	t	461	normal_username	_NOVALUE_	neishaboori	2024-04-01 16:05:34.031253
830	0	t	306	first_login	2024-02-29 14:29	_NOVALUE_	2024-04-01 17:05:08.262108
831	0	t	128	first_login	2024-02-12 03:22	_NOVALUE_	2024-04-02 04:26:43.588912
833	0	t	128	group	2-Month-70G	3-Month-150G	2024-04-02 04:26:58.324565
834	0	t	300	first_login	2024-02-29 04:55	_NOVALUE_	2024-04-02 04:37:06.110089
836	0	t	314	first_login	2024-03-02 07:27	_NOVALUE_	2024-04-02 04:38:08.532397
839	0	t	316	first_login	2024-03-02 15:50	_NOVALUE_	2024-04-02 04:40:57.050141
841	0	t	126	abs_exp_date	2024-03-20 02:56	_NOVALUE_	2024-04-02 07:00:14.406485
842	0	t	126	group	2-Month-70G	3-Month-150G	2024-04-02 07:00:23.442141
845	0	t	105	abs_exp_date	2024-03-27 07:04	_NOVALUE_	2024-04-02 09:08:58.475812
846	0	t	105	group	2-Month-70G	3-Month-150G	2024-04-02 09:09:07.010677
847	0	t	315	first_login	2024-03-02 07:03	_NOVALUE_	2024-04-02 12:40:24.783574
848	0	t	464	normal_username	_NOVALUE_	esi	2024-04-02 16:43:42.423925
850	0	t	202	first_login	2024-02-19 07:24	_NOVALUE_	2024-04-03 03:42:10.437658
851	0	t	153	first_login	2024-02-14 07:02	_NOVALUE_	2024-04-03 04:54:40.117212
852	0	t	153	abs_exp_date	2024-03-05 15:48	_NOVALUE_	2024-04-03 04:54:44.781043
854	0	t	161	first_login	2024-02-15 01:40	_NOVALUE_	2024-04-03 05:16:38.491565
855	0	t	161	group	2-Month-70G	3-Month-150G	2024-04-03 05:16:54.115502
856	0	t	127	group	2-Month-70G	6-Month-300G	2024-04-03 05:22:16.319847
858	0	t	127	abs_exp_date	_NOVALUE_	2024-07-11 05:22	2024-04-03 05:22:50.272535
863	0	t	467	normal_username	_NOVALUE_	bameri	2024-04-03 17:56:44.221015
864	0	t	468	normal_username	_NOVALUE_	shahi	2024-04-04 02:48:25.992195
865	0	t	195	abs_exp_date	2024-04-03 15:24	_NOVALUE_	2024-04-04 03:03:01.923814
867	0	t	195	traffic_periodic_accounting_daily	45	_NOVALUE_	2024-04-04 03:03:13.188156
727	0	t	427	traffic_periodic_accounting_daily	90	68	2024-03-17 17:11:04.629741
728	0	t	427	traffic_periodic_accounting_daily_limit	150000M	120000M	2024-03-17 17:11:04.629741
730	0	t	429	normal_username	_NOVALUE_	milad	2024-03-18 06:27:04.205117
736	0	t	433	normal_username	_NOVALUE_	danial	2024-03-19 12:38:58.639669
1062	0	t	538	normal_username	_NOVALUE_	nhasibi2	2024-04-23 05:07:39.528984
747	0	t	59	abs_exp_date	2024-03-18 17:39	_NOVALUE_	2024-03-19 18:04:26.912505
756	0	t	440	normal_username	_NOVALUE_	mahshid2	2024-03-22 13:35:19.900526
758	0	t	394	first_login	2024-03-17 14:15	_NOVALUE_	2024-03-23 03:29:55.773797
761	0	t	260	first_login	2024-02-23 15:47	_NOVALUE_	2024-03-23 09:33:16.825198
762	0	t	190	first_login	2024-02-18 07:54	_NOVALUE_	2024-03-23 09:33:56.625407
763	0	t	442	normal_username	_NOVALUE_	aghasemi	2024-03-23 09:42:50.596421
766	0	t	255	first_login	2024-02-22 13:03	_NOVALUE_	2024-03-24 13:03:01.904066
768	0	t	446	normal_username	_NOVALUE_	seyed	2024-03-25 06:06:01.747048
769	0	t	270	first_login	2024-02-25 16:17	_NOVALUE_	2024-03-25 06:38:20.913895
770	0	t	270	abs_exp_date	2024-03-23 14:55	_NOVALUE_	2024-03-25 06:38:35.543535
776	0	t	207	first_login	2024-02-19 15:14	_NOVALUE_	2024-03-26 12:23:39.315194
778	0	t	271	first_login	2024-02-25 14:23	_NOVALUE_	2024-03-26 16:30:08.800844
780	0	t	272	group	1-Month-50G	3-Month-150G	2024-03-26 17:30:20.114406
783	0	t	447	first_login	2024-03-27 03:48	_NOVALUE_	2024-03-27 04:03:54.059435
784	0	t	447	abs_exp_date	2024-03-27 04:38	_NOVALUE_	2024-03-27 04:04:08.094163
785	0	t	447	group	3-Month-150G	1-Month-50G	2024-03-27 04:04:23.39616
787	0	t	448	abs_exp_date	_NOVALUE_	2024-05-05 04:12	2024-03-27 04:12:52.640171
788	0	t	450	normal_username	_NOVALUE_	farnaz2	2024-03-27 04:18:29.891452
790	0	t	93	first_login	2024-02-08 20:03	_NOVALUE_	2024-03-27 07:30:43.476709
792	0	t	93	group	2-Month-70G	3-Month-150G	2024-03-27 07:31:08.418547
794	0	t	278	first_login	2024-02-26 02:37	_NOVALUE_	2024-03-27 10:41:24.769107
795	0	t	242	first_login	2024-02-26 04:08	_NOVALUE_	2024-03-27 11:44:42.960403
805	0	t	453	abs_exp_date	_NOVALUE_	2024-03-30 07:04	2024-03-29 07:04:34.724883
806	0	t	454	normal_username	_NOVALUE_	arash1	2024-03-29 09:09:08.119008
809	0	t	164	group	1-Month-20G	1-Month-35G	2024-03-30 12:25:14.337043
814	0	t	319	group	1-Month-35G	2-Month-70G	2024-03-31 06:24:45.935614
817	0	t	425	group	1-Month-70G	1-Month-35G	2024-03-31 13:53:46.617452
818	0	t	460	normal_username	_NOVALUE_	jalalizadeh2	2024-03-31 16:51:10.202278
822	0	t	311	abs_exp_date	2024-04-04 10:14	2024-05-04 16:53	2024-03-31 16:53:40.890407
1552	0	t	404	first_login	2024-03-13 17:01	_NOVALUE_	2024-06-14 01:58:05.031965
832	0	t	128	abs_exp_date	2024-03-22 04:20	_NOVALUE_	2024-04-02 04:26:48.145874
835	0	t	301	first_login	2024-03-02 02:37	_NOVALUE_	2024-04-02 04:37:37.302645
837	0	t	313	first_login	2024-03-02 05:49	_NOVALUE_	2024-04-02 04:38:24.356851
838	0	t	462	normal_username	_NOVALUE_	mostafa109	2024-04-02 04:39:01.034229
840	0	t	126	first_login	2024-02-12 02:05	_NOVALUE_	2024-04-02 06:59:26.628874
843	0	t	463	normal_username	_NOVALUE_	jalalizadeh10	2024-04-02 07:19:48.786418
844	0	t	105	first_login	2024-02-09 06:14	_NOVALUE_	2024-04-02 09:08:53.281844
849	0	t	465	normal_username	_NOVALUE_	noora	2024-04-02 16:45:55.717832
853	0	t	391	group	1-Month-35G	1-Month-70G	2024-04-03 05:01:08.812414
857	0	t	127	first_login	2024-02-12 02:03	_NOVALUE_	2024-04-03 05:22:27.836269
859	0	t	127	traffic_periodic_accounting_daily	37	99	2024-04-03 05:24:03.386344
860	0	t	127	traffic_periodic_accounting_daily_limit	25000M	100000M	2024-04-03 05:24:03.386344
861	0	t	127	traffic_periodic_accounting_daily_usage	58591904	_NOVALUE_	2024-04-03 05:24:03.386344
862	0	t	322	first_login	2024-03-04 04:37	_NOVALUE_	2024-04-03 12:00:41.941637
866	0	t	195	first_login	2024-02-18 14:51	_NOVALUE_	2024-04-04 03:03:06.213401
868	0	t	195	traffic_periodic_accounting_daily_limit	60000M	_NOVALUE_	2024-04-04 03:03:13.188156
869	0	t	195	traffic_periodic_accounting_daily_usage	12939177	_NOVALUE_	2024-04-04 03:03:13.188156
870	0	t	195	group	2-Month-70G	3-Month-150G	2024-04-04 03:03:42.195481
871	0	t	154	first_login	2024-02-16 01:42	_NOVALUE_	2024-04-04 03:10:37.23006
872	0	t	154	abs_exp_date	2024-04-03 18:24	_NOVALUE_	2024-04-04 03:10:42.928453
873	0	t	154	group	2-Month-70G	3-Month-150G	2024-04-04 03:10:55.011984
874	0	t	277	first_login	2024-02-26 06:00	_NOVALUE_	2024-04-04 03:15:12.220191
875	0	t	276	first_login	2024-02-26 02:38	_NOVALUE_	2024-04-04 03:15:29.506624
876	0	t	469	normal_username	_NOVALUE_	asemi	2024-04-04 07:42:22.195627
877	0	t	470	normal_username	_NOVALUE_	salmani	2024-04-04 08:01:48.444608
878	0	t	471	normal_username	_NOVALUE_	mahshid	2024-04-04 09:42:17.8402
879	0	t	471	abs_exp_date	_NOVALUE_	2024-06-27 09:42	2024-04-04 09:42:54.262691
880	0	t	328	first_login	2024-03-05 12:11	_NOVALUE_	2024-04-04 11:51:15.045288
881	0	t	362	first_login	2024-03-10 13:32	_NOVALUE_	2024-04-04 15:38:55.496586
882	0	t	362	group	1-Month-35G	2-Month-70G	2024-04-04 15:39:18.51198
883	0	t	362	abs_exp_date	_NOVALUE_	2024-05-08 15:41	2024-04-04 15:41:49.273331
884	0	t	336	first_login	2024-03-05 21:48	_NOVALUE_	2024-04-04 19:28:53.636518
885	0	t	472	normal_username	_NOVALUE_	nabikhani	2024-04-05 04:26:44.486869
886	0	t	168	first_login	2024-02-20 09:54	_NOVALUE_	2024-04-05 08:41:54.493875
887	0	t	168	abs_exp_date	2024-04-02 18:14	_NOVALUE_	2024-04-05 08:42:08.727289
888	0	t	168	group	2-Month-70G	3-Month-150G	2024-04-05 08:42:31.167796
889	0	t	347	first_login	2024-03-07 01:26	_NOVALUE_	2024-04-05 10:04:11.843903
890	0	t	473	normal_username	_NOVALUE_	ghafari20	2024-04-05 10:05:18.983706
891	0	t	178	abs_exp_date	2024-03-15 06:03	_NOVALUE_	2024-04-05 13:24:51.337248
892	0	t	321	first_login	2024-03-03 14:37	_NOVALUE_	2024-04-05 13:46:32.988145
893	0	t	475	normal_username	_NOVALUE_	bagheri2	2024-04-05 16:14:45.130589
894	0	t	475	abs_exp_date	_NOVALUE_	2024-04-18 16:14	2024-04-05 16:14:59.760333
895	0	t	329	first_login	2024-03-06 11:57	_NOVALUE_	2024-04-05 16:43:59.245624
896	0	t	340	first_login	2024-03-06 09:03	_NOVALUE_	2024-04-06 06:23:50.060972
897	0	t	204	first_login	2024-02-19 09:31	_NOVALUE_	2024-04-06 10:01:13.139406
898	0	t	348	first_login	2024-03-07 02:27	_NOVALUE_	2024-04-06 11:30:07.477592
899	0	t	345	first_login	2024-03-07 04:04	_NOVALUE_	2024-04-06 13:23:45.445501
900	0	t	476	normal_username	_NOVALUE_	arianpc	2024-04-06 17:06:33.76723
901	0	t	476	abs_exp_date	_NOVALUE_	2024-11-12 16:07	2024-04-06 17:07:04.968057
904	0	t	352	first_login	2024-03-08 02:42	_NOVALUE_	2024-04-07 08:19:42.957485
905	0	t	39	first_login	2024-02-08 15:04	_NOVALUE_	2024-04-07 09:59:52.405365
907	0	t	353	first_login	2024-03-08 07:47	_NOVALUE_	2024-04-07 12:03:08.019172
908	0	t	409	group	1-Month-35G	1-Month-50G	2024-04-07 12:15:17.215054
909	0	t	239	first_login	2024-02-24 13:06	_NOVALUE_	2024-04-07 13:20:22.030854
910	0	t	477	normal_username	_NOVALUE_	omid1	2024-04-07 15:15:00.981381
911	0	t	268	first_login	2024-03-08 16:28	_NOVALUE_	2024-04-08 05:07:19.921331
912	0	t	268	group	1-Month-35G	2-Month-70G	2024-04-08 05:07:38.776684
914	0	t	478	normal_username	_NOVALUE_	saba	2024-04-08 16:23:24.599061
916	0	t	480	normal_username	_NOVALUE_	reyhaneh	2024-04-09 02:08:11.847582
918	0	t	357	first_login	2024-03-09 03:43	_NOVALUE_	2024-04-09 04:02:33.625377
919	0	t	357	group	1-Month-35G	3-Month-150G	2024-04-09 04:02:43.00586
921	0	t	481	normal_username	_NOVALUE_	msm86	2024-04-09 06:35:08.301565
922	0	t	482	normal_username	_NOVALUE_	bama-2060	2024-04-09 06:58:03.501772
923	0	t	483	normal_username	_NOVALUE_	bama-2061	2024-04-09 06:58:03.501772
924	0	t	484	normal_username	_NOVALUE_	bama-2062	2024-04-09 06:58:03.501772
925	0	t	485	normal_username	_NOVALUE_	bama-2063	2024-04-09 06:58:03.501772
926	0	t	486	normal_username	_NOVALUE_	bama-2064	2024-04-09 06:58:03.501772
927	0	t	487	normal_username	_NOVALUE_	bama-2065	2024-04-09 06:58:03.501772
928	0	t	488	normal_username	_NOVALUE_	bama-2066	2024-04-09 06:58:03.501772
929	0	t	489	normal_username	_NOVALUE_	bama-2067	2024-04-09 06:58:03.501772
930	0	t	490	normal_username	_NOVALUE_	bama-2068	2024-04-09 06:58:03.501772
931	0	t	491	normal_username	_NOVALUE_	bama-2069	2024-04-09 06:58:03.501772
932	0	t	493	normal_username	_NOVALUE_	bama2060	2024-04-09 07:01:23.530214
933	0	t	494	normal_username	_NOVALUE_	bama2061	2024-04-09 07:01:23.530214
934	0	t	495	normal_username	_NOVALUE_	bama2062	2024-04-09 07:01:23.530214
935	0	t	496	normal_username	_NOVALUE_	bama2063	2024-04-09 07:01:23.530214
1559	0	t	171	first_login	2024-05-16 00:00	_NOVALUE_	2024-06-15 05:22:14.288577
937	0	t	498	normal_username	_NOVALUE_	bama2065	2024-04-09 07:01:23.530214
938	0	t	499	normal_username	_NOVALUE_	bama2066	2024-04-09 07:01:23.530214
939	0	t	500	normal_username	_NOVALUE_	bama2067	2024-04-09 07:01:23.530214
940	0	t	501	normal_username	_NOVALUE_	bama2068	2024-04-09 07:01:23.530214
941	0	t	502	normal_username	_NOVALUE_	bama2069	2024-04-09 07:01:23.530214
943	0	t	390	first_login	2024-03-11 17:17	_NOVALUE_	2024-04-09 07:17:16.786439
944	0	t	349	first_login	2024-03-09 08:28	_NOVALUE_	2024-04-09 08:09:32.324183
945	0	t	350	first_login	2024-03-11 05:27	_NOVALUE_	2024-04-09 08:09:46.258394
947	0	t	504	normal_username	_NOVALUE_	bameri2	2024-04-09 12:42:32.707222
948	0	t	391	first_login	2024-03-11 16:09	_NOVALUE_	2024-04-09 16:21:29.322668
949	0	t	84	abs_exp_date	2024-02-13 18:20	_NOVALUE_	2024-04-10 08:57:53.415827
951	0	t	505	normal_username	_NOVALUE_	asal2	2024-04-10 11:01:46.980856
952	0	t	505	abs_exp_date	_NOVALUE_	2024-04-11 11:03	2024-04-10 11:03:43.200001
953	0	t	505	group	1-Month-35G	3-Month-150G	2024-04-10 12:28:51.786366
954	0	t	505	abs_exp_date	2024-04-11 11:03	_NOVALUE_	2024-04-10 12:29:07.374639
956	0	t	33	abs_exp_date	2024-04-10 15:32	_NOVALUE_	2024-04-10 18:26:51.305172
960	0	t	335	first_login	2024-03-05 09:30	_NOVALUE_	2024-04-11 07:06:59.341778
962	0	t	506	normal_username	_NOVALUE_	parisa2	2024-04-11 11:32:34.514259
1858	0	t	254	first_login	2024-06-21 12:14	_NOVALUE_	2024-07-20 16:41:39.606375
964	0	t	508	normal_username	_NOVALUE_	armand	2024-04-11 16:13:24.949612
965	0	t	508	abs_exp_date	_NOVALUE_	2024-04-27 16:14	2024-04-11 16:14:03.86989
966	0	t	399	first_login	2024-03-13 01:01	_NOVALUE_	2024-04-12 03:56:34.581246
967	0	t	359	first_login	2024-03-10 06:53	_NOVALUE_	2024-04-12 04:30:39.33102
968	0	t	509	normal_username	_NOVALUE_	mehdipoor	2024-04-12 14:40:09.887981
970	0	t	450	abs_exp_date	2024-04-12 04:18	_NOVALUE_	2024-04-12 15:10:32.500033
971	0	t	130	first_login	2024-02-13 00:40	_NOVALUE_	2024-04-13 05:42:39.999745
973	0	t	512	normal_username	_NOVALUE_	msm24	2024-04-14 02:19:16.100974
974	0	t	409	first_login	2024-03-14 19:16	_NOVALUE_	2024-04-14 06:07:33.506486
976	0	t	514	normal_username	_NOVALUE_	heliya	2024-04-14 13:40:59.991705
978	0	t	402	first_login	2024-03-13 16:35	_NOVALUE_	2024-04-14 14:30:09.09642
979	0	t	515	normal_username	_NOVALUE_	maziyar	2024-04-14 14:40:59.809444
982	0	t	520	normal_username	_NOVALUE_	leila25	2024-04-15 13:23:10.259223
984	0	t	103	abs_exp_date	2024-04-15 06:24	_NOVALUE_	2024-04-15 14:33:08.699512
986	0	t	5	first_login	2024-02-08 16:46	_NOVALUE_	2024-04-15 15:23:58.563381
988	0	t	5	traffic_periodic_accounting_daily	67	_NOVALUE_	2024-04-15 15:24:20.465304
989	0	t	5	traffic_periodic_accounting_daily_limit	100000M	_NOVALUE_	2024-04-15 15:24:20.465304
990	0	t	5	traffic_periodic_accounting_daily_usage	267878760	_NOVALUE_	2024-04-15 15:24:20.465304
991	0	t	521	normal_username	_NOVALUE_	naser15	2024-04-15 16:19:54.461949
992	0	t	522	normal_username	_NOVALUE_	rezakermani	2024-04-15 16:39:56.413992
993	0	t	171	first_login	2024-03-16 17:05	_NOVALUE_	2024-04-15 16:55:27.028384
995	0	t	200	first_login	2024-03-19 06:50	_NOVALUE_	2024-04-16 12:43:46.180006
1564	0	t	349	first_login	2024-05-18 00:47	_NOVALUE_	2024-06-15 13:22:52.834229
1001	0	t	419	first_login	2024-03-16 16:44	_NOVALUE_	2024-04-16 13:53:00.250656
1005	0	t	420	first_login	2024-03-17 10:37	_NOVALUE_	2024-04-17 03:39:09.727882
1006	0	t	420	group	1-Month-10G	1-Month-20G	2024-04-17 03:39:30.712781
1007	0	t	413	first_login	2024-03-15 16:02	_NOVALUE_	2024-04-17 05:18:07.380649
1008	0	t	142	group	1-Month-35G	3-month-100-G-bama	2024-04-17 05:31:22.959866
1011	0	t	524	normal_username	_NOVALUE_	talkhabloo	2024-04-17 13:36:45.446629
1012	0	t	524	abs_exp_date	_NOVALUE_	2024-07-01 13:37	2024-04-17 13:37:01.809349
1017	0	t	480	abs_exp_date	2024-04-29 02:09	_NOVALUE_	2024-04-17 14:16:54.821659
902	0	t	476	traffic_periodic_accounting_daily	365	220	2024-04-06 17:07:48.023204
903	0	t	476	traffic_periodic_accounting_daily_limit	600000M	300000M	2024-04-06 17:07:48.023204
906	0	t	39	abs_exp_date	2024-03-07 15:03	_NOVALUE_	2024-04-07 10:04:40.426098
913	0	t	356	first_login	2024-03-09 04:00	_NOVALUE_	2024-04-08 11:26:52.317906
915	0	t	479	normal_username	_NOVALUE_	aghasemi2	2024-04-08 17:34:26.595688
917	0	t	480	abs_exp_date	_NOVALUE_	2024-04-29 02:09	2024-04-09 02:09:46.510586
920	0	t	364	first_login	2024-03-10 22:50	_NOVALUE_	2024-04-09 06:32:21.032905
942	0	t	354	first_login	2024-03-08 15:33	_NOVALUE_	2024-04-09 07:16:32.622627
946	0	t	361	first_login	2024-03-10 06:58	_NOVALUE_	2024-04-09 08:12:32.054705
950	0	t	84	group	1-Month-20G	1-Month-35G	2024-04-10 08:58:09.164818
955	0	t	33	first_login	2024-02-09 01:02	_NOVALUE_	2024-04-10 18:26:37.903324
957	0	t	33	traffic_periodic_accounting_daily	62	_NOVALUE_	2024-04-10 18:27:15.251593
958	0	t	33	traffic_periodic_accounting_daily_limit	100000M	_NOVALUE_	2024-04-10 18:27:15.251593
959	0	t	33	traffic_periodic_accounting_daily_usage	10210324359	_NOVALUE_	2024-04-10 18:27:15.251593
961	0	t	393	first_login	2024-03-12 04:08	_NOVALUE_	2024-04-11 09:03:05.136411
969	0	t	450	first_login	2024-03-27 04:40	_NOVALUE_	2024-04-12 15:08:31.501744
972	0	t	510	normal_username	_NOVALUE_	raeesi	2024-04-13 16:28:26.10632
975	0	t	513	normal_username	_NOVALUE_	akbari2	2024-04-14 06:14:47.440026
977	0	t	400	first_login	2024-03-13 15:58	_NOVALUE_	2024-04-14 14:29:44.123367
980	0	t	516	normal_username	_NOVALUE_	msm60	2024-04-14 14:54:51.346672
981	0	t	208	group	1-Month-35G	1-Month-70G	2024-04-14 17:42:06.990548
983	0	t	103	first_login	2024-02-09 05:26	_NOVALUE_	2024-04-15 14:32:43.606059
985	0	t	103	group	3-Month-150G	1-Month-35G	2024-04-15 14:33:22.021754
987	0	t	5	abs_exp_date	2024-04-15 14:13	_NOVALUE_	2024-04-15 15:24:08.851947
994	0	t	134	first_login	2024-03-15 12:17	_NOVALUE_	2024-04-15 17:12:42.503423
1560	0	t	603	first_login	2024-05-14 11:18	_NOVALUE_	2024-06-15 08:28:01.317184
1566	0	t	605	first_login	2024-05-14 14:50	_NOVALUE_	2024-06-15 14:07:57.593427
1567	0	t	208	group	1-Month-50G	2-Month-70G	2024-06-15 14:08:24.967146
1002	0	t	142	first_login	2024-02-19 12:04	_NOVALUE_	2024-04-16 15:41:21.905025
1003	0	t	142	abs_exp_date	2024-04-16 13:45	_NOVALUE_	2024-04-16 15:42:18.312054
1004	0	t	142	group	2-Month-70G	1-Month-35G	2024-04-16 15:42:53.945189
1009	0	t	423	first_login	2024-03-18 02:33	_NOVALUE_	2024-04-17 06:21:49.147474
1010	0	t	428	first_login	2024-03-18 05:26	_NOVALUE_	2024-04-17 12:47:03.788593
1013	0	t	524	traffic_periodic_accounting_daily	90	75	2024-04-17 13:37:24.460513
1014	0	t	524	traffic_periodic_accounting_daily_limit	150000M	130000M	2024-04-17 13:37:24.460513
1015	0	t	429	first_login	2024-03-18 07:07	_NOVALUE_	2024-04-17 14:16:02.705879
1016	0	t	480	first_login	2024-04-09 06:50	_NOVALUE_	2024-04-17 14:16:40.57735
1018	0	t	525	normal_username	_NOVALUE_	barkhordari	2024-04-17 17:11:16.605128
1019	0	t	188	first_login	2024-02-17 14:22	_NOVALUE_	2024-04-18 07:13:15.081205
1020	0	t	188	group	2-Month-70G	3-Month-150G	2024-04-18 07:13:52.213031
1021	0	t	419	first_login	2024-04-17 13:52	_NOVALUE_	2024-04-18 07:38:51.438673
1022	0	t	526	normal_username	_NOVALUE_	zohreh	2024-04-18 08:32:30.944717
1023	0	t	526	group	1-Month-50G	1-Month-35G	2024-04-18 08:32:44.831941
1024	0	t	527	normal_username	_NOVALUE_	soheyl2	2024-04-18 13:46:02.981169
1025	0	t	430	first_login	2024-03-19 03:26	_NOVALUE_	2024-04-18 19:42:02.997724
1026	0	t	528	normal_username	_NOVALUE_	bama2070	2024-04-18 19:50:34.794341
1027	0	t	528	abs_exp_date	_NOVALUE_	2024-05-11 19:51	2024-04-18 19:51:00.530406
1078	0	t	271	first_login	2024-03-26 18:06	_NOVALUE_	2024-04-26 02:09:39.103265
1029	0	t	530	normal_username	_NOVALUE_	sanjabi20	2024-04-19 08:03:50.935793
1030	0	t	208	first_login	2024-03-20 04:44	_NOVALUE_	2024-04-19 16:28:02.324424
1031	0	t	208	group	1-Month-70G	1-Month-50G	2024-04-19 16:28:23.233186
1032	0	t	209	first_login	2024-03-20 06:59	_NOVALUE_	2024-04-19 16:31:06.131854
1033	0	t	210	first_login	2024-03-20 05:03	_NOVALUE_	2024-04-19 16:33:37.564619
1034	0	t	128	traffic_periodic_accounting_daily	39	_NOVALUE_	2024-04-20 03:51:58.290958
1035	0	t	128	traffic_periodic_accounting_daily_limit	50000M	_NOVALUE_	2024-04-20 03:51:58.290958
1036	0	t	128	traffic_periodic_accounting_daily_usage	113648458	_NOVALUE_	2024-04-20 03:51:58.290958
1037	0	t	531	normal_username	_NOVALUE_	moein	2024-04-20 17:00:37.122994
1038	0	t	367	first_login	2024-03-11 00:17	_NOVALUE_	2024-04-21 11:33:43.652876
1039	0	t	367	abs_exp_date	2024-04-17 18:03	_NOVALUE_	2024-04-21 11:34:03.01625
1040	0	t	532	normal_username	_NOVALUE_	ghazal	2024-04-21 14:02:01.567245
1041	0	t	532	abs_exp_date	_NOVALUE_	2024-05-19 14:05	2024-04-21 14:05:44.152086
1042	0	t	52	first_login	2024-02-08 16:31	_NOVALUE_	2024-04-21 14:34:34.441721
1043	0	t	52	abs_exp_date	2024-04-20 17:05	_NOVALUE_	2024-04-21 14:34:53.621305
1044	0	t	254	first_login	2024-03-22 11:55	_NOVALUE_	2024-04-21 14:37:39.417526
1045	0	t	397	first_login	2024-03-12 15:47	_NOVALUE_	2024-04-21 14:44:37.546729
1046	0	t	397	abs_exp_date	2024-04-25 13:52	_NOVALUE_	2024-04-21 14:44:46.830545
1047	0	t	397	traffic_periodic_accounting_daily	44	_NOVALUE_	2024-04-21 14:45:00.1159
1048	0	t	397	traffic_periodic_accounting_daily_limit	65000M	_NOVALUE_	2024-04-21 14:45:00.1159
1049	0	t	397	traffic_periodic_accounting_daily_usage	3374506808	_NOVALUE_	2024-04-21 14:45:00.1159
1050	0	t	397	group	2-Month-70G	1-Month-50G	2024-04-21 14:45:17.816147
1051	0	t	534	normal_username	_NOVALUE_	habibi1	2024-04-21 15:47:06.464458
1052	0	t	534	group	1-Month-100G	1-Month-35G	2024-04-21 16:06:08.891853
1053	0	t	535	normal_username	_NOVALUE_	maleki1	2024-04-21 16:11:32.426442
1054	0	t	536	normal_username	_NOVALUE_	habibi2	2024-04-21 16:14:36.176771
1055	0	t	537	normal_username	_NOVALUE_	mohammadi66	2024-04-22 04:51:53.099719
1056	0	t	113	first_login	2024-02-10 07:47	_NOVALUE_	2024-04-22 04:54:48.313046
1057	0	t	113	group	2-Month-70G	3-Month-150G	2024-04-22 04:55:20.920297
1058	0	t	275	first_login	2024-03-23 03:41	_NOVALUE_	2024-04-22 11:01:07.083625
1059	0	t	441	first_login	2024-03-23 09:40	_NOVALUE_	2024-04-22 13:56:39.468513
1060	0	t	260	first_login	2024-03-23 09:56	_NOVALUE_	2024-04-22 14:02:49.456077
1061	0	t	120	first_login	2024-03-20 06:06	_NOVALUE_	2024-04-22 16:33:17.394811
1063	0	t	442	first_login	2024-03-23 10:46	_NOVALUE_	2024-04-23 05:15:32.614749
1064	0	t	132	first_login	2024-03-24 05:49	_NOVALUE_	2024-04-23 08:34:08.932137
1065	0	t	132	multi_login	3	2	2024-04-23 08:34:45.542673
1066	0	t	394	first_login	2024-03-23 14:13	_NOVALUE_	2024-04-23 13:23:43.620973
1067	0	t	540	normal_username	_NOVALUE_	mehrabi	2024-04-24 05:39:13.00514
1068	0	t	542	normal_username	_NOVALUE_	samira3	2024-04-24 16:46:56.757024
1069	0	t	542	abs_exp_date	_NOVALUE_	2024-10-16 16:47	2024-04-24 16:47:33.324625
1070	0	t	543	normal_username	_NOVALUE_	imani2	2024-04-25 06:39:02.727376
1071	0	t	270	first_login	2024-03-25 07:00	_NOVALUE_	2024-04-25 09:06:26.480112
1072	0	t	179	first_login	2024-02-17 08:00	_NOVALUE_	2024-04-25 09:43:54.952925
1073	0	t	179	traffic_periodic_accounting_daily	68	_NOVALUE_	2024-04-25 09:44:17.434532
1074	0	t	179	traffic_periodic_accounting_daily_limit	120000M	_NOVALUE_	2024-04-25 09:44:17.434532
1075	0	t	179	traffic_periodic_accounting_daily_usage	42342835	_NOVALUE_	2024-04-25 09:44:17.434532
1076	0	t	269	first_login	2024-03-26 06:41	_NOVALUE_	2024-04-25 09:46:42.465278
1077	0	t	179	abs_exp_date	2024-04-25 08:32	_NOVALUE_	2024-04-25 09:56:26.561539
1079	0	t	462	first_login	2024-04-02 04:51	_NOVALUE_	2024-04-26 02:10:11.536256
1080	0	t	447	first_login	2024-03-27 04:10	_NOVALUE_	2024-04-26 05:30:01.101373
1081	0	t	544	normal_username	_NOVALUE_	salimian	2024-04-26 07:56:58.907755
1082	0	t	544	abs_exp_date	_NOVALUE_	2024-07-17 07:57	2024-04-26 07:57:32.905282
1083	0	t	545	normal_username	_NOVALUE_	bama2071	2024-04-26 11:22:31.07957
1084	0	t	546	normal_username	_NOVALUE_	bama2072	2024-04-26 11:22:31.07957
1085	0	t	547	normal_username	_NOVALUE_	bama2073	2024-04-26 11:22:31.07957
1086	0	t	548	normal_username	_NOVALUE_	bama2074	2024-04-26 11:22:31.07957
1087	0	t	549	normal_username	_NOVALUE_	bama2075	2024-04-26 11:22:31.07957
1088	0	t	550	normal_username	_NOVALUE_	bama2076	2024-04-26 11:22:31.07957
1089	0	t	551	normal_username	_NOVALUE_	bama2077	2024-04-26 11:22:31.07957
1090	0	t	552	normal_username	_NOVALUE_	bama2078	2024-04-26 11:22:31.07957
1091	0	t	553	normal_username	_NOVALUE_	bama2079	2024-04-26 11:22:31.07957
1092	0	t	554	normal_username	_NOVALUE_	bama2080	2024-04-26 11:22:31.07957
1093	0	t	556	normal_username	_NOVALUE_	alipoor2	2024-04-26 12:14:31.305101
1094	0	t	557	normal_username	_NOVALUE_	ebi	2024-04-27 05:49:55.418569
1095	0	t	300	first_login	2024-04-02 04:51	_NOVALUE_	2024-04-27 12:25:14.108473
1096	0	t	314	first_login	2024-04-02 04:51	_NOVALUE_	2024-04-27 12:25:35.304567
1097	0	t	279	first_login	2024-03-27 14:43	_NOVALUE_	2024-04-27 12:28:40.441287
1098	0	t	190	first_login	2024-03-27 02:06	_NOVALUE_	2024-04-27 12:34:57.745337
1099	0	t	278	first_login	2024-03-27 12:44	_NOVALUE_	2024-04-27 12:37:51.914299
1100	0	t	280	first_login	2024-03-28 06:11	_NOVALUE_	2024-04-27 13:05:31.202507
1101	0	t	432	first_login	2024-03-19 05:21	_NOVALUE_	2024-04-27 14:33:55.33474
1102	0	t	121	first_login	2024-02-11 15:36	_NOVALUE_	2024-04-27 15:06:15.642786
1103	0	t	121	abs_exp_date	2024-05-06 16:35	_NOVALUE_	2024-04-27 15:06:31.832165
1104	0	t	121	group	3-Month-150G	1-Month-35G	2024-04-27 15:07:59.564731
1105	0	t	558	normal_username	_NOVALUE_	alvani	2024-04-28 01:05:03.78084
1106	0	t	558	abs_exp_date	_NOVALUE_	2024-04-30 01:05	2024-04-28 01:05:19.805624
1107	0	t	375	first_login	2024-03-28 15:10	_NOVALUE_	2024-04-28 12:32:03.654276
1108	0	t	375	group	1-Month-35G	2-Month-70G	2024-04-28 12:32:23.365366
1109	0	t	242	first_login	2024-03-27 11:59	_NOVALUE_	2024-04-28 12:32:58.006099
1110	0	t	286	first_login	2024-03-29 09:17	_NOVALUE_	2024-04-28 14:04:20.001385
1111	0	t	560	normal_username	_NOVALUE_	ghasemi	2024-04-28 14:22:23.892463
1112	0	t	561	normal_username	_NOVALUE_	mohammad91	2024-04-28 14:27:52.380423
1113	0	t	562	normal_username	_NOVALUE_	batool	2024-04-28 15:48:43.738567
1114	0	t	201	first_login	2024-02-19 04:58	_NOVALUE_	2024-04-28 16:57:13.361279
1115	0	t	201	abs_exp_date	2024-04-29 05:47	_NOVALUE_	2024-04-28 16:57:25.952646
1116	0	t	201	traffic_periodic_accounting_daily	70	_NOVALUE_	2024-04-28 16:57:47.583557
1117	0	t	201	traffic_periodic_accounting_daily_limit	90000M	_NOVALUE_	2024-04-28 16:57:47.583557
1118	0	t	201	traffic_periodic_accounting_daily_usage	13228815335	_NOVALUE_	2024-04-28 16:57:47.583557
1119	0	t	563	normal_username	_NOVALUE_	kahari	2024-04-29 04:23:46.002868
1120	0	t	62	first_login	2024-02-08 17:00	_NOVALUE_	2024-04-29 04:48:16.896373
1121	0	t	62	abs_exp_date	2024-04-28 17:59	_NOVALUE_	2024-04-29 04:48:25.601614
1122	0	t	475	first_login	2024-04-05 17:05	_NOVALUE_	2024-04-29 05:54:44.088655
1123	0	t	475	abs_exp_date	2024-04-18 16:14	_NOVALUE_	2024-04-29 05:54:53.064208
1124	0	t	564	normal_username	_NOVALUE_	zhestmezon	2024-04-29 06:30:04.376268
1125	0	t	258	first_login	2024-03-26 05:51	_NOVALUE_	2024-04-29 07:06:11.080967
1126	0	t	112	first_login	2024-02-10 05:28	_NOVALUE_	2024-04-29 07:08:14.896562
1127	0	t	112	abs_exp_date	2024-04-28 06:29	_NOVALUE_	2024-04-29 07:08:25.204698
1128	0	t	252	first_login	2024-03-30 16:37	_NOVALUE_	2024-04-29 16:47:43.759576
1129	0	t	565	normal_username	_NOVALUE_	ansari	2024-04-30 03:28:56.573349
1130	0	t	565	traffic_periodic_accounting_daily	365	365	2024-04-30 03:31:39.385923
1131	0	t	565	traffic_periodic_accounting_daily_limit	600000M	350000M	2024-04-30 03:31:39.385923
1132	0	t	420	first_login	2024-04-17 03:40	_NOVALUE_	2024-04-30 06:18:00.347334
1133	0	t	566	normal_username	_NOVALUE_	mina	2024-04-30 07:59:54.978941
1134	0	t	164	first_login	2024-03-30 12:24	_NOVALUE_	2024-04-30 13:12:09.91487
1135	0	t	568	normal_username	_NOVALUE_	bama2081	2024-04-30 14:19:32.736252
1136	0	t	569	normal_username	_NOVALUE_	bama2082	2024-04-30 14:19:32.736252
1137	0	t	570	normal_username	_NOVALUE_	bama2083	2024-04-30 14:19:32.736252
1138	0	t	571	normal_username	_NOVALUE_	bama2084	2024-04-30 14:19:32.736252
1139	0	t	572	normal_username	_NOVALUE_	bama2085	2024-04-30 14:19:32.736252
1140	0	t	573	normal_username	_NOVALUE_	bama2086	2024-04-30 14:19:32.736252
1141	0	t	574	normal_username	_NOVALUE_	bama2087	2024-04-30 14:19:32.736252
1142	0	t	575	normal_username	_NOVALUE_	bama2088	2024-04-30 14:19:32.736252
1143	0	t	576	normal_username	_NOVALUE_	bama2089	2024-04-30 14:19:32.736252
1144	0	t	577	normal_username	_NOVALUE_	bama2090	2024-04-30 14:19:32.736252
1145	0	t	458	first_login	2024-03-31 12:16	_NOVALUE_	2024-04-30 15:51:43.415102
1146	0	t	579	normal_username	_NOVALUE_	nazanin10	2024-05-01 00:49:32.418637
1147	0	t	558	first_login	2024-04-28 02:36	_NOVALUE_	2024-05-01 11:42:15.6112
1148	0	t	558	abs_exp_date	2024-04-30 01:05	_NOVALUE_	2024-05-01 11:42:27.813095
1149	0	t	558	group	1-Month-10G	1-Month-35G	2024-05-01 11:44:11.192806
1150	0	t	310	first_login	2024-03-31 16:54	_NOVALUE_	2024-05-01 13:00:26.720947
1151	0	t	580	normal_username	_NOVALUE_	hidokht	2024-05-01 14:28:36.069067
1152	0	t	320	first_login	2024-04-01 08:19	_NOVALUE_	2024-05-01 16:32:55.55255
1153	0	t	319	first_login	2024-03-03 00:20	_NOVALUE_	2024-05-01 16:35:48.095549
1154	0	t	287	first_login	2024-04-01 12:26	_NOVALUE_	2024-05-02 04:38:45.186254
1155	0	t	301	first_login	2024-04-02 05:04	_NOVALUE_	2024-05-02 09:03:04.96828
1156	0	t	581	normal_username	_NOVALUE_	bama2091	2024-05-02 09:12:50.851634
1157	0	t	581	multi_login	2	4	2024-05-02 09:14:40.102755
1158	0	t	306	first_login	2024-04-01 18:17	_NOVALUE_	2024-05-02 11:37:25.306454
1159	0	t	315	first_login	2024-04-02 12:50	_NOVALUE_	2024-05-02 15:13:56.711478
1160	0	t	153	first_login	2024-04-03 05:02	_NOVALUE_	2024-05-03 05:40:17.401452
1161	0	t	108	first_login	2024-02-09 14:29	_NOVALUE_	2024-05-03 11:28:27.919516
1162	0	t	322	first_login	2024-04-03 12:23	_NOVALUE_	2024-05-03 11:35:21.067603
1163	0	t	582	normal_username	_NOVALUE_	mostafa110	2024-05-03 13:10:34.366125
1164	0	t	321	first_login	2024-04-05 14:27	_NOVALUE_	2024-05-04 02:46:10.139546
1165	0	t	448	first_login	2024-03-27 08:31	_NOVALUE_	2024-05-04 07:21:02.663669
1166	0	t	448	abs_exp_date	2024-05-05 04:12	_NOVALUE_	2024-05-04 07:21:17.598045
1167	0	t	534	group	1-Month-35G	1-Month-70G	2024-05-04 11:45:20.381978
1561	0	t	120	first_login	2024-05-14 08:08	_NOVALUE_	2024-06-15 08:38:13.417886
1170	0	t	316	first_login	2024-04-02 06:01	_NOVALUE_	2024-05-05 01:01:37.582927
1171	0	t	467	first_login	2024-04-04 11:21	_NOVALUE_	2024-05-05 08:22:33.970441
1172	0	t	336	first_login	2024-04-05 01:23	_NOVALUE_	2024-05-05 09:12:14.972892
1173	0	t	313	first_login	2024-04-02 07:27	_NOVALUE_	2024-05-05 10:23:04.986141
1174	0	t	90	first_login	2024-02-08 23:56	_NOVALUE_	2024-05-05 14:33:28.291904
1175	0	t	90	abs_exp_date	2024-05-03 19:38	_NOVALUE_	2024-05-05 14:33:35.63619
1176	0	t	90	traffic_periodic_accounting_daily	85	85	2024-05-05 14:33:47.667399
1177	0	t	90	traffic_periodic_accounting_daily	85	_NOVALUE_	2024-05-05 14:33:54.823876
1178	0	t	90	traffic_periodic_accounting_daily_limit	70000M	_NOVALUE_	2024-05-05 14:33:54.823876
1179	0	t	90	traffic_periodic_accounting_daily_usage	1015616829	_NOVALUE_	2024-05-05 14:33:54.823876
1180	0	t	90	multi_login	2	1	2024-05-05 14:34:14.154002
1181	0	t	436	first_login	2024-03-24 14:03	_NOVALUE_	2024-05-05 14:37:15.7652
1182	0	t	436	group	2-Month-70G	3-Month-150G	2024-05-05 14:37:27.399804
1183	0	t	436	traffic_periodic_accounting_daily	90	90	2024-05-05 14:38:27.408997
1184	0	t	436	traffic_periodic_accounting_daily_limit	150000M	100000M	2024-05-05 14:38:27.408997
1185	0	t	473	first_login	2024-04-05 11:15	_NOVALUE_	2024-05-05 14:48:53.275028
1186	0	t	277	first_login	2024-04-04 03:43	_NOVALUE_	2024-05-05 15:12:42.423406
1187	0	t	276	first_login	2024-04-04 06:31	_NOVALUE_	2024-05-05 15:13:02.736028
1188	0	t	380	first_login	2024-04-05 12:36	_NOVALUE_	2024-05-05 15:17:55.436108
1189	0	t	387	first_login	2024-04-08 12:10	_NOVALUE_	2024-05-05 15:18:39.020805
1190	0	t	583	normal_username	_NOVALUE_	bama2058	2024-05-05 15:20:21.260666
1191	0	t	584	normal_username	_NOVALUE_	khavari	2024-05-05 15:41:22.899681
1192	0	t	472	first_login	2024-04-06 13:14	_NOVALUE_	2024-05-06 05:18:12.704328
1193	0	t	202	first_login	2024-04-03 03:53	_NOVALUE_	2024-05-06 08:30:41.662863
1194	0	t	340	first_login	2024-04-06 07:15	_NOVALUE_	2024-05-06 15:25:07.921223
1195	0	t	348	first_login	2024-04-06 11:34	_NOVALUE_	2024-05-06 15:28:33.505201
1196	0	t	585	normal_username	_NOVALUE_	fereshteh	2024-05-06 15:30:52.637066
1197	0	t	585	abs_exp_date	_NOVALUE_	2024-05-31 15:31	2024-05-06 15:31:21.352977
1198	0	t	89	first_login	2024-02-10 06:40	_NOVALUE_	2024-05-07 03:57:13.265359
1199	0	t	89	abs_exp_date	2024-05-05 19:36	_NOVALUE_	2024-05-07 03:57:51.634455
1200	0	t	345	first_login	2024-04-06 13:55	_NOVALUE_	2024-05-07 04:23:12.446416
1201	0	t	461	first_login	2024-04-01 16:06	_NOVALUE_	2024-05-07 07:00:34.332782
1202	0	t	354	first_login	2024-04-09 07:19	_NOVALUE_	2024-05-07 08:27:07.834846
1203	0	t	353	first_login	2024-04-07 14:24	_NOVALUE_	2024-05-07 15:32:37.761577
1204	0	t	39	first_login	2024-04-07 10:12	_NOVALUE_	2024-05-07 15:33:26.296763
1205	0	t	352	first_login	2024-04-07 08:59	_NOVALUE_	2024-05-07 15:33:55.771383
1206	0	t	586	normal_username	_NOVALUE_	alipoor3	2024-05-08 07:39:32.359275
1207	0	t	536	group	1-Month-35G	1-Month-70G	2024-05-08 14:03:15.922796
1208	0	t	391	first_login	2024-04-09 16:18	_NOVALUE_	2024-05-08 14:42:00.090663
1209	0	t	587	normal_username	_NOVALUE_	akbar6	2024-05-08 15:21:12.678423
1210	0	t	587	abs_exp_date	_NOVALUE_	2024-09-13 15:21	2024-05-08 15:21:25.752508
1211	0	t	248	first_login	2024-02-20 16:33	_NOVALUE_	2024-05-08 15:22:53.564304
1212	0	t	248	abs_exp_date	2024-05-08 17:19	_NOVALUE_	2024-05-08 15:23:01.484975
1213	0	t	24	first_login	2024-02-08 14:07	_NOVALUE_	2024-05-08 15:23:52.039669
1214	0	t	588	normal_username	_NOVALUE_	bama2064	2024-05-08 16:09:27.565753
1215	0	t	399	first_login	2024-04-12 03:57	_NOVALUE_	2024-05-09 01:19:32.928172
1216	0	t	356	first_login	2024-04-09 03:39	_NOVALUE_	2024-05-09 04:46:35.702491
1217	0	t	76	first_login	2024-02-08 17:54	_NOVALUE_	2024-05-09 04:48:54.515093
1218	0	t	589	normal_username	_NOVALUE_	habibi4	2024-05-09 05:38:11.273091
1219	0	t	464	group	1-Month-35G	3-Month-150G	2024-05-09 09:09:02.891035
1220	0	t	464	group	3-Month-150G	2-Month-70G	2024-05-09 09:09:35.562647
1221	0	t	464	first_login	2024-04-02 16:47	_NOVALUE_	2024-05-09 09:09:54.389793
1222	0	t	465	group	1-Month-35G	2-Month-70G	2024-05-09 09:10:15.009797
1223	0	t	465	first_login	2024-04-02 16:51	_NOVALUE_	2024-05-09 09:10:23.489684
1224	0	t	364	first_login	2024-04-09 06:38	_NOVALUE_	2024-05-09 09:37:23.882737
1225	0	t	361	first_login	2024-04-09 08:23	_NOVALUE_	2024-05-09 12:59:59.199726
1228	0	t	504	first_login	2024-04-09 15:44	_NOVALUE_	2024-05-10 09:07:59.531924
1229	0	t	390	first_login	2024-04-09 09:34	_NOVALUE_	2024-05-10 16:51:01.161397
1230	0	t	116	first_login	2024-02-10 11:53	_NOVALUE_	2024-05-11 06:02:06.642375
1234	0	t	590	normal_username	_NOVALUE_	bama2092	2024-05-11 12:55:16.880378
1235	0	t	591	normal_username	_NOVALUE_	bama2093	2024-05-11 12:55:16.880378
1236	0	t	592	normal_username	_NOVALUE_	bama2094	2024-05-11 12:55:16.880378
1237	0	t	593	normal_username	_NOVALUE_	bama2095	2024-05-11 12:55:16.880378
1238	0	t	594	normal_username	_NOVALUE_	bama2096	2024-05-11 12:55:16.880378
1239	0	t	595	normal_username	_NOVALUE_	bama2097	2024-05-11 12:55:16.880378
1240	0	t	596	normal_username	_NOVALUE_	bama2098	2024-05-11 12:55:16.880378
1241	0	t	597	normal_username	_NOVALUE_	bama2099	2024-05-11 12:55:16.880378
1242	0	t	598	normal_username	_NOVALUE_	bama2100	2024-05-11 12:55:16.880378
1243	0	t	599	normal_username	_NOVALUE_	bama2101	2024-05-11 12:55:16.880378
1247	0	t	450	first_login	2024-04-12 17:32	_NOVALUE_	2024-05-12 11:43:03.797617
1250	0	t	528	abs_exp_date	2024-05-11 19:51	_NOVALUE_	2024-05-12 13:58:16.865025
1251	0	t	509	first_login	2024-04-12 17:00	_NOVALUE_	2024-05-13 02:32:50.750851
1253	0	t	401	first_login	2024-03-13 14:47	_NOVALUE_	2024-05-13 05:26:46.748525
1256	0	t	311	abs_exp_date	2024-05-04 16:53	_NOVALUE_	2024-05-13 08:34:49.372583
1257	0	t	311	group	2-Month-70G	1-Month-35G	2024-05-13 08:35:02.658877
1258	0	t	602	normal_username	_NOVALUE_	shekufeh	2024-05-13 15:41:03.593417
1261	0	t	603	normal_username	_NOVALUE_	najafi	2024-05-13 17:03:04.978419
1262	0	t	604	normal_username	_NOVALUE_	harandi	2024-05-13 17:07:47.383852
1263	0	t	335	first_login	2024-04-11 07:16	_NOVALUE_	2024-05-14 01:46:23.275587
1264	0	t	408	first_login	2024-03-14 16:42	_NOVALUE_	2024-05-14 02:15:44.045476
1265	0	t	408	group	2-Month-70G	3-Month-150G	2024-05-14 02:15:54.126348
1266	0	t	512	first_login	2024-04-14 02:42	_NOVALUE_	2024-05-14 06:18:58.518196
1269	0	t	158	first_login	2024-02-14 05:57	_NOVALUE_	2024-05-14 12:42:39.070549
1271	0	t	514	first_login	2024-04-14 13:45	_NOVALUE_	2024-05-14 14:20:51.399464
1272	0	t	46	multi_login	2	1	2024-05-14 16:26:46.192751
1273	0	t	606	normal_username	_NOVALUE_	hossein	2024-05-14 16:28:41.050824
1276	0	t	516	first_login	2024-04-15 02:07	_NOVALUE_	2024-05-15 07:04:53.035923
1282	0	t	607	traffic_periodic_accounting_daily	90	90	2024-05-15 16:27:12.87854
1283	0	t	607	traffic_periodic_accounting_daily_limit	30M	30000M	2024-05-15 16:27:12.87854
1284	0	t	103	first_login	2024-04-15 15:19	_NOVALUE_	2024-05-15 17:29:06.570868
1286	0	t	134	first_login	2024-04-15 17:53	_NOVALUE_	2024-05-16 10:37:35.175607
1290	0	t	428	first_login	2024-04-17 14:15	_NOVALUE_	2024-05-17 04:32:06.254586
1292	0	t	181	first_login	2024-02-17 08:37	_NOVALUE_	2024-05-17 14:32:46.648115
1295	0	t	609	normal_username	_NOVALUE_	saeed	2024-05-17 15:27:37.202972
1296	0	t	429	first_login	2024-04-17 14:23	_NOVALUE_	2024-05-17 17:11:01.229831
1297	0	t	534	first_login	2024-04-22 05:15	_NOVALUE_	2024-05-18 12:46:48.388806
1298	0	t	534	group	1-Month-70G	1-Month-35G	2024-05-18 12:48:03.857149
1299	0	t	610	normal_username	_NOVALUE_	habibi1	2024-05-18 13:33:54.953651
1302	0	t	526	first_login	2024-04-18 09:21	_NOVALUE_	2024-05-18 16:35:42.33153
1303	0	t	526	group	1-Month-35G	3-month-100-G-bama	2024-05-18 16:35:58.117066
1304	0	t	271	first_login	2024-04-26 06:14	_NOVALUE_	2024-05-19 12:45:56.621081
1305	0	t	611	normal_username	_NOVALUE_	javdani	2024-05-19 12:51:44.274301
1581	0	t	716	abs_exp_date	_NOVALUE_	2024-07-10 05:53	2024-06-18 05:53:40.093331
1312	0	t	508	abs_exp_date	2024-04-27 16:14	_NOVALUE_	2024-05-19 13:44:02.990504
1315	0	t	532	first_login	2024-04-21 15:02	_NOVALUE_	2024-05-19 14:24:21.30377
1317	0	t	527	first_login	2024-04-18 13:46	_NOVALUE_	2024-05-19 14:42:14.727179
1319	0	t	603	multi_login	2	4	2024-05-20 02:42:15.55267
1337	0	t	187	first_login	2024-02-17 14:16	_NOVALUE_	2024-05-21 12:13:03.880626
1323	0	t	615	normal_username	_NOVALUE_	bama2102	2024-05-20 05:44:50.68122
1324	0	t	616	normal_username	_NOVALUE_	bama2103	2024-05-20 05:44:50.68122
1325	0	t	617	normal_username	_NOVALUE_	bama2104	2024-05-20 05:44:50.68122
1326	0	t	618	normal_username	_NOVALUE_	bama2105	2024-05-20 05:44:50.68122
1327	0	t	619	normal_username	_NOVALUE_	bama2106	2024-05-20 05:44:50.68122
1328	0	t	620	normal_username	_NOVALUE_	bama2107	2024-05-20 05:44:50.68122
1329	0	t	621	normal_username	_NOVALUE_	bama2108	2024-05-20 05:44:50.68122
1330	0	t	622	normal_username	_NOVALUE_	bama2109	2024-05-20 05:44:50.68122
1331	0	t	623	normal_username	_NOVALUE_	bama2110	2024-05-20 05:44:50.68122
1332	0	t	624	normal_username	_NOVALUE_	bama2111	2024-05-20 05:44:50.68122
1333	0	t	209	first_login	2024-04-19 22:13	_NOVALUE_	2024-05-20 08:12:44.608095
1338	0	t	187	group	3-Month-150G	12-Month-600G	2024-05-21 12:13:18.187215
1339	0	t	254	first_login	2024-04-21 14:41	_NOVALUE_	2024-05-21 15:50:04.883917
1341	0	t	275	first_login	2024-04-22 12:58	_NOVALUE_	2024-05-22 14:01:04.293519
1343	0	t	260	first_login	2024-04-22 14:15	_NOVALUE_	2024-05-22 16:22:22.175388
1344	0	t	280	first_login	2024-04-27 13:09	_NOVALUE_	2024-05-23 05:51:17.552681
1347	0	t	257	first_login	2024-02-23 05:55	_NOVALUE_	2024-05-23 14:02:54.391742
1353	0	t	628	normal_username	_NOVALUE_	bama2058	2024-05-24 15:58:47.22121
1355	0	t	132	group	1-Month-50G	2-Month-70G	2024-05-25 03:15:04.690154
1356	0	t	269	first_login	2024-04-25 11:24	_NOVALUE_	2024-05-25 12:09:45.211963
1358	0	t	531	multi_login	1	2	2024-05-25 12:38:40.568609
1360	0	t	355	first_login	2024-03-08 15:20	_NOVALUE_	2024-05-25 13:59:01.580828
1361	0	t	318	first_login	2024-03-02 22:01	_NOVALUE_	2024-05-25 16:17:28.879662
1362	0	t	462	first_login	2024-04-26 03:14	_NOVALUE_	2024-05-26 06:11:13.383106
1366	0	t	203	first_login	2024-02-19 08:18	_NOVALUE_	2024-05-26 08:28:40.072605
1367	0	t	203	group	3-Month-150G	3-month-100-G-bama	2024-05-26 08:29:03.903169
1368	0	t	203	normal_username	abolfazl2	ab2	2024-05-26 08:31:29.116201
1369	0	t	203	group	3-month-100-G-bama	6-Month-300G	2024-05-26 08:31:53.194367
1370	0	t	536	first_login	2024-04-22 00:44	_NOVALUE_	2024-05-26 14:21:50.737348
1226	0	t	481	first_login	2024-04-09 06:45	_NOVALUE_	2024-05-09 16:02:31.065852
1859	0	t	662	first_login	2024-06-03 08:49	_NOVALUE_	2024-07-20 16:59:03.224477
1232	0	t	118	first_login	2024-02-10 11:56	_NOVALUE_	2024-05-11 08:58:01.181862
1233	0	t	84	first_login	2024-04-10 10:03	_NOVALUE_	2024-05-11 12:24:42.261166
1244	0	t	601	normal_username	_NOVALUE_	maral2	2024-05-11 13:03:05.460397
1248	0	t	145	first_login	2024-02-12 05:42	_NOVALUE_	2024-05-12 11:45:59.952458
1254	0	t	401	group	2-Month-70G	3-Month-150G	2024-05-13 05:27:02.226266
1259	0	t	602	abs_exp_date	_NOVALUE_	2024-05-31 15:42	2024-05-13 15:42:24.547708
1260	0	t	480	first_login	2024-04-18 02:24	_NOVALUE_	2024-05-13 15:43:22.900594
1267	0	t	409	first_login	2024-04-14 07:36	_NOVALUE_	2024-05-14 08:05:25.160979
1270	0	t	605	normal_username	_NOVALUE_	mirzaei	2024-05-14 14:09:02.324901
1274	0	t	349	first_login	2024-04-09 08:34	_NOVALUE_	2024-05-15 01:27:29.323018
1275	0	t	350	first_login	2024-04-14 06:56	_NOVALUE_	2024-05-15 01:28:02.804182
1277	0	t	400	first_login	2024-04-15 07:17	_NOVALUE_	2024-05-15 15:08:31.189583
1279	0	t	607	normal_username	_NOVALUE_	ayousefi2	2024-05-15 16:26:08.097718
1280	0	t	607	traffic_periodic_accounting_daily	90	90	2024-05-15 16:26:56.065346
1281	0	t	607	traffic_periodic_accounting_daily_limit	150000M	30M	2024-05-15 16:26:56.065346
1285	0	t	171	first_login	2024-04-15 17:19	_NOVALUE_	2024-05-15 19:04:06.252018
1287	0	t	198	first_login	2024-02-18 17:48	_NOVALUE_	2024-05-16 14:00:58.19805
1288	0	t	198	abs_exp_date	2024-05-15 18:01	_NOVALUE_	2024-05-16 14:01:07.119918
1291	0	t	522	first_login	2024-04-17 03:01	_NOVALUE_	2024-05-17 07:45:48.488919
1300	0	t	413	first_login	2024-04-17 05:18	_NOVALUE_	2024-05-18 14:59:46.207422
1306	0	t	430	first_login	2024-04-19 03:27	_NOVALUE_	2024-05-19 12:54:54.448078
1313	0	t	508	group	1-Month-35G	1-Month-20G	2024-05-19 13:44:46.681279
1314	0	t	612	normal_username	_NOVALUE_	roodaki	2024-05-19 14:22:33.998462
1316	0	t	532	abs_exp_date	2024-05-19 14:05	_NOVALUE_	2024-05-19 14:24:28.480813
1340	0	t	627	normal_username	_NOVALUE_	aliasadi	2024-05-21 15:54:38.95596
1334	0	t	210	first_login	2024-04-19 22:53	_NOVALUE_	2024-05-20 08:13:05.4343
1335	0	t	282	first_login	2024-02-26 13:22	_NOVALUE_	2024-05-20 12:15:59.09425
1336	0	t	282	abs_exp_date	2024-05-19 14:19	_NOVALUE_	2024-05-20 12:16:09.651452
1342	0	t	441	first_login	2024-04-22 13:58	_NOVALUE_	2024-05-22 15:45:40.255119
1345	0	t	176	lock	_NOVALUE_		2024-05-23 07:15:48.73275
1350	0	t	531	multi_login	2	1	2024-05-23 14:06:10.659741
1351	0	t	394	first_login	2024-04-23 13:25	_NOVALUE_	2024-05-23 14:17:05.659459
1354	0	t	132	first_login	2024-04-23 08:57	_NOVALUE_	2024-05-25 03:14:54.957341
1357	0	t	269	group	1-Month-35G	3-Month-150G	2024-05-25 12:10:32.222995
1363	0	t	270	first_login	2024-04-25 09:22	_NOVALUE_	2024-05-26 06:12:15.551573
1371	0	t	536	group	1-Month-70G	1-Month-50G	2024-05-26 14:22:21.148399
1372	0	t	630	normal_username	_NOVALUE_	habibi2	2024-05-26 14:23:28.913243
1385	0	t	283	first_login	2024-02-26 15:25	_NOVALUE_	2024-05-27 06:00:36.294417
1387	0	t	513	first_login	2024-04-14 10:04	_NOVALUE_	2024-05-27 13:39:26.457406
1388	0	t	281	first_login	2024-02-26 13:16	_NOVALUE_	2024-05-27 13:53:22.847613
1390	0	t	646	normal_username	_NOVALUE_	ghadimi	2024-05-27 16:32:41.687906
1394	0	t	279	first_login	2024-04-27 13:20	_NOVALUE_	2024-05-28 02:02:08.397998
1395	0	t	314	first_login	2024-04-27 12:40	_NOVALUE_	2024-05-28 06:07:02.530178
1401	0	t	336	first_login	2024-05-05 09:17	_NOVALUE_	2024-05-28 12:00:52.674999
1402	0	t	561	first_login	2024-04-28 14:51	_NOVALUE_	2024-05-28 16:23:05.285822
1404	0	t	121	first_login	2024-04-28 05:41	_NOVALUE_	2024-05-29 05:47:14.715552
1412	0	t	652	normal_username	_NOVALUE_	mostafa111	2024-05-30 09:18:26.770009
1410	0	t	1	multi_login	2	2	2024-05-29 15:53:31.165981
1411	0	t	252	first_login	2024-04-29 16:54	_NOVALUE_	2024-05-30 02:38:10.08023
1414	0	t	653	normal_username	_NOVALUE_	khoshghadam	2024-05-30 09:40:59.280139
1416	0	t	646	first_login	2024-05-28 16:01	_NOVALUE_	2024-05-31 03:33:05.323943
1418	0	t	579	first_login	2024-05-01 01:30	_NOVALUE_	2024-05-31 04:12:23.320444
1420	0	t	341	first_login	2024-03-06 11:00	_NOVALUE_	2024-05-31 05:43:59.802351
1421	0	t	341	group	3-Month-150G	6-Month-300G	2024-05-31 05:47:18.617857
1423	0	t	431	first_login	2024-03-18 17:24	_NOVALUE_	2024-05-31 16:37:33.568341
1424	0	t	377	first_login	2024-04-03 14:26	_NOVALUE_	2024-05-31 16:39:21.942773
1425	0	t	655	normal_username	_NOVALUE_	bama2122	2024-05-31 16:41:23.77945
1426	0	t	656	normal_username	_NOVALUE_	bama2123	2024-05-31 16:41:23.77945
1427	0	t	657	normal_username	_NOVALUE_	bama2124	2024-05-31 16:41:23.77945
1428	0	t	658	normal_username	_NOVALUE_	bama2125	2024-05-31 16:41:23.77945
1429	0	t	659	normal_username	_NOVALUE_	bama2126	2024-05-31 16:41:23.77945
1430	0	t	660	normal_username	_NOVALUE_	bama2127	2024-05-31 16:41:23.77945
1431	0	t	661	normal_username	_NOVALUE_	bama2128	2024-05-31 16:41:23.77945
1432	0	t	662	normal_username	_NOVALUE_	bama2129	2024-05-31 16:41:23.77945
1433	0	t	663	normal_username	_NOVALUE_	bama2130	2024-05-31 16:41:23.77945
1434	0	t	664	normal_username	_NOVALUE_	bama2131	2024-05-31 16:41:23.77945
1436	0	t	258	first_login	2024-04-29 07:19	_NOVALUE_	2024-06-01 04:27:38.59468
1438	0	t	310	first_login	2024-05-01 13:04	_NOVALUE_	2024-06-01 04:32:05.058491
1439	0	t	305	first_login	2024-02-29 13:56	_NOVALUE_	2024-06-01 06:40:34.425081
1440	0	t	305	group	3-Month-250G	6-Month-300G	2024-06-01 06:40:45.849928
1442	0	t	666	normal_username	_NOVALUE_	elna	2024-06-01 13:50:24.97142
1444	0	t	319	first_login	2024-05-01 16:36	_NOVALUE_	2024-06-01 14:40:31.406434
1445	0	t	319	first_login	2024-06-01 14:37	_NOVALUE_	2024-06-01 14:40:40.676695
1449	0	t	315	first_login	2024-05-02 15:29	_NOVALUE_	2024-06-01 16:16:22.896262
1451	0	t	668	normal_username	_NOVALUE_	tdmsm2	2024-06-02 08:05:40.986069
1454	0	t	448	group	2-Month-70G	1-Month-50G	2024-06-02 15:30:22.563707
1455	0	t	448	first_login	2024-05-04 12:32	_NOVALUE_	2024-06-02 15:30:38.809897
1456	0	t	669	normal_username	_NOVALUE_	ashraf	2024-06-03 04:34:39.254349
1457	0	t	669	group	12-Month-600G	12-Month-800G	2024-06-03 04:34:54.462006
1459	0	t	321	first_login	2024-05-04 02:49	_NOVALUE_	2024-06-03 05:40:51.968062
1227	0	t	481	group	1-Month-35G	3-month-100-G-bama	2024-05-09 16:02:47.435992
1245	0	t	477	first_login	2024-04-07 15:53	_NOVALUE_	2024-05-11 14:44:02.76867
1246	0	t	393	first_login	2024-04-11 12:23	_NOVALUE_	2024-05-11 14:56:35.198984
1249	0	t	528	first_login	2024-04-20 18:11	_NOVALUE_	2024-05-12 13:58:06.252552
1252	0	t	509	group	1-Month-50G	3-Month-150G	2024-05-13 02:33:45.067273
1255	0	t	311	first_login	2024-04-01 15:09	_NOVALUE_	2024-05-13 08:34:37.192473
1268	0	t	120	first_login	2024-04-22 16:33	_NOVALUE_	2024-05-14 08:06:14.167079
1278	0	t	402	first_login	2024-04-14 16:32	_NOVALUE_	2024-05-15 15:08:57.779974
1289	0	t	200	first_login	2024-04-16 12:55	_NOVALUE_	2024-05-16 14:04:04.879327
1293	0	t	423	first_login	2024-04-17 08:15	_NOVALUE_	2024-05-17 14:37:39.084205
1294	0	t	595	group	1-Month-20G	3-month-100-G-bama	2024-05-17 14:50:53.492576
1301	0	t	419	first_login	2024-04-18 11:44	_NOVALUE_	2024-05-18 15:46:15.605242
1307	0	t	430	group	1-Month-35G	2-Month-70G	2024-05-19 12:55:15.290057
1582	0	t	428	first_login	2024-05-17 05:37	_NOVALUE_	2024-06-18 06:38:09.058566
1583	0	t	596	first_login	2024-05-18 07:40	_NOVALUE_	2024-06-18 08:07:04.114518
1311	0	t	508	first_login	2024-04-13 11:19	_NOVALUE_	2024-05-19 13:43:45.97433
1318	0	t	613	normal_username	_NOVALUE_	m41	2024-05-19 15:19:53.162773
1320	0	t	208	first_login	2024-04-19 16:50	_NOVALUE_	2024-05-20 02:56:07.437297
1346	0	t	442	first_login	2024-04-23 05:39	_NOVALUE_	2024-05-23 13:22:01.728722
1348	0	t	531	first_login	2024-04-20 19:48	_NOVALUE_	2024-05-23 14:03:43.658649
1349	0	t	531	group	1-Month-100G	3-Month-150G	2024-05-23 14:03:59.222631
1352	0	t	176	lock		_NOVALUE_	2024-05-23 17:34:34.485604
1359	0	t	531	multi_login	2	_NOVALUE_	2024-05-25 12:38:49.666972
1364	0	t	629	normal_username	_NOVALUE_	makki1	2024-05-26 06:41:00.7785
1365	0	t	274	first_login	2024-02-25 23:34	_NOVALUE_	2024-05-26 06:43:19.533888
1373	0	t	447	first_login	2024-04-26 05:30	_NOVALUE_	2024-05-26 16:53:05.532862
1374	0	t	631	normal_username	_NOVALUE_	bama2112	2024-05-26 17:24:07.16982
1375	0	t	632	normal_username	_NOVALUE_	bama2113	2024-05-26 17:24:07.16982
1376	0	t	633	normal_username	_NOVALUE_	bama2114	2024-05-26 17:24:07.16982
1377	0	t	634	normal_username	_NOVALUE_	bama2115	2024-05-26 17:24:07.16982
1378	0	t	635	normal_username	_NOVALUE_	bama2116	2024-05-26 17:24:07.16982
1379	0	t	636	normal_username	_NOVALUE_	bama2117	2024-05-26 17:24:07.16982
1380	0	t	637	normal_username	_NOVALUE_	bama2118	2024-05-26 17:24:07.16982
1381	0	t	638	normal_username	_NOVALUE_	bama2119	2024-05-26 17:24:07.16982
1382	0	t	639	normal_username	_NOVALUE_	bama2120	2024-05-26 17:24:07.16982
1383	0	t	640	normal_username	_NOVALUE_	bama2121	2024-05-26 17:24:07.16982
1384	0	t	644	normal_username	_NOVALUE_	elham1	2024-05-26 17:29:15.774853
1386	0	t	645	normal_username	_NOVALUE_	mirzayi	2024-05-27 10:20:09.153366
1389	0	t	307	first_login	2024-03-01 03:45	_NOVALUE_	2024-05-27 13:54:45.860951
1391	0	t	646	abs_exp_date	_NOVALUE_	2024-05-30 16:33	2024-05-27 16:33:00.279251
1392	0	t	647	normal_username	_NOVALUE_	fatemeh1	2024-05-27 16:42:57.800845
1393	0	t	648	normal_username	_NOVALUE_	fatemeh2	2024-05-27 16:44:05.731647
1396	0	t	300	first_login	2024-04-27 15:23	_NOVALUE_	2024-05-28 06:07:18.529408
1397	0	t	398	lock	_NOVALUE_		2024-05-28 08:08:05.826631
1398	0	t	190	first_login	2024-04-27 23:35	_NOVALUE_	2024-05-28 09:34:31.691131
1399	0	t	278	first_login	2024-04-27 12:56	_NOVALUE_	2024-05-28 09:34:53.986807
1400	0	t	164	first_login	2024-04-30 13:16	_NOVALUE_	2024-05-28 09:59:33.437227
1403	0	t	649	normal_username	_NOVALUE_	tdmsm	2024-05-29 01:51:12.588366
1405	0	t	650	normal_username	_NOVALUE_	melika	2024-05-29 05:52:19.249249
1413	0	t	286	first_login	2024-04-28 14:34	_NOVALUE_	2024-05-30 09:34:59.479135
1419	0	t	341	abs_exp_date	2024-06-01 11:57	_NOVALUE_	2024-05-31 05:43:47.087478
1417	0	t	646	abs_exp_date	2024-05-30 16:33	_NOVALUE_	2024-05-31 03:33:20.873617
1422	0	t	458	first_login	2024-04-30 16:08	_NOVALUE_	2024-05-31 15:17:21.464682
1435	0	t	320	first_login	2024-05-01 16:38	_NOVALUE_	2024-06-01 01:47:19.614678
1437	0	t	566	first_login	2024-04-30 08:42	_NOVALUE_	2024-06-01 04:30:13.990395
1441	0	t	287	first_login	2024-05-02 04:39	_NOVALUE_	2024-06-01 11:29:35.74596
1443	0	t	319	group	2-Month-70G	1-Month-35G	2024-06-01 14:39:57.657276
1446	0	t	666	group	1-Month-35G	3-Month-150G	2024-06-01 15:02:09.730106
1447	0	t	667	normal_username	_NOVALUE_	azam	2024-06-01 15:13:52.385769
1448	0	t	1	multi_login	2	_NOVALUE_	2024-06-01 15:44:45.893977
1450	0	t	420	first_login	2024-04-30 06:19	_NOVALUE_	2024-06-02 03:53:56.566543
1452	0	t	602	first_login	2024-05-14 02:58	_NOVALUE_	2024-06-02 15:12:51.452517
1453	0	t	602	abs_exp_date	2024-05-31 15:42	_NOVALUE_	2024-06-02 15:13:06.290786
1458	0	t	322	first_login	2024-05-03 11:42	_NOVALUE_	2024-06-03 05:24:49.124431
1460	0	t	610	group	1-Month-35G	1-Month-70G	2024-06-03 11:42:56.764186
1461	0	t	411	first_login	2024-03-17 05:02	_NOVALUE_	2024-06-04 04:20:11.331682
1462	0	t	411	abs_exp_date	2024-06-04 06:27	_NOVALUE_	2024-06-04 04:20:21.869958
1463	0	t	411	group	3-Month-150G	6-Month-300G	2024-06-04 04:20:39.064536
1562	0	t	593	first_login	2024-05-15 12:12	_NOVALUE_	2024-06-15 12:46:34.025594
1465	0	t	582	first_login	2024-05-03 16:24	_NOVALUE_	2024-06-04 09:37:42.854135
1466	0	t	670	normal_username	_NOVALUE_	bama2132	2024-06-04 15:00:54.572605
1467	0	t	671	normal_username	_NOVALUE_	bama2133	2024-06-04 15:00:54.572605
1468	0	t	672	normal_username	_NOVALUE_	bama2134	2024-06-04 15:00:54.572605
1469	0	t	673	normal_username	_NOVALUE_	bama2135	2024-06-04 15:00:54.572605
1470	0	t	674	normal_username	_NOVALUE_	bama2136	2024-06-04 15:00:54.572605
1471	0	t	675	normal_username	_NOVALUE_	bama2137	2024-06-04 15:00:54.572605
1472	0	t	676	normal_username	_NOVALUE_	bama2138	2024-06-04 15:00:54.572605
1473	0	t	677	normal_username	_NOVALUE_	bama2139	2024-06-04 15:00:54.572605
1474	0	t	678	normal_username	_NOVALUE_	bama2140	2024-06-04 15:00:54.572605
1475	0	t	679	normal_username	_NOVALUE_	bama2141	2024-06-04 15:00:54.572605
1476	0	t	344	first_login	2024-03-06 16:08	_NOVALUE_	2024-06-05 02:51:35.354561
1477	0	t	344	group	3-Month-150G	6-Month-300G	2024-06-05 02:51:55.480264
1478	0	t	399	first_login	2024-05-09 01:23	_NOVALUE_	2024-06-05 12:52:38.292023
1479	0	t	340	first_login	2024-05-06 15:27	_NOVALUE_	2024-06-05 14:16:52.621143
1480	0	t	682	normal_username	_NOVALUE_	m42	2024-06-05 15:07:34.174336
1481	0	t	316	first_login	2024-05-05 01:17	_NOVALUE_	2024-06-05 15:13:25.846263
1482	0	t	277	first_login	2024-05-05 15:26	_NOVALUE_	2024-06-05 15:23:08.629673
1483	0	t	276	first_login	2024-05-06 02:20	_NOVALUE_	2024-06-05 15:25:47.96768
1484	0	t	683	normal_username	_NOVALUE_	tst	2024-06-06 01:41:06.155381
1485	0	t	683	abs_exp_date	_NOVALUE_	2024-06-09 01:41	2024-06-06 01:41:40.069935
1486	0	t	380	first_login	2024-05-05 15:20	_NOVALUE_	2024-06-06 08:26:18.085266
1487	0	t	572	first_login	2024-05-06 11:20	_NOVALUE_	2024-06-06 08:30:40.161861
1488	0	t	348	first_login	2024-05-06 15:46	_NOVALUE_	2024-06-06 08:43:24.846978
1489	0	t	345	first_login	2024-05-07 05:27	_NOVALUE_	2024-06-06 08:56:56.762577
1490	0	t	584	first_login	2024-05-05 15:53	_NOVALUE_	2024-06-06 15:52:39.808228
1491	0	t	584	group	1-Month-100G	1-Month-35G	2024-06-06 15:53:02.699263
1492	0	t	353	first_login	2024-05-08 01:59	_NOVALUE_	2024-06-07 03:44:33.15644
1493	0	t	581	first_login	2024-05-02 10:12	_NOVALUE_	2024-06-07 05:39:46.572243
1494	0	t	352	first_login	2024-05-08 05:03	_NOVALUE_	2024-06-07 07:05:35.033997
1495	0	t	39	first_login	2024-05-08 01:21	_NOVALUE_	2024-06-07 07:06:01.627318
1496	0	t	684	normal_username	_NOVALUE_	firoozeh	2024-06-07 14:41:38.952533
1497	0	t	472	first_login	2024-05-06 05:19	_NOVALUE_	2024-06-07 15:25:26.849838
1498	0	t	391	first_login	2024-05-08 14:43	_NOVALUE_	2024-06-07 16:18:07.850126
1499	0	t	685	normal_username	_NOVALUE_	fatah	2024-06-07 16:35:22.474921
1500	0	t	358	first_login	2024-03-09 13:35	_NOVALUE_	2024-06-07 17:31:26.499046
1501	0	t	358	group	3-Month-150G	12-Month-600G	2024-06-07 17:32:16.268027
1502	0	t	601	first_login	2024-05-11 13:10	_NOVALUE_	2024-06-08 05:34:00.071315
1503	0	t	313	first_login	2024-05-05 11:00	_NOVALUE_	2024-06-08 05:47:16.851226
1504	0	t	202	first_login	2024-05-06 08:30	_NOVALUE_	2024-06-08 05:47:44.750937
1505	0	t	687	normal_username	_NOVALUE_	khjamali	2024-06-08 09:10:49.799835
1506	0	t	688	normal_username	_NOVALUE_	tdmsm3	2024-06-08 15:23:49.17662
1507	0	t	689	normal_username	_NOVALUE_	tdmsm4	2024-06-08 15:24:56.062817
1508	0	t	690	normal_username	_NOVALUE_	tdmsm5	2024-06-08 15:25:48.766585
1509	0	t	361	first_login	2024-05-09 13:09	_NOVALUE_	2024-06-08 15:37:34.503558
1510	0	t	309	first_login	2024-03-01 08:44	_NOVALUE_	2024-06-08 17:08:32.204355
1511	0	t	309	group	3-Month-150G	6-Month-300G	2024-06-08 17:08:53.579715
1517	0	t	363	first_login	2024-03-10 13:30	_NOVALUE_	2024-06-09 04:40:36.779338
1518	0	t	364	first_login	2024-05-09 09:38	_NOVALUE_	2024-06-09 15:32:12.065775
1514	0	t	692	normal_username	_NOVALUE_	akbari3	2024-06-08 18:03:31.968806
1515	0	t	367	group	2-Month-70G	1-Month-20G	2024-06-09 01:28:32.73952
1516	0	t	367	first_login	2024-04-22 00:17	_NOVALUE_	2024-06-09 01:28:50.186038
1519	0	t	693	normal_username	_NOVALUE_	bama2142	2024-06-09 15:46:40.562513
1520	0	t	694	normal_username	_NOVALUE_	bama2143	2024-06-09 15:46:40.562513
1521	0	t	695	normal_username	_NOVALUE_	bama2144	2024-06-09 15:46:40.562513
1522	0	t	696	normal_username	_NOVALUE_	bama2145	2024-06-09 15:46:40.562513
1523	0	t	697	normal_username	_NOVALUE_	bama2146	2024-06-09 15:46:40.562513
1524	0	t	698	normal_username	_NOVALUE_	bama2147	2024-06-09 15:46:40.562513
1525	0	t	699	normal_username	_NOVALUE_	bama2148	2024-06-09 15:46:40.562513
1526	0	t	700	normal_username	_NOVALUE_	bama2149	2024-06-09 15:46:40.562513
1527	0	t	701	normal_username	_NOVALUE_	bama2150	2024-06-09 15:46:40.562513
1528	0	t	702	normal_username	_NOVALUE_	bama2151	2024-06-09 15:46:40.562513
1529	0	t	704	normal_username	_NOVALUE_	system10	2024-06-10 11:22:31.780197
1530	0	t	366	first_login	2024-03-11 19:22	_NOVALUE_	2024-06-10 12:26:44.52337
1860	0	t	52	first_login	2024-04-21 14:34	_NOVALUE_	2024-07-21 12:29:02.640688
1532	0	t	450	first_login	2024-05-12 11:54	_NOVALUE_	2024-06-10 15:02:16.56763
1533	0	t	393	first_login	2024-05-11 16:07	_NOVALUE_	2024-06-10 17:24:23.814122
1534	0	t	478	first_login	2024-04-08 16:40	_NOVALUE_	2024-06-10 17:27:30.591201
1535	0	t	706	normal_username	_NOVALUE_	firoozeh	2024-06-10 17:30:31.690809
1536	0	t	706	abs_exp_date	_NOVALUE_	2024-07-06 17:31	2024-06-10 17:31:16.761768
1537	0	t	707	normal_username	_NOVALUE_	khanzadeh	2024-06-11 04:18:56.908047
1538	0	t	280	first_login	2024-05-23 06:01	_NOVALUE_	2024-06-11 14:33:39.726048
1539	0	t	477	first_login	2024-05-11 15:10	_NOVALUE_	2024-06-11 14:55:56.772406
1540	0	t	708	normal_username	_NOVALUE_	test10	2024-06-11 16:35:32.700255
1541	0	t	84	first_login	2024-05-11 18:12	_NOVALUE_	2024-06-12 05:00:36.731204
1542	0	t	130	first_login	2024-04-13 06:16	_NOVALUE_	2024-06-12 09:16:39.719483
1543	0	t	130	traffic_periodic_accounting_daily_usage	141M	30141M	2024-06-12 09:17:10.33339
1544	0	t	409	first_login	2024-05-14 08:08	_NOVALUE_	2024-06-12 15:01:52.645836
1545	0	t	528	first_login	2024-05-12 16:26	_NOVALUE_	2024-06-12 15:08:35.647386
1546	0	t	590	first_login	2024-05-13 10:10	_NOVALUE_	2024-06-12 15:15:22.79429
1547	0	t	164	multi_login	1	2	2024-06-12 16:18:08.087068
1548	0	t	164	group	1-Month-35G	1-Month-20G	2024-06-12 16:18:52.91034
1553	0	t	405	first_login	2024-03-15 07:05	_NOVALUE_	2024-06-14 01:58:24.192326
1556	0	t	516	first_login	2024-05-15 07:06	_NOVALUE_	2024-06-14 13:34:38.291419
1557	0	t	103	first_login	2024-05-16 03:13	_NOVALUE_	2024-06-14 15:48:26.370295
1563	0	t	356	first_login	2024-05-09 04:47	_NOVALUE_	2024-06-15 13:01:03.977592
1565	0	t	350	first_login	2024-05-15 03:24	_NOVALUE_	2024-06-15 13:23:57.524845
1568	0	t	209	group	1-Month-35G	2-Month-70G	2024-06-15 14:08:59.64336
1569	0	t	210	group	1-Month-35G	2-Month-70G	2024-06-15 14:13:25.587886
1570	0	t	400	first_login	2024-05-15 16:14	_NOVALUE_	2024-06-15 14:13:46.085779
1571	0	t	402	first_login	2024-05-16 05:07	_NOVALUE_	2024-06-15 14:14:01.667831
1572	0	t	200	first_login	2024-05-17 00:11	_NOVALUE_	2024-06-16 01:06:41.984247
1573	0	t	301	first_login	2024-05-02 10:11	_NOVALUE_	2024-06-16 13:57:08.101346
1574	0	t	423	first_login	2024-05-17 14:53	_NOVALUE_	2024-06-16 15:00:27.04595
1575	0	t	710	normal_username	_NOVALUE_	shahin	2024-06-16 15:50:40.058515
1576	0	t	712	normal_username	_NOVALUE_	sanjabi30	2024-06-16 16:19:28.313215
1584	0	t	134	first_login	2024-05-16 15:15	_NOVALUE_	2024-06-18 08:14:54.059208
1585	0	t	59	first_login	2024-03-19 18:04	_NOVALUE_	2024-06-18 11:18:09.430326
1586	0	t	522	first_login	2024-05-19 08:11	_NOVALUE_	2024-06-18 12:02:49.848646
1587	0	t	413	first_login	2024-05-18 19:59	_NOVALUE_	2024-06-18 12:30:38.418769
1589	0	t	508	first_login	2024-05-19 13:45	_NOVALUE_	2024-06-18 14:57:13.356899
1591	0	t	429	first_login	2024-05-17 17:11	_NOVALUE_	2024-06-18 17:01:38.363717
1595	0	t	612	first_login	2024-05-19 14:27	_NOVALUE_	2024-06-19 06:09:45.106763
1596	0	t	717	normal_username	_NOVALUE_	mostafa112	2024-06-19 06:15:05.52063
1601	0	t	599	first_login	2024-05-19 13:08	_NOVALUE_	2024-06-19 13:42:55.47675
1602	0	t	598	first_login	2024-05-20 04:35	_NOVALUE_	2024-06-19 13:43:58.255234
1606	0	t	721	abs_exp_date	_NOVALUE_	2024-06-23 17:32	2024-06-19 17:32:43.217795
1607	0	t	628	first_login	2024-05-24 21:57	_NOVALUE_	2024-06-20 09:03:08.439713
1611	0	t	575	first_login	2024-05-07 12:53	_NOVALUE_	2024-06-20 16:35:54.839826
1612	0	t	254	first_login	2024-05-21 15:55	_NOVALUE_	2024-06-21 11:55:17.757939
1615	0	t	724	normal_username	_NOVALUE_	msm90	2024-06-22 14:36:23.025249
1618	0	t	1	first_login	2024-02-08 12:07	_NOVALUE_	2024-06-23 07:35:36.922409
1619	0	t	287	first_login	2024-06-01 11:44	_NOVALUE_	2024-06-23 08:29:19.071084
1621	0	t	721	abs_exp_date	2024-06-23 17:32	_NOVALUE_	2024-06-24 02:01:29.075829
1622	0	t	727	normal_username	_NOVALUE_	sara70	2024-06-24 06:47:18.366447
1634	0	t	739	normal_username	_NOVALUE_	beni	2024-06-25 04:08:57.326444
1638	0	t	553	first_login	2024-05-01 05:30	_NOVALUE_	2024-06-25 16:06:08.166207
1640	0	t	741	normal_username	_NOVALUE_	kahouli	2024-06-25 18:05:22.967531
1641	0	t	741	group	12-Month-800G	12-Month-600G	2024-06-25 18:06:22.930206
1642	0	t	653	multi_login	2	2	2024-06-26 09:34:13.145855
1648	0	t	471	first_login	2024-04-04 09:55	_NOVALUE_	2024-06-27 12:20:47.917607
1654	0	t	195	group	3-Month-150G	3-month-100-G-bama	2024-06-28 05:12:56.476181
1660	0	t	745	normal_username	_NOVALUE_	saghar2	2024-06-28 14:51:49.082842
1662	0	t	77	first_login	2024-02-09 02:55	_NOVALUE_	2024-06-29 06:18:11.0717
1668	0	t	252	first_login	2024-05-30 02:47	_NOVALUE_	2024-06-29 08:14:12.067775
1674	0	t	746	normal_username	_NOVALUE_	mostafa113	2024-06-30 05:44:06.36235
1676	0	t	747	normal_username	_NOVALUE_	mahdieh	2024-06-30 08:59:06.553017
1678	0	t	748	normal_username	_NOVALUE_	bama2162	2024-06-30 17:14:35.055124
1679	0	t	749	normal_username	_NOVALUE_	bama2163	2024-06-30 17:14:35.055124
1680	0	t	750	normal_username	_NOVALUE_	bama2164	2024-06-30 17:14:35.055124
1681	0	t	751	normal_username	_NOVALUE_	bama2165	2024-06-30 17:14:35.055124
1682	0	t	752	normal_username	_NOVALUE_	bama2166	2024-06-30 17:14:35.055124
1683	0	t	753	normal_username	_NOVALUE_	bama2167	2024-06-30 17:14:35.055124
1684	0	t	754	normal_username	_NOVALUE_	bama2168	2024-06-30 17:14:35.055124
1685	0	t	755	normal_username	_NOVALUE_	bama2169	2024-06-30 17:14:35.055124
1686	0	t	756	normal_username	_NOVALUE_	bama2170	2024-06-30 17:14:35.055124
1687	0	t	757	normal_username	_NOVALUE_	bama2171	2024-06-30 17:14:35.055124
1688	0	t	320	first_login	2024-06-01 03:03	_NOVALUE_	2024-07-01 04:24:04.467157
1692	0	t	566	first_login	2024-06-01 04:36	_NOVALUE_	2024-07-01 13:50:46.469301
1693	0	t	760	normal_username	_NOVALUE_	shegarf	2024-07-01 14:03:26.052692
1694	0	t	377	first_login	2024-06-01 02:01	_NOVALUE_	2024-07-01 14:49:39.335394
1698	0	t	761	abs_exp_date	2024-07-03 15:07	2024-07-02 15:08	2024-07-01 15:08:11.968374
1702	0	t	762	normal_username	_NOVALUE_	pegah	2024-07-01 16:40:53.962232
1706	0	t	126	first_login	2024-04-02 07:00	_NOVALUE_	2024-07-02 02:47:43.491081
1707	0	t	128	first_login	2024-04-02 04:27	_NOVALUE_	2024-07-02 04:03:08.114167
1710	0	t	89	group	3-Month-150G	3-month-100-G-bama	2024-07-02 11:43:44.659282
1716	0	t	764	abs_exp_date	_NOVALUE_	2024-07-03 16:49	2024-07-02 16:49:12.161155
1720	0	t	195	first_login	2024-04-04 03:37	_NOVALUE_	2024-07-03 05:16:07.463348
1721	0	t	322	first_login	2024-06-03 05:34	_NOVALUE_	2024-07-03 07:43:31.49227
1723	0	t	765	normal_username	_NOVALUE_	m37	2024-07-03 09:24:10.626057
1724	0	t	765	traffic_periodic_accounting_daily	90	90	2024-07-03 09:24:24.783565
1725	0	t	765	traffic_periodic_accounting_daily_limit	100000M	30000M	2024-07-03 09:24:24.783565
1734	0	t	767	normal_username	_NOVALUE_	asadi	2024-07-04 04:49:24.68709
1737	0	t	309	normal_username	navid39	parastoo39	2024-07-05 05:05:06.227393
1740	0	t	468	first_login	2024-04-04 02:50	_NOVALUE_	2024-07-06 08:12:29.051828
1747	0	t	380	first_login	2024-06-06 08:50	_NOVALUE_	2024-07-06 17:27:11.839615
1748	0	t	353	first_login	2024-06-07 03:48	_NOVALUE_	2024-07-07 05:25:16.952679
1751	0	t	427	first_login	2024-03-25 16:35	_NOVALUE_	2024-07-07 14:26:19.339133
1753	0	t	391	first_login	2024-06-08 03:43	_NOVALUE_	2024-07-07 14:29:11.602427
1755	0	t	480	first_login	2024-06-13 09:10	_NOVALUE_	2024-07-08 01:15:49.668835
1756	0	t	472	first_login	2024-06-07 15:26	_NOVALUE_	2024-07-08 05:42:42.199976
1769	0	t	781	normal_username	_NOVALUE_	parsa2	2024-07-08 13:19:59.501285
1770	0	t	313	first_login	2024-06-08 06:03	_NOVALUE_	2024-07-08 14:13:59.025354
1771	0	t	652	first_login	2024-06-01 01:52	_NOVALUE_	2024-07-08 14:14:22.536141
1773	0	t	584	first_login	2024-06-07 04:46	_NOVALUE_	2024-07-09 01:29:08.093406
2352	0	t	937	normal_username	_NOVALUE_	emami	2024-09-09 05:56:42.101405
1785	0	t	692	traffic_periodic_accounting_daily	90	90	2024-07-10 01:25:15.640411
1786	0	t	692	traffic_periodic_accounting_daily_limit	100000M	50000M	2024-07-10 01:25:15.640411
1787	0	t	450	first_login	2024-06-10 15:04	_NOVALUE_	2024-07-10 08:14:54.542873
1788	0	t	716	abs_exp_date	2024-07-10 05:53	_NOVALUE_	2024-07-10 11:54:36.720751
1789	0	t	716	first_login	2024-06-18 06:13	_NOVALUE_	2024-07-10 11:54:43.447657
1795	0	t	210	group	2-Month-70G	1-Month-20G	2024-07-10 14:44:46.314389
1797	0	t	209	group	2-Month-70G	1-Month-20G	2024-07-10 14:45:42.805102
1799	0	t	445	first_login	2024-03-25 05:26	_NOVALUE_	2024-07-11 02:17:57.422372
1800	0	t	393	first_login	2024-06-10 17:25	_NOVALUE_	2024-07-11 09:16:45.961651
1801	0	t	409	first_login	2024-06-12 14:43	_NOVALUE_	2024-07-12 06:20:38.1587
1861	0	t	52	group	3-Month-150G	1-Month-50G	2024-07-21 12:29:13.346425
1803	0	t	364	first_login	2024-06-10 21:52	_NOVALUE_	2024-07-12 14:51:18.86453
1588	0	t	433	first_login	2024-03-19 12:50	_NOVALUE_	2024-06-18 13:24:49.466848
1597	0	t	718	normal_username	_NOVALUE_	tdmsm7	2024-06-19 06:16:06.043448
1599	0	t	504	first_login	2024-05-10 09:13	_NOVALUE_	2024-06-19 13:30:45.732728
1600	0	t	504	group	1-Month-35G	3-month-100-G-bama	2024-06-19 13:30:56.811065
1604	0	t	720	normal_username	_NOVALUE_	msm72	2024-06-19 15:38:09.859394
1608	0	t	628	group	1-Month-35G	1-Month-20G	2024-06-20 09:03:20.52312
1613	0	t	441	first_login	2024-05-22 18:26	_NOVALUE_	2024-06-22 02:53:49.92499
1616	0	t	725	normal_username	_NOVALUE_	msm91	2024-06-22 14:40:16.55462
1620	0	t	721	first_login	2024-06-20 03:43	_NOVALUE_	2024-06-24 02:01:14.604817
1623	0	t	394	first_login	2024-05-23 14:24	_NOVALUE_	2024-06-24 14:15:17.117097
1624	0	t	728	normal_username	_NOVALUE_	bama2152	2024-06-24 17:39:13.818142
1625	0	t	729	normal_username	_NOVALUE_	bama2153	2024-06-24 17:39:13.818142
1626	0	t	730	normal_username	_NOVALUE_	bama2154	2024-06-24 17:39:13.818142
1627	0	t	731	normal_username	_NOVALUE_	bama2155	2024-06-24 17:39:13.818142
1628	0	t	732	normal_username	_NOVALUE_	bama2156	2024-06-24 17:39:13.818142
1629	0	t	733	normal_username	_NOVALUE_	bama2157	2024-06-24 17:39:13.818142
1630	0	t	734	normal_username	_NOVALUE_	bama2158	2024-06-24 17:39:13.818142
1631	0	t	735	normal_username	_NOVALUE_	bama2159	2024-06-24 17:39:13.818142
1632	0	t	736	normal_username	_NOVALUE_	bama2160	2024-06-24 17:39:13.818142
1633	0	t	737	normal_username	_NOVALUE_	bama2161	2024-06-24 17:39:13.818142
1635	0	t	740	normal_username	_NOVALUE_	test11	2024-06-25 04:11:51.6696
1636	0	t	740	abs_exp_date	_NOVALUE_	2024-06-26 04:12	2024-06-25 04:12:05.694388
1643	0	t	278	first_login	2024-05-28 12:38	_NOVALUE_	2024-06-26 14:12:52.120114
1644	0	t	742	normal_username	_NOVALUE_	bahareh3	2024-06-26 14:51:15.248846
1646	0	t	743	normal_username	_NOVALUE_	ghaderi	2024-06-27 01:08:26.719983
1647	0	t	743	multi_login	2	2	2024-06-27 01:10:12.239692
1649	0	t	471	abs_exp_date	2024-06-27 09:42	_NOVALUE_	2024-06-27 12:20:55.426058
1652	0	t	513	first_login	2024-05-27 13:55	_NOVALUE_	2024-06-27 17:01:20.743953
1655	0	t	190	first_login	2024-05-28 11:04	_NOVALUE_	2024-06-28 06:16:27.943269
1656	0	t	375	first_login	2024-04-28 13:30	_NOVALUE_	2024-06-28 06:22:13.057698
1657	0	t	375	group	2-Month-70G	1-Month-20G	2024-06-28 06:22:38.836616
1658	0	t	121	first_login	2024-05-29 06:08	_NOVALUE_	2024-06-28 07:47:03.138385
1659	0	t	744	normal_username	_NOVALUE_	bahareh4	2024-06-28 08:11:34.226394
1663	0	t	77	abs_exp_date	2024-06-25 18:54	_NOVALUE_	2024-06-29 06:18:21.388187
1664	0	t	340	first_login	2024-06-05 16:29	_NOVALUE_	2024-06-29 07:27:09.664753
1666	0	t	30	first_login	2024-02-08 14:25	_NOVALUE_	2024-06-29 07:43:06.995218
1667	0	t	30	abs_exp_date	2024-03-01 14:18	_NOVALUE_	2024-06-29 07:44:04.080704
1671	0	t	515	first_login	2024-04-14 15:54	_NOVALUE_	2024-06-29 15:17:29.373958
1672	0	t	515	group	2-Month-70G	3-month-100-G-bama	2024-06-29 15:17:49.708866
1675	0	t	579	first_login	2024-05-31 04:22	_NOVALUE_	2024-06-30 06:07:36.507176
1689	0	t	720	group	1-Month-20G	1-Month-35G	2024-07-01 12:23:16.621146
1690	0	t	759	normal_username	_NOVALUE_	msm72	2024-07-01 12:24:04.466819
1691	0	t	724	group	1-Month-20G	3-month-100-G-bama	2024-07-01 13:49:59.571036
1696	0	t	761	normal_username	_NOVALUE_	test30	2024-07-01 15:07:32.459798
1697	0	t	761	abs_exp_date	_NOVALUE_	2024-07-03 15:07	2024-07-01 15:07:47.237112
1701	0	t	724	group	3-month-100-G-bama	1-Month-20G	2024-07-01 16:40:23.29144
1703	0	t	762	group	1-Month-20G	3-month-100-G-bama	2024-07-01 16:41:06.624347
1704	0	t	524	first_login	2024-04-17 16:57	_NOVALUE_	2024-07-02 02:37:42.283733
1708	0	t	763	normal_username	_NOVALUE_	mashaalpc	2024-07-02 04:35:39.695208
1711	0	t	478	first_login	2024-06-10 17:32	_NOVALUE_	2024-07-02 14:56:40.465269
1718	0	t	630	group	1-Month-50G	1-Month-35G	2024-07-02 17:28:23.194504
1719	0	t	448	first_login	2024-06-02 16:03	_NOVALUE_	2024-07-03 01:09:18.07315
1722	0	t	89	traffic_periodic_accounting_daily_usage	60743M	90743M	2024-07-03 09:23:19.260785
1727	0	t	154	first_login	2024-04-04 03:29	_NOVALUE_	2024-07-03 15:48:17.445566
1729	0	t	766	abs_exp_date	_NOVALUE_	2024-09-06 16:58	2024-07-03 16:58:53.433391
1730	0	t	766	abs_exp_date	2024-09-06 16:58	2024-09-06 17:00	2024-07-03 17:00:59.419416
1735	0	t	420	first_login	2024-06-02 03:54	_NOVALUE_	2024-07-04 04:51:50.785511
1736	0	t	666	first_login	2024-06-01 13:56	_NOVALUE_	2024-07-04 09:17:33.195729
1738	0	t	768	normal_username	_NOVALUE_	azm	2024-07-05 05:41:38.181679
1741	0	t	769	normal_username	_NOVALUE_	m50	2024-07-06 08:24:29.588859
1742	0	t	766	abs_exp_date	2024-09-06 17:00	_NOVALUE_	2024-07-06 13:06:17.623653
1743	0	t	766	abs_exp_date	_NOVALUE_	2024-09-08 13:06	2024-07-06 13:06:50.513335
1749	0	t	277	first_login	2024-06-05 16:06	_NOVALUE_	2024-07-07 05:56:56.308695
1752	0	t	427	abs_exp_date	2024-05-24 17:10	_NOVALUE_	2024-07-07 14:26:28.146921
1757	0	t	601	first_login	2024-06-08 05:33	_NOVALUE_	2024-07-08 06:59:42.410321
1758	0	t	581	first_login	2024-06-07 07:52	_NOVALUE_	2024-07-08 12:27:56.82962
1772	0	t	782	normal_username	_NOVALUE_	mahshad	2024-07-08 16:39:48.894298
1774	0	t	357	first_login	2024-04-09 04:04	_NOVALUE_	2024-07-09 01:38:23.783073
1775	0	t	357	group	3-Month-150G	1-Month-20G	2024-07-09 01:38:35.298201
1776	0	t	202	first_login	2024-06-08 06:03	_NOVALUE_	2024-07-09 02:25:06.900881
1778	0	t	689	first_login	2024-06-09 03:48	_NOVALUE_	2024-07-09 14:58:21.429352
1779	0	t	784	normal_username	_NOVALUE_	taghipoor2	2024-07-09 15:20:49.342755
1780	0	t	406	first_login	2024-03-15 07:33	_NOVALUE_	2024-07-10 01:22:46.789075
1781	0	t	406	abs_exp_date	2024-07-09 14:15	_NOVALUE_	2024-07-10 01:22:54.114628
1784	0	t	692	group	1-Month-35G	3-month-100-G-bama	2024-07-10 01:24:47.373242
1790	0	t	716	group	1-Month-20G	3-month-100-G-bama	2024-07-10 11:54:55.055858
1791	0	t	280	first_login	2024-06-11 14:34	_NOVALUE_	2024-07-10 14:41:27.954373
1792	0	t	208	first_login	2024-05-20 05:29	_NOVALUE_	2024-07-10 14:43:46.24621
1794	0	t	210	first_login	2024-05-20 08:39	_NOVALUE_	2024-07-10 14:44:35.234125
1796	0	t	208	group	2-Month-70G	1-Month-20G	2024-07-10 14:45:13.868649
1798	0	t	505	first_login	2024-04-10 12:36	_NOVALUE_	2024-07-10 14:48:12.609006
1804	0	t	516	first_login	2024-06-14 14:11	_NOVALUE_	2024-07-13 01:35:59.271086
1590	0	t	508	abs_exp_date	_NOVALUE_	2024-06-23 14:57	2024-06-18 14:57:28.38871
1592	0	t	429	group	1-Month-35G	1-Month-20G	2024-06-18 17:01:55.096816
1593	0	t	532	first_login	2024-05-19 15:50	_NOVALUE_	2024-06-18 17:23:40.168139
1594	0	t	532	group	1-Month-35G	3-month-100-G-bama	2024-06-18 17:24:03.200771
1598	0	t	719	normal_username	_NOVALUE_	tdmsm8	2024-06-19 06:16:46.969161
1603	0	t	271	first_login	2024-05-20 12:27	_NOVALUE_	2024-06-19 14:46:24.081034
1605	0	t	721	normal_username	_NOVALUE_	alipoor	2024-06-19 17:32:22.212678
1609	0	t	722	normal_username	_NOVALUE_	erfan	2024-06-20 13:16:23.04609
1610	0	t	722	abs_exp_date	_NOVALUE_	2024-07-07 13:16	2024-06-20 13:16:46.630901
1614	0	t	275	first_login	2024-05-22 14:02	_NOVALUE_	2024-06-22 03:53:18.982251
1617	0	t	726	normal_username	_NOVALUE_	jamshidi2	2024-06-23 03:44:49.113094
1637	0	t	274	first_login	2024-05-26 10:08	_NOVALUE_	2024-06-25 15:03:12.540964
1639	0	t	270	first_login	2024-05-26 06:38	_NOVALUE_	2024-06-25 16:56:26.059853
1645	0	t	93	first_login	2024-03-27 07:40	_NOVALUE_	2024-06-26 17:11:51.0848
1650	0	t	527	first_login	2024-05-20 00:10	_NOVALUE_	2024-06-27 12:49:33.19222
1651	0	t	336	first_login	2024-05-28 12:01	_NOVALUE_	2024-06-27 15:16:46.13389
1653	0	t	561	first_login	2024-05-28 16:25	_NOVALUE_	2024-06-27 17:22:20.32616
1661	0	t	311	first_login	2024-05-13 09:28	_NOVALUE_	2024-06-28 16:23:34.197937
1665	0	t	314	first_login	2024-05-28 10:18	_NOVALUE_	2024-06-29 07:27:55.318405
1669	0	t	419	first_login	2024-05-18 15:53	_NOVALUE_	2024-06-29 14:14:52.655249
1670	0	t	447	first_login	2024-05-26 16:54	_NOVALUE_	2024-06-29 14:25:56.404228
1673	0	t	279	first_login	2024-05-28 02:16	_NOVALUE_	2024-06-30 01:34:49.591481
1677	0	t	458	first_login	2024-05-31 15:32	_NOVALUE_	2024-06-30 16:53:16.775341
1695	0	t	310	first_login	2024-06-01 06:28	_NOVALUE_	2024-07-01 15:04:16.535241
1699	0	t	646	first_login	2024-05-31 04:25	_NOVALUE_	2024-07-01 16:05:31.997753
1700	0	t	319	first_login	2024-06-01 14:37	_NOVALUE_	2024-07-01 16:14:26.798011
1705	0	t	524	abs_exp_date	2024-07-01 13:37	_NOVALUE_	2024-07-02 02:37:52.870011
1709	0	t	89	first_login	2024-05-07 19:36	_NOVALUE_	2024-07-02 11:43:15.978735
1712	0	t	286	first_login	2024-05-30 09:42	_NOVALUE_	2024-07-02 15:21:58.978205
1713	0	t	161	first_login	2024-04-03 05:49	_NOVALUE_	2024-07-02 15:27:24.345932
1714	0	t	558	first_login	2024-05-08 15:59	_NOVALUE_	2024-07-02 15:35:48.607223
1715	0	t	764	normal_username	_NOVALUE_	test	2024-07-02 16:48:57.36165
1717	0	t	630	first_login	2024-05-27 02:01	_NOVALUE_	2024-07-02 17:27:54.49133
1726	0	t	321	first_login	2024-06-03 05:41	_NOVALUE_	2024-07-03 11:40:27.494951
1728	0	t	766	normal_username	_NOVALUE_	morteza	2024-07-03 16:58:05.608862
1731	0	t	305	abs_exp_date	_NOVALUE_	2024-07-04 17:14	2024-07-03 17:14:58.036537
1732	0	t	305	abs_exp_date	2024-07-04 17:14	2024-08-07 17:15	2024-07-03 17:15:47.636825
1733	0	t	305	abs_exp_date	2024-08-07 17:15	2024-08-07 17:17	2024-07-03 17:17:05.342389
1739	0	t	263	first_login	2024-02-24 16:14	_NOVALUE_	2024-07-05 09:32:50.366688
1744	0	t	316	first_login	2024-06-06 01:41	_NOVALUE_	2024-07-06 13:10:38.115144
1745	0	t	602	group	1-Month-35G	3-month-100-G-bama	2024-07-06 13:59:02.736052
1746	0	t	348	first_login	2024-06-06 08:46	_NOVALUE_	2024-07-06 17:08:16.738666
1750	0	t	276	first_login	2024-06-08 23:39	_NOVALUE_	2024-07-07 05:57:14.037656
1754	0	t	168	first_login	2024-04-05 09:46	_NOVALUE_	2024-07-07 16:14:28.487063
1759	0	t	770	normal_username	_NOVALUE_	bama2172	2024-07-08 12:32:12.236646
1760	0	t	771	normal_username	_NOVALUE_	bama2173	2024-07-08 12:32:12.236646
1761	0	t	772	normal_username	_NOVALUE_	bama2174	2024-07-08 12:32:12.236646
1762	0	t	773	normal_username	_NOVALUE_	bama2175	2024-07-08 12:32:12.236646
1763	0	t	774	normal_username	_NOVALUE_	bama2176	2024-07-08 12:32:12.236646
1764	0	t	775	normal_username	_NOVALUE_	bama2177	2024-07-08 12:32:12.236646
1765	0	t	776	normal_username	_NOVALUE_	bama2178	2024-07-08 12:32:12.236646
1766	0	t	777	normal_username	_NOVALUE_	bama2179	2024-07-08 12:32:12.236646
1767	0	t	778	normal_username	_NOVALUE_	bama2180	2024-07-08 12:32:12.236646
1768	0	t	779	normal_username	_NOVALUE_	bama2181	2024-07-08 12:32:12.236646
1782	0	t	406	group	6-Month-300G	3-month-100-G-bama	2024-07-10 01:23:04.940531
1783	0	t	692	first_login	2024-06-09 03:31	_NOVALUE_	2024-07-10 01:24:28.85333
1793	0	t	209	first_login	2024-05-20 08:17	_NOVALUE_	2024-07-10 14:44:08.653644
1805	0	t	127	first_login	2024-04-06 05:59	_NOVALUE_	2024-07-13 03:25:37.344342
1806	0	t	127	abs_exp_date	2024-07-11 05:22	_NOVALUE_	2024-07-13 03:25:45.720111
1807	0	t	127	group	6-Month-300G	3-month-100-G-bama	2024-07-13 03:25:56.123672
1808	0	t	127	traffic_periodic_accounting_daily	99	90	2024-07-13 03:26:24.643035
1809	0	t	127	traffic_periodic_accounting_daily_limit	100000M	50000M	2024-07-13 03:26:24.643035
1810	0	t	127	traffic_periodic_accounting_daily_usage	1421212221	_NOVALUE_	2024-07-13 03:26:24.643035
1811	0	t	688	first_login	2024-06-09 09:58	_NOVALUE_	2024-07-13 08:17:31.130254
1812	0	t	759	first_login	2024-07-01 14:55	_NOVALUE_	2024-07-13 08:20:46.505156
1813	0	t	84	first_login	2024-06-12 05:49	_NOVALUE_	2024-07-13 08:33:41.430726
1814	0	t	759	group	1-Month-20G	1-Month-50G	2024-07-13 08:57:19.578254
1815	0	t	759	traffic_periodic_accounting_daily	30	30	2024-07-13 08:57:45.444053
1816	0	t	759	traffic_periodic_accounting_daily_limit	50000M	40000M	2024-07-13 08:57:45.444053
1817	0	t	512	first_login	2024-06-13 17:21	_NOVALUE_	2024-07-14 06:30:40.623417
1818	0	t	335	first_login	2024-06-13 05:16	_NOVALUE_	2024-07-14 11:58:29.777874
1819	0	t	528	first_login	2024-06-12 22:28	_NOVALUE_	2024-07-14 12:35:04.882433
1820	0	t	721	group	1-Month-10G	1-Month-35G	2024-07-14 15:17:54.180936
1821	0	t	103	first_login	2024-06-14 15:48	_NOVALUE_	2024-07-14 16:54:36.604461
1822	0	t	5	first_login	2024-04-15 15:56	_NOVALUE_	2024-07-15 02:29:20.810295
1823	0	t	367	first_login	2024-06-10 00:05	_NOVALUE_	2024-07-15 07:10:26.19578
1824	0	t	367	group	1-Month-20G	3-month-100-G-bama	2024-07-15 07:11:28.600477
1825	0	t	367	traffic_periodic_accounting_daily	90	90	2024-07-15 07:12:04.943066
1826	0	t	367	traffic_periodic_accounting_daily_limit	100000M	50000M	2024-07-15 07:12:04.943066
1827	0	t	520	first_login	2024-04-15 14:41	_NOVALUE_	2024-07-15 09:02:42.826829
1828	0	t	400	first_login	2024-06-16 04:42	_NOVALUE_	2024-07-15 17:10:25.09192
1829	0	t	402	first_login	2024-06-15 15:36	_NOVALUE_	2024-07-15 17:10:54.313354
1830	0	t	200	first_login	2024-06-16 01:33	_NOVALUE_	2024-07-16 02:51:31.220457
1831	0	t	786	normal_username	_NOVALUE_	noori5	2024-07-16 09:14:05.42669
1832	0	t	593	first_login	2024-06-15 14:24	_NOVALUE_	2024-07-17 05:52:31.787898
1833	0	t	349	first_login	2024-06-15 12:11	_NOVALUE_	2024-07-17 07:25:20.476519
1834	0	t	350	first_login	2024-06-16 02:01	_NOVALUE_	2024-07-17 07:25:40.445398
1835	0	t	787	normal_username	_NOVALUE_	mostafa114	2024-07-17 07:26:38.854846
1836	0	t	188	first_login	2024-04-18 07:14	_NOVALUE_	2024-07-17 13:55:44.735285
1837	0	t	188	traffic_periodic_accounting_daily	90	90	2024-07-17 13:56:12.122751
1838	0	t	188	traffic_periodic_accounting_daily_limit	150000M	500000M	2024-07-17 13:56:12.122751
1839	0	t	188	traffic_periodic_accounting_daily	90	90	2024-07-17 13:56:55.85567
1840	0	t	188	traffic_periodic_accounting_daily_limit	500000M	100000M	2024-07-17 13:56:55.85567
1841	0	t	423	first_login	2024-06-16 16:49	_NOVALUE_	2024-07-17 14:12:41.256729
1842	0	t	142	first_login	2024-04-17 00:30	_NOVALUE_	2024-07-17 14:37:20.838482
1843	0	t	610	first_login	2024-05-18 13:35	_NOVALUE_	2024-07-17 15:15:04.410138
1844	0	t	610	group	1-Month-70G	1-Month-35G	2024-07-17 15:15:43.970029
1845	0	t	428	first_login	2024-06-18 06:38	_NOVALUE_	2024-07-18 09:53:09.452818
1846	0	t	430	first_login	2024-05-19 12:58	_NOVALUE_	2024-07-18 13:13:49.973763
1847	0	t	430	group	2-Month-70G	1-Month-35G	2024-07-18 13:15:30.191174
1848	0	t	430	group	1-Month-35G	1-Month-20G	2024-07-18 13:15:47.869055
1849	0	t	767	group	1-Month-35G	1-Month-50G	2024-07-18 16:11:07.242164
1850	0	t	767	group	1-Month-50G	1-Month-70G	2024-07-18 16:11:26.31828
1851	0	t	596	first_login	2024-06-18 09:19	_NOVALUE_	2024-07-18 18:47:30.32238
1852	0	t	605	first_login	2024-06-16 01:32	_NOVALUE_	2024-07-19 06:53:25.416836
1853	0	t	271	first_login	2024-06-19 14:55	_NOVALUE_	2024-07-19 19:37:39.71155
1854	0	t	522	first_login	2024-06-19 05:19	_NOVALUE_	2024-07-20 02:30:35.87992
1855	0	t	612	first_login	2024-06-19 06:19	_NOVALUE_	2024-07-20 03:41:21.261192
1862	0	t	649	first_login	2024-06-01 00:56	_NOVALUE_	2024-07-21 14:25:34.091745
1863	0	t	724	group	1-Month-20G	2-Month-70G	2024-07-21 14:28:00.681341
1864	0	t	725	group	1-Month-20G	2-Month-70G	2024-07-21 14:28:33.186419
1865	0	t	709	first_login	2024-06-15 06:53	_NOVALUE_	2024-07-21 14:29:43.134274
1866	0	t	275	first_login	2024-06-22 08:20	_NOVALUE_	2024-07-21 14:30:13.551601
1867	0	t	668	first_login	2024-06-10 02:13	_NOVALUE_	2024-07-21 14:32:44.881356
1868	0	t	789	normal_username	_NOVALUE_	msm72	2024-07-21 14:34:33.707389
1869	0	t	429	first_login	2024-06-18 18:14	_NOVALUE_	2024-07-22 11:09:28.436177
1870	0	t	790	normal_username	_NOVALUE_	theotheo	2024-07-22 11:17:21.512175
1871	0	t	441	first_login	2024-06-22 03:35	_NOVALUE_	2024-07-22 15:37:02.756341
1872	0	t	791	normal_username	_NOVALUE_	bagheri	2024-07-22 16:13:33.662388
1873	0	t	791	traffic_periodic_accounting_daily	30	20	2024-07-22 16:13:52.530469
1874	0	t	791	traffic_periodic_accounting_daily_limit	20000M	24000M	2024-07-22 16:13:52.530469
1875	0	t	791	abs_exp_date	_NOVALUE_	2024-08-11 16:14	2024-07-22 16:14:51.914948
1876	0	t	113	first_login	2024-04-22 04:55	_NOVALUE_	2024-07-22 16:27:10.864101
1877	0	t	113	group	3-Month-150G	1-Month-20G	2024-07-22 16:27:21.254049
1878	0	t	287	first_login	2024-06-23 08:32	_NOVALUE_	2024-07-23 10:29:56.043317
1879	0	t	572	first_login	2024-06-06 08:35	_NOVALUE_	2024-07-23 12:05:18.237352
1880	0	t	719	first_login	2024-06-22 02:06	_NOVALUE_	2024-07-23 12:13:13.109184
1881	0	t	120	first_login	2024-06-15 08:38	_NOVALUE_	2024-07-23 12:48:07.638034
1882	0	t	120	group	1-Month-70G	3-month-100-G-bama	2024-07-23 12:48:23.264965
1883	0	t	721	first_login	2024-06-24 02:06	_NOVALUE_	2024-07-24 04:43:57.743886
1884	0	t	721	group	1-Month-35G	3-month-100-G-bama	2024-07-24 04:44:14.457447
1885	0	t	792	normal_username	_NOVALUE_	test120	2024-07-24 05:26:19.841423
1886	0	t	792	abs_exp_date	_NOVALUE_	2024-07-25 05:26	2024-07-24 05:26:31.378165
1887	0	t	628	first_login	2024-06-24 11:33	_NOVALUE_	2024-07-24 05:29:51.861274
1888	0	t	727	first_login	2024-06-24 06:47	_NOVALUE_	2024-07-24 09:11:14.240636
1889	0	t	794	normal_username	_NOVALUE_	bahareh5	2024-07-24 14:49:11.952886
1890	0	t	794	abs_exp_date	_NOVALUE_	2024-07-25 14:49	2024-07-24 14:49:28.960952
1891	0	t	258	first_login	2024-06-01 04:57	_NOVALUE_	2024-07-24 17:11:29.680913
1892	0	t	394	first_login	2024-06-24 20:14	_NOVALUE_	2024-07-25 02:49:07.196353
1893	0	t	179	first_login	2024-04-25 09:56	_NOVALUE_	2024-07-25 06:04:53.574367
1894	0	t	179	group	3-Month-150G	1-Month-20G	2024-07-25 06:05:05.430472
1895	0	t	795	normal_username	_NOVALUE_	ramezan	2024-07-25 14:21:15.325188
1896	0	t	795	abs_exp_date	_NOVALUE_	2024-09-10 14:21	2024-07-25 14:21:37.170393
1897	0	t	728	first_login	2024-06-25 10:32	_NOVALUE_	2024-07-25 15:56:49.901186
1898	0	t	744	first_login	2024-06-28 16:51	_NOVALUE_	2024-07-25 16:12:47.005977
1899	0	t	744	group	1-Month-20G	2-Month-70G	2024-07-25 16:13:04.448122
1900	0	t	744	abs_exp_date	_NOVALUE_	2024-09-04 16:13	2024-07-25 16:13:44.071646
1901	0	t	744	traffic_periodic_accounting_daily	60	41	2024-07-25 16:14:10.931555
1902	0	t	744	traffic_periodic_accounting_daily_limit	70000M	25000M	2024-07-25 16:14:10.931555
1903	0	t	744	traffic_periodic_accounting_daily_usage	21024104825	_NOVALUE_	2024-07-25 16:14:10.931555
1904	0	t	274	first_login	2024-06-25 15:03	_NOVALUE_	2024-07-25 16:54:05.621256
1905	0	t	794	first_login	2024-07-25 01:03	_NOVALUE_	2024-07-26 04:13:07.789822
1906	0	t	794	abs_exp_date	2024-07-25 14:49	2024-09-05 04:13	2024-07-26 04:13:28.575375
1907	0	t	794	group	1-Month-10G	2-Month-70G	2024-07-26 04:13:46.637246
1908	0	t	270	first_login	2024-06-25 16:59	_NOVALUE_	2024-07-26 06:41:08.207507
1909	0	t	797	normal_username	_NOVALUE_	reyhaneh	2024-07-26 14:43:25.324548
1910	0	t	798	normal_username	_NOVALUE_	farahbakhsh	2024-07-26 14:49:40.566064
1911	0	t	798	abs_exp_date	_NOVALUE_	2024-07-27 14:50	2024-07-26 14:50:01.523992
1912	0	t	278	first_login	2024-06-26 14:46	_NOVALUE_	2024-07-27 01:25:21.285399
1913	0	t	190	first_login	2024-06-28 14:04	_NOVALUE_	2024-07-27 01:25:35.836324
1914	0	t	132	first_login	2024-05-27 08:56	_NOVALUE_	2024-07-27 03:16:03.932689
1915	0	t	132	group	2-Month-70G	3-month-100-G-bama	2024-07-27 03:16:17.823136
1916	0	t	132	traffic_periodic_accounting_daily	90	90	2024-07-27 03:17:07.733919
1917	0	t	132	traffic_periodic_accounting_daily_limit	100000M	50000M	2024-07-27 03:17:07.733919
1918	0	t	629	group	2-Month-70G	12-Month-600G	2024-07-27 08:14:53.092225
1919	0	t	629	first_login	2024-05-26 07:03	_NOVALUE_	2024-07-27 08:15:05.240385
1920	0	t	798	abs_exp_date	2024-07-27 14:50	2024-08-21 12:50	2024-07-27 12:50:45.595227
1921	0	t	134	first_login	2024-06-18 09:29	_NOVALUE_	2024-07-27 16:02:01.751988
1922	0	t	336	first_login	2024-06-27 15:50	_NOVALUE_	2024-07-27 17:29:42.413996
1923	0	t	713	abs_exp_date	2024-07-08 05:39	_NOVALUE_	2024-07-28 02:21:22.372942
1924	0	t	201	first_login	2024-04-28 17:03	_NOVALUE_	2024-07-28 04:22:48.465561
1925	0	t	561	first_login	2024-06-27 17:22	_NOVALUE_	2024-07-28 04:32:22.069094
1926	0	t	742	first_login	2024-06-27 01:26	_NOVALUE_	2024-07-28 05:38:49.307598
2816	0	t	983	group	2-Month-70G	3-Month-150G	2024-10-28 06:16:41.993037
1928	0	t	598	first_login	2024-06-19 13:54	_NOVALUE_	2024-07-28 13:56:53.661189
1929	0	t	548	first_login	2024-04-28 11:53	_NOVALUE_	2024-07-28 13:57:45.526721
1930	0	t	548	group	1-Month-20G	2-Month-70G	2024-07-28 13:58:11.288679
1931	0	t	801	normal_username	_NOVALUE_	mtorabi	2024-07-28 14:20:48.320428
1932	0	t	801	traffic_periodic_accounting_daily	180	176	2024-07-28 14:21:08.37169
1933	0	t	801	traffic_periodic_accounting_daily_limit	300000M	100000M	2024-07-28 14:21:08.37169
1934	0	t	801	abs_exp_date	_NOVALUE_	2025-01-20 13:21	2024-07-28 14:21:28.358689
1935	0	t	605	group	1-Month-35G	2-Month-70G	2024-07-28 16:44:11.90351
1936	0	t	605	abs_exp_date	_NOVALUE_	2024-09-08 16:44	2024-07-28 16:44:34.166861
1937	0	t	802	normal_username	_NOVALUE_	seyedi	2024-07-29 05:23:09.659601
1938	0	t	513	first_login	2024-06-28 03:45	_NOVALUE_	2024-07-29 06:57:31.808127
1939	0	t	803	normal_username	_NOVALUE_	bama2074	2024-07-29 14:19:31.268144
1940	0	t	252	first_login	2024-06-29 08:43	_NOVALUE_	2024-07-29 15:35:54.500317
1941	0	t	121	first_login	2024-06-28 09:12	_NOVALUE_	2024-07-29 15:57:41.432796
1942	0	t	804	normal_username	_NOVALUE_	mcb	2024-07-29 15:58:44.352692
1943	0	t	804	group	1-Month-35G	3-month-100-G-bama	2024-07-29 15:59:17.201725
1944	0	t	30	first_login	2024-06-29 08:07	_NOVALUE_	2024-07-29 16:02:51.728313
1945	0	t	340	first_login	2024-06-29 07:56	_NOVALUE_	2024-07-29 16:03:52.798193
1946	0	t	564	first_login	2024-04-30 12:48	_NOVALUE_	2024-07-29 16:10:45.682767
1947	0	t	564	lock	_NOVALUE_		2024-07-29 16:10:57.962788
1948	0	t	564	lock		_NOVALUE_	2024-07-29 18:37:53.340435
1949	0	t	279	first_login	2024-06-30 01:35	_NOVALUE_	2024-07-30 06:27:20.920094
1950	0	t	717	first_login	2024-06-19 06:48	_NOVALUE_	2024-07-30 06:52:18.357534
1951	0	t	314	first_login	2024-06-30 00:57	_NOVALUE_	2024-07-30 06:52:41.302396
1952	0	t	579	first_login	2024-06-30 06:09	_NOVALUE_	2024-07-30 09:35:06.819342
1953	0	t	375	first_login	2024-06-28 09:08	_NOVALUE_	2024-07-30 11:00:47.145858
1954	0	t	375	group	1-Month-20G	2-Month-70G	2024-07-30 11:01:09.719497
1955	0	t	805	normal_username	_NOVALUE_	kian	2024-07-30 15:00:18.774512
1956	0	t	806	normal_username	_NOVALUE_	panahipc	2024-07-30 15:23:23.758194
1957	0	t	807	normal_username	_NOVALUE_	tiam	2024-07-30 15:27:26.316734
1958	0	t	807	group	1-Month-35G	6-Month-300G	2024-07-30 15:42:46.312177
1959	0	t	806	group	1-Month-10G	6-Month-300G	2024-07-30 15:43:57.050424
1960	0	t	806	traffic_periodic_accounting_daily	180	180	2024-07-30 15:45:08.314417
1961	0	t	806	traffic_periodic_accounting_daily_limit	300000M	21000M	2024-07-30 15:45:08.314417
1962	0	t	745	first_login	2024-06-29 15:06	_NOVALUE_	2024-07-30 15:46:52.266894
1963	0	t	562	first_login	2024-05-01 13:39	_NOVALUE_	2024-07-30 17:14:40.123141
1964	0	t	563	first_login	2024-04-29 04:23	_NOVALUE_	2024-07-31 03:28:01.863344
1965	0	t	458	first_login	2024-06-30 23:25	_NOVALUE_	2024-07-31 04:33:34.282338
1966	0	t	808	normal_username	_NOVALUE_	esfandiari1	2024-07-31 05:44:35.124469
1967	0	t	809	normal_username	_NOVALUE_	esfandiari2	2024-07-31 05:45:48.040242
1968	0	t	359	first_login	2024-04-12 10:47	_NOVALUE_	2024-07-31 08:38:41.010484
1969	0	t	359	group	1-Month-50G	1-Month-20G	2024-07-31 08:38:52.585585
2817	0	t	983	abs_exp_date	2024-10-28 03:39	_NOVALUE_	2024-10-28 06:16:50.313078
1971	0	t	320	first_login	2024-07-01 04:26	_NOVALUE_	2024-07-31 10:24:35.833254
1972	0	t	112	first_login	2024-04-29 08:47	_NOVALUE_	2024-07-31 10:34:34.064081
1973	0	t	112	traffic_periodic_accounting_daily	90	90	2024-07-31 10:35:08.708237
1974	0	t	112	traffic_periodic_accounting_daily_limit	150000M	50000M	2024-07-31 10:35:08.708237
1975	0	t	811	normal_username	_NOVALUE_	bama2182	2024-07-31 13:23:10.057512
1976	0	t	812	normal_username	_NOVALUE_	bama2183	2024-07-31 13:23:10.057512
1977	0	t	813	normal_username	_NOVALUE_	bama2184	2024-07-31 13:23:10.057512
1978	0	t	814	normal_username	_NOVALUE_	bama2185	2024-07-31 13:23:10.057512
1979	0	t	815	normal_username	_NOVALUE_	bama2186	2024-07-31 13:23:10.057512
1980	0	t	816	normal_username	_NOVALUE_	bama2187	2024-07-31 13:23:10.057512
1981	0	t	817	normal_username	_NOVALUE_	bama2188	2024-07-31 13:23:10.057512
1982	0	t	818	normal_username	_NOVALUE_	bama2189	2024-07-31 13:23:10.057512
1983	0	t	819	normal_username	_NOVALUE_	bama2190	2024-07-31 13:23:10.057512
1984	0	t	820	normal_username	_NOVALUE_	bama2191	2024-07-31 13:23:10.057512
1985	0	t	646	first_login	2024-07-01 16:48	_NOVALUE_	2024-08-01 08:43:05.837705
1986	0	t	782	first_login	2024-07-09 01:07	_NOVALUE_	2024-08-01 11:38:57.834376
1987	0	t	782	group	1-Month-20G	1-Month-50G	2024-08-01 11:39:27.95252
1988	0	t	782	traffic_periodic_accounting_daily_usage	21012865582	_NOVALUE_	2024-08-01 11:39:27.95252
1989	0	t	321	first_login	2024-07-03 12:17	_NOVALUE_	2024-08-01 14:21:41.630218
1990	0	t	566	first_login	2024-07-01 15:55	_NOVALUE_	2024-08-01 16:31:39.449503
1991	0	t	822	normal_username	_NOVALUE_	msm33	2024-08-01 16:38:41.344342
1992	0	t	822	abs_exp_date	_NOVALUE_	2024-08-29 16:38	2024-08-01 16:38:58.318116
1993	0	t	319	first_login	2024-07-01 23:55	_NOVALUE_	2024-08-01 16:54:37.583137
1994	0	t	448	first_login	2024-07-03 02:45	_NOVALUE_	2024-08-02 03:15:21.401206
1995	0	t	823	normal_username	_NOVALUE_	shirvani	2024-08-02 13:22:05.319956
1996	0	t	823	group	3-Month-150G	3-month-100-G-bama	2024-08-02 13:22:22.985888
1997	0	t	108	first_login	2024-05-03 11:31	_NOVALUE_	2024-08-02 14:35:37.196695
1998	0	t	322	first_login	2024-07-03 08:27	_NOVALUE_	2024-08-02 16:40:18.960778
1999	0	t	286	first_login	2024-07-02 15:49	_NOVALUE_	2024-08-02 18:14:19.643856
2000	0	t	747	first_login	2024-06-30 08:59	_NOVALUE_	2024-08-03 02:16:40.535813
2001	0	t	420	first_login	2024-07-04 04:52	_NOVALUE_	2024-08-03 06:11:30.132668
2002	0	t	575	first_login	2024-06-20 16:40	_NOVALUE_	2024-08-03 13:32:04.53658
2003	0	t	263	first_login	2024-07-05 09:35	_NOVALUE_	2024-08-03 15:30:38.657204
2004	0	t	824	normal_username	_NOVALUE_	noroozi	2024-08-03 18:07:27.133113
2005	0	t	824	traffic_periodic_accounting_daily	180	180	2024-08-03 18:07:46.552063
2006	0	t	824	traffic_periodic_accounting_daily_limit	300000M	100000M	2024-08-03 18:07:46.552063
2007	0	t	393	first_login	2024-07-11 09:18	_NOVALUE_	2024-08-04 02:10:31.722952
2008	0	t	825	normal_username	_NOVALUE_	meysam	2024-08-04 04:19:28.361933
2009	0	t	179	group	1-Month-20G	1-Month-35G	2024-08-04 07:54:12.198736
2010	0	t	729	first_login	2024-06-27 11:53	_NOVALUE_	2024-08-04 12:51:04.733399
2011	0	t	310	first_login	2024-07-01 16:06	_NOVALUE_	2024-08-04 16:04:53.244943
2012	0	t	478	first_login	2024-07-02 15:10	_NOVALUE_	2024-08-04 17:11:03.016006
2013	0	t	478	group	1-Month-50G	1-Month-35G	2024-08-04 17:11:38.750851
2014	0	t	826	normal_username	_NOVALUE_	skeyhan	2024-08-05 04:48:46.793382
2015	0	t	827	normal_username	_NOVALUE_	bagheri45	2024-08-05 06:36:45.987359
2016	0	t	828	normal_username	_NOVALUE_	nazgol	2024-08-05 06:38:51.90072
2017	0	t	637	first_login	2024-05-29 14:54	_NOVALUE_	2024-08-05 14:28:51.345598
2018	0	t	829	normal_username	_NOVALUE_	mghorbani	2024-08-05 16:42:33.992942
2019	0	t	829	traffic_periodic_accounting_daily	90	90	2024-08-05 16:44:31.919032
2020	0	t	829	group	3-month-100-G-bama	6-Month-300G	2024-08-05 16:45:56.900027
2021	0	t	829	abs_exp_date	_NOVALUE_	2024-12-01 15:46	2024-08-05 16:46:15.712851
2022	0	t	829	traffic_periodic_accounting_daily	90	118	2024-08-05 16:46:44.752419
2023	0	t	829	traffic_periodic_accounting_daily_limit	100000M	150000M	2024-08-05 16:46:44.752419
2024	0	t	348	first_login	2024-07-06 17:09	_NOVALUE_	2024-08-05 17:59:12.289021
2025	0	t	830	normal_username	_NOVALUE_	mahyar	2024-08-06 06:09:04.902413
2026	0	t	353	first_login	2024-07-07 05:28	_NOVALUE_	2024-08-06 06:10:01.256345
2027	0	t	353	group	1-Month-35G	1-Month-20G	2024-08-06 06:10:10.247061
2028	0	t	204	first_login	2024-04-21 09:18	_NOVALUE_	2024-08-06 06:20:45.552109
2029	0	t	630	first_login	2024-07-02 17:28	_NOVALUE_	2024-08-06 09:19:01.688067
2030	0	t	748	first_login	2024-07-01 05:23	_NOVALUE_	2024-08-06 09:45:00.839743
2031	0	t	391	first_login	2024-07-07 14:23	_NOVALUE_	2024-08-06 12:12:57.495393
2032	0	t	831	normal_username	_NOVALUE_	mehrdad	2024-08-06 12:19:37.493432
2033	0	t	316	first_login	2024-07-06 13:32	_NOVALUE_	2024-08-06 14:32:28.907404
2034	0	t	833	normal_username	_NOVALUE_	mojtaba	2024-08-06 17:10:14.793606
2035	0	t	833	abs_exp_date	_NOVALUE_	2024-08-08 17:10	2024-08-06 17:10:34.76341
2036	0	t	834	normal_username	_NOVALUE_	morteza35	2024-08-07 05:18:36.085333
2037	0	t	76	first_login	2024-05-09 04:49	_NOVALUE_	2024-08-07 06:47:40.855721
2038	0	t	248	first_login	2024-05-08 15:25	_NOVALUE_	2024-08-07 09:42:42.711966
2039	0	t	835	normal_username	_NOVALUE_	taghavi	2024-08-07 17:33:01.810811
2040	0	t	835	traffic_periodic_accounting_daily	180	180	2024-08-07 17:33:25.71387
2041	0	t	836	normal_username	_NOVALUE_	naji	2024-08-07 17:36:12.073555
2042	0	t	313	first_login	2024-07-08 14:48	_NOVALUE_	2024-08-08 02:46:44.434282
2043	0	t	791	first_login	2024-07-22 16:19	_NOVALUE_	2024-08-08 02:54:50.803434
2044	0	t	791	abs_exp_date	2024-08-11 16:14	_NOVALUE_	2024-08-08 02:55:14.935135
2045	0	t	837	normal_username	_NOVALUE_	bagheri	2024-08-08 03:16:56.752283
2046	0	t	838	normal_username	_NOVALUE_	m100	2024-08-08 09:17:34.621842
2047	0	t	839	normal_username	_NOVALUE_	bama2192	2024-08-08 12:08:50.269423
2048	0	t	840	normal_username	_NOVALUE_	bama2193	2024-08-08 12:08:50.269423
2049	0	t	841	normal_username	_NOVALUE_	bama2194	2024-08-08 12:08:50.269423
2050	0	t	842	normal_username	_NOVALUE_	bama2195	2024-08-08 12:08:50.269423
2051	0	t	843	normal_username	_NOVALUE_	bama2196	2024-08-08 12:08:50.269423
2052	0	t	844	normal_username	_NOVALUE_	bama2197	2024-08-08 12:08:50.269423
2053	0	t	845	normal_username	_NOVALUE_	bama2198	2024-08-08 12:08:50.269423
2054	0	t	846	normal_username	_NOVALUE_	bama2199	2024-08-08 12:08:50.269423
2055	0	t	847	normal_username	_NOVALUE_	bama2200	2024-08-08 12:08:50.269423
2056	0	t	848	normal_username	_NOVALUE_	bama2201	2024-08-08 12:08:50.269423
2057	0	t	419	first_login	2024-06-29 14:20	_NOVALUE_	2024-08-08 14:30:55.791027
2058	0	t	472	first_login	2024-07-08 09:04	_NOVALUE_	2024-08-08 15:47:52.834483
2059	0	t	850	normal_username	_NOVALUE_	noroozi	2024-08-09 03:11:40.913497
2060	0	t	850	abs_exp_date	_NOVALUE_	2025-01-30 02:12	2024-08-09 03:12:18.286618
2061	0	t	850	traffic_periodic_accounting_daily	180	174	2024-08-09 03:13:14.537728
2062	0	t	850	traffic_periodic_accounting_daily_limit	300000M	200000M	2024-08-09 03:13:14.537728
2063	0	t	746	first_login	2024-07-05 09:51	_NOVALUE_	2024-08-09 06:09:11.805026
2064	0	t	450	first_login	2024-07-10 08:28	_NOVALUE_	2024-08-09 06:14:10.335701
2065	0	t	852	normal_username	_NOVALUE_	arezum	2024-08-09 07:29:35.17848
2066	0	t	852	abs_exp_date	_NOVALUE_	2024-10-14 07:30	2024-08-09 07:30:18.646049
2067	0	t	852	traffic_periodic_accounting_daily	90	66	2024-08-09 07:31:13.938738
2068	0	t	852	traffic_periodic_accounting_daily_limit	150000M	100000M	2024-08-09 07:31:13.938738
2069	0	t	852	lock	_NOVALUE_		2024-08-09 08:37:34.39487
2353	0	t	202	first_login	2024-08-10 03:30	_NOVALUE_	2024-09-09 09:08:30.309939
2071	0	t	280	first_login	2024-07-10 16:51	_NOVALUE_	2024-08-09 17:04:35.688432
2072	0	t	208	first_login	2024-07-10 15:04	_NOVALUE_	2024-08-09 17:18:58.537628
2073	0	t	209	first_login	2024-07-10 15:20	_NOVALUE_	2024-08-09 17:19:22.984246
2074	0	t	210	first_login	2024-07-10 23:24	_NOVALUE_	2024-08-09 17:19:44.734618
2075	0	t	357	first_login	2024-07-09 01:46	_NOVALUE_	2024-08-10 02:21:42.314613
2076	0	t	202	first_login	2024-07-09 02:25	_NOVALUE_	2024-08-10 03:29:26.395077
2077	0	t	853	normal_username	_NOVALUE_	daftar15	2024-08-10 03:51:57.86396
2078	0	t	504	group	3-month-100-G-bama	2-Month-70G	2024-08-10 04:18:21.809164
2079	0	t	504	first_login	2024-06-19 13:32	_NOVALUE_	2024-08-10 04:18:45.767519
2080	0	t	689	first_login	2024-07-09 16:00	_NOVALUE_	2024-08-10 04:23:56.718419
2083	0	t	854	normal_username	_NOVALUE_	fahim	2024-08-10 06:13:16.868507
2085	0	t	652	first_login	2024-07-09 01:12	_NOVALUE_	2024-08-10 07:22:57.094194
2086	0	t	429	group	1-Month-20G	1-Month-35G	2024-08-10 09:27:59.388534
2087	0	t	855	normal_username	_NOVALUE_	msm72	2024-08-10 13:41:49.064986
2088	0	t	856	normal_username	_NOVALUE_	rafiee	2024-08-11 09:04:12.811147
2089	0	t	857	normal_username	_NOVALUE_	hanieh2	2024-08-11 15:43:10.351359
2090	0	t	858	normal_username	_NOVALUE_	ayusefi	2024-08-11 15:47:33.562073
2092	0	t	401	first_login	2024-05-13 06:11	_NOVALUE_	2024-08-11 16:17:50.247091
2093	0	t	747	multi_login	2	3	2024-08-12 03:56:49.226552
2094	0	t	277	first_login	2024-07-07 06:39	_NOVALUE_	2024-08-12 04:53:14.279932
2095	0	t	276	first_login	2024-07-07 11:16	_NOVALUE_	2024-08-12 04:54:03.059756
2098	0	t	179	group	1-Month-35G	1-Month-50G	2024-08-12 09:24:24.408764
2100	0	t	157	traffic_periodic_accounting_daily	180	180	2024-08-12 12:48:03.499292
2101	0	t	157	traffic_periodic_accounting_daily_limit	300000M	200000M	2024-08-12 12:48:03.499292
2298	0	t	323	multi_login	2	1	2024-09-04 04:54:27.001737
2103	0	t	860	normal_username	_NOVALUE_	noroozian	2024-08-12 16:00:40.757776
2104	0	t	158	first_login	2024-05-14 12:45	_NOVALUE_	2024-08-12 16:21:59.44089
2107	0	t	84	first_login	2024-07-13 08:50	_NOVALUE_	2024-08-12 16:24:38.605005
2108	0	t	130	first_login	2024-06-12 09:17	_NOVALUE_	2024-08-13 05:12:31.02125
2111	0	t	130	traffic_periodic_accounting_daily	60	60	2024-08-13 05:13:03.717501
2112	0	t	130	traffic_periodic_accounting_daily_limit	200000M	20000M	2024-08-13 05:13:03.717501
2113	0	t	707	first_login	2024-06-11 04:19	_NOVALUE_	2024-08-13 05:43:45.813901
2114	0	t	707	group	1-Month-20G	6-Month-300G	2024-08-13 05:44:22.874347
2115	0	t	707	traffic_periodic_accounting_daily	180	180	2024-08-13 05:44:52.156476
2116	0	t	707	traffic_periodic_accounting_daily_limit	300000M	200000M	2024-08-13 05:44:52.156476
2120	0	t	103	first_login	2024-07-14 17:11	_NOVALUE_	2024-08-13 23:02:38.397422
2121	0	t	423	first_login	2024-07-17 14:15	_NOVALUE_	2024-08-14 06:43:32.157102
2124	0	t	396	first_login	2024-03-12 14:17	_NOVALUE_	2024-08-14 14:30:07.208484
2128	0	t	200	first_login	2024-07-16 03:22	_NOVALUE_	2024-08-15 08:16:05.682914
2130	0	t	862	normal_username	_NOVALUE_	roodaki	2024-08-15 10:48:42.713303
2131	0	t	811	group	1-Month-20G	1-Month-35G	2024-08-15 12:33:08.660526
2132	0	t	528	first_login	2024-07-14 16:25	_NOVALUE_	2024-08-15 12:35:31.05072
2133	0	t	595	first_login	2024-05-17 12:55	_NOVALUE_	2024-08-15 16:30:45.35134
2135	0	t	181	first_login	2024-05-17 14:33	_NOVALUE_	2024-08-16 02:42:45.00688
2136	0	t	863	normal_username	_NOVALUE_	bama2202	2024-08-16 09:18:08.528673
2137	0	t	864	normal_username	_NOVALUE_	bama2203	2024-08-16 09:18:08.528673
2138	0	t	865	normal_username	_NOVALUE_	bama2204	2024-08-16 09:18:08.528673
2139	0	t	866	normal_username	_NOVALUE_	bama2205	2024-08-16 09:18:08.528673
2140	0	t	867	normal_username	_NOVALUE_	bama2206	2024-08-16 09:18:08.528673
2141	0	t	868	normal_username	_NOVALUE_	bama2207	2024-08-16 09:18:08.528673
2142	0	t	869	normal_username	_NOVALUE_	bama2208	2024-08-16 09:18:08.528673
2143	0	t	870	normal_username	_NOVALUE_	bama2209	2024-08-16 09:18:08.528673
2144	0	t	871	normal_username	_NOVALUE_	bama2210	2024-08-16 09:18:08.528673
2145	0	t	872	normal_username	_NOVALUE_	bama2211	2024-08-16 09:18:08.528673
2147	0	t	874	abs_exp_date	_NOVALUE_	2024-09-08 14:13	2024-08-16 14:13:32.761513
2148	0	t	875	normal_username	_NOVALUE_	hivapc	2024-08-16 17:35:18.416368
2150	0	t	197	first_login	2024-02-18 17:01	_NOVALUE_	2024-08-17 16:01:02.291239
2151	0	t	878	normal_username	_NOVALUE_	test7	2024-08-17 16:52:11.934063
2153	0	t	430	first_login	2024-07-18 13:20	_NOVALUE_	2024-08-18 14:26:53.920895
2155	0	t	349	first_login	2024-07-17 07:34	_NOVALUE_	2024-08-19 03:56:31.291936
2156	0	t	350	first_login	2024-07-17 08:32	_NOVALUE_	2024-08-19 03:57:00.639458
2158	0	t	213	first_login	2024-02-20 05:51	_NOVALUE_	2024-08-19 07:38:51.110197
2159	0	t	880	normal_username	_NOVALUE_	elmira2	2024-08-19 07:39:46.112731
2160	0	t	189	first_login	2024-02-18 07:15	_NOVALUE_	2024-08-19 10:18:40.119642
2162	0	t	881	normal_username	_NOVALUE_	azam2	2024-08-19 10:37:53.328763
2163	0	t	522	first_login	2024-07-25 08:31	_NOVALUE_	2024-08-19 13:53:00.604616
2165	0	t	93	lock	_NOVALUE_		2024-08-19 15:03:43.264158
2167	0	t	882	abs_exp_date	_NOVALUE_	2024-08-20 16:01	2024-08-19 16:01:43.664776
2168	0	t	718	first_login	2024-07-20 08:57	_NOVALUE_	2024-08-20 11:06:56.904116
2171	0	t	725	group	2-Month-70G	3-month-100-G-bama	2024-08-20 11:21:45.208608
2172	0	t	709	first_login	2024-07-22 07:34	_NOVALUE_	2024-08-20 11:22:18.234677
2173	0	t	649	first_login	2024-07-22 01:14	_NOVALUE_	2024-08-20 11:23:27.127508
2175	0	t	596	first_login	2024-07-19 09:10	_NOVALUE_	2024-08-20 15:52:11.831947
2176	0	t	883	normal_username	_NOVALUE_	test600	2024-08-21 01:05:31.887219
2178	0	t	884	normal_username	_NOVALUE_	sherafat	2024-08-21 02:21:14.39639
2179	0	t	116	first_login	2024-05-11 06:03	_NOVALUE_	2024-08-21 06:33:24.665746
2180	0	t	116	traffic_periodic_accounting_daily	90	90	2024-08-21 06:33:46.40347
2181	0	t	116	traffic_periodic_accounting_daily_limit	40000M	20000M	2024-08-21 06:33:46.40347
2185	0	t	798	first_login	2024-07-26 16:42	_NOVALUE_	2024-08-21 17:31:52.094723
2186	0	t	798	abs_exp_date	2024-08-21 12:50	_NOVALUE_	2024-08-21 17:32:02.032144
2188	0	t	429	first_login	2024-07-22 11:17	_NOVALUE_	2024-08-22 01:10:38.610035
2198	0	t	254	first_login	2024-07-20 22:07	_NOVALUE_	2024-08-23 06:18:35.090419
2200	0	t	257	first_login	2024-05-23 14:15	_NOVALUE_	2024-08-23 16:36:09.756498
2194	0	t	531	first_login	2024-05-23 14:06	_NOVALUE_	2024-08-22 15:53:13.098403
2201	0	t	889	normal_username	_NOVALUE_	saghar	2024-08-24 02:28:31.983729
2202	0	t	890	normal_username	_NOVALUE_	m52	2024-08-24 04:51:09.37415
2203	0	t	394	first_login	2024-07-25 02:49	_NOVALUE_	2024-08-24 04:55:05.280661
2204	0	t	891	normal_username	_NOVALUE_	daftar20	2024-08-24 07:47:36.361085
2206	0	t	179	first_login	2024-07-25 06:12	_NOVALUE_	2024-08-24 11:50:45.357154
2207	0	t	269	first_login	2024-05-25 13:17	_NOVALUE_	2024-08-24 12:09:15.736244
2081	0	t	688	first_login	2024-07-17 10:53	_NOVALUE_	2024-08-10 04:24:38.06432
2082	0	t	768	first_login	2024-07-06 08:13	_NOVALUE_	2024-08-10 04:24:55.228247
2084	0	t	854	traffic_periodic_accounting_daily	90	90	2024-08-10 06:13:38.307279
2091	0	t	858	abs_exp_date	_NOVALUE_	2024-09-30 15:48	2024-08-11 15:48:34.180492
2096	0	t	516	first_login	2024-07-13 01:40	_NOVALUE_	2024-08-12 04:57:49.310588
2097	0	t	408	first_login	2024-05-14 02:16	_NOVALUE_	2024-08-12 08:28:08.280182
2099	0	t	157	first_login	2024-02-13 23:58	_NOVALUE_	2024-08-12 12:47:44.918576
2105	0	t	158	traffic_periodic_accounting_daily	90	90	2024-08-12 16:22:33.661963
2106	0	t	158	traffic_periodic_accounting_daily_limit	150000M	120000M	2024-08-12 16:22:33.661963
2109	0	t	130	traffic_periodic_accounting_daily	60	60	2024-08-13 05:12:46.3179
2110	0	t	130	traffic_periodic_accounting_daily_limit	70000M	200000M	2024-08-13 05:12:46.3179
2117	0	t	861	normal_username	_NOVALUE_	raheleh	2024-08-13 08:19:02.387769
2118	0	t	335	first_login	2024-07-14 12:18	_NOVALUE_	2024-08-13 13:15:58.773937
2119	0	t	512	first_login	2024-07-14 07:10	_NOVALUE_	2024-08-13 16:25:33.843748
2122	0	t	423	group	1-Month-35G	3-month-100-G-bama	2024-08-14 06:43:49.529565
2123	0	t	307	group	3-Month-150G	6-Month-300G	2024-08-14 07:05:16.483656
2125	0	t	396	group	1-Month-20G	6-Month-300G	2024-08-14 14:30:21.254908
2126	0	t	396	traffic_periodic_accounting_daily	180	180	2024-08-14 14:30:53.280384
2127	0	t	396	traffic_periodic_accounting_daily_limit	300000M	200000M	2024-08-14 14:30:53.280384
2129	0	t	400	first_login	2024-07-15 17:12	_NOVALUE_	2024-08-15 10:38:38.415011
2134	0	t	595	traffic_periodic_accounting_daily	90	90	2024-08-15 16:31:15.989202
2146	0	t	874	normal_username	_NOVALUE_	babak2	2024-08-16 14:12:00.832084
2149	0	t	610	first_login	2024-07-17 15:18	_NOVALUE_	2024-08-17 00:25:27.317388
2152	0	t	878	abs_exp_date	_NOVALUE_	2024-08-18 16:53	2024-08-17 16:53:20.317936
2154	0	t	879	normal_username	_NOVALUE_	hafezpc	2024-08-18 15:20:25.626702
2157	0	t	787	first_login	2024-07-17 08:43	_NOVALUE_	2024-08-19 03:57:39.304747
2161	0	t	189	group	6-Month-300G	12-Month-600G	2024-08-19 10:19:12.506453
2164	0	t	271	first_login	2024-07-19 20:21	_NOVALUE_	2024-08-19 15:02:18.105108
2166	0	t	882	normal_username	_NOVALUE_	test9	2024-08-19 15:54:34.319956
2169	0	t	724	first_login	2024-06-24 10:11	_NOVALUE_	2024-08-20 11:19:40.982858
2170	0	t	724	group	2-Month-70G	1-Month-20G	2024-08-20 11:20:29.342131
2174	0	t	275	first_login	2024-07-21 15:12	_NOVALUE_	2024-08-20 11:24:14.737138
2177	0	t	883	abs_exp_date	_NOVALUE_	2024-08-22 01:05	2024-08-21 01:05:52.417236
2182	0	t	116	traffic_periodic_accounting_daily	90	90	2024-08-21 06:50:21.514641
2183	0	t	116	traffic_periodic_accounting_daily_limit	20000M	10000M	2024-08-21 06:50:21.514641
2184	0	t	878	abs_exp_date	2024-08-18 16:53	2024-08-22 12:01	2024-08-21 12:01:48.115931
2187	0	t	798	group	1-Month-10G	3-month-100-G-bama	2024-08-21 17:32:16.098488
2189	0	t	727	first_login	2024-07-24 09:12	_NOVALUE_	2024-08-22 03:53:36.445418
2199	0	t	887	normal_username	_NOVALUE_	mahali	2024-08-23 06:45:43.808269
2193	0	t	287	first_login	2024-07-23 10:30	_NOVALUE_	2024-08-22 14:34:01.106243
2195	0	t	531	traffic_periodic_accounting_daily	90	90	2024-08-22 16:04:18.710598
2196	0	t	531	traffic_periodic_accounting_daily_limit	150000M	100000M	2024-08-22 16:04:18.710598
2197	0	t	886	normal_username	_NOVALUE_	saharh	2024-08-23 03:13:09.510957
2205	0	t	113	first_login	2024-07-23 00:27	_NOVALUE_	2024-08-24 10:27:55.201985
2208	0	t	893	normal_username	_NOVALUE_	asadi	2024-08-24 12:12:23.765388
2209	0	t	318	group	3-Month-150G	6-Month-300G	2024-08-24 12:29:00.251
2818	0	t	983	first_login	2024-09-21 04:47	_NOVALUE_	2024-10-28 06:16:58.498352
2211	0	t	274	first_login	2024-07-25 16:57	_NOVALUE_	2024-08-25 03:21:54.364836
2212	0	t	441	first_login	2024-07-22 15:37	_NOVALUE_	2024-08-25 05:59:13.323603
2213	0	t	837	group	1-Month-20G	1-Month-50G	2024-08-25 06:42:18.916523
2214	0	t	283	first_login	2024-05-27 06:10	_NOVALUE_	2024-08-25 07:07:04.828418
2215	0	t	894	normal_username	_NOVALUE_	johari	2024-08-25 14:01:26.299444
2216	0	t	278	first_login	2024-07-27 01:31	_NOVALUE_	2024-08-26 03:59:47.934208
2217	0	t	719	first_login	2024-07-24 00:26	_NOVALUE_	2024-08-26 04:00:53.692821
2218	0	t	364	first_login	2024-07-14 13:53	_NOVALUE_	2024-08-26 05:45:42.775315
2219	0	t	270	first_login	2024-07-26 06:43	_NOVALUE_	2024-08-26 13:39:47.234958
2220	0	t	878	first_login	2024-08-21 16:32	_NOVALUE_	2024-08-26 13:45:48.44338
2221	0	t	878	abs_exp_date	2024-08-22 12:01	2024-08-27 13:46	2024-08-26 13:46:08.519972
2222	0	t	590	first_login	2024-06-13 01:06	_NOVALUE_	2024-08-26 16:26:47.495044
2223	0	t	728	first_login	2024-07-26 16:24	_NOVALUE_	2024-08-26 16:27:26.699136
2224	0	t	662	first_login	2024-07-21 13:26	_NOVALUE_	2024-08-26 16:28:14.103613
2225	0	t	895	normal_username	_NOVALUE_	test220	2024-08-26 17:58:39.404642
2226	0	t	895	abs_exp_date	_NOVALUE_	2024-08-27 18:16	2024-08-26 18:16:29.168918
2227	0	t	336	first_login	2024-07-27 23:02	_NOVALUE_	2024-08-27 01:11:40.953032
2228	0	t	713	first_login	2024-07-28 04:03	_NOVALUE_	2024-08-27 07:41:27.639624
2229	0	t	561	first_login	2024-07-28 05:44	_NOVALUE_	2024-08-27 08:27:26.058275
2230	0	t	790	first_login	2024-07-22 13:13	_NOVALUE_	2024-08-27 10:56:06.917986
2231	0	t	198	first_login	2024-05-16 14:03	_NOVALUE_	2024-08-27 12:19:20.111844
2232	0	t	190	first_login	2024-07-27 07:11	_NOVALUE_	2024-08-27 13:21:18.143484
2233	0	t	896	normal_username	_NOVALUE_	arash10	2024-08-27 13:25:48.420465
2234	0	t	897	normal_username	_NOVALUE_	amirhossein	2024-08-27 13:33:05.308888
2235	0	t	899	normal_username	_NOVALUE_	hizomi	2024-08-28 08:16:12.77379
2236	0	t	900	normal_username	_NOVALUE_	shamim	2024-08-28 12:36:08.686178
2237	0	t	513	first_login	2024-07-29 07:06	_NOVALUE_	2024-08-28 12:56:53.417832
2238	0	t	901	normal_username	_NOVALUE_	abbasi	2024-08-28 13:07:57.643574
2239	0	t	319	first_login	2024-08-01 17:02	_NOVALUE_	2024-08-28 13:50:09.912938
2240	0	t	902	normal_username	_NOVALUE_	enayat	2024-08-28 15:51:09.942664
2241	0	t	252	first_login	2024-07-29 16:04	_NOVALUE_	2024-08-28 16:19:34.196976
2242	0	t	30	first_login	2024-07-29 16:11	_NOVALUE_	2024-08-28 16:22:18.074694
2243	0	t	279	first_login	2024-07-30 07:00	_NOVALUE_	2024-08-29 09:01:53.756844
2244	0	t	742	first_login	2024-07-28 06:43	_NOVALUE_	2024-08-29 15:36:35.373959
2245	0	t	579	first_login	2024-07-30 10:00	_NOVALUE_	2024-08-29 15:56:03.891657
2246	0	t	894	lock	_NOVALUE_		2024-08-30 06:42:59.513829
2247	0	t	903	normal_username	_NOVALUE_	rayan	2024-08-30 07:29:52.59948
2248	0	t	905	normal_username	_NOVALUE_	heliyapc	2024-08-30 07:37:32.361227
2249	0	t	906	normal_username	_NOVALUE_	ahmadi2	2024-08-30 08:33:43.961019
2250	0	t	458	first_login	2024-07-31 04:45	_NOVALUE_	2024-08-30 13:18:02.825575
2251	0	t	320	first_login	2024-07-31 10:37	_NOVALUE_	2024-08-30 16:44:57.173516
2819	0	t	983	traffic_periodic_accounting_daily	90	90	2024-10-28 06:17:58.801266
2253	0	t	646	first_login	2024-08-01 08:44	_NOVALUE_	2024-08-31 12:02:56.358146
2254	0	t	907	normal_username	_NOVALUE_	test80	2024-08-31 12:40:44.506862
2255	0	t	907	abs_exp_date	_NOVALUE_	2024-09-01 12:40	2024-08-31 12:40:58.811163
2256	0	t	448	group	1-Month-50G	2-Month-70G	2024-08-31 13:39:37.20167
2257	0	t	811	first_login	2024-08-01 11:51	_NOVALUE_	2024-08-31 14:56:26.284355
2258	0	t	908	normal_username	_NOVALUE_	bama2212	2024-08-31 14:58:12.245121
2259	0	t	909	normal_username	_NOVALUE_	bama2213	2024-08-31 14:58:12.245121
2260	0	t	910	normal_username	_NOVALUE_	bama2214	2024-08-31 14:58:12.245121
2261	0	t	911	normal_username	_NOVALUE_	bama2215	2024-08-31 14:58:12.245121
2262	0	t	912	normal_username	_NOVALUE_	bama2216	2024-08-31 14:58:12.245121
2263	0	t	913	normal_username	_NOVALUE_	bama2217	2024-08-31 14:58:12.245121
2264	0	t	914	normal_username	_NOVALUE_	bama2218	2024-08-31 14:58:12.245121
2265	0	t	915	normal_username	_NOVALUE_	bama2219	2024-08-31 14:58:12.245121
2266	0	t	916	normal_username	_NOVALUE_	bama2220	2024-08-31 14:58:12.245121
2267	0	t	917	normal_username	_NOVALUE_	bama2221	2024-08-31 14:58:12.245121
2268	0	t	340	first_login	2024-07-29 19:20	_NOVALUE_	2024-08-31 15:37:16.775341
2269	0	t	919	normal_username	_NOVALUE_	aghasemi	2024-08-31 16:38:29.20915
2270	0	t	359	first_login	2024-07-31 08:46	_NOVALUE_	2024-08-31 17:11:25.610837
2271	0	t	321	first_login	2024-08-01 14:30	_NOVALUE_	2024-09-01 13:01:23.705427
2272	0	t	920	normal_username	_NOVALUE_	zolfaghari	2024-09-01 13:16:31.863643
2273	0	t	920	group	1-Month-35G	12-Month-600G	2024-09-01 13:17:19.710652
2274	0	t	920	abs_exp_date	_NOVALUE_	2025-06-24 13:17	2024-09-01 13:17:37.094566
2275	0	t	566	first_login	2024-08-01 17:06	_NOVALUE_	2024-09-01 13:47:57.416396
2276	0	t	531	traffic_periodic_accounting_daily	90	90	2024-09-01 14:56:37.256992
2277	0	t	531	traffic_periodic_accounting_daily_limit	100000M	150000M	2024-09-01 14:56:37.256992
2278	0	t	286	first_login	2024-08-02 21:58	_NOVALUE_	2024-09-02 03:56:57.998395
2279	0	t	322	first_login	2024-08-02 17:28	_NOVALUE_	2024-09-02 14:18:00.028539
2280	0	t	857	first_login	2024-08-11 15:51	_NOVALUE_	2024-09-02 16:15:33.708856
2281	0	t	921	normal_username	_NOVALUE_	hanieh2	2024-09-02 16:16:59.539726
2282	0	t	420	first_login	2024-08-03 06:11	_NOVALUE_	2024-09-03 03:38:05.19028
2283	0	t	922	normal_username	_NOVALUE_	daftar21	2024-09-03 09:19:06.034636
2284	0	t	923	normal_username	_NOVALUE_	reyhaneh	2024-09-03 11:55:56.883438
2285	0	t	825	first_login	2024-08-04 04:20	_NOVALUE_	2024-09-03 11:56:17.947658
2286	0	t	924	normal_username	_NOVALUE_	rafiee	2024-09-03 12:33:11.247362
2287	0	t	924	group	1-Month-35G	1-Month-50G	2024-09-03 12:34:01.24215
2288	0	t	924	abs_exp_date	_NOVALUE_	2024-10-05 14:33	2024-09-03 14:33:03.821003
2289	0	t	924	group	1-Month-50G	2-Month-70G	2024-09-03 14:33:29.400099
2290	0	t	925	normal_username	_NOVALUE_	test900	2024-09-03 14:52:28.602686
2291	0	t	925	abs_exp_date	_NOVALUE_	2024-09-04 14:53	2024-09-03 14:53:18.301445
2292	0	t	926	normal_username	_NOVALUE_	rrastegar	2024-09-03 14:57:41.214201
2293	0	t	478	first_login	2024-08-04 17:11	_NOVALUE_	2024-09-03 15:00:01.710692
2294	0	t	830	first_login	2024-08-06 06:18	_NOVALUE_	2024-09-03 15:15:44.17083
2295	0	t	830	group	1-Month-35G	3-Month-150G	2024-09-03 15:16:01.444416
2296	0	t	927	normal_username	_NOVALUE_	saba	2024-09-03 16:33:11.301826
2297	0	t	263	first_login	2024-08-03 15:49	_NOVALUE_	2024-09-03 17:39:53.356535
2299	0	t	928	normal_username	_NOVALUE_	seyf	2024-09-04 04:57:35.048859
2300	0	t	928	normal_username	seyf	seif	2024-09-04 05:02:26.122625
2301	0	t	928	traffic_periodic_accounting_daily	365	365	2024-09-04 05:04:01.723336
2302	0	t	928	traffic_periodic_accounting_daily_limit	600000M	650000M	2024-09-04 05:04:01.723336
2303	0	t	310	first_login	2024-08-05 02:20	_NOVALUE_	2024-09-04 07:05:50.302189
2304	0	t	826	first_login	2024-08-05 06:54	_NOVALUE_	2024-09-04 11:29:53.267258
2305	0	t	827	first_login	2024-08-05 06:49	_NOVALUE_	2024-09-04 11:30:11.064863
2306	0	t	929	normal_username	_NOVALUE_	matin	2024-09-04 11:32:02.302352
2307	0	t	828	first_login	2024-08-05 08:33	_NOVALUE_	2024-09-04 14:27:32.757006
2308	0	t	348	first_login	2024-08-05 18:34	_NOVALUE_	2024-09-05 01:03:03.285915
2309	0	t	348	lock	_NOVALUE_		2024-09-05 01:03:15.292194
2310	0	t	930	normal_username	_NOVALUE_	manzar	2024-09-05 02:47:33.373834
2311	0	t	930	traffic_periodic_accounting_daily	180	180	2024-09-05 02:47:52.119801
2312	0	t	930	traffic_periodic_accounting_daily_limit	300000M	250000M	2024-09-05 02:47:52.119801
2313	0	t	575	first_login	2024-08-03 14:58	_NOVALUE_	2024-09-05 07:37:57.805321
2314	0	t	348	lock		_NOVALUE_	2024-09-05 07:38:51.398623
2315	0	t	893	group	1-Month-35G	1-Month-70G	2024-09-05 09:12:48.09016
2316	0	t	893	group	1-Month-70G	1-Month-100G	2024-09-05 09:13:02.636341
2317	0	t	794	first_login	2024-07-26 04:22	_NOVALUE_	2024-09-05 09:54:23.48552
2318	0	t	794	abs_exp_date	2024-09-05 04:13	_NOVALUE_	2024-09-05 09:54:40.277419
2319	0	t	794	group	2-Month-70G	1-Month-35G	2024-09-05 09:54:55.233987
2320	0	t	391	first_login	2024-08-06 12:24	_NOVALUE_	2024-09-05 10:00:12.06185
2321	0	t	353	first_login	2024-08-06 06:15	_NOVALUE_	2024-09-05 10:52:01.964652
2322	0	t	931	normal_username	_NOVALUE_	baran	2024-09-06 04:06:38.930573
2323	0	t	855	first_login	2024-08-10 13:58	_NOVALUE_	2024-09-06 08:48:06.975117
2324	0	t	932	normal_username	_NOVALUE_	msm72	2024-09-06 08:49:58.866184
2325	0	t	637	first_login	2024-08-05 17:02	_NOVALUE_	2024-09-06 12:49:42.135834
2326	0	t	933	normal_username	_NOVALUE_	elham	2024-09-06 16:31:17.837754
2327	0	t	50	first_login	2024-02-08 18:06	_NOVALUE_	2024-09-06 16:33:50.31467
2332	0	t	747	first_login	2024-08-03 02:18	_NOVALUE_	2024-09-07 05:01:51.831331
2328	0	t	50	abs_exp_date	2024-09-05 16:48	2025-09-05 16:34	2024-09-06 16:34:13.615667
2333	0	t	747	group	1-Month-50G	3-month-100-G-bama	2024-09-07 05:02:05.153314
2336	0	t	450	group	1-Month-35G	1-Month-70G	2024-09-07 13:44:15.696199
2337	0	t	450	group	1-Month-70G	2-Month-70G	2024-09-07 13:44:34.01042
2338	0	t	316	first_login	2024-08-06 14:53	_NOVALUE_	2024-09-07 13:46:38.870936
2339	0	t	313	first_login	2024-08-08 04:10	_NOVALUE_	2024-09-07 13:59:37.575833
2341	0	t	934	normal_username	_NOVALUE_	baran2	2024-09-07 14:11:19.01512
2345	0	t	862	group	1-Month-35G	1-Month-50G	2024-09-08 04:00:22.809648
2346	0	t	419	first_login	2024-08-08 14:47	_NOVALUE_	2024-09-08 04:41:35.575268
2347	0	t	472	first_login	2024-08-08 16:57	_NOVALUE_	2024-09-08 07:47:52.904351
2348	0	t	935	normal_username	_NOVALUE_	majd	2024-09-08 13:08:47.686648
2351	0	t	630	group	1-Month-35G	1-Month-50G	2024-09-08 15:09:36.200115
2354	0	t	280	first_login	2024-08-09 17:05	_NOVALUE_	2024-09-09 13:10:56.913257
2356	0	t	209	first_login	2024-08-10 00:17	_NOVALUE_	2024-09-09 13:57:01.323454
2358	0	t	605	first_login	2024-07-19 08:45	_NOVALUE_	2024-09-09 13:58:27.843364
2359	0	t	605	abs_exp_date	2024-09-08 16:44	_NOVALUE_	2024-09-09 13:58:37.194704
2360	0	t	605	group	2-Month-70G	1-Month-35G	2024-09-09 13:58:49.117184
2361	0	t	838	first_login	2024-08-08 09:22	_NOVALUE_	2024-09-09 14:07:39.306648
2363	0	t	939	normal_username	_NOVALUE_	farzan1	2024-09-10 05:40:35.634616
2364	0	t	930	abs_exp_date	_NOVALUE_	2024-09-10 08:50	2024-09-10 05:56:26.541018
2365	0	t	930	abs_exp_date	2024-09-10 08:50	2025-03-03 04:56	2024-09-10 05:56:37.250654
2368	0	t	874	first_login	2024-08-16 15:34	_NOVALUE_	2024-09-10 15:17:02.952238
2369	0	t	874	abs_exp_date	2024-09-08 14:13	_NOVALUE_	2024-09-10 15:17:15.464562
2372	0	t	795	first_login	2024-07-26 02:52	_NOVALUE_	2024-09-11 13:20:31.957053
2374	0	t	513	group	1-Month-50G	1-Month-35G	2024-09-11 15:03:13.556
2375	0	t	516	first_login	2024-08-12 04:59	_NOVALUE_	2024-09-11 16:09:32.630439
2376	0	t	208	group	1-Month-20G	1-Month-50G	2024-09-12 06:08:58.545049
2387	0	t	84	first_login	2024-08-12 21:50	_NOVALUE_	2024-09-12 10:50:23.472131
2392	0	t	953	normal_username	_NOVALUE_	arast	2024-09-13 14:22:44.007696
2393	0	t	572	first_login	2024-07-23 13:04	_NOVALUE_	2024-09-13 14:25:31.534833
2394	0	t	954	normal_username	_NOVALUE_	milad2	2024-09-13 17:22:44.352482
2396	0	t	587	group	6-Month-300G	12-Month-600G	2024-09-14 06:10:39.96738
2398	0	t	587	first_login	2024-05-13 03:43	_NOVALUE_	2024-09-14 06:11:09.838397
2399	0	t	587	abs_exp_date	2024-09-13 15:21	_NOVALUE_	2024-09-14 06:11:19.270596
2400	0	t	956	normal_username	_NOVALUE_	saghar	2024-09-14 06:30:05.927935
2402	0	t	103	first_login	2024-08-14 02:38	_NOVALUE_	2024-09-14 13:16:48.176681
2403	0	t	862	first_login	2024-08-15 11:24	_NOVALUE_	2024-09-14 15:28:49.138038
2404	0	t	400	first_login	2024-08-15 10:40	_NOVALUE_	2024-09-14 16:59:59.223882
2405	0	t	412	first_login	2024-03-15 11:51	_NOVALUE_	2024-09-14 18:19:56.750008
2406	0	t	512	first_login	2024-08-13 23:14	_NOVALUE_	2024-09-15 01:03:15.233357
2407	0	t	62	first_login	2024-04-29 05:49	_NOVALUE_	2024-09-15 04:12:24.034725
2408	0	t	62	group	3-Month-150G	1-Month-35G	2024-09-15 04:12:36.975168
2410	0	t	276	first_login	2024-08-12 07:43	_NOVALUE_	2024-09-15 04:14:01.656961
2411	0	t	532	first_login	2024-06-19 00:49	_NOVALUE_	2024-09-15 14:36:00.012597
2412	0	t	532	group	3-month-100-G-bama	1-Month-35G	2024-09-15 14:36:12.223972
2413	0	t	958	normal_username	_NOVALUE_	ghazal	2024-09-15 15:18:44.857863
2415	0	t	712	first_login	2024-06-16 17:50	_NOVALUE_	2024-09-16 04:35:56.006475
2417	0	t	712	traffic_periodic_accounting_daily	180	180	2024-09-16 04:36:49.040009
2418	0	t	433	first_login	2024-06-18 13:26	_NOVALUE_	2024-09-16 14:19:21.792178
2419	0	t	433	traffic_periodic_accounting_daily	90	90	2024-09-16 14:19:40.913835
2420	0	t	59	first_login	2024-06-18 13:26	_NOVALUE_	2024-09-17 03:29:57.895171
2421	0	t	959	normal_username	_NOVALUE_	dashti2	2024-09-17 13:29:00.728959
2422	0	t	430	first_login	2024-08-18 14:39	_NOVALUE_	2024-09-17 17:00:22.145073
2424	0	t	960	traffic_periodic_accounting_daily	30	167	2024-09-17 18:15:01.14147
2425	0	t	960	abs_exp_date	_NOVALUE_	2024-09-17 21:02	2024-09-17 18:15:42.812573
2426	0	t	960	abs_exp_date	2024-09-17 21:02	2025-03-03 17:16	2024-09-17 18:16:14.139153
2427	0	t	652	first_login	2024-08-10 09:14	_NOVALUE_	2024-09-18 03:33:19.52982
2428	0	t	522	first_login	2024-08-29 10:17	_NOVALUE_	2024-09-18 10:29:58.340164
2429	0	t	584	first_login	2024-07-09 04:13	_NOVALUE_	2024-09-19 05:15:10.125487
2430	0	t	271	first_login	2024-08-19 15:02	_NOVALUE_	2024-09-19 08:13:41.21456
2433	0	t	396	lock	_NOVALUE_		2024-09-19 16:40:50.006835
2434	0	t	972	normal_username	_NOVALUE_	bama2232	2024-09-20 05:02:57.328589
2435	0	t	973	normal_username	_NOVALUE_	bama2233	2024-09-20 05:02:57.328589
2436	0	t	974	normal_username	_NOVALUE_	bama2234	2024-09-20 05:02:57.328589
2437	0	t	975	normal_username	_NOVALUE_	bama2235	2024-09-20 05:02:57.328589
2438	0	t	976	normal_username	_NOVALUE_	bama2236	2024-09-20 05:02:57.328589
2439	0	t	977	normal_username	_NOVALUE_	bama2237	2024-09-20 05:02:57.328589
2440	0	t	978	normal_username	_NOVALUE_	bama2238	2024-09-20 05:02:57.328589
2441	0	t	979	normal_username	_NOVALUE_	bama2239	2024-09-20 05:02:57.328589
2442	0	t	980	normal_username	_NOVALUE_	bama2240	2024-09-20 05:02:57.328589
2443	0	t	981	normal_username	_NOVALUE_	bama2241	2024-09-20 05:02:57.328589
2445	0	t	983	normal_username	_NOVALUE_	fatemeh40	2024-09-21 03:38:47.747822
2447	0	t	983	abs_exp_date	_NOVALUE_	2024-10-28 03:39	2024-09-21 03:39:12.628995
2448	0	t	596	first_login	2024-08-20 15:52	_NOVALUE_	2024-09-21 06:43:07.330229
2450	0	t	649	first_login	2024-08-26 04:22	_NOVALUE_	2024-09-21 08:20:35.098049
2452	0	t	718	first_login	2024-08-20 12:24	_NOVALUE_	2024-09-21 08:21:44.916461
2454	0	t	724	first_login	2024-08-27 15:46	_NOVALUE_	2024-09-21 08:22:46.045338
2457	0	t	985	normal_username	_NOVALUE_	fasa	2024-09-22 03:40:13.716574
2458	0	t	715	first_login	2024-06-23 08:27	_NOVALUE_	2024-09-22 04:39:05.994299
2461	0	t	880	first_login	2024-08-19 07:45	_NOVALUE_	2024-09-22 11:36:10.254387
2463	0	t	986	normal_username	_NOVALUE_	reyhaneh	2024-09-22 14:43:28.812455
2465	0	t	987	normal_username	_NOVALUE_	hosseini3	2024-09-23 06:11:10.537554
2329	0	t	50	traffic_periodic_accounting_daily	210	364	2024-09-06 16:34:45.227101
2330	0	t	50	traffic_periodic_accounting_daily_limit	450000M	600000M	2024-09-06 16:34:45.227101
2331	0	t	50	traffic_periodic_accounting_daily_usage	101817670	_NOVALUE_	2024-09-06 16:34:45.227101
2334	0	t	837	first_login	2024-08-08 03:29	_NOVALUE_	2024-09-07 11:11:40.936077
2335	0	t	889	group	1-Month-50G	1-Month-100G	2024-09-07 12:33:16.868341
2340	0	t	717	first_login	2024-07-30 08:10	_NOVALUE_	2024-09-07 13:59:59.330515
2342	0	t	747	traffic_periodic_accounting_daily	90	90	2024-09-07 14:13:47.614239
2343	0	t	747	multi_login	3	2	2024-09-07 14:14:00.570745
2344	0	t	602	first_login	2024-06-03 05:03	_NOVALUE_	2024-09-08 02:40:00.42439
2349	0	t	936	normal_username	_NOVALUE_	azba	2024-09-08 14:49:14.733197
2350	0	t	630	first_login	2024-08-06 09:19	_NOVALUE_	2024-09-08 15:09:14.582816
2355	0	t	208	first_login	2024-08-09 17:24	_NOVALUE_	2024-09-09 13:56:08.03666
2357	0	t	210	first_login	2024-08-09 22:38	_NOVALUE_	2024-09-09 13:58:04.180343
2362	0	t	357	first_login	2024-08-10 02:21	_NOVALUE_	2024-09-10 03:48:02.53104
2366	0	t	930	traffic_periodic_accounting_daily	180	174	2024-09-10 05:56:47.957019
2367	0	t	940	normal_username	_NOVALUE_	faranak	2024-09-10 11:45:24.70633
2370	0	t	884	first_login	2024-08-21 02:27	_NOVALUE_	2024-09-10 15:21:00.408236
2371	0	t	941	normal_username	_NOVALUE_	sherafat	2024-09-10 15:26:38.016733
2373	0	t	795	abs_exp_date	2024-09-10 14:21	_NOVALUE_	2024-09-11 13:20:39.044527
2377	0	t	942	normal_username	_NOVALUE_	bama2222	2024-09-12 08:48:40.235546
2378	0	t	943	normal_username	_NOVALUE_	bama2223	2024-09-12 08:48:40.235546
2379	0	t	944	normal_username	_NOVALUE_	bama2224	2024-09-12 08:48:40.235546
2380	0	t	945	normal_username	_NOVALUE_	bama2225	2024-09-12 08:48:40.235546
2381	0	t	946	normal_username	_NOVALUE_	bama2226	2024-09-12 08:48:40.235546
2382	0	t	947	normal_username	_NOVALUE_	bama2227	2024-09-12 08:48:40.235546
2383	0	t	948	normal_username	_NOVALUE_	bama2228	2024-09-12 08:48:40.235546
2384	0	t	949	normal_username	_NOVALUE_	bama2229	2024-09-12 08:48:40.235546
2385	0	t	950	normal_username	_NOVALUE_	bama2230	2024-09-12 08:48:40.235546
2386	0	t	951	normal_username	_NOVALUE_	bama2231	2024-09-12 08:48:40.235546
2388	0	t	335	first_login	2024-08-13 13:18	_NOVALUE_	2024-09-12 16:27:46.366941
2389	0	t	404	first_login	2024-06-14 04:01	_NOVALUE_	2024-09-12 16:30:33.709899
2390	0	t	405	first_login	2024-06-16 04:45	_NOVALUE_	2024-09-12 16:30:54.935708
2391	0	t	834	first_login	2024-08-07 14:35	_NOVALUE_	2024-09-12 17:12:26.962086
2395	0	t	955	normal_username	_NOVALUE_	torabi100	2024-09-14 03:49:16.688681
2397	0	t	587	traffic_periodic_accounting_daily	365	365	2024-09-14 06:10:59.347038
2401	0	t	200	first_login	2024-08-15 08:41	_NOVALUE_	2024-09-14 09:06:57.174959
2409	0	t	277	first_login	2024-08-12 10:17	_NOVALUE_	2024-09-15 04:13:43.897842
2414	0	t	528	first_login	2024-08-16 02:44	_NOVALUE_	2024-09-15 15:27:30.722569
2416	0	t	712	group	3-Month-250G	6-Month-300G	2024-09-16 04:36:16.338608
2423	0	t	960	normal_username	_NOVALUE_	manzar2	2024-09-17 18:14:10.064666
2431	0	t	275	first_login	2024-08-20 05:19	_NOVALUE_	2024-09-19 08:14:56.727704
2432	0	t	961	normal_username	_NOVALUE_	fa30	2024-09-19 09:17:18.718872
2444	0	t	864	first_login	2024-08-19 13:09	_NOVALUE_	2024-09-20 05:04:25.611326
2446	0	t	983	group	1-Month-50G	2-Month-70G	2024-09-21 03:39:01.469328
2449	0	t	727	first_login	2024-08-22 03:53	_NOVALUE_	2024-09-21 06:44:06.599268
2451	0	t	709	first_login	2024-08-21 01:23	_NOVALUE_	2024-09-21 08:20:54.968086
2453	0	t	689	first_login	2024-08-10 09:17	_NOVALUE_	2024-09-21 08:22:25.701128
2455	0	t	725	first_login	2024-06-30 03:46	_NOVALUE_	2024-09-21 08:23:11.182198
2456	0	t	725	group	3-month-100-G-bama	1-Month-20G	2024-09-21 08:25:42.230781
2459	0	t	715	traffic_periodic_accounting_daily	90	90	2024-09-22 04:39:32.48976
2460	0	t	278	first_login	2024-08-26 04:06	_NOVALUE_	2024-09-22 07:08:43.613904
2462	0	t	254	first_login	2024-08-23 06:19	_NOVALUE_	2024-09-22 11:37:13.830841
2464	0	t	745	first_login	2024-07-30 15:53	_NOVALUE_	2024-09-22 16:05:22.57276
2466	0	t	350	first_login	2024-08-20 01:32	_NOVALUE_	2024-09-23 12:56:17.338454
2467	0	t	349	first_login	2024-08-22 06:24	_NOVALUE_	2024-09-23 12:57:03.926546
2468	0	t	787	first_login	2024-08-19 15:59	_NOVALUE_	2024-09-23 12:57:32.028346
2469	0	t	988	normal_username	_NOVALUE_	shima	2024-09-23 13:48:54.188102
2470	0	t	988	traffic_periodic_accounting_daily	90	90	2024-09-23 13:50:36.364647
2471	0	t	890	first_login	2024-08-24 07:50	_NOVALUE_	2024-09-23 13:55:35.860965
2472	0	t	394	first_login	2024-08-24 04:56	_NOVALUE_	2024-09-23 14:02:22.619976
2473	0	t	893	first_login	2024-08-24 14:00	_NOVALUE_	2024-09-23 14:48:02.386196
2474	0	t	989	normal_username	_NOVALUE_	bama2182	2024-09-23 17:40:51.759739
2475	0	t	448	group	2-Month-70G	3-month-100-G-bama	2024-09-24 04:44:58.125203
2476	0	t	990	normal_username	_NOVALUE_	askari2	2024-09-24 05:02:34.219063
2477	0	t	359	first_login	2024-09-01 07:00	_NOVALUE_	2024-09-24 05:10:37.395271
2478	0	t	991	normal_username	_NOVALUE_	c106	2024-09-24 05:11:29.479311
2479	0	t	991	group	1-Month-20G	1-Month-35G	2024-09-24 05:11:41.999618
2480	0	t	524	group	3-Month-150G	6-Month-300G	2024-09-24 05:40:27.639675
2481	0	t	524	traffic_periodic_accounting_daily	75	95	2024-09-24 05:41:09.289526
2482	0	t	524	traffic_periodic_accounting_daily_limit	130000M	150000M	2024-09-24 05:41:09.289526
2483	0	t	524	traffic_periodic_accounting_daily_usage	4283639798	_NOVALUE_	2024-09-24 05:41:09.289526
2484	0	t	524	traffic_periodic_accounting_daily	95	180	2024-09-24 05:41:28.78983
2485	0	t	274	first_login	2024-08-25 03:28	_NOVALUE_	2024-09-24 06:16:10.277878
2486	0	t	891	first_login	2024-08-24 07:47	_NOVALUE_	2024-09-24 07:11:44.827526
2487	0	t	891	traffic_periodic_accounting_daily	30	30	2024-09-24 07:12:03.079095
2488	0	t	441	first_login	2024-08-25 07:37	_NOVALUE_	2024-09-24 13:10:13.089819
2489	0	t	825	first_login	2024-09-03 15:50	_NOVALUE_	2024-09-24 13:29:18.934038
2490	0	t	992	normal_username	_NOVALUE_	azizm	2024-09-25 05:35:37.303513
2491	0	t	992	traffic_periodic_accounting_daily	90	90	2024-09-25 05:36:20.09477
2492	0	t	992	group	3-month-100-G-bama	1-Month-35G	2024-09-25 07:15:19.297273
2493	0	t	992	group	1-Month-35G	1-Month-20G	2024-09-25 07:15:23.701571
2494	0	t	993	normal_username	_NOVALUE_	mirzayi2	2024-09-25 10:51:44.370579
2495	0	t	364	first_login	2024-08-26 08:44	_NOVALUE_	2024-09-25 12:31:11.325283
2496	0	t	396	lock		_NOVALUE_	2024-09-25 15:08:12.549984
2498	0	t	471	first_login	2024-06-27 12:22	_NOVALUE_	2024-09-25 16:28:59.34326
2501	0	t	270	first_login	2024-08-26 14:51	_NOVALUE_	2024-09-26 05:33:36.000893
2504	0	t	713	first_login	2024-08-27 07:43	_NOVALUE_	2024-09-26 14:38:58.390139
2505	0	t	319	first_login	2024-08-28 13:50	_NOVALUE_	2024-09-27 15:07:31.755884
2507	0	t	513	first_login	2024-08-28 13:01	_NOVALUE_	2024-09-28 06:30:45.828057
2511	0	t	994	normal_username	_NOVALUE_	c200	2024-09-28 14:06:57.924385
2515	0	t	995	normal_username	_NOVALUE_	faraji	2024-09-29 06:06:47.983767
2521	0	t	320	first_login	2024-08-30 16:45	_NOVALUE_	2024-09-29 17:30:54.990267
2522	0	t	458	first_login	2024-08-30 13:18	_NOVALUE_	2024-09-29 17:31:56.082962
2523	0	t	126	first_login	2024-07-02 02:59	_NOVALUE_	2024-09-30 04:11:49.367367
2528	0	t	999	group	12-Month-600G	6-Month-300G	2024-09-30 11:12:21.853703
2530	0	t	128	first_login	2024-07-02 04:59	_NOVALUE_	2024-09-30 11:13:32.709539
2531	0	t	279	first_login	2024-08-29 09:41	_NOVALUE_	2024-09-30 11:16:13.786704
2534	0	t	1001	normal_username	_NOVALUE_	saba	2024-09-30 14:19:12.903005
2535	0	t	558	first_login	2024-07-02 15:37	_NOVALUE_	2024-09-30 14:48:51.440654
2537	0	t	340	first_login	2024-09-01 00:16	_NOVALUE_	2024-10-01 09:09:56.450225
2540	0	t	429	first_login	2024-08-22 01:51	_NOVALUE_	2024-10-01 13:59:22.262051
2541	0	t	504	group	2-Month-70G	1-Month-35G	2024-10-01 15:58:06.182353
2544	0	t	974	group	1-Month-20G	2-Month-70G	2024-10-02 12:10:18.475019
2545	0	t	974	traffic_periodic_accounting_daily	60	60	2024-10-02 12:15:15.583224
2546	0	t	974	traffic_periodic_accounting_daily_limit	70000M	40000M	2024-10-02 12:15:15.583224
2548	0	t	1002	multi_login	2	4	2024-10-03 04:13:59.948353
2550	0	t	420	first_login	2024-09-03 03:38	_NOVALUE_	2024-10-03 05:46:33.487797
2554	0	t	1003	normal_username	_NOVALUE_	bahareh5	2024-10-03 14:55:26.627169
2555	0	t	579	first_login	2024-08-29 15:56	_NOVALUE_	2024-10-03 15:11:57.108059
2556	0	t	579	group	1-Month-20G	3-Month-150G	2024-10-03 15:12:15.565698
2557	0	t	579	traffic_periodic_accounting_daily	90	90	2024-10-03 15:12:37.688875
2558	0	t	286	first_login	2024-09-02 04:08	_NOVALUE_	2024-10-04 04:15:48.034423
2563	0	t	348	first_login	2024-09-05 07:41	_NOVALUE_	2024-10-05 08:12:00.98942
2565	0	t	353	first_login	2024-09-05 10:54	_NOVALUE_	2024-10-05 11:55:09.69832
2567	0	t	924	first_login	2024-09-03 14:29	_NOVALUE_	2024-10-06 01:34:57.288037
2568	0	t	924	abs_exp_date	2024-10-05 14:33	_NOVALUE_	2024-10-06 01:35:09.592384
2569	0	t	924	group	2-Month-70G	1-Month-35G	2024-10-06 01:35:25.609954
2570	0	t	933	first_login	2024-09-06 17:16	_NOVALUE_	2024-10-06 11:52:58.620786
2572	0	t	1004	abs_exp_date	_NOVALUE_	2024-10-18 12:33	2024-10-06 12:33:05.719023
2575	0	t	692	traffic_periodic_accounting_daily	90	180	2024-10-06 12:35:55.845307
2576	0	t	692	traffic_periodic_accounting_daily_limit	50000M	200000M	2024-10-06 12:35:55.845307
2577	0	t	692	traffic_periodic_accounting_daily_usage	4034092331	_NOVALUE_	2024-10-06 12:35:55.845307
2579	0	t	1005	normal_username	_NOVALUE_	tdmsm9	2024-10-07 01:39:09.910682
2581	0	t	113	first_login	2024-08-24 10:28	_NOVALUE_	2024-10-07 01:42:56.723738
2582	0	t	921	first_login	2024-09-02 16:17	_NOVALUE_	2024-10-07 02:33:33.93867
2583	0	t	450	first_login	2024-08-09 07:19	_NOVALUE_	2024-10-07 10:28:26.741599
2584	0	t	112	first_login	2024-07-31 11:22	_NOVALUE_	2024-10-07 10:32:17.716527
2587	0	t	1006	normal_username	_NOVALUE_	mohabat	2024-10-07 11:03:57.622036
2591	0	t	1007	group	3-month-100-G-bama	6-Month-300G	2024-10-07 11:54:59.618843
2595	0	t	336	first_login	2024-08-27 04:31	_NOVALUE_	2024-10-07 12:03:24.485907
2602	0	t	941	first_login	2024-09-10 15:27	_NOVALUE_	2024-10-08 01:28:59.19634
2603	0	t	941	group	1-Month-35G	1-Month-70G	2024-10-08 01:29:32.208579
2604	0	t	766	first_login	2024-07-03 17:11	_NOVALUE_	2024-10-08 03:40:28.417081
2606	0	t	313	first_login	2024-09-07 14:48	_NOVALUE_	2024-10-08 04:49:03.902094
2607	0	t	717	first_login	2024-09-07 15:17	_NOVALUE_	2024-10-08 04:56:30.980393
2608	0	t	406	first_login	2024-07-10 03:52	_NOVALUE_	2024-10-08 05:57:39.572889
2610	0	t	168	first_login	2024-07-07 16:31	_NOVALUE_	2024-10-08 07:36:53.034203
2615	0	t	637	first_login	2024-09-06 14:13	_NOVALUE_	2024-10-08 14:17:59.048873
2616	0	t	419	first_login	2024-09-08 12:43	_NOVALUE_	2024-10-08 15:33:51.409747
2617	0	t	766	abs_exp_date	_NOVALUE_	2024-10-11 01:09	2024-10-09 01:09:34.441681
2618	0	t	716	first_login	2024-07-10 11:55	_NOVALUE_	2024-10-09 11:04:30.930637
2623	0	t	208	first_login	2024-09-09 14:08	_NOVALUE_	2024-10-09 15:14:43.501199
2625	0	t	210	first_login	2024-09-09 13:59	_NOVALUE_	2024-10-09 15:15:31.978217
2626	0	t	605	first_login	2024-09-09 14:36	_NOVALUE_	2024-10-09 15:15:48.868533
2627	0	t	939	first_login	2024-09-10 05:40	_NOVALUE_	2024-10-10 08:32:42.201454
2629	0	t	838	first_login	2024-09-10 03:48	_NOVALUE_	2024-10-10 08:34:41.990576
2630	0	t	838	group	1-Month-20G	3-month-100-G-bama	2024-10-10 08:35:44.410906
2633	0	t	1012	normal_username	_NOVALUE_	melikapc	2024-10-10 09:12:46.983825
2635	0	t	252	first_login	2024-08-28 16:23	_NOVALUE_	2024-10-10 15:23:43.830062
2637	0	t	510	traffic_periodic_accounting_daily	180	180	2024-10-11 03:30:29.679371
2638	0	t	510	traffic_periodic_accounting_daily_limit	300000M	250000M	2024-10-11 03:30:29.679371
2639	0	t	605	abs_exp_date	_NOVALUE_	2024-10-14 04:14	2024-10-11 04:14:23.237136
2641	0	t	357	first_login	2024-09-10 03:48	_NOVALUE_	2024-10-12 02:17:04.890968
2642	0	t	516	first_login	2024-09-11 19:21	_NOVALUE_	2024-10-12 03:06:23.49251
2643	0	t	130	first_login	2024-08-13 05:12	_NOVALUE_	2024-10-12 09:49:53.736048
2645	0	t	935	first_login	2024-09-08 13:43	_NOVALUE_	2024-10-12 11:31:17.577023
2646	0	t	935	group	1-Month-50G	3-month-100-G-bama	2024-10-12 11:40:07.08664
2652	0	t	1012	abs_exp_date	2024-10-14 09:13	_NOVALUE_	2024-10-12 14:20:53.649216
2653	0	t	1012	group	2-Month-70G	1-Month-35G	2024-10-12 14:21:31.103507
2657	0	t	202	first_login	2024-09-09 09:08	_NOVALUE_	2024-10-13 02:46:07.81765
2658	0	t	1016	normal_username	_NOVALUE_	pariapc	2024-10-13 06:02:51.347886
2662	0	t	542	traffic_periodic_accounting_daily	365	180	2024-10-13 14:01:57.452663
2497	0	t	471	group	3-Month-150G	3-month-100-G-bama	2024-09-25 16:28:26.233272
2500	0	t	311	first_login	2024-07-08 08:54	_NOVALUE_	2024-09-26 03:50:18.86276
2502	0	t	561	first_login	2024-08-27 08:32	_NOVALUE_	2024-09-26 09:54:30.130834
2506	0	t	30	first_login	2024-08-28 16:31	_NOVALUE_	2024-09-27 16:46:49.149392
2508	0	t	515	first_login	2024-06-29 15:39	_NOVALUE_	2024-09-28 07:40:06.722851
2509	0	t	515	group	3-month-100-G-bama	6-Month-300G	2024-09-28 07:40:27.060869
2510	0	t	515	traffic_periodic_accounting_daily	180	180	2024-09-28 07:40:54.539856
2512	0	t	994	traffic_periodic_accounting_daily	180	180	2024-09-28 14:07:20.85469
2514	0	t	719	first_login	2024-08-27 03:04	_NOVALUE_	2024-09-29 02:59:04.999004
2516	0	t	939	group	1-Month-35G	1-Month-70G	2024-09-29 10:16:52.287987
2517	0	t	906	first_login	2024-08-30 08:55	_NOVALUE_	2024-09-29 13:31:41.673677
2518	0	t	919	first_login	2024-08-31 16:58	_NOVALUE_	2024-09-29 14:37:52.899336
2524	0	t	127	first_login	2024-07-13 03:26	_NOVALUE_	2024-09-30 04:13:26.841133
2526	0	t	998	traffic_periodic_accounting_daily	180	180	2024-09-30 10:37:09.096534
2527	0	t	999	normal_username	_NOVALUE_	sanjabi16	2024-09-30 10:37:34.12094
2529	0	t	999	traffic_periodic_accounting_daily	180	180	2024-09-30 11:12:39.071972
2532	0	t	279	group	1-Month-70G	1-Month-50G	2024-09-30 11:16:30.61247
2538	0	t	954	lock	_NOVALUE_		2024-10-01 09:13:50.906566
2539	0	t	646	first_login	2024-08-31 15:53	_NOVALUE_	2024-10-01 09:25:36.396376
2542	0	t	504	first_login	2024-08-10 04:19	_NOVALUE_	2024-10-01 15:58:14.903065
2543	0	t	566	first_login	2024-09-01 14:45	_NOVALUE_	2024-10-02 03:58:27.24782
2547	0	t	1002	normal_username	_NOVALUE_	roodakipc	2024-10-03 03:18:00.083559
2549	0	t	1002	multi_login	4	4	2024-10-03 04:14:09.292405
2551	0	t	420	group	1-Month-20G	1-Month-10G	2024-10-03 05:46:49.187534
2559	0	t	887	first_login	2024-08-23 06:59	_NOVALUE_	2024-10-04 09:25:37.471997
2560	0	t	827	first_login	2024-09-04 11:30	_NOVALUE_	2024-10-04 13:06:50.420349
2564	0	t	391	first_login	2024-09-05 09:59	_NOVALUE_	2024-10-05 11:43:40.9728
2571	0	t	1004	normal_username	_NOVALUE_	hoda	2024-10-06 12:30:42.895216
2573	0	t	692	first_login	2024-07-10 01:56	_NOVALUE_	2024-10-06 12:34:51.044325
2580	0	t	649	first_login	2024-09-21 09:54	_NOVALUE_	2024-10-07 01:40:32.948768
2585	0	t	112	traffic_periodic_accounting_daily	90	90	2024-10-07 10:32:37.878727
2586	0	t	112	traffic_periodic_accounting_daily_limit	50000M	120000M	2024-10-07 10:32:37.878727
2589	0	t	367	traffic_periodic_accounting_daily_usage	1M	100001M	2024-10-07 11:53:40.995402
2592	0	t	1007	abs_exp_date	_NOVALUE_	2025-01-13 10:55	2024-10-07 11:55:11.550436
2596	0	t	765	first_login	2024-07-03 09:24	_NOVALUE_	2024-10-07 12:09:55.026856
2598	0	t	936	first_login	2024-09-08 14:59	_NOVALUE_	2024-10-07 15:54:58.106961
2600	0	t	837	first_login	2024-09-07 11:39	_NOVALUE_	2024-10-07 16:07:21.785587
2601	0	t	932	first_login	2024-09-07 13:58	_NOVALUE_	2024-10-07 16:43:09.241239
2605	0	t	766	abs_exp_date	2024-09-08 13:06	_NOVALUE_	2024-10-08 03:40:37.311462
2609	0	t	766	group	3-month-100-G-bama	1-Month-50G	2024-10-08 06:56:59.65999
2611	0	t	1008	normal_username	_NOVALUE_	fooladvand	2024-10-08 11:01:51.158356
2614	0	t	310	first_login	2024-09-04 07:15	_NOVALUE_	2024-10-08 14:13:39.042999
2619	0	t	716	traffic_periodic_accounting_daily	90	90	2024-10-09 11:04:47.250121
2620	0	t	1010	normal_username	_NOVALUE_	tdmsm10	2024-10-09 14:01:24.608204
2621	0	t	1011	normal_username	_NOVALUE_	tdmsm11	2024-10-09 14:01:54.227402
2624	0	t	209	first_login	2024-09-09 13:59	_NOVALUE_	2024-10-09 15:15:13.161487
2628	0	t	939	group	1-Month-70G	1-Month-35G	2024-10-10 08:32:55.79489
2634	0	t	1012	abs_exp_date	_NOVALUE_	2024-10-14 09:13	2024-10-10 09:13:03.735179
2636	0	t	510	first_login	2024-04-13 16:33	_NOVALUE_	2024-10-11 03:30:11.83343
2640	0	t	630	first_login	2024-09-08 16:01	_NOVALUE_	2024-10-11 17:14:11.621974
2644	0	t	130	traffic_periodic_accounting_daily	60	60	2024-10-12 09:50:08.583661
2647	0	t	1013	normal_username	_NOVALUE_	monshi	2024-10-12 12:53:54.315233
2649	0	t	1012	group	1-Month-10G	2-Month-70G	2024-10-12 13:44:07.647248
2650	0	t	1012	traffic_periodic_accounting_daily	60	60	2024-10-12 14:20:16.138045
2651	0	t	1012	traffic_periodic_accounting_daily_limit	70000M	35000M	2024-10-12 14:20:16.138045
2655	0	t	1015	traffic_periodic_accounting_daily	90	90	2024-10-12 14:31:41.009345
2656	0	t	1015	traffic_periodic_accounting_daily_limit	100000M	60000M	2024-10-12 14:31:41.009345
2659	0	t	505	first_login	2024-07-11 09:51	_NOVALUE_	2024-10-13 12:53:35.128042
2660	0	t	335	first_login	2024-09-12 16:31	_NOVALUE_	2024-10-13 12:54:34.399902
2663	0	t	542	traffic_periodic_accounting_daily_limit	600000M	250000M	2024-10-13 14:01:57.452663
2664	0	t	542	traffic_periodic_accounting_daily_usage	181494682893	_NOVALUE_	2024-10-13 14:01:57.452663
2666	0	t	520	first_login	2024-07-15 09:11	_NOVALUE_	2024-10-13 14:44:18.582459
2667	0	t	520	abs_exp_date	_NOVALUE_	2025-01-17 13:44	2024-10-13 14:44:39.031418
2672	0	t	862	first_login	2024-09-14 15:48	_NOVALUE_	2024-10-14 09:11:42.188655
2673	0	t	572	first_login	2024-09-13 16:13	_NOVALUE_	2024-10-14 12:13:47.69415
2675	0	t	103	first_login	2024-09-14 13:47	_NOVALUE_	2024-10-14 15:15:16.486358
2676	0	t	62	first_login	2024-09-15 04:34	_NOVALUE_	2024-10-15 06:17:06.383864
2677	0	t	1004	group	1-Month-20G	1-Month-35G	2024-10-15 06:20:41.197597
2679	0	t	1004	abs_exp_date	2024-10-18 12:33	_NOVALUE_	2024-10-15 06:21:23.088566
2680	0	t	1004	first_login	2024-10-06 14:58	_NOVALUE_	2024-10-15 06:25:08.530343
2682	0	t	1004	group	2-Month-70G	1-Month-35G	2024-10-15 07:26:37.100528
2684	0	t	188	first_login	2024-07-17 13:57	_NOVALUE_	2024-10-15 15:45:10.189978
2685	0	t	188	group	3-Month-150G	6-Month-300G	2024-10-15 15:45:24.156143
2686	0	t	188	abs_exp_date	_NOVALUE_	2025-02-12 14:45	2024-10-15 15:45:37.641649
2687	0	t	188	traffic_periodic_accounting_daily	90	120	2024-10-15 15:45:59.572037
2688	0	t	188	traffic_periodic_accounting_daily_limit	100000M	250000M	2024-10-15 15:45:59.572037
2689	0	t	188	traffic_periodic_accounting_daily_usage	39501547367	_NOVALUE_	2024-10-15 15:45:59.572037
2694	0	t	1017	normal_username	_NOVALUE_	fatemeh	2024-10-15 16:00:26.746508
2695	0	t	1017	traffic_periodic_accounting_daily	365	365	2024-10-15 16:00:43.250893
2696	0	t	997	lock	_NOVALUE_	بدهی	2024-10-15 16:08:42.276085
2699	0	t	958	first_login	2024-09-15 15:19	_NOVALUE_	2024-10-15 17:12:06.00771
2499	0	t	471	traffic_periodic_accounting_daily	90	90	2024-09-25 16:29:22.39913
2503	0	t	590	first_login	2024-08-26 16:33	_NOVALUE_	2024-09-26 12:45:30.725023
2513	0	t	190	first_login	2024-08-28 03:22	_NOVALUE_	2024-09-29 02:37:17.500659
2519	0	t	997	normal_username	_NOVALUE_	salehi	2024-09-29 14:43:56.603321
2520	0	t	662	first_login	2024-08-30 08:31	_NOVALUE_	2024-09-29 16:07:03.146348
2525	0	t	998	normal_username	_NOVALUE_	sanjabi15	2024-09-30 10:35:29.799575
2820	0	t	564	first_login	2024-07-30 01:44	_NOVALUE_	2024-10-28 06:54:52.655589
2536	0	t	742	first_login	2024-08-29 17:24	_NOVALUE_	2024-09-30 17:17:19.417356
2552	0	t	322	first_login	2024-09-02 14:30	_NOVALUE_	2024-10-03 07:04:09.411133
2553	0	t	400	group	1-Month-35G	1-Month-70G	2024-10-03 10:06:11.484357
2561	0	t	826	first_login	2024-09-04 11:33	_NOVALUE_	2024-10-04 15:25:34.994956
2562	0	t	828	first_login	2024-09-04 15:06	_NOVALUE_	2024-10-04 16:30:03.464383
2566	0	t	728	first_login	2024-08-27 06:48	_NOVALUE_	2024-10-05 13:23:28.913732
2574	0	t	692	group	3-month-100-G-bama	6-Month-300G	2024-10-06 12:35:03.014115
2578	0	t	321	first_login	2024-09-01 13:01	_NOVALUE_	2024-10-06 16:13:16.726008
2588	0	t	367	group	3-month-100-G-bama	6-Month-300G	2024-10-07 11:52:58.985115
2590	0	t	1007	normal_username	_NOVALUE_	bama2006	2024-10-07 11:54:47.993552
2593	0	t	1007	traffic_periodic_accounting_daily	180	98	2024-10-07 11:55:31.595196
2594	0	t	1007	traffic_periodic_accounting_daily_limit	300000M	100000M	2024-10-07 11:55:31.595196
2597	0	t	769	first_login	2024-07-06 08:25	_NOVALUE_	2024-10-07 12:11:36.99676
2599	0	t	512	group	1-Month-35G	2-Month-70G	2024-10-07 15:55:30.08955
2612	0	t	1009	normal_username	_NOVALUE_	miladpc	2024-10-08 11:05:55.264432
2613	0	t	472	first_login	2024-09-08 09:31	_NOVALUE_	2024-10-08 14:12:07.189828
2622	0	t	280	first_login	2024-09-09 14:04	_NOVALUE_	2024-10-09 14:36:38.933504
2631	0	t	838	traffic_periodic_accounting_daily	90	90	2024-10-10 08:36:06.880286
2632	0	t	838	traffic_periodic_accounting_daily_limit	100000M	60000M	2024-10-10 08:36:06.880286
2648	0	t	1013	abs_exp_date	_NOVALUE_	2024-11-07 11:54	2024-10-12 12:54:46.447373
2654	0	t	1015	normal_username	_NOVALUE_	m101	2024-10-12 14:31:06.74995
2661	0	t	542	group	6-Month-300G	12-Month-600G	2024-10-13 14:01:14.919329
2665	0	t	520	group	3-Month-150G	6-Month-300G	2024-10-13 14:44:04.588477
2668	0	t	520	traffic_periodic_accounting_daily	180	96	2024-10-13 14:45:22.343041
2669	0	t	520	traffic_periodic_accounting_daily_limit	300000M	130000M	2024-10-13 14:45:22.343041
2670	0	t	520	traffic_periodic_accounting_daily_usage	171458687	_NOVALUE_	2024-10-13 14:45:22.343041
2671	0	t	1004	group	1-Month-10G	1-Month-20G	2024-10-14 02:20:32.559532
2674	0	t	956	first_login	2024-09-14 06:30	_NOVALUE_	2024-10-14 13:40:34.472108
2678	0	t	1004	group	1-Month-35G	2-Month-70G	2024-10-15 06:20:57.371612
2681	0	t	1004	first_login	2024-10-15 06:06	_NOVALUE_	2024-10-15 07:26:21.044373
2683	0	t	786	first_login	2024-07-16 11:20	_NOVALUE_	2024-10-15 07:39:49.170499
2690	0	t	188	traffic_periodic_accounting_daily	120	120	2024-10-15 15:46:23.983606
2691	0	t	188	traffic_periodic_accounting_daily_limit	250000M	200000M	2024-10-15 15:46:23.983606
2692	0	t	400	first_login	2024-09-14 17:08	_NOVALUE_	2024-10-15 15:49:19.026906
2693	0	t	400	group	1-Month-70G	1-Month-50G	2024-10-15 15:49:34.711534
2697	0	t	997	lock	بدهی		2024-10-15 16:19:11.127406
2698	0	t	997	lock		_NOVALUE_	2024-10-15 16:19:29.040957
2700	0	t	958	group	1-Month-35G	3-month-100-G-bama	2024-10-15 17:12:24.453276
2701	0	t	958	traffic_periodic_accounting_daily	90	90	2024-10-15 17:12:47.414915
2702	0	t	1013	multi_login	2	3	2024-10-16 01:34:57.404587
2703	0	t	1002	multi_login	4	5	2024-10-16 03:52:55.677558
2704	0	t	276	first_login	2024-09-15 06:09	_NOVALUE_	2024-10-16 04:59:47.093286
2705	0	t	277	first_login	2024-09-15 06:05	_NOVALUE_	2024-10-16 05:26:49.950793
2706	0	t	929	first_login	2024-09-04 15:27	_NOVALUE_	2024-10-16 06:20:00.963425
2726	0	t	542	abs_exp_date	2024-10-16 16:47	_NOVALUE_	2024-10-18 03:48:02.050163
2708	0	t	528	first_login	2024-09-15 17:03	_NOVALUE_	2024-10-16 10:07:20.719788
2709	0	t	528	group	1-Month-35G	1-Month-20G	2024-10-16 10:07:36.23013
2710	0	t	142	first_login	2024-07-17 14:51	_NOVALUE_	2024-10-16 10:08:40.219067
2711	0	t	142	group	3-month-100-G-bama	1-Month-20G	2024-10-16 10:12:14.525262
2712	0	t	688	first_login	2024-08-13 06:43	_NOVALUE_	2024-10-16 11:38:19.631283
2713	0	t	931	first_login	2024-09-06 04:25	_NOVALUE_	2024-10-16 12:26:30.697624
2714	0	t	934	first_login	2024-09-07 14:18	_NOVALUE_	2024-10-16 12:26:50.874816
2715	0	t	1019	normal_username	_NOVALUE_	bama2008	2024-10-16 13:07:37.488036
2716	0	t	1020	normal_username	_NOVALUE_	bama2242	2024-10-16 13:44:57.30621
2717	0	t	1021	normal_username	_NOVALUE_	bama2243	2024-10-16 13:44:57.30621
2718	0	t	1022	normal_username	_NOVALUE_	bama2244	2024-10-16 13:44:57.30621
2719	0	t	1023	normal_username	_NOVALUE_	bama2245	2024-10-16 13:44:57.30621
2720	0	t	1024	normal_username	_NOVALUE_	bama2246	2024-10-16 13:44:57.30621
2721	0	t	1025	normal_username	_NOVALUE_	bama2247	2024-10-16 13:44:57.30621
2722	0	t	1026	normal_username	_NOVALUE_	bama2248	2024-10-16 13:44:57.30621
2723	0	t	1027	normal_username	_NOVALUE_	bama2249	2024-10-16 13:44:57.30621
2724	0	t	1028	normal_username	_NOVALUE_	bama2250	2024-10-16 13:44:57.30621
2725	0	t	1029	normal_username	_NOVALUE_	bama2251	2024-10-16 13:44:57.30621
2727	0	t	542	first_login	2024-04-25 03:25	_NOVALUE_	2024-10-18 03:48:15.205177
2728	0	t	542	group	12-Month-600G	6-Month-300G	2024-10-18 03:49:14.776306
2729	0	t	430	first_login	2024-09-17 17:09	_NOVALUE_	2024-10-18 05:36:16.812151
2730	0	t	1031	normal_username	_NOVALUE_	alavi	2024-10-18 14:24:07.447188
2731	0	t	937	first_login	2024-09-10 08:47	_NOVALUE_	2024-10-19 02:12:31.886107
2732	0	t	985	first_login	2024-09-22 05:06	_NOVALUE_	2024-10-19 07:21:19.48794
2733	0	t	1032	normal_username	_NOVALUE_	fasa	2024-10-19 07:21:46.87702
2734	0	t	522	first_login	2024-09-28 05:53	_NOVALUE_	2024-10-19 07:58:41.161269
2735	0	t	275	first_login	2024-09-19 10:09	_NOVALUE_	2024-10-19 11:47:45.197178
2736	0	t	584	group	1-Month-35G	2-Month-70G	2024-10-19 12:00:59.838361
2737	0	t	584	first_login	2024-09-19 06:13	_NOVALUE_	2024-10-19 12:01:12.185211
2738	0	t	584	traffic_periodic_accounting_daily	60	60	2024-10-19 12:01:35.017078
2739	0	t	584	traffic_periodic_accounting_daily_limit	70000M	50000M	2024-10-19 12:01:35.017078
2740	0	t	721	first_login	2024-07-24 04:45	_NOVALUE_	2024-10-19 12:23:53.618783
2745	0	t	271	first_login	2024-09-19 09:26	_NOVALUE_	2024-10-19 13:41:33.727775
2747	0	t	893	first_login	2024-09-23 14:48	_NOVALUE_	2024-10-19 16:10:07.98769
2748	0	t	986	first_login	2024-09-22 22:57	_NOVALUE_	2024-10-20 06:23:45.699468
2751	0	t	1034	normal_username	_NOVALUE_	akaram	2024-10-20 13:30:13.188968
2752	0	t	727	first_login	2024-09-21 08:30	_NOVALUE_	2024-10-21 10:16:29.502063
2754	0	t	1035	normal_username	_NOVALUE_	latifeh	2024-10-21 11:13:06.508099
2755	0	t	254	first_login	2024-09-22 11:59	_NOVALUE_	2024-10-21 12:45:30.253516
2758	0	t	278	first_login	2024-09-22 12:09	_NOVALUE_	2024-10-22 07:13:50.947128
2759	0	t	278	group	1-Month-35G	1-Month-20G	2024-10-22 07:13:56.443122
2766	0	t	1036	traffic_periodic_accounting_daily	28	28	2024-10-22 09:56:53.193435
2767	0	t	1036	traffic_periodic_accounting_daily_limit	800000M	80000M	2024-10-22 09:56:53.193435
2770	0	t	419	first_login	2024-10-08 15:35	_NOVALUE_	2024-10-23 03:08:45.615518
2771	0	t	1037	normal_username	_NOVALUE_	saghar2	2024-10-23 13:38:57.304156
2772	0	t	1038	normal_username	_NOVALUE_	tahoora	2024-10-23 14:16:43.976973
2778	0	t	991	first_login	2024-09-24 05:13	_NOVALUE_	2024-10-24 12:13:04.896455
2782	0	t	1044	normal_username	_NOVALUE_	bama2252	2024-10-24 17:09:24.619654
2783	0	t	1045	normal_username	_NOVALUE_	bama2253	2024-10-24 17:09:24.619654
2784	0	t	1046	normal_username	_NOVALUE_	bama2254	2024-10-24 17:09:24.619654
2785	0	t	1047	normal_username	_NOVALUE_	bama2255	2024-10-24 17:09:24.619654
2786	0	t	1048	normal_username	_NOVALUE_	bama2256	2024-10-24 17:09:24.619654
2787	0	t	1049	normal_username	_NOVALUE_	bama2257	2024-10-24 17:09:24.619654
2788	0	t	1050	normal_username	_NOVALUE_	bama2258	2024-10-24 17:09:24.619654
2789	0	t	1051	normal_username	_NOVALUE_	bama2259	2024-10-24 17:09:24.619654
2790	0	t	1052	normal_username	_NOVALUE_	bama2260	2024-10-24 17:09:24.619654
2791	0	t	1053	normal_username	_NOVALUE_	bama2261	2024-10-24 17:09:24.619654
2793	0	t	825	first_login	2024-09-24 13:02	_NOVALUE_	2024-10-25 03:23:28.88297
2794	0	t	1013	group	1-Month-35G	1-Month-50G	2024-10-25 03:50:05.264414
2795	0	t	441	first_login	2024-09-24 14:15	_NOVALUE_	2024-10-25 14:36:35.310827
2797	0	t	718	first_login	2024-09-24 10:19	_NOVALUE_	2024-10-26 00:57:32.073392
2798	0	t	132	first_login	2024-07-27 03:18	_NOVALUE_	2024-10-26 04:26:15.522015
2800	0	t	350	first_login	2024-09-24 03:33	_NOVALUE_	2024-10-26 04:57:13.859199
2803	0	t	349	first_login	2024-09-24 06:21	_NOVALUE_	2024-10-26 04:58:21.551049
2804	0	t	271	first_login	2024-10-19 14:54	_NOVALUE_	2024-10-26 04:58:45.529345
2807	0	t	271	abs_exp_date	2024-12-18 04:00	2024-11-18 04:01	2024-10-26 05:01:33.908761
2808	0	t	271	group	2-Month-70G	1-Month-35G	2024-10-26 05:01:44.703569
2809	0	t	270	first_login	2024-09-26 05:41	_NOVALUE_	2024-10-26 11:56:28.644349
2810	0	t	1055	normal_username	_NOVALUE_	tdmsm12	2024-10-26 13:48:01.470889
2811	0	t	1056	normal_username	_NOVALUE_	bahareh5	2024-10-27 03:23:44.723222
2812	0	t	713	first_login	2024-09-26 14:44	_NOVALUE_	2024-10-27 05:21:37.474278
2813	0	t	1057	normal_username	_NOVALUE_	asghari	2024-10-27 05:25:02.414845
2815	0	t	319	first_login	2024-09-27 15:09	_NOVALUE_	2024-10-27 15:53:18.938436
2821	0	t	1058	normal_username	_NOVALUE_	aghasemi	2024-10-28 08:21:27.525488
2823	0	t	804	first_login	2024-07-30 08:57	_NOVALUE_	2024-10-28 13:08:40.249386
2824	0	t	804	group	3-month-100-G-bama	1-Month-35G	2024-10-28 13:08:50.005188
2826	0	t	932	first_login	2024-10-07 18:14	_NOVALUE_	2024-10-29 05:03:17.519501
2828	0	t	513	first_login	2024-09-28 06:45	_NOVALUE_	2024-10-29 05:34:27.20945
2836	0	t	906	first_login	2024-09-29 13:32	_NOVALUE_	2024-10-29 15:44:38.867817
2838	0	t	320	first_login	2024-09-29 20:02	_NOVALUE_	2024-10-30 04:48:11.882784
2842	0	t	563	first_login	2024-07-31 03:34	_NOVALUE_	2024-10-30 09:16:00.587421
2843	0	t	279	first_login	2024-09-30 11:57	_NOVALUE_	2024-10-30 12:47:57.732899
2846	0	t	990	first_login	2024-09-24 05:40	_NOVALUE_	2024-10-31 04:47:13.573591
2847	0	t	1060	normal_username	_NOVALUE_	farzan1	2024-10-31 11:29:26.502093
2848	0	t	504	first_login	2024-10-01 16:03	_NOVALUE_	2024-11-01 02:30:08.978494
2850	0	t	340	first_login	2024-10-01 09:42	_NOVALUE_	2024-11-02 01:33:43.952152
2852	0	t	1061	normal_username	_NOVALUE_	rafiee	2024-11-02 08:09:38.578773
2853	0	t	1063	normal_username	_NOVALUE_	daftar30	2024-11-02 08:16:21.681508
2856	0	t	1064	normal_username	_NOVALUE_	paroham	2024-11-02 14:23:28.023326
2857	0	t	1066	normal_username	_NOVALUE_	m102	2024-11-02 15:35:31.236961
2859	0	t	391	first_login	2024-10-05 12:58	_NOVALUE_	2024-11-03 06:28:25.972682
2861	0	t	1068	normal_username	_NOVALUE_	abas	2024-11-03 12:19:43.81159
2863	0	t	827	first_login	2024-10-04 13:10	_NOVALUE_	2024-11-03 13:52:31.02889
2864	0	t	1069	normal_username	_NOVALUE_	navab2	2024-11-03 14:19:13.988402
2865	0	t	1069	abs_exp_date	_NOVALUE_	2025-04-11 22:49	2024-11-03 14:20:50.49255
2868	0	t	286	first_login	2024-10-04 04:17	_NOVALUE_	2024-11-04 09:10:56.554882
2870	0	t	1013	abs_exp_date	2024-11-07 11:54	_NOVALUE_	2024-11-04 11:22:56.964269
2872	0	t	1071	traffic_periodic_accounting_daily	90	90	2024-11-04 11:31:21.67041
2874	0	t	353	first_login	2024-10-05 12:58	_NOVALUE_	2024-11-04 13:29:55.4012
2875	0	t	1071	multi_login	2	3	2024-11-05 10:10:30.567684
2878	0	t	589	first_login	2024-05-09 07:42	_NOVALUE_	2024-11-05 15:55:37.71638
2879	0	t	941	first_login	2024-10-08 01:31	_NOVALUE_	2024-11-06 01:05:04.338164
2880	0	t	472	first_login	2024-10-08 14:31	_NOVALUE_	2024-11-06 05:53:22.541183
2883	0	t	313	first_login	2024-10-08 04:58	_NOVALUE_	2024-11-07 07:11:35.393666
2887	0	t	936	first_login	2024-10-07 18:04	_NOVALUE_	2024-11-07 12:46:35.67121
2889	0	t	887	first_login	2024-10-06 20:51	_NOVALUE_	2024-11-08 07:15:44.323506
2892	0	t	1074	normal_username	_NOVALUE_	yavari	2024-11-08 12:47:11.753002
2894	0	t	280	first_login	2024-10-09 14:47	_NOVALUE_	2024-11-08 13:54:51.906269
2895	0	t	208	first_login	2024-10-09 15:54	_NOVALUE_	2024-11-09 00:45:26.904954
2898	0	t	605	first_login	2024-10-10 01:14	_NOVALUE_	2024-11-09 00:46:43.267794
2900	0	t	717	first_login	2024-10-08 04:58	_NOVALUE_	2024-11-09 05:47:06.766591
2741	0	t	721	traffic_periodic_accounting_daily	90	90	2024-10-19 12:24:24.127032
2749	0	t	768	first_login	2024-08-10 09:12	_NOVALUE_	2024-10-20 06:25:25.804457
2753	0	t	276	group	1-Month-35G	1-Month-50G	2024-10-21 10:28:59.923921
2756	0	t	120	first_login	2024-07-23 12:48	_NOVALUE_	2024-10-21 17:43:17.658252
2760	0	t	725	first_login	2024-09-21 10:39	_NOVALUE_	2024-10-22 07:14:13.617281
2763	0	t	1036	abs_exp_date	_NOVALUE_	2024-11-19 08:55	2024-10-22 09:55:59.330321
2768	0	t	537	first_login	2024-04-22 05:06	_NOVALUE_	2024-10-22 14:24:41.691503
2769	0	t	1002	multi_login	5	6	2024-10-23 01:24:47.523545
2773	0	t	394	first_login	2024-09-23 14:19	_NOVALUE_	2024-10-23 15:16:56.154291
2776	0	t	1039	abs_exp_date	_NOVALUE_	2024-11-30 00:41	2024-10-24 01:41:35.820502
2777	0	t	1040	normal_username	_NOVALUE_	mahshidpc	2024-10-24 03:50:18.282187
2779	0	t	724	first_login	2024-09-21 08:41	_NOVALUE_	2024-10-24 14:23:46.21066
2781	0	t	1042	normal_username	_NOVALUE_	mghorbani2	2024-10-24 15:35:08.324904
2792	0	t	961	first_login	2024-09-19 09:34	_NOVALUE_	2024-10-25 02:15:52.636283
2796	0	t	596	first_login	2024-09-21 14:33	_NOVALUE_	2024-10-25 14:53:44.480037
2799	0	t	880	first_login	2024-09-23 04:55	_NOVALUE_	2024-10-26 04:56:03.101727
2801	0	t	30	first_login	2024-09-27 16:59	_NOVALUE_	2024-10-26 04:57:31.949759
2805	0	t	271	group	1-Month-50G	2-Month-70G	2024-10-26 04:59:45.51442
2806	0	t	271	abs_exp_date	_NOVALUE_	2024-12-18 04:00	2024-10-26 05:00:13.403424
2814	0	t	709	first_login	2024-09-22 08:25	_NOVALUE_	2024-10-27 09:10:39.80086
2822	0	t	590	first_login	2024-09-26 13:39	_NOVALUE_	2024-10-28 13:05:22.303966
2825	0	t	864	first_login	2024-09-20 13:23	_NOVALUE_	2024-10-28 15:06:20.18811
2827	0	t	719	first_login	2024-09-29 03:01	_NOVALUE_	2024-10-29 05:04:35.109928
2829	0	t	513	group	1-Month-35G	1-Month-50G	2024-10-29 05:34:45.034591
2831	0	t	190	first_login	2024-09-29 04:39	_NOVALUE_	2024-10-29 10:48:35.181171
2832	0	t	562	first_login	2024-07-30 17:15	_NOVALUE_	2024-10-29 15:29:42.050997
2839	0	t	458	first_login	2024-09-30 01:31	_NOVALUE_	2024-10-30 04:55:47.481464
2840	0	t	646	group	1-Month-10G	2-Month-70G	2024-10-30 05:06:02.009941
2845	0	t	1001	first_login	2024-09-30 17:15	_NOVALUE_	2024-10-31 01:16:41.796445
2849	0	t	429	first_login	2024-10-01 14:00	_NOVALUE_	2024-11-01 02:31:02.18043
2851	0	t	566	first_login	2024-10-02 04:54	_NOVALUE_	2024-11-02 01:36:37.686876
2854	0	t	322	first_login	2024-10-03 07:41	_NOVALUE_	2024-11-02 14:04:30.412812
2860	0	t	1067	normal_username	_NOVALUE_	gorjian5	2024-11-03 07:08:34.13125
2869	0	t	348	first_login	2024-10-05 08:12	_NOVALUE_	2024-11-04 09:49:39.0957
2871	0	t	1071	normal_username	_NOVALUE_	monshi	2024-11-04 11:30:45.552997
2876	0	t	742	first_login	2024-09-30 17:35	_NOVALUE_	2024-11-05 14:52:06.692073
2881	0	t	649	first_login	2024-10-07 01:51	_NOVALUE_	2024-11-06 05:54:32.714875
2884	0	t	321	first_login	2024-10-06 22:36	_NOVALUE_	2024-11-07 07:16:39.314748
2885	0	t	1073	normal_username	_NOVALUE_	farnosh	2024-11-07 12:36:57.487552
2890	0	t	887	group	1-Month-35G	3-Month-150G	2024-11-08 07:16:09.466827
2896	0	t	209	first_login	2024-10-10 00:16	_NOVALUE_	2024-11-09 00:45:46.06623
2897	0	t	210	first_login	2024-10-09 23:08	_NOVALUE_	2024-11-09 00:46:05.575172
2901	0	t	823	first_login	2024-08-02 17:45	_NOVALUE_	2024-11-09 13:38:26.813639
2903	0	t	76	first_login	2024-08-07 06:47	_NOVALUE_	2024-11-10 08:40:39.474068
2906	0	t	408	first_login	2024-08-12 08:28	_NOVALUE_	2024-11-11 00:53:14.679601
2907	0	t	408	traffic_periodic_accounting_daily	90	90	2024-11-11 00:53:42.705438
2908	0	t	408	traffic_periodic_accounting_daily_limit	150000M	100000M	2024-11-11 00:53:42.705438
2909	0	t	874	first_login	2024-09-10 15:25	_NOVALUE_	2024-11-11 09:09:03.476776
2910	0	t	357	first_login	2024-10-12 02:28	_NOVALUE_	2024-11-12 00:34:58.496494
2911	0	t	862	first_login	2024-10-14 13:57	_NOVALUE_	2024-11-12 04:21:24.42457
2913	0	t	1016	first_login	2024-10-13 06:03	_NOVALUE_	2024-11-12 13:22:41.810256
2916	0	t	335	first_login	2024-10-13 17:07	_NOVALUE_	2024-11-13 09:18:59.364544
2918	0	t	595	first_login	2024-08-15 17:00	_NOVALUE_	2024-11-14 09:15:37.766281
2920	0	t	400	first_login	2024-10-15 15:50	_NOVALUE_	2024-11-14 15:14:17.208542
2931	0	t	929	first_login	2024-10-16 09:52	_NOVALUE_	2024-11-15 14:30:43.691184
2934	0	t	1019	traffic_periodic_accounting_daily	60	60	2024-11-15 14:36:29.519684
2935	0	t	1019	traffic_periodic_accounting_daily_limit	70000M	40000M	2024-11-15 14:36:29.519684
2936	0	t	747	multi_login	2	3	2024-11-16 04:46:28.172807
2938	0	t	854	group	3-month-100-G-bama	1-Month-20G	2024-11-16 10:56:03.378086
2939	0	t	854	traffic_periodic_accounting_daily	90	_NOVALUE_	2024-11-16 10:56:33.592238
2940	0	t	854	traffic_periodic_accounting_daily_limit	100000M	_NOVALUE_	2024-11-16 10:56:33.592238
2941	0	t	854	traffic_periodic_accounting_daily_usage	212579242	_NOVALUE_	2024-11-16 10:56:33.592238
2942	0	t	1088	normal_username	_NOVALUE_	elham	2024-11-16 13:37:14.213065
2944	0	t	276	first_login	2024-10-16 06:30	_NOVALUE_	2024-11-17 03:32:11.277911
2945	0	t	277	first_login	2024-10-16 23:23	_NOVALUE_	2024-11-17 03:32:33.587553
2946	0	t	430	first_login	2024-10-18 05:58	_NOVALUE_	2024-11-17 05:47:20.986529
2948	0	t	956	first_login	2024-10-14 14:16	_NOVALUE_	2024-11-17 11:25:59.894898
2950	0	t	1088	abs_exp_date	2024-12-12 14:05	2024-12-09 14:06	2024-11-17 14:06:25.176188
2951	0	t	1089	normal_username	_NOVALUE_	hasani	2024-11-18 04:07:41.489223
2952	0	t	1031	first_login	2024-10-18 14:35	_NOVALUE_	2024-11-18 12:45:44.409197
2954	0	t	1091	normal_username	_NOVALUE_	bahareh	2024-11-18 13:11:22.414173
2955	0	t	271	first_login	2024-10-26 05:04	_NOVALUE_	2024-11-18 14:29:27.982131
2957	0	t	522	first_login	2024-10-20 09:40	_NOVALUE_	2024-11-19 02:46:53.475743
2958	0	t	275	first_login	2024-10-19 11:49	_NOVALUE_	2024-11-19 07:57:40.429349
2961	0	t	254	first_login	2024-10-22 07:55	_NOVALUE_	2024-11-19 12:01:56.035425
2964	0	t	30	first_login	2024-10-26 05:11	_NOVALUE_	2024-11-20 08:14:10.813817
2965	0	t	652	first_login	2024-09-18 04:14	_NOVALUE_	2024-11-20 08:14:33.184574
2967	0	t	727	first_login	2024-10-21 10:17	_NOVALUE_	2024-11-20 09:32:22.724091
2968	0	t	1095	normal_username	_NOVALUE_	bahareh5	2024-11-21 01:30:59.560756
2970	0	t	1096	normal_username	_NOVALUE_	saeedeh	2024-11-21 07:09:29.430682
2975	0	t	394	first_login	2024-10-23 15:20	_NOVALUE_	2024-11-21 15:21:23.39673
2742	0	t	721	traffic_periodic_accounting_daily	90	90	2024-10-19 12:30:37.819502
2743	0	t	721	traffic_periodic_accounting_daily_limit	100000M	200000M	2024-10-19 12:30:37.819502
2744	0	t	721	group	3-month-100-G-bama	3-Month-150G	2024-10-19 12:31:01.716953
2746	0	t	745	first_login	2024-09-22 17:23	_NOVALUE_	2024-10-19 15:00:36.764353
2750	0	t	1033	normal_username	_NOVALUE_	c201	2024-10-20 12:19:08.101492
2757	0	t	120	group	3-month-100-G-bama	1-Month-50G	2024-10-21 17:43:29.188413
2761	0	t	689	first_login	2024-09-21 09:05	_NOVALUE_	2024-10-22 07:14:35.765137
2762	0	t	1036	normal_username	_NOVALUE_	asadi	2024-10-22 09:55:37.999199
2764	0	t	1036	traffic_periodic_accounting_daily	30	28	2024-10-22 09:56:40.882462
2765	0	t	1036	traffic_periodic_accounting_daily_limit	100000M	800000M	2024-10-22 09:56:40.882462
2774	0	t	1039	normal_username	_NOVALUE_	raha3	2024-10-24 01:40:57.005583
2775	0	t	1039	group	1-Month-35G	2-Month-70G	2024-10-24 01:41:16.057439
2780	0	t	274	first_login	2024-09-24 06:17	_NOVALUE_	2024-10-24 14:39:14.094284
2802	0	t	787	first_login	2024-09-25 02:59	_NOVALUE_	2024-10-26 04:57:52.816408
2830	0	t	1059	normal_username	_NOVALUE_	ahatami30	2024-10-29 07:16:02.613999
2833	0	t	562	group	3-Month-250G	6-Month-300G	2024-10-29 15:29:53.036496
2834	0	t	562	traffic_periodic_accounting_daily	180	180	2024-10-29 15:38:21.270439
2835	0	t	562	traffic_periodic_accounting_daily_limit	300000M	200000M	2024-10-29 15:38:21.270439
2837	0	t	997	first_login	2024-09-29 15:00	_NOVALUE_	2024-10-29 16:12:01.584276
2841	0	t	995	first_login	2024-09-29 13:20	_NOVALUE_	2024-10-30 06:13:56.703882
2844	0	t	364	first_login	2024-09-25 12:49	_NOVALUE_	2024-10-30 13:16:38.825165
2855	0	t	1004	group	1-Month-35G	1-Month-70G	2024-11-02 14:18:35.741453
2858	0	t	420	first_login	2024-10-03 05:50	_NOVALUE_	2024-11-03 02:19:20.813399
2862	0	t	1068	abs_exp_date	_NOVALUE_	2024-12-02 12:20	2024-11-03 12:20:44.679662
2866	0	t	826	first_login	2024-10-04 15:26	_NOVALUE_	2024-11-03 17:09:14.385717
2867	0	t	1002	first_login	2024-10-05 01:40	_NOVALUE_	2024-11-04 02:01:44.662809
2873	0	t	1005	first_login	2024-10-07 03:35	_NOVALUE_	2024-11-04 11:50:46.450433
2877	0	t	837	first_login	2024-10-07 16:07	_NOVALUE_	2024-11-05 15:36:57.788705
2882	0	t	630	group	1-Month-50G	2-Month-70G	2024-11-06 12:07:23.475589
2886	0	t	1073	abs_exp_date	_NOVALUE_	2024-12-06 12:37	2024-11-07 12:37:10.454587
2888	0	t	310	first_login	2024-10-08 14:40	_NOVALUE_	2024-11-08 01:52:36.310369
2891	0	t	887	traffic_periodic_accounting_daily	90	90	2024-11-08 07:16:41.727476
2893	0	t	1074	traffic_periodic_accounting_daily	90	90	2024-11-08 12:47:29.479759
2899	0	t	605	abs_exp_date	2024-10-14 04:14	_NOVALUE_	2024-11-09 00:46:53.102752
2902	0	t	637	first_login	2024-10-08 14:57	_NOVALUE_	2024-11-09 14:29:55.796045
2904	0	t	516	first_login	2024-10-12 06:36	_NOVALUE_	2024-11-10 13:52:59.787439
2905	0	t	158	first_login	2024-08-12 16:22	_NOVALUE_	2024-11-10 17:12:44.686465
2912	0	t	1075	normal_username	_NOVALUE_	roodaki	2024-11-12 12:48:09.518811
2914	0	t	953	group	2-Month-70G	1-Month-50G	2024-11-12 15:41:57.124988
2915	0	t	953	first_login	2024-09-13 14:42	_NOVALUE_	2024-11-12 15:42:03.797844
2917	0	t	512	first_login	2024-09-15 01:09	_NOVALUE_	2024-11-14 01:03:33.5181
2919	0	t	181	first_login	2024-08-16 03:33	_NOVALUE_	2024-11-14 09:29:26.637726
2921	0	t	1077	normal_username	_NOVALUE_	bama2262	2024-11-14 15:22:48.510417
2922	0	t	1078	normal_username	_NOVALUE_	bama2263	2024-11-14 15:22:48.510417
2923	0	t	1079	normal_username	_NOVALUE_	bama2264	2024-11-14 15:22:48.510417
2924	0	t	1080	normal_username	_NOVALUE_	bama2265	2024-11-14 15:22:48.510417
2925	0	t	1081	normal_username	_NOVALUE_	bama2266	2024-11-14 15:22:48.510417
2926	0	t	1082	normal_username	_NOVALUE_	bama2267	2024-11-14 15:22:48.510417
2927	0	t	1083	normal_username	_NOVALUE_	bama2268	2024-11-14 15:22:48.510417
2928	0	t	1084	normal_username	_NOVALUE_	bama2269	2024-11-14 15:22:48.510417
2929	0	t	1085	normal_username	_NOVALUE_	bama2270	2024-11-14 15:22:48.510417
2930	0	t	1086	normal_username	_NOVALUE_	bama2271	2024-11-14 15:22:48.510417
2932	0	t	1019	first_login	2024-10-16 13:08	_NOVALUE_	2024-11-15 14:35:58.885796
2933	0	t	1019	group	1-Month-20G	2-Month-70G	2024-11-15 14:36:09.321472
2937	0	t	854	first_login	2024-08-10 14:42	_NOVALUE_	2024-11-16 10:55:47.056803
2943	0	t	528	first_login	2024-10-16 15:13	_NOVALUE_	2024-11-16 17:16:34.591491
2947	0	t	103	first_login	2024-10-14 15:19	_NOVALUE_	2024-11-17 10:23:52.335076
2949	0	t	1088	abs_exp_date	_NOVALUE_	2024-12-12 14:05	2024-11-17 14:05:20.612717
2953	0	t	1090	normal_username	_NOVALUE_	bakhshi	2024-11-18 12:49:22.059699
2956	0	t	271	abs_exp_date	2024-11-18 04:01	_NOVALUE_	2024-11-18 14:29:39.266754
2959	0	t	986	first_login	2024-10-20 06:24	_NOVALUE_	2024-11-19 07:58:11.475974
2960	0	t	1092	normal_username	_NOVALUE_	tara	2024-11-19 10:52:06.329214
2962	0	t	1093	normal_username	_NOVALUE_	anbar	2024-11-20 01:44:09.960727
2963	0	t	1094	normal_username	_NOVALUE_	daftar31	2024-11-20 02:24:10.670681
2966	0	t	1056	first_login	2024-10-27 03:59	_NOVALUE_	2024-11-20 09:25:41.187727
2969	0	t	531	first_login	2024-08-22 16:03	_NOVALUE_	2024-11-21 01:48:59.209275
2971	0	t	278	first_login	2024-10-22 07:26	_NOVALUE_	2024-11-21 11:28:22.715513
2972	0	t	505	first_login	2024-10-13 12:54	_NOVALUE_	2024-11-21 11:44:41.610141
2973	0	t	505	group	3-Month-150G	1-Month-35G	2024-11-21 11:44:53.503122
2974	0	t	120	first_login	2024-10-21 17:44	_NOVALUE_	2024-11-21 13:31:29.282945
2976	0	t	724	first_login	2024-10-24 14:36	_NOVALUE_	2024-11-22 02:29:15.694975
2977	0	t	725	first_login	2024-10-22 07:40	_NOVALUE_	2024-11-22 02:29:33.670014
2978	0	t	1022	first_login	2024-10-22 11:35	_NOVALUE_	2024-11-22 07:18:38.276376
\.


--
-- Name: user_audit_log_user_audit_log_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('user_audit_log_user_audit_log_seq', 2978, true);


--
-- Data for Name: user_messages; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY user_messages (message_id, user_id, message_text, post_date) FROM stdin;
\.


--
-- Name: user_messages_message_id; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('user_messages_message_id', 1, false);


--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY users (user_id, owner_id, credit, group_id, creation_date) FROM stdin;
379	0	1.00	3	2024-03-10 18:09:50.871667
655	0	1.00	2	2024-05-31 16:40:17.67696
3	0	1.00	2	2024-02-08 12:46:42.473675
508	0	1.00	2	2024-04-11 16:13:14.925558
120	0	1.00	4	2024-02-11 08:00:32.519296
1060	0	1.00	3	2024-10-31 11:29:11.178112
1072	0	1.00	3	2024-11-07 12:27:46.166246
796	0	1.00	10	2024-07-25 16:15:38.158994
681	0	1.00	3	2024-06-05 15:06:59.976163
1035	0	1.00	14	2024-10-21 11:12:38.626431
415	0	1.00	4	2024-03-16 13:09:11.027331
769	0	1.00	14	2024-07-06 08:24:07.974534
504	0	1.00	3	2024-04-09 12:42:10.101029
118	0	1.00	8	2024-02-10 11:55:08.912966
101	0	1.00	3	2024-02-09 02:51:59.513377
114	0	1.00	7	2024-02-10 09:24:13.0335
851	0	1.00	8	2024-08-09 07:29:11.823259
1012	0	1.00	3	2024-10-10 09:12:25.976337
180	0	1.00	8	2024-02-17 08:25:55.911269
461	0	1.00	4	2024-04-01 16:05:13.152237
527	0	1.00	3	2024-04-18 13:45:50.499774
1095	0	1.00	3	2024-11-21 01:30:43.589822
709	0	1.00	2	2024-06-15 03:15:10.823804
682	0	1.00	14	2024-06-05 15:07:16.845583
91	0	1.00	7	2024-02-08 18:39:44.616953
258	0	1.00	4	2024-02-23 04:40:14.241468
204	0	1.00	1	2024-02-19 09:31:12.866335
340	0	1.00	4	2024-03-06 08:57:14.547105
582	0	1.00	3	2024-05-03 13:09:50.49619
6	0	1.00	8	2024-02-08 13:05:46.990989
535	0	1.00	3	2024-04-21 16:11:14.451339
505	0	1.00	3	2024-04-10 11:01:23.42178
202	0	1.00	1	2024-02-19 07:24:30.702266
207	0	1.00	8	2024-02-19 15:10:43.417985
435	0	1.00	7	2024-03-19 13:28:52.634064
763	0	1.00	3	2024-07-02 04:35:00.744987
1057	0	1.00	3	2024-10-27 05:24:49.684477
128	0	1.00	8	2024-02-12 03:19:40.392797
65	0	1.00	7	2024-02-08 17:07:57.908943
786	0	1.00	14	2024-07-16 09:13:15.245652
105	0	1.00	8	2024-02-09 06:03:08.126403
765	0	1.00	14	2024-07-03 09:24:00.715269
1008	0	1.00	2	2024-10-08 11:01:29.183577
46	0	1.00	13	2024-02-08 15:25:30.451904
104	0	1.00	3	2024-02-09 05:31:52.64075
517	0	1.00	8	2024-04-15 13:20:03.724124
469	0	1.00	9	2024-04-04 07:42:06.294876
986	0	1.00	2	2024-09-22 14:43:11.41826
126	0	1.00	8	2024-02-12 01:56:19.835
324	0	1.00	3	2024-03-05 05:00:57.535553
770	0	1.00	2	2024-07-08 12:30:38.109253
476	0	1.00	12	2024-04-06 17:06:11.890976
876	0	1.00	1	2024-08-17 16:27:25.457615
300	0	1.00	3	2024-02-29 03:58:59.698787
132	0	1.00	14	2024-02-12 04:03:20.126794
445	0	1.00	8	2024-03-25 05:06:25.06298
463	0	1.00	3	2024-04-02 07:19:00.828746
160	0	1.00	2	2024-02-14 14:56:36.209591
522	0	1.00	3	2024-04-15 16:39:42.958322
1002	0	1.00	2	2024-10-03 03:17:47.726508
301	0	1.00	3	2024-02-29 04:01:13.512525
481	0	1.00	14	2024-04-09 06:34:31.818438
127	0	1.00	14	2024-02-12 02:00:32.93574
540	0	1.00	3	2024-04-24 05:38:39.208176
585	0	1.00	3	2024-05-06 15:30:33.247072
559	0	1.00	6	2024-04-28 14:21:55.697691
286	0	1.00	3	2024-02-28 06:52:53.252106
443	0	1.00	3	2024-03-24 10:47:22.997643
288	0	1.00	13	2024-02-28 16:23:23.939964
449	0	1.00	3	2024-03-27 04:17:48.959583
36	0	1.00	3	2024-02-08 14:39:11.269543
959	0	1.00	4	2024-09-17 13:28:45.855392
189	0	1.00	12	2024-02-18 07:15:14.617107
304	0	1.00	5	2024-02-29 08:00:55.249679
685	0	1.00	14	2024-06-07 16:35:03.64333
123	0	1.00	5	2024-02-12 01:39:50.503975
418	0	1.00	3	2024-03-16 15:17:06.350084
107	0	1.00	3	2024-02-09 06:07:22.20394
557	0	1.00	10	2024-04-27 05:49:44.635441
822	0	1.00	2	2024-08-01 16:38:27.342452
962	0	1.00	2	2024-09-20 05:00:16.316208
537	0	1.00	10	2024-04-22 04:51:39.792328
683	0	1.00	1	2024-06-06 01:40:56.897763
452	0	1.00	3	2024-03-28 19:04:57.656197
162	0	1.00	8	2024-02-15 02:18:17.996582
130	0	1.00	7	2024-02-12 03:52:21.613128
739	0	1.00	10	2024-06-25 04:08:48.256127
316	0	1.00	3	2024-03-02 13:48:46.784526
116	0	1.00	8	2024-02-10 11:52:17.13621
351	0	1.00	8	2024-03-07 06:05:50.499192
313	0	1.00	4	2024-03-02 05:32:31.102492
364	0	1.00	5	2024-03-10 17:01:01.067054
558	0	1.00	3	2024-04-28 01:04:46.611648
392	0	1.00	2	2024-03-12 01:02:53.99307
1055	0	1.00	2	2024-10-26 13:47:37.226726
414	0	1.00	5	2024-03-15 16:24:34.072754
177	0	1.00	4	2024-02-17 04:13:16.480501
475	0	1.00	3	2024-04-05 16:14:12.236169
607	0	1.00	8	2024-05-15 16:25:53.870628
134	0	1.00	3	2024-02-12 05:10:38.583048
668	0	1.00	2	2024-06-02 08:05:19.180684
543	0	1.00	6	2024-04-25 06:38:13.020286
70	0	1.00	7	2024-02-08 17:31:38.10798
306	0	1.00	3	2024-02-29 14:29:18.785154
938	0	1.00	3	2024-09-10 05:40:21.435413
124	0	1.00	4	2024-02-12 01:42:06.881916
457	0	1.00	3	2024-03-31 04:05:47.59491
341	0	1.00	10	2024-03-06 10:57:25.438606
494	0	10.00	3	2024-04-09 07:00:53.625043
284	0	1.00	4	2024-02-27 13:25:56.857627
92	0	1.00	3	2024-02-08 18:43:41.923139
136	0	1.00	3	2024-02-12 05:10:38.583048
996	0	1.00	4	2024-09-29 14:43:23.421355
357	0	1.00	2	2024-03-09 03:42:54.804493
460	0	1.00	3	2024-03-31 16:49:38.17245
146	0	1.00	2	2024-02-12 12:45:43.6846
459	0	1.00	3	2024-03-31 16:49:20.122651
608	0	1.00	11	2024-05-17 15:27:07.614163
539	0	1.00	4	2024-04-24 05:38:31.953369
111	0	1.00	3	2024-02-10 05:05:09.454029
444	0	1.00	3	2024-03-24 10:47:23.200898
122	0	1.00	2	2024-02-11 18:06:16.993356
346	0	1.00	4	2024-03-06 23:54:12.356643
135	0	1.00	3	2024-02-12 05:10:38.583048
150	0	1.00	10	2024-02-13 04:53:25.324289
332	0	1.00	3	2024-03-05 05:00:57.535553
212	0	1.00	4	2024-02-19 17:26:09.168813
330	0	1.00	3	2024-03-05 05:00:57.535553
1092	0	1.00	2	2024-11-19 10:51:56.408333
302	0	1.00	4	2024-02-29 07:48:51.407859
1089	0	1.00	4	2024-11-18 04:07:16.461329
243	0	1.00	3	2024-02-20 12:15:45.476432
907	0	1.00	1	2024-08-31 12:40:27.871069
137	0	1.00	3	2024-02-12 05:10:38.583048
696	0	1.00	2	2024-06-09 15:45:49.717926
695	0	1.00	2	2024-06-09 15:45:49.717926
711	0	1.00	9	2024-06-16 16:19:12.572526
241	0	1.00	3	2024-02-20 12:15:45.476432
139	0	1.00	3	2024-02-12 05:10:38.583048
326	0	1.00	3	2024-03-05 05:00:57.535553
722	0	1.00	3	2024-06-20 13:16:10.227807
354	0	1.00	4	2024-03-08 14:59:41.102641
799	0	1.00	4	2024-07-28 13:10:49.614491
259	0	1.00	6	2024-02-23 04:48:04.641016
61	0	1.00	6	2024-02-08 16:46:55.979783
671	0	1.00	2	2024-06-04 15:00:04.657533
470	0	1.00	4	2024-04-04 08:01:22.584124
238	0	1.00	3	2024-02-20 12:15:45.476432
785	0	1.00	14	2024-07-11 02:17:21.700705
853	0	1.00	1	2024-08-10 03:51:42.317902
331	0	1.00	3	2024-03-05 05:00:57.535553
164	0	1.00	2	2024-02-15 04:26:18.75731
877	0	1.00	1	2024-08-17 16:27:26.601643
560	0	1.00	3	2024-04-28 14:22:06.016681
1061	0	1.00	3	2024-11-02 06:35:09.808209
412	0	1.00	10	2024-03-15 08:25:06.329371
886	0	1.00	3	2024-08-23 03:11:18.981726
210	0	1.00	2	2024-02-19 15:43:51.479777
615	0	1.00	2	2024-05-20 05:44:09.850926
75	0	1.00	8	2024-02-08 17:46:38.592854
1016	0	1.00	2	2024-10-13 06:02:31.804262
289	0	1.00	3	2024-02-28 16:32:12.983881
707	0	1.00	10	2024-06-11 04:18:40.066453
355	0	1.00	3	2024-03-08 15:18:35.931753
184	0	1.00	3	2024-02-17 08:40:50.406759
806	0	1.00	10	2024-07-30 15:23:10.350584
96	0	1.00	2	2024-02-08 18:57:08.136535
397	0	1.00	4	2024-03-12 13:52:17.807229
446	0	1.00	8	2024-03-25 06:05:51.800033
244	0	1.00	3	2024-02-20 12:15:45.476432
922	0	1.00	1	2024-09-03 09:18:49.012168
467	0	1.00	4	2024-04-03 17:56:30.892787
747	0	1.00	14	2024-06-30 08:58:54.201943
151	0	1.00	7	2024-02-13 13:33:20.004034
255	0	1.00	3	2024-02-22 10:35:29.059131
83	0	1.00	3	2024-02-08 18:18:01.934431
311	0	1.00	3	2024-03-01 09:14:08.362988
360	0	1.00	3	2024-03-10 03:00:38.277781
97	0	1.00	2	2024-02-08 18:58:18.484352
477	0	1.00	4	2024-04-07 15:14:39.346483
591	0	1.00	2	2024-05-11 12:54:25.862361
250	0	1.00	4	2024-02-21 16:26:12.03428
312	0	1.00	10	2024-03-01 13:42:21.029527
697	0	1.00	2	2024-06-09 15:45:49.717926
190	0	1.00	4	2024-02-18 07:54:21.737729
240	0	1.00	3	2024-02-20 12:15:45.476432
247	0	1.00	7	2024-02-20 15:40:24.510284
68	0	1.00	5	2024-02-08 17:15:18.932373
328	0	1.00	3	2024-03-05 05:00:57.535553
115	0	1.00	3	2024-02-10 10:32:50.2415
297	0	1.00	3	2024-02-28 16:32:12.983881
298	0	1.00	3	2024-02-28 16:32:12.983881
808	0	1.00	1	2024-07-31 05:42:33.932807
584	0	1.00	7	2024-05-05 15:40:47.344853
841	0	1.00	2	2024-08-08 12:08:11.81247
656	0	1.00	2	2024-05-31 16:40:17.67696
7	0	1.00	2	2024-02-08 13:15:42.117472
183	0	1.00	8	2024-02-17 08:36:54.797731
303	0	1.00	4	2024-02-29 07:54:20.601197
325	0	1.00	3	2024-03-05 05:00:57.535553
942	0	1.00	2	2024-09-12 08:48:04.435579
143	0	1.00	3	2024-02-12 05:10:38.583048
349	0	1.00	4	2024-03-07 03:35:44.379637
669	0	1.00	13	2024-06-03 04:34:06.522131
338	0	1.00	3	2024-03-05 14:50:16.305911
771	0	1.00	2	2024-07-08 12:30:38.109253
236	0	1.00	14	2024-02-20 12:15:45.476432
268	0	1.00	7	2024-02-25 12:05:35.894948
293	0	1.00	3	2024-02-28 16:32:12.983881
453	0	1.00	1	2024-03-29 06:50:30.091866
242	0	1.00	3	2024-02-20 12:15:45.476432
296	0	1.00	3	2024-02-28 16:32:12.983881
329	0	1.00	3	2024-03-05 05:00:57.535553
74	0	1.00	2	2024-02-08 17:44:11.819471
479	0	1.00	3	2024-04-08 17:34:12.523864
616	0	1.00	2	2024-05-20 05:44:09.850926
176	0	1.00	8	2024-02-17 00:50:00.0375
348	0	1.00	4	2024-03-07 00:12:04.122209
213	0	1.00	10	2024-02-20 02:17:31.685205
31	0	1.00	3	2024-02-08 14:20:37.221001
740	0	1.00	1	2024-06-25 04:11:33.301988
112	0	1.00	8	2024-02-10 05:24:40.025935
63	0	1.00	3	2024-02-08 17:01:25.643002
362	0	1.00	7	2024-03-10 13:28:14.529517
714	0	1.00	8	2024-06-17 14:58:00.347364
295	0	1.00	3	2024-02-28 16:32:12.983881
440	0	1.00	8	2024-03-22 13:34:59.835774
290	0	1.00	3	2024-02-28 16:32:12.983881
235	0	1.00	3	2024-02-20 12:15:45.476432
686	0	1.00	2	2024-06-08 06:00:29.04203
261	0	1.00	3	2024-02-24 07:15:05.524345
425	0	1.00	3	2024-03-17 16:25:32.291984
185	0	1.00	4	2024-02-17 13:16:46.580686
239	0	1.00	3	2024-02-20 12:15:45.476432
431	0	1.00	3	2024-03-18 17:03:39.162335
291	0	1.00	3	2024-02-28 16:32:12.983881
285	0	1.00	4	2024-02-27 13:57:22.075902
657	0	1.00	2	2024-05-31 16:40:17.67696
365	0	1.00	8	2024-03-10 17:20:31.220807
961	0	1.00	2	2024-09-19 09:16:57.011228
294	0	1.00	3	2024-02-28 16:32:12.983881
141	0	1.00	3	2024-02-12 05:10:38.583048
727	0	1.00	2	2024-06-24 06:46:47.947661
237	0	1.00	3	2024-02-20 12:15:45.476432
1009	0	1.00	2	2024-10-08 11:05:36.903041
292	0	1.00	3	2024-02-28 16:32:12.983881
337	0	1.00	3	2024-03-05 14:35:03.759314
327	0	1.00	3	2024-03-05 05:00:57.535553
518	0	1.00	8	2024-04-15 13:20:08.780559
333	0	1.00	3	2024-03-05 05:00:57.535553
507	0	1.00	3	2024-04-11 16:10:37.218422
390	0	1.00	3	2024-03-11 15:18:32.690718
420	0	1.00	1	2024-03-17 10:34:56.719979
495	0	10.00	3	2024-04-09 07:00:53.625043
77	0	1.00	10	2024-02-08 17:53:09.803565
880	0	1.00	3	2024-08-19 07:39:34.4141
742	0	1.00	3	2024-06-26 14:50:48.86107
381	0	1.00	3	2024-03-10 18:09:50.871667
831	0	1.00	2	2024-08-06 12:19:23.925121
761	0	1.00	1	2024-07-01 15:07:22.013137
658	0	1.00	2	2024-05-31 16:40:17.67696
413	0	1.00	4	2024-03-15 16:01:31.498116
322	0	1.00	4	2024-03-04 04:32:17.81503
401	0	1.00	8	2024-03-13 14:41:22.634767
860	0	1.00	2	2024-08-12 16:00:25.01762
891	0	1.00	1	2024-08-24 07:47:27.648881
990	0	1.00	3	2024-09-24 05:02:14.594355
826	0	1.00	3	2024-08-05 04:48:35.384063
1063	0	1.00	1	2024-11-02 08:16:10.777688
809	0	1.00	1	2024-07-31 05:45:31.236342
825	0	1.00	2	2024-08-04 04:19:10.117752
909	0	1.00	2	2024-08-31 14:57:28.246535
370	0	1.00	3	2024-03-10 18:05:12.704752
465	0	1.00	7	2024-04-02 16:45:16.92598
500	0	10.00	3	2024-04-09 07:00:53.625043
932	0	1.00	3	2024-09-06 08:48:27.944171
1020	0	1.00	2	2024-10-16 13:44:04.120878
773	0	1.00	2	2024-07-08 12:30:38.109253
277	0	1.00	3	2024-02-26 00:58:52.265105
842	0	1.00	2	2024-08-08 12:08:11.81247
525	0	1.00	3	2024-04-17 17:10:51.901291
275	0	1.00	3	2024-02-26 00:54:23.352068
704	0	1.00	14	2024-06-10 11:22:17.912296
383	0	1.00	3	2024-03-10 18:09:50.871667
1039	0	1.00	7	2024-10-24 01:39:23.684434
807	0	1.00	10	2024-07-30 15:27:11.909458
396	0	1.00	10	2024-03-12 13:42:31.042079
708	0	1.00	1	2024-06-11 16:35:19.522008
653	0	1.00	3	2024-05-30 09:39:55.578384
374	0	1.00	7	2024-03-10 18:05:12.704752
513	0	1.00	4	2024-04-14 06:14:36.488609
627	0	1.00	2	2024-05-21 15:54:12.592719
728	0	1.00	2	2024-06-24 17:38:27.697783
864	0	1.00	2	2024-08-16 09:16:58.299453
772	0	1.00	2	2024-07-08 12:30:38.109253
501	0	10.00	3	2024-04-09 07:00:53.625043
987	0	1.00	2	2024-09-23 06:10:58.245677
167	0	1.00	8	2024-02-15 16:33:56.712177
386	0	1.00	3	2024-03-10 18:09:50.871667
749	0	1.00	2	2024-06-30 17:13:15.513006
521	0	1.00	3	2024-04-15 16:19:40.347876
589	0	1.00	3	2024-05-09 05:17:39.810573
502	0	10.00	3	2024-04-09 07:00:53.625043
493	0	10.00	3	2024-04-09 07:00:53.625043
368	0	1.00	3	2024-03-10 18:05:12.704752
659	0	1.00	2	2024-05-31 16:40:17.67696
371	0	1.00	3	2024-03-10 18:05:12.704752
649	0	1.00	2	2024-05-29 01:50:53.866818
729	0	1.00	2	2024-06-24 17:38:27.697783
314	0	1.00	4	2024-03-02 05:33:59.756135
556	0	1.00	4	2024-04-26 12:14:20.830347
430	0	1.00	2	2024-03-18 16:55:14.533163
717	0	1.00	3	2024-06-19 06:14:54.260197
792	0	1.00	1	2024-07-24 05:26:10.081783
377	0	1.00	3	2024-03-10 18:05:12.704752
960	0	1.00	3	2024-09-17 18:13:47.098152
380	0	1.00	3	2024-03-10 18:09:50.871667
336	0	1.00	4	2024-03-05 12:41:56.43579
592	0	1.00	2	2024-05-11 12:54:25.862361
992	0	1.00	2	2024-09-25 05:35:19.042212
339	0	1.00	3	2024-03-05 15:32:42.105301
863	0	1.00	2	2024-08-16 09:16:58.299453
473	0	1.00	3	2024-04-05 10:04:57.36128
760	0	1.00	2	2024-07-01 14:03:06.41713
468	0	1.00	8	2024-04-04 02:48:14.295831
604	0	1.00	4	2024-05-13 17:07:36.671514
715	0	1.00	8	2024-06-17 14:58:00.855426
561	0	1.00	3	2024-04-28 14:25:36.105633
937	0	1.00	2	2024-09-09 05:56:25.848653
999	0	1.00	10	2024-09-30 10:37:22.510136
526	0	1.00	14	2024-04-18 08:32:17.573216
345	0	1.00	3	2024-03-06 23:53:40.38729
417	0	1.00	3	2024-03-16 15:14:37.601633
563	0	1.00	8	2024-04-29 04:23:33.693948
366	0	1.00	8	2024-03-10 17:20:31.668703
373	0	1.00	3	2024-03-10 18:05:12.704752
887	0	1.00	8	2024-08-23 06:44:57.677951
746	0	1.00	3	2024-06-30 05:43:55.249614
426	0	1.00	4	2024-03-17 17:09:59.224768
282	0	1.00	8	2024-02-26 13:18:49.148396
147	0	1.00	12	2024-02-12 12:55:31.500876
458	0	1.00	4	2024-03-31 12:15:53.332324
407	0	1.00	8	2024-03-14 14:28:27.701138
278	0	1.00	2	2024-02-26 00:59:59.202105
804	0	1.00	3	2024-07-29 15:58:20.644095
748	0	1.00	2	2024-06-30 17:13:15.513006
113	0	1.00	2	2024-02-10 07:46:54.507898
643	0	1.00	4	2024-05-26 17:28:55.894104
899	0	1.00	3	2024-08-28 08:15:52.554314
369	0	1.00	3	2024-03-10 18:05:12.704752
687	0	1.00	12	2024-06-08 09:10:34.287985
90	0	1.00	8	2024-02-08 18:37:48.500696
498	0	10.00	3	2024-04-09 07:00:53.625043
544	0	1.00	8	2024-04-26 07:56:34.975717
528	0	1.00	2	2024-04-18 19:50:13.045101
894	0	1.00	14	2024-08-25 14:01:11.480516
788	0	1.00	2	2024-07-21 14:34:13.903106
531	0	1.00	8	2024-04-20 16:59:52.177614
790	0	1.00	2	2024-07-22 11:16:50.31623
274	0	1.00	4	2024-02-25 15:23:52.915951
1062	0	1.00	3	2024-11-02 08:16:04.622271
617	0	1.00	2	2024-05-20 05:44:09.850926
372	0	1.00	3	2024-03-10 18:05:12.704752
499	0	10.00	3	2024-04-09 07:00:53.625043
908	0	1.00	2	2024-08-31 14:57:28.246535
388	0	1.00	3	2024-03-10 18:09:50.871667
382	0	1.00	3	2024-03-10 18:09:50.871667
929	0	1.00	3	2024-09-04 11:31:49.646904
519	0	1.00	8	2024-04-15 13:22:55.130303
496	0	10.00	3	2024-04-09 07:00:53.625043
376	0	1.00	3	2024-03-10 18:05:12.704752
384	0	1.00	3	2024-03-10 18:09:50.871667
385	0	1.00	3	2024-03-10 18:09:50.871667
963	0	1.00	2	2024-09-20 05:00:16.316208
342	0	1.00	7	2024-03-06 14:02:15.121769
943	0	1.00	2	2024-09-12 08:48:04.435579
567	0	1.00	2	2024-04-30 14:17:16.456045
648	0	1.00	10	2024-05-27 16:43:51.806987
753	0	1.00	2	2024-06-30 17:13:15.513006
181	0	1.00	8	2024-02-17 08:33:51.61661
751	0	1.00	2	2024-06-30 17:13:15.513006
1007	0	1.00	10	2024-10-07 11:54:34.65211
575	0	10.00	2	2024-04-30 14:17:29.468115
542	0	1.00	10	2024-04-24 16:46:40.169206
618	0	1.00	2	2024-05-20 05:44:09.850926
944	0	1.00	2	2024-09-12 08:48:04.435579
662	0	1.00	2	2024-05-31 16:40:17.67696
865	0	1.00	2	2024-08-16 09:16:58.299453
545	0	10.00	2	2024-04-26 11:21:47.084987
879	0	1.00	2	2024-08-18 15:20:09.584211
611	0	1.00	4	2024-05-19 12:50:59.381759
623	0	1.00	2	2024-05-20 05:44:09.850926
730	0	1.00	2	2024-06-24 17:38:27.697783
571	0	10.00	2	2024-04-30 14:17:29.468115
622	0	1.00	2	2024-05-20 05:44:09.850926
280	0	1.00	3	2024-02-26 09:26:11.873396
593	0	1.00	2	2024-05-11 12:54:25.862361
660	0	1.00	2	2024-05-31 16:40:17.67696
572	0	10.00	2	2024-04-30 14:17:29.468115
953	0	1.00	4	2024-09-13 14:22:25.69779
549	0	10.00	2	2024-04-26 11:21:47.084987
906	0	1.00	3	2024-08-30 08:33:20.995041
570	0	10.00	2	2024-04-30 14:17:29.468115
541	0	1.00	10	2024-04-24 16:46:38.232362
619	0	1.00	2	2024-05-20 05:44:09.850926
610	0	1.00	3	2024-05-18 13:33:19.059646
679	0	1.00	2	2024-06-04 15:00:04.657533
344	0	1.00	10	2024-03-06 15:55:16.495993
903	0	1.00	3	2024-08-30 07:29:32.817493
672	0	1.00	2	2024-06-04 15:00:04.657533
209	0	1.00	2	2024-02-19 15:43:10.344407
573	0	10.00	2	2024-04-30 14:17:29.468115
638	0	1.00	2	2024-05-26 17:23:06.447219
629	0	1.00	12	2024-05-26 06:40:48.247527
581	0	1.00	4	2024-05-02 09:12:09.66008
554	0	10.00	2	2024-04-26 11:21:47.084987
597	0	1.00	2	2024-05-11 12:54:25.862361
1088	0	1.00	5	2024-11-16 13:37:04.320835
677	0	1.00	2	2024-06-04 15:00:04.657533
358	0	1.00	12	2024-03-09 12:32:34.503039
661	0	1.00	2	2024-05-31 16:40:17.67696
404	0	1.00	8	2024-03-13 16:49:21.08036
437	0	1.00	7	2024-03-19 13:30:22.786649
664	0	1.00	2	2024-05-31 16:40:17.67696
307	0	1.00	10	2024-03-01 01:40:05.406616
50	0	1.00	12	2024-02-08 15:48:18.314194
547	0	10.00	2	2024-04-26 11:21:47.084987
637	0	1.00	2	2024-05-26 17:23:06.447219
636	0	1.00	2	2024-05-26 17:23:06.447219
1096	0	1.00	3	2024-11-21 07:09:14.972745
1019	0	1.00	7	2024-10-16 13:07:25.729066
775	0	1.00	2	2024-07-08 12:30:38.109253
154	0	1.00	8	2024-02-13 17:22:13.902337
726	0	1.00	12	2024-06-23 03:44:22.010753
852	0	1.00	8	2024-08-09 07:29:21.074284
750	0	1.00	2	2024-06-30 17:13:15.513006
594	0	1.00	2	2024-05-11 12:54:25.862361
630	0	1.00	7	2024-05-26 14:23:08.777793
995	0	1.00	3	2024-09-29 06:06:30.613464
530	0	1.00	10	2024-04-19 08:03:40.373298
1031	0	1.00	3	2024-10-18 14:23:48.762959
599	0	1.00	2	2024-05-11 12:54:25.862361
568	0	10.00	2	2024-04-30 14:17:29.468115
640	0	1.00	2	2024-05-26 17:23:06.447219
693	0	1.00	2	2024-06-09 15:45:49.717926
550	0	10.00	2	2024-04-26 11:21:47.084987
270	0	1.00	4	2024-02-25 13:51:14.030708
588	0	1.00	3	2024-05-08 16:08:41.963839
774	0	1.00	2	2024-07-08 12:30:38.109253
408	0	1.00	8	2024-03-14 14:41:13.351149
994	0	1.00	10	2024-09-28 14:06:47.482199
565	0	1.00	12	2024-04-30 03:28:49.466591
754	0	1.00	2	2024-06-30 17:13:15.513006
45	0	1.00	13	2024-02-08 15:23:09.604866
634	0	1.00	2	2024-05-26 17:23:06.447219
795	0	1.00	14	2024-07-25 14:20:55.17569
955	0	1.00	3	2024-09-14 03:49:03.030107
719	0	1.00	2	2024-06-19 06:16:32.006966
670	0	1.00	2	2024-06-04 15:00:04.657533
606	0	1.00	8	2024-05-14 16:28:25.669461
764	0	1.00	1	2024-07-02 16:48:47.195914
590	0	1.00	2	2024-05-11 12:54:25.862361
663	0	1.00	2	2024-05-31 16:40:17.67696
718	0	1.00	2	2024-06-19 06:15:51.239638
613	0	1.00	14	2024-05-19 15:18:50.776592
353	0	1.00	2	2024-03-08 06:59:47.820932
667	0	1.00	12	2024-06-01 15:13:38.210272
203	0	1.00	10	2024-02-19 08:17:00.453193
620	0	1.00	2	2024-05-20 05:44:09.850926
553	0	10.00	2	2024-04-26 11:21:47.084987
898	0	1.00	1	2024-08-27 16:38:51.553084
39	0	1.00	4	2024-02-08 15:02:09.857903
552	0	10.00	2	2024-04-26 11:21:47.084987
724	0	1.00	2	2024-06-22 14:35:27.456729
694	0	1.00	2	2024-06-09 15:45:49.717926
639	0	1.00	2	2024-05-26 17:23:06.447219
676	0	1.00	2	2024-06-04 15:00:04.657533
675	0	1.00	2	2024-06-04 15:00:04.657533
516	0	1.00	3	2024-04-14 14:54:33.223839
752	0	1.00	2	2024-06-30 17:13:15.513006
546	0	10.00	2	2024-04-26 11:21:47.084987
520	0	1.00	10	2024-04-15 13:22:55.515901
633	0	1.00	2	2024-05-26 17:23:06.447219
551	0	10.00	2	2024-04-26 11:21:47.084987
153	0	1.00	3	2024-02-13 15:47:43.212031
843	0	1.00	2	2024-08-08 12:08:11.81247
673	0	1.00	2	2024-06-04 15:00:04.657533
632	0	1.00	2	2024-05-26 17:23:06.447219
644	0	1.00	4	2024-05-26 17:28:57.088945
635	0	1.00	2	2024-05-26 17:23:06.447219
1065	0	1.00	14	2024-11-02 15:35:15.64172
624	0	1.00	2	2024-05-20 05:44:09.850926
569	0	10.00	2	2024-04-30 14:17:29.468115
731	0	1.00	2	2024-06-24 17:38:27.697783
455	0	1.00	8	2024-03-30 15:10:39.404419
631	0	1.00	2	2024-05-26 17:23:06.447219
576	0	10.00	2	2024-04-30 14:17:29.468115
577	0	10.00	2	2024-04-30 14:17:29.468115
621	0	1.00	2	2024-05-20 05:44:09.850926
574	0	10.00	2	2024-04-30 14:17:29.468115
926	0	1.00	3	2024-09-03 14:57:06.446636
723	0	1.00	2	2024-06-22 03:53:45.454801
692	0	1.00	10	2024-06-08 18:03:18.478423
958	0	1.00	14	2024-09-15 15:18:32.021502
812	0	1.00	2	2024-07-31 13:17:33.681739
1090	0	1.00	3	2024-11-18 12:49:01.908597
846	0	1.00	2	2024-08-08 12:08:11.81247
647	0	1.00	10	2024-05-27 16:42:39.117526
438	0	1.00	13	2024-03-19 15:15:38.199182
1037	0	1.00	3	2024-10-23 13:38:45.719431
1010	0	1.00	2	2024-10-09 14:01:07.653485
801	0	1.00	10	2024-07-28 14:19:48.816687
945	0	1.00	2	2024-09-12 08:48:04.435579
262	0	1.00	10	2024-02-24 10:27:25.933415
833	0	1.00	1	2024-08-06 17:09:40.413528
1023	0	1.00	2	2024-10-16 13:44:04.120878
897	0	1.00	1	2024-08-27 13:32:47.125457
335	0	1.00	3	2024-03-05 08:40:06.142146
778	0	1.00	2	2024-07-08 12:30:38.109253
866	0	1.00	2	2024-08-16 09:16:58.299453
850	0	1.00	10	2024-08-09 03:10:53.201926
756	0	1.00	2	2024-06-30 17:13:15.513006
737	0	1.00	2	2024-06-24 17:38:27.697783
197	0	1.00	10	2024-02-18 16:58:53.635175
579	0	1.00	8	2024-05-01 00:49:06.225561
820	0	1.00	2	2024-07-31 13:17:33.681739
361	0	1.00	3	2024-03-10 06:46:26.929817
645	0	1.00	8	2024-05-27 10:19:50.70976
24	0	1.00	8	2024-02-08 13:58:39.325223
678	0	1.00	2	2024-06-04 15:00:04.657533
848	0	1.00	2	2024-08-08 12:08:11.81247
1022	0	1.00	2	2024-10-16 13:44:04.120878
170	0	1.00	10	2024-02-16 04:54:13.019616
735	0	1.00	2	2024-06-24 17:38:27.697783
869	0	1.00	2	2024-08-16 09:16:58.299453
766	0	1.00	4	2024-07-03 16:57:07.175452
823	0	1.00	14	2024-08-02 13:21:49.59122
868	0	1.00	2	2024-08-16 09:16:58.299453
702	0	1.00	2	2024-06-09 15:45:49.717926
1067	0	1.00	2	2024-11-03 07:08:23.501856
698	0	1.00	2	2024-06-09 15:45:49.717926
1011	0	1.00	2	2024-10-09 14:01:37.595985
705	0	1.00	3	2024-06-10 17:26:41.618375
1058	0	1.00	3	2024-10-28 08:21:15.780277
248	0	1.00	8	2024-02-20 16:18:44.569364
252	0	1.00	5	2024-02-22 04:33:19.86013
736	0	1.00	2	2024-06-24 17:38:27.697783
815	0	1.00	2	2024-07-31 13:17:33.681739
1032	0	1.00	2	2024-10-19 07:21:39.542419
840	0	1.00	2	2024-08-08 12:08:11.81247
263	0	1.00	4	2024-02-24 15:54:57.938705
30	0	1.00	3	2024-02-08 14:17:27.607655
776	0	1.00	2	2024-07-08 12:30:38.109253
596	0	1.00	2	2024-05-11 12:54:25.862361
462	0	1.00	3	2024-04-02 04:38:48.612309
157	0	1.00	10	2024-02-13 23:57:36.502052
883	0	1.00	1	2024-08-21 01:05:18.914565
733	0	1.00	2	2024-06-24 17:38:27.697783
674	0	1.00	2	2024-06-04 15:00:04.657533
690	0	1.00	2	2024-06-08 15:25:26.605711
650	0	1.00	8	2024-05-29 05:51:33.245409
699	0	1.00	2	2024-06-09 15:45:49.717926
509	0	1.00	8	2024-04-12 14:39:45.721084
566	0	1.00	3	2024-04-30 07:59:40.886052
1041	0	1.00	12	2024-10-24 05:00:07.39153
743	0	1.00	3	2024-06-27 01:07:54.026431
964	0	1.00	2	2024-09-20 05:00:16.316208
844	0	1.00	2	2024-08-08 12:08:11.81247
847	0	1.00	2	2024-08-08 12:08:11.81247
845	0	1.00	2	2024-08-08 12:08:11.81247
688	0	1.00	2	2024-06-08 15:22:10.636459
895	0	1.00	2	2024-08-26 17:58:23.568175
878	0	1.00	1	2024-08-17 16:51:56.479095
276	0	1.00	4	2024-02-26 00:57:22.935463
757	0	1.00	2	2024-06-30 17:13:15.513006
1017	0	1.00	12	2024-10-15 15:59:32.608285
700	0	1.00	2	2024-06-09 15:45:49.717926
257	0	1.00	8	2024-02-23 03:10:43.960777
817	0	1.00	2	2024-07-31 13:17:33.681739
782	0	1.00	4	2024-07-08 16:39:33.347911
813	0	1.00	2	2024-07-31 13:17:33.681739
779	0	1.00	2	2024-07-08 12:30:38.109253
936	0	1.00	2	2024-09-08 14:49:03.161149
701	0	1.00	2	2024-06-09 15:45:49.717926
318	0	1.00	10	2024-03-02 15:34:24.761574
787	0	1.00	2	2024-07-17 07:26:26.120292
867	0	1.00	2	2024-08-16 09:16:58.299453
628	0	1.00	2	2024-05-24 15:58:23.66142
991	0	1.00	3	2024-09-24 05:11:20.655279
269	0	1.00	8	2024-02-25 12:58:31.423827
725	0	1.00	2	2024-06-22 14:39:58.755636
881	0	1.00	3	2024-08-19 10:37:34.744699
781	0	1.00	14	2024-07-08 13:19:46.069484
777	0	1.00	2	2024-07-08 12:30:38.109253
930	0	1.00	10	2024-09-05 02:47:24.317401
1040	0	1.00	1	2024-10-24 03:49:23.61757
1076	0	1.00	2	2024-11-14 15:22:00.208769
814	0	1.00	2	2024-07-31 13:17:33.681739
734	0	1.00	2	2024-06-24 17:38:27.697783
837	0	1.00	4	2024-08-08 03:16:46.64863
84	0	1.00	3	2024-02-08 18:20:08.588818
411	0	1.00	10	2024-03-15 06:23:10.365107
436	0	1.00	8	2024-03-19 13:28:53.715318
732	0	1.00	2	2024-06-24 17:38:27.697783
62	0	1.00	3	2024-02-08 16:59:07.681019
793	0	1.00	1	2024-07-24 14:47:06.661117
1093	0	1.00	1	2024-11-20 01:43:57.136065
1074	0	1.00	8	2024-11-08 12:44:55.155463
755	0	1.00	2	2024-06-30 17:13:15.513006
870	0	1.00	2	2024-08-16 09:16:58.299453
1069	0	1.00	10	2024-11-03 14:18:45.475041
689	0	1.00	2	2024-06-08 15:24:17.625103
471	0	1.00	14	2024-04-04 09:42:04.248402
1021	0	1.00	2	2024-10-16 13:44:04.120878
350	0	1.00	4	2024-03-07 03:37:08.911645
161	0	1.00	8	2024-02-14 16:27:13.377782
1014	0	1.00	2	2024-10-12 14:30:33.991547
108	0	1.00	8	2024-02-09 11:18:25.778687
762	0	1.00	14	2024-07-01 16:40:42.751636
832	0	1.00	2	2024-08-06 17:04:04.309268
409	0	1.00	4	2024-03-14 19:06:10.954127
871	0	1.00	2	2024-08-16 09:16:58.299453
93	0	1.00	8	2024-02-08 18:45:31.380583
816	0	1.00	2	2024-07-31 13:17:33.681739
323	0	1.00	10	2024-03-04 14:34:51.143077
839	0	1.00	2	2024-08-08 12:08:11.81247
965	0	1.00	2	2024-09-20 05:00:16.316208
1066	0	1.00	14	2024-11-02 15:35:16.003282
716	0	1.00	14	2024-06-18 05:48:06.052173
400	0	1.00	4	2024-03-13 13:42:02.017208
538	0	1.00	11	2024-04-23 05:07:13.279648
818	0	1.00	2	2024-07-31 13:17:33.681739
892	0	1.00	3	2024-08-24 12:12:08.707543
1001	0	1.00	3	2024-09-30 14:19:03.400941
768	0	1.00	2	2024-07-05 05:40:47.118224
912	0	1.00	2	2024-08-31 14:57:28.246535
506	0	1.00	13	2024-04-11 11:31:48.807046
974	0	1.00	7	2024-09-20 05:01:57.897202
1075	0	1.00	4	2024-11-12 12:47:59.316816
954	0	1.00	3	2024-09-13 17:22:33.15209
947	0	1.00	2	2024-09-12 08:48:04.435579
1077	0	1.00	2	2024-11-14 15:22:07.897933
836	0	1.00	2	2024-08-07 17:35:50.996458
888	0	1.00	3	2024-08-24 02:28:10.431058
1026	0	1.00	2	2024-10-16 13:44:04.120878
949	0	1.00	2	2024-09-12 08:48:04.435579
712	0	1.00	10	2024-06-16 16:19:17.808134
602	0	1.00	14	2024-05-13 15:39:41.913433
271	0	1.00	3	2024-02-25 14:22:21.38498
595	0	1.00	14	2024-05-11 12:54:25.862361
978	0	1.00	2	2024-09-20 05:01:57.897202
872	0	1.00	2	2024-08-16 09:16:58.299453
419	0	1.00	4	2024-03-16 16:31:20.353758
103	0	1.00	3	2024-02-09 05:23:48.015332
819	0	1.00	2	2024-07-31 13:17:33.681739
472	0	1.00	3	2024-04-05 04:26:17.819118
975	0	1.00	2	2024-09-20 05:01:57.897202
802	0	1.00	3	2024-07-29 05:22:55.741678
1024	0	1.00	2	2024-10-16 13:44:04.120878
882	0	1.00	1	2024-08-19 15:54:15.219338
580	0	1.00	13	2024-05-01 14:27:35.799164
980	0	1.00	2	2024-09-20 05:01:57.897202
977	0	1.00	2	2024-09-20 05:01:57.897202
913	0	1.00	2	2024-08-31 14:57:28.246535
827	0	1.00	5	2024-08-05 06:36:28.225039
988	0	1.00	8	2024-09-23 13:48:30.423315
948	0	1.00	2	2024-09-12 08:48:04.435579
187	0	1.00	12	2024-02-17 14:08:07.235222
973	0	1.00	2	2024-09-20 05:01:57.897202
900	0	1.00	3	2024-08-28 12:34:26.79762
208	0	1.00	4	2024-02-19 15:40:45.72095
450	0	1.00	7	2024-03-27 04:18:19.927976
911	0	1.00	2	2024-08-31 14:57:28.246535
875	0	1.00	2	2024-08-16 17:35:00.571072
1027	0	1.00	2	2024-10-16 13:44:04.120878
981	0	1.00	2	2024-09-20 05:01:57.897202
713	0	1.00	2	2024-06-17 05:37:29.636087
917	0	1.00	2	2024-08-31 14:57:28.246535
279	0	1.00	4	2024-02-26 05:03:51.564189
915	0	1.00	2	2024-08-31 14:57:28.246535
993	0	1.00	10	2024-09-25 10:51:31.608534
405	0	1.00	8	2024-03-13 16:51:06.840234
902	0	1.00	14	2024-08-28 15:50:50.423257
441	0	1.00	4	2024-03-23 09:31:31.763565
1064	0	1.00	2	2024-11-02 14:23:05.640063
925	0	1.00	1	2024-09-03 14:52:02.669927
829	0	1.00	10	2024-08-05 16:41:45.094458
433	0	1.00	8	2024-03-19 12:38:08.80833
972	0	1.00	2	2024-09-20 05:01:57.897202
1091	0	1.00	3	2024-11-18 13:11:10.066049
940	0	1.00	8	2024-09-10 10:37:48.805039
1094	0	1.00	1	2024-11-20 02:23:06.986977
979	0	1.00	2	2024-09-20 05:01:57.897202
391	0	1.00	5	2024-03-11 15:28:25.76632
652	0	1.00	3	2024-05-30 09:17:03.488122
966	0	1.00	2	2024-09-20 05:00:16.316208
967	0	1.00	2	2024-09-20 05:00:16.316208
310	0	1.00	4	2024-03-01 09:12:50.070792
394	0	1.00	4	2024-03-12 03:20:46.336617
957	0	1.00	3	2024-09-15 04:11:59.013173
890	0	1.00	2	2024-08-24 04:50:54.438541
968	0	1.00	2	2024-09-20 05:00:16.316208
998	0	1.00	10	2024-09-30 10:34:58.840037
1029	0	1.00	2	2024-10-16 13:44:04.120878
914	0	1.00	2	2024-08-31 14:57:28.246535
983	0	1.00	8	2024-09-21 03:37:23.747657
969	0	1.00	2	2024-09-20 05:00:16.316208
317	0	1.00	12	2024-03-02 15:16:20.637222
861	0	1.00	4	2024-08-13 08:18:45.047972
970	0	1.00	2	2024-09-20 05:00:16.316208
971	0	1.00	2	2024-09-20 05:00:16.316208
512	0	1.00	7	2024-04-14 02:18:54.603106
321	0	1.00	3	2024-03-03 14:31:44.362726
1015	0	1.00	14	2024-10-12 14:30:46.570593
59	0	1.00	8	2024-02-08 16:38:23.469719
916	0	1.00	2	2024-08-31 14:57:28.246535
5	0	1.00	8	2024-02-08 13:00:20.369133
741	0	1.00	12	2024-06-25 18:05:00.151478
1028	0	1.00	2	2024-10-16 13:44:04.120878
946	0	1.00	2	2024-09-12 08:48:04.435579
901	0	1.00	3	2024-08-28 13:07:45.487862
910	0	1.00	2	2024-08-31 14:57:28.246535
283	0	1.00	8	2024-02-26 15:04:29.030657
989	0	1.00	2	2024-09-23 17:40:34.233574
941	0	1.00	5	2024-09-10 15:26:22.055309
158	0	1.00	8	2024-02-14 05:43:59.313749
429	0	1.00	3	2024-03-18 06:26:51.643607
320	0	1.00	3	2024-03-03 02:38:29.471585
562	0	1.00	10	2024-04-28 15:48:19.740941
1025	0	1.00	2	2024-10-16 13:44:04.120878
1033	0	1.00	7	2024-10-20 12:18:49.787361
309	0	1.00	10	2024-03-01 08:25:41.545372
1070	0	1.00	4	2024-11-04 11:30:02.897044
976	0	1.00	2	2024-09-20 05:01:57.897202
423	0	1.00	14	2024-03-17 16:05:00.911528
44	0	1.00	13	2024-02-08 15:20:53.029425
40	0	1.00	13	2024-02-08 15:06:44.825837
410	0	1.00	13	2024-03-15 05:41:12.099052
951	0	1.00	2	2024-09-12 08:48:04.435579
997	0	1.00	4	2024-09-29 14:43:24.462232
950	0	1.00	2	2024-09-12 08:48:04.435579
854	0	1.00	2	2024-08-10 06:13:00.612791
1078	0	1.00	2	2024-11-14 15:22:07.897933
920	0	1.00	12	2024-09-01 13:15:59.629794
198	0	1.00	8	2024-02-18 17:00:52.740738
1005	0	1.00	3	2024-10-07 01:38:32.69854
47	0	1.00	13	2024-02-08 15:26:30.80363
928	0	1.00	12	2024-09-04 04:57:22.853483
76	0	1.00	9	2024-02-08 17:51:23.196207
1036	0	1.00	6	2024-10-22 09:55:29.607898
874	0	1.00	2	2024-08-16 14:11:25.972717
1034	0	1.00	14	2024-10-20 13:30:00.598784
524	0	1.00	10	2024-04-17 13:36:25.376367
646	0	1.00	7	2024-05-27 16:32:25.545891
1068	0	1.00	5	2024-11-03 12:19:21.307483
403	0	1.00	13	2024-03-13 16:35:44.526289
1042	0	1.00	12	2024-10-24 15:34:54.203681
406	0	1.00	14	2024-03-14 14:14:19.581121
1038	0	1.00	3	2024-10-23 14:16:10.714557
830	0	1.00	8	2024-08-06 06:08:49.737823
1080	0	1.00	2	2024-11-14 15:22:07.897933
1081	0	1.00	2	2024-11-14 15:22:07.897933
1082	0	1.00	2	2024-11-14 15:22:07.897933
1043	0	1.00	2	2024-10-24 17:08:33.498735
1052	0	1.00	2	2024-10-24 17:08:43.180559
1053	0	1.00	2	2024-10-24 17:08:43.180559
1083	0	1.00	2	2024-11-14 15:22:07.897933
1084	0	1.00	2	2024-11-14 15:22:07.897933
1085	0	1.00	2	2024-11-14 15:22:07.897933
1086	0	1.00	2	2024-11-14 15:22:07.897933
1044	0	1.00	2	2024-10-24 17:08:43.180559
956	0	1.00	6	2024-09-14 06:14:16.503725
587	0	1.00	12	2024-05-08 15:20:58.46898
1050	0	1.00	2	2024-10-24 17:08:43.180559
254	0	1.00	4	2024-02-22 07:50:14.272811
319	0	1.00	3	2024-03-02 15:39:27.38323
1048	0	1.00	2	2024-10-24 17:08:43.180559
510	0	1.00	10	2024-04-13 16:28:03.139897
564	0	1.00	8	2024-04-29 06:29:42.874429
835	0	1.00	10	2024-08-07 17:32:45.757423
721	0	1.00	8	2024-06-19 17:32:04.95143
1046	0	1.00	2	2024-10-24 17:08:43.180559
1049	0	1.00	2	2024-10-24 17:08:43.180559
1071	0	1.00	8	2024-11-04 11:30:14.978266
1045	0	1.00	2	2024-10-24 17:08:43.180559
1	0	1.00	13	2024-02-08 12:07:25.485885
188	0	1.00	10	2024-02-17 14:11:51.425393
1079	0	1.00	2	2024-11-14 15:22:07.897933
1047	0	1.00	2	2024-10-24 17:08:43.180559
838	0	1.00	14	2024-08-08 09:17:16.234402
1051	0	1.00	2	2024-10-24 17:08:43.180559
\.


--
-- Name: users_user_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('users_user_id_seq', 1096, true);


--
-- Data for Name: voip_charge_rule_tariff; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY voip_charge_rule_tariff (tariff_id, tariff_name, comment) FROM stdin;
\.


--
-- Name: voip_charge_rule_tariff_tariff_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('voip_charge_rule_tariff_tariff_id_seq', 1, false);


--
-- Data for Name: voip_charge_rules; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY voip_charge_rules (charge_id, charge_rule_id, start_time, end_time, time_limit, ras_id, tariff_id) FROM stdin;
\.


--
-- Data for Name: voip_onlines_snapshot; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY voip_onlines_snapshot (snp_date, ras_id, value) FROM stdin;
\.


--
-- Data for Name: voip_users; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY voip_users (user_id, voip_username, voip_password) FROM stdin;
\.


--
-- Data for Name: web_analyzer_log; Type: TABLE DATA; Schema: public; Owner: ibs
--

COPY web_analyzer_log (log_id, _date, user_id, ip_addr, url, elapsed, bytes, miss, hit, successful, failure, _count) FROM stdin;
\.


--
-- Name: web_analyzer_log_log_id; Type: SEQUENCE SET; Schema: public; Owner: ibs
--

SELECT pg_catalog.setval('web_analyzer_log_log_id', 1, false);


--
-- Name: add_user_save_details_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY add_user_save_details
    ADD CONSTRAINT add_user_save_details_pkey PRIMARY KEY (add_user_save_id, user_id);


--
-- Name: add_user_saves_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY add_user_saves
    ADD CONSTRAINT add_user_saves_pkey PRIMARY KEY (add_user_save_id);


--
-- Name: admin_deposit_change_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY admin_deposit_change
    ADD CONSTRAINT admin_deposit_change_pkey PRIMARY KEY (admin_deposit_change_id);


--
-- Name: admin_locks_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY admin_locks
    ADD CONSTRAINT admin_locks_pkey PRIMARY KEY (lock_id);


--
-- Name: admin_messages_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY admin_messages
    ADD CONSTRAINT admin_messages_pkey PRIMARY KEY (message_id);


--
-- Name: admin_perm_templates_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY admin_perm_templates_detail
    ADD CONSTRAINT admin_perm_templates_detail_pkey PRIMARY KEY (template_id, perm_name);


--
-- Name: admin_perm_templates_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY admin_perm_templates
    ADD CONSTRAINT admin_perm_templates_pkey PRIMARY KEY (template_id);


--
-- Name: admin_perms_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY admin_perms
    ADD CONSTRAINT admin_perms_pkey PRIMARY KEY (admin_id, perm_name);


--
-- Name: admins_extended_attrs_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY admins_extended_attrs
    ADD CONSTRAINT admins_extended_attrs_pkey PRIMARY KEY (admin_id, attr_name);


--
-- Name: admins_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY admins
    ADD CONSTRAINT admins_pkey PRIMARY KEY (admin_id);


--
-- Name: admins_username_key; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY admins
    ADD CONSTRAINT admins_username_key UNIQUE (username);


--
-- Name: bw_interface_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY bw_interface
    ADD CONSTRAINT bw_interface_pkey PRIMARY KEY (interface_id);


--
-- Name: bw_leaf_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY bw_leaf
    ADD CONSTRAINT bw_leaf_pkey PRIMARY KEY (leaf_id);


--
-- Name: bw_leaf_services_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY bw_leaf_services
    ADD CONSTRAINT bw_leaf_services_pkey PRIMARY KEY (leaf_service_id);


--
-- Name: bw_node_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY bw_node
    ADD CONSTRAINT bw_node_pkey PRIMARY KEY (node_id);


--
-- Name: bw_static_ip_ip_key; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY bw_static_ip
    ADD CONSTRAINT bw_static_ip_ip_key UNIQUE (ip);


--
-- Name: bw_static_ip_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY bw_static_ip
    ADD CONSTRAINT bw_static_ip_pkey PRIMARY KEY (bw_static_ip_id);


--
-- Name: caller_id_users_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY caller_id_users
    ADD CONSTRAINT caller_id_users_pkey PRIMARY KEY (caller_id);


--
-- Name: charge_rule_day_of_weeks_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY charge_rule_day_of_weeks
    ADD CONSTRAINT charge_rule_day_of_weeks_pkey PRIMARY KEY (charge_rule_id, day_of_week);


--
-- Name: charge_rule_ports_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY charge_rule_ports
    ADD CONSTRAINT charge_rule_ports_pkey PRIMARY KEY (charge_rule_id, ras_port);


--
-- Name: charge_rules_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY charge_rules
    ADD CONSTRAINT charge_rules_pkey PRIMARY KEY (charge_rule_id);


--
-- Name: charges_name_key; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY charges
    ADD CONSTRAINT charges_name_key UNIQUE (name);


--
-- Name: charges_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY charges
    ADD CONSTRAINT charges_pkey PRIMARY KEY (charge_id);


--
-- Name: connection_log_details_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY connection_log_details
    ADD CONSTRAINT connection_log_details_pkey PRIMARY KEY (connection_log_id, name);


--
-- Name: connection_log_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY connection_log
    ADD CONSTRAINT connection_log_pkey PRIMARY KEY (connection_log_id);


--
-- Name: credit_change_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY credit_change
    ADD CONSTRAINT credit_change_pkey PRIMARY KEY (credit_change_id);


--
-- Name: credit_change_userid_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY credit_change_userid
    ADD CONSTRAINT credit_change_userid_pkey PRIMARY KEY (credit_change_id, user_id);


--
-- Name: defs_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY defs
    ADD CONSTRAINT defs_pkey PRIMARY KEY (name);


--
-- Name: group_attrs_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY group_attrs
    ADD CONSTRAINT group_attrs_pkey PRIMARY KEY (group_id, attr_name);


--
-- Name: groups_group_name_key; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY groups
    ADD CONSTRAINT groups_group_name_key UNIQUE (group_name);


--
-- Name: groups_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY groups
    ADD CONSTRAINT groups_pkey PRIMARY KEY (group_id);


--
-- Name: ias_event_extended_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY ias_event_extended
    ADD CONSTRAINT ias_event_extended_pkey PRIMARY KEY (event_id, name);


--
-- Name: ias_event_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY ias_event
    ADD CONSTRAINT ias_event_pkey PRIMARY KEY (event_id);


--
-- Name: ibs_states_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY ibs_states
    ADD CONSTRAINT ibs_states_pkey PRIMARY KEY (name);


--
-- Name: internet_bw_snapshot_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY internet_bw_snapshot
    ADD CONSTRAINT internet_bw_snapshot_pkey PRIMARY KEY (user_id, snp_date);


--
-- Name: internet_charge_rules_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY internet_charge_rules
    ADD CONSTRAINT internet_charge_rules_pkey PRIMARY KEY (charge_rule_id);


--
-- Name: internet_onlines_snapshot_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY internet_onlines_snapshot
    ADD CONSTRAINT internet_onlines_snapshot_pkey PRIMARY KEY (snp_date, ras_id);


--
-- Name: ippool_ips_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY ippool_ips
    ADD CONSTRAINT ippool_ips_pkey PRIMARY KEY (ippool_id, ip);


--
-- Name: ippool_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY ippool
    ADD CONSTRAINT ippool_pkey PRIMARY KEY (ippool_id);


--
-- Name: normal_users_normal_username_key; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY normal_users
    ADD CONSTRAINT normal_users_normal_username_key UNIQUE (normal_username);


--
-- Name: persistent_lan_users_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY persistent_lan_users
    ADD CONSTRAINT persistent_lan_users_pkey PRIMARY KEY (persistent_lan_mac, persistent_lan_ip);


--
-- Name: ras_attrs_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY ras_attrs
    ADD CONSTRAINT ras_attrs_pkey PRIMARY KEY (ras_id, attr_name);


--
-- Name: ras_ippools_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY ras_ippools
    ADD CONSTRAINT ras_ippools_pkey PRIMARY KEY (serial);


--
-- Name: ras_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY ras
    ADD CONSTRAINT ras_pkey PRIMARY KEY (ras_id);


--
-- Name: ras_ports_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY ras_ports
    ADD CONSTRAINT ras_ports_pkey PRIMARY KEY (ras_id, port_name);


--
-- Name: ras_ras_description_key; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY ras
    ADD CONSTRAINT ras_ras_description_key UNIQUE (ras_description);


--
-- Name: ras_ras_ip_key; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY ras
    ADD CONSTRAINT ras_ras_ip_key UNIQUE (ras_ip);


--
-- Name: tariff_prefix_list_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY tariff_prefix_list
    ADD CONSTRAINT tariff_prefix_list_pkey PRIMARY KEY (prefix_id);


--
-- Name: user_attrs_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY user_attrs
    ADD CONSTRAINT user_attrs_pkey PRIMARY KEY (user_id, attr_name);


--
-- Name: user_audit_log_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY user_audit_log
    ADD CONSTRAINT user_audit_log_pkey PRIMARY KEY (user_audit_log);


--
-- Name: user_messages_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY user_messages
    ADD CONSTRAINT user_messages_pkey PRIMARY KEY (message_id);


--
-- Name: users_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_pkey PRIMARY KEY (user_id);


--
-- Name: voip_charge_rule_tariff_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY voip_charge_rule_tariff
    ADD CONSTRAINT voip_charge_rule_tariff_pkey PRIMARY KEY (tariff_id);


--
-- Name: voip_charge_rules_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY voip_charge_rules
    ADD CONSTRAINT voip_charge_rules_pkey PRIMARY KEY (charge_rule_id);


--
-- Name: voip_onlines_snapshot_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY voip_onlines_snapshot
    ADD CONSTRAINT voip_onlines_snapshot_pkey PRIMARY KEY (snp_date, ras_id);


--
-- Name: voip_users_voip_username_key; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY voip_users
    ADD CONSTRAINT voip_users_voip_username_key UNIQUE (voip_username);


--
-- Name: web_analyzer_log_pkey; Type: CONSTRAINT; Schema: public; Owner: ibs; Tablespace: 
--

ALTER TABLE ONLY web_analyzer_log
    ADD CONSTRAINT web_analyzer_log_pkey PRIMARY KEY (log_id);


--
-- Name: caller_id_users_user_id; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE INDEX caller_id_users_user_id ON caller_id_users USING btree (user_id);


--
-- Name: connection_log_details_name_value_index; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE INDEX connection_log_details_name_value_index ON connection_log_details USING btree (name, value);


--
-- Name: connection_log_login_time_index; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE INDEX connection_log_login_time_index ON connection_log USING btree (login_time);


--
-- Name: connection_log_userid_index; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE INDEX connection_log_userid_index ON connection_log USING btree (user_id);


--
-- Name: credit_change_userid_index; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE INDEX credit_change_userid_index ON credit_change_userid USING btree (user_id);


--
-- Name: group_attrs_name_value; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE INDEX group_attrs_name_value ON group_attrs USING btree (attr_name, attr_value);


--
-- Name: ippool_ips_index; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE UNIQUE INDEX ippool_ips_index ON ippool_ips USING btree (ippool_id, ip);


--
-- Name: normal_users_user_id; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE UNIQUE INDEX normal_users_user_id ON normal_users USING btree (user_id);


--
-- Name: persistent_lan_ras_id_index; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE INDEX persistent_lan_ras_id_index ON persistent_lan_users USING btree (persistent_lan_ras_id);


--
-- Name: persistent_lan_user_id; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE INDEX persistent_lan_user_id ON persistent_lan_users USING btree (user_id);


--
-- Name: prefix_name_index; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE UNIQUE INDEX prefix_name_index ON tariff_prefix_list USING btree (tariff_id, prefix_code);


--
-- Name: ras_attrs_index; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE UNIQUE INDEX ras_attrs_index ON ras_attrs USING btree (ras_id, attr_name);


--
-- Name: ras_ports_index; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE UNIQUE INDEX ras_ports_index ON ras_ports USING btree (ras_id, port_name);


--
-- Name: user_attrs_abs_exp_date; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE INDEX user_attrs_abs_exp_date ON user_attrs USING btree (attr_name, ((attr_value)::bigint)) WHERE (attr_name = ANY (ARRAY['abs_exp_date'::text, 'first_login'::text]));


--
-- Name: user_attrs_name_value; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE INDEX user_attrs_name_value ON user_attrs USING btree (attr_name, attr_value);


--
-- Name: users_group_id; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE INDEX users_group_id ON users USING btree (group_id);


--
-- Name: voip_users_user_id; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE UNIQUE INDEX voip_users_user_id ON voip_users USING btree (user_id);


--
-- Name: web_analyzer_log_date_index; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE INDEX web_analyzer_log_date_index ON web_analyzer_log USING btree (_date);


--
-- Name: web_analyzer_log_user_id_index; Type: INDEX; Schema: public; Owner: ibs; Tablespace: 
--

CREATE INDEX web_analyzer_log_user_id_index ON web_analyzer_log USING btree (user_id);


--
-- Name: system_admin; Type: RULE; Schema: public; Owner: ibs
--

CREATE RULE system_admin AS ON DELETE TO admins WHERE (old.admin_id = 0) DO INSTEAD NOTHING;


--
-- Name: system_admin_god; Type: RULE; Schema: public; Owner: ibs
--

CREATE RULE system_admin_god AS ON DELETE TO admin_perms WHERE ((old.admin_id = 0) AND (old.perm_name = 'GOD'::text)) DO INSTEAD NOTHING;


--
-- Name: add_user_save_details_add_user_save_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY add_user_save_details
    ADD CONSTRAINT add_user_save_details_add_user_save_id_fkey FOREIGN KEY (add_user_save_id) REFERENCES add_user_saves(add_user_save_id);


--
-- Name: add_user_saves_admin_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY add_user_saves
    ADD CONSTRAINT add_user_saves_admin_id_fkey FOREIGN KEY (admin_id) REFERENCES admins(admin_id);


--
-- Name: admin_locks_admin_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY admin_locks
    ADD CONSTRAINT admin_locks_admin_id_fkey FOREIGN KEY (admin_id) REFERENCES admins(admin_id);


--
-- Name: admin_locks_locker_admin_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY admin_locks
    ADD CONSTRAINT admin_locks_locker_admin_id_fkey FOREIGN KEY (locker_admin_id) REFERENCES admins(admin_id);


--
-- Name: admin_messages_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY admin_messages
    ADD CONSTRAINT admin_messages_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(user_id);


--
-- Name: admin_perm_templates_detail_template_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY admin_perm_templates_detail
    ADD CONSTRAINT admin_perm_templates_detail_template_id_fkey FOREIGN KEY (template_id) REFERENCES admin_perm_templates(template_id);


--
-- Name: admin_perms_admin_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY admin_perms
    ADD CONSTRAINT admin_perms_admin_id_fkey FOREIGN KEY (admin_id) REFERENCES admins(admin_id);


--
-- Name: admins_extended_attrs_admin_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY admins_extended_attrs
    ADD CONSTRAINT admins_extended_attrs_admin_id_fkey FOREIGN KEY (admin_id) REFERENCES admins(admin_id);


--
-- Name: bw_leaf_interface_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY bw_leaf
    ADD CONSTRAINT bw_leaf_interface_id_fkey FOREIGN KEY (interface_id) REFERENCES bw_interface(interface_id);


--
-- Name: bw_leaf_parent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY bw_leaf
    ADD CONSTRAINT bw_leaf_parent_id_fkey FOREIGN KEY (parent_id) REFERENCES bw_node(node_id);


--
-- Name: bw_leaf_services_leaf_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY bw_leaf_services
    ADD CONSTRAINT bw_leaf_services_leaf_id_fkey FOREIGN KEY (leaf_id) REFERENCES bw_leaf(leaf_id);


--
-- Name: bw_node_interface_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY bw_node
    ADD CONSTRAINT bw_node_interface_id_fkey FOREIGN KEY (interface_id) REFERENCES bw_interface(interface_id);


--
-- Name: bw_node_parent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY bw_node
    ADD CONSTRAINT bw_node_parent_id_fkey FOREIGN KEY (parent_id) REFERENCES bw_node(node_id);


--
-- Name: bw_static_ip_receive_leaf_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY bw_static_ip
    ADD CONSTRAINT bw_static_ip_receive_leaf_id_fkey FOREIGN KEY (receive_leaf_id) REFERENCES bw_leaf(leaf_id);


--
-- Name: bw_static_ip_transmit_leaf_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY bw_static_ip
    ADD CONSTRAINT bw_static_ip_transmit_leaf_id_fkey FOREIGN KEY (transmit_leaf_id) REFERENCES bw_leaf(leaf_id);


--
-- Name: caller_id_users_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY caller_id_users
    ADD CONSTRAINT caller_id_users_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(user_id);


--
-- Name: charge_rules_charge_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY charge_rules
    ADD CONSTRAINT charge_rules_charge_id_fkey FOREIGN KEY (charge_id) REFERENCES charges(charge_id);


--
-- Name: charge_rules_ras_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY charge_rules
    ADD CONSTRAINT charge_rules_ras_id_fkey FOREIGN KEY (ras_id) REFERENCES ras(ras_id);


--
-- Name: charges_admin_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY charges
    ADD CONSTRAINT charges_admin_id_fkey FOREIGN KEY (admin_id) REFERENCES admins(admin_id);


--
-- Name: connection_log_details_connection_log_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY connection_log_details
    ADD CONSTRAINT connection_log_details_connection_log_id_fkey FOREIGN KEY (connection_log_id) REFERENCES connection_log(connection_log_id);


--
-- Name: credit_change_userid_credit_change_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY credit_change_userid
    ADD CONSTRAINT credit_change_userid_credit_change_id_fkey FOREIGN KEY (credit_change_id) REFERENCES credit_change(credit_change_id);


--
-- Name: group_attrs_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY group_attrs
    ADD CONSTRAINT group_attrs_group_id_fkey FOREIGN KEY (group_id) REFERENCES groups(group_id);


--
-- Name: groups_owner_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY groups
    ADD CONSTRAINT groups_owner_id_fkey FOREIGN KEY (owner_id) REFERENCES admins(admin_id);


--
-- Name: ias_event_extended_event_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY ias_event_extended
    ADD CONSTRAINT ias_event_extended_event_id_fkey FOREIGN KEY (event_id) REFERENCES ias_event(event_id);


--
-- Name: internet_bw_snapshot_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY internet_bw_snapshot
    ADD CONSTRAINT internet_bw_snapshot_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(user_id);


--
-- Name: internet_charge_rules_bw_receive_leaf_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY internet_charge_rules
    ADD CONSTRAINT internet_charge_rules_bw_receive_leaf_id_fkey FOREIGN KEY (bw_receive_leaf_id) REFERENCES bw_leaf(leaf_id);


--
-- Name: internet_charge_rules_bw_transmit_leaf_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY internet_charge_rules
    ADD CONSTRAINT internet_charge_rules_bw_transmit_leaf_id_fkey FOREIGN KEY (bw_transmit_leaf_id) REFERENCES bw_leaf(leaf_id);


--
-- Name: ippool_ips_ippool_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY ippool_ips
    ADD CONSTRAINT ippool_ips_ippool_id_fkey FOREIGN KEY (ippool_id) REFERENCES ippool(ippool_id);


--
-- Name: normal_users_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY normal_users
    ADD CONSTRAINT normal_users_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(user_id);


--
-- Name: persistent_lan_users_persistent_lan_ras_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY persistent_lan_users
    ADD CONSTRAINT persistent_lan_users_persistent_lan_ras_id_fkey FOREIGN KEY (persistent_lan_ras_id) REFERENCES ras(ras_id);


--
-- Name: persistent_lan_users_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY persistent_lan_users
    ADD CONSTRAINT persistent_lan_users_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(user_id);


--
-- Name: ras_attrs_ras_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY ras_attrs
    ADD CONSTRAINT ras_attrs_ras_id_fkey FOREIGN KEY (ras_id) REFERENCES ras(ras_id);


--
-- Name: ras_ippools_ippool_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY ras_ippools
    ADD CONSTRAINT ras_ippools_ippool_id_fkey FOREIGN KEY (ippool_id) REFERENCES ippool(ippool_id);


--
-- Name: ras_ippools_ras_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY ras_ippools
    ADD CONSTRAINT ras_ippools_ras_id_fkey FOREIGN KEY (ras_id) REFERENCES ras(ras_id);


--
-- Name: ras_ports_ras_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY ras_ports
    ADD CONSTRAINT ras_ports_ras_id_fkey FOREIGN KEY (ras_id) REFERENCES ras(ras_id);


--
-- Name: tariff_prefix_list_tariff_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY tariff_prefix_list
    ADD CONSTRAINT tariff_prefix_list_tariff_id_fkey FOREIGN KEY (tariff_id) REFERENCES voip_charge_rule_tariff(tariff_id);


--
-- Name: user_attrs_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY user_attrs
    ADD CONSTRAINT user_attrs_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(user_id);


--
-- Name: user_messages_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY user_messages
    ADD CONSTRAINT user_messages_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(user_id);


--
-- Name: users_owner_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_owner_id_fkey FOREIGN KEY (owner_id) REFERENCES admins(admin_id);


--
-- Name: voip_charge_rules_tariff_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY voip_charge_rules
    ADD CONSTRAINT voip_charge_rules_tariff_id_fkey FOREIGN KEY (tariff_id) REFERENCES voip_charge_rule_tariff(tariff_id);


--
-- Name: voip_users_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: ibs
--

ALTER TABLE ONLY voip_users
    ADD CONSTRAINT voip_users_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(user_id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

